/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxb.io;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import java.lang.annotation.Annotation;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBException;
import javax.xml.bind.UnmarshalException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.namespace.QName;
import org.apache.cxf.attachment.AttachmentUtil;
import org.apache.cxf.common.jaxb.JAXBUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.databinding.DataReader;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.jaxb.JAXBDataBase;
import org.apache.cxf.jaxb.JAXBDataBinding;
import org.apache.cxf.jaxb.JAXBEncoderDecoder;
import org.apache.cxf.jaxb.UnmarshallerEventHandler;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.service.model.MessagePartInfo;

@TraceObjectField(fieldName="LOG", fieldDesc="Ljava/util/logging/Logger;")
public class DataReaderImpl<T>
extends JAXBDataBase
implements DataReader<T> {
    private static final Logger LOG = LogUtils.getLogger(DataReaderImpl.class);
    JAXBDataBinding databinding;
    boolean unwrapJAXBElement;
    ValidationEventHandler veventHandler;
    boolean setEventHandler;
    static final long serialVersionUID = 2950738572730616771L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public DataReaderImpl(JAXBDataBinding binding, boolean unwrap) {
        super(binding.getContext());
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.io.DataReaderImpl", "<init>", new Object[]{binding, unwrap});
        }
        this.setEventHandler = true;
        this.unwrapJAXBElement = unwrap;
        this.databinding = binding;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxb.io.DataReaderImpl", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Object read(T input) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.io.DataReaderImpl", "read", new Object[]{input});
        }
        Object object = this.read(null, input);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            object = object;
            LOG.exiting("org.apache.cxf.jaxb.io.DataReaderImpl", "read", object);
        }
        return object;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setProperty(String prop, Object value) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.io.DataReaderImpl", "setProperty", new Object[]{prop, value});
        }
        boolean isLoggableFinest = LOG.isLoggable(Level.FINEST);
        if (prop.equals("unwrap.jaxb.element")) {
            this.unwrapJAXBElement = Boolean.TRUE.equals(value);
            if (isLoggableFinest) {
                LOG.finest("UnwrapJAXBElement is set to: " + this.unwrapJAXBElement + " trough property");
            }
        } else if (prop.equals(Message.class.getName())) {
            Object unwrapProperty;
            Message m = (Message)value;
            this.veventHandler = this.getValidationEventHandler(m, "jaxb-reader-validation-event-handler");
            if (this.veventHandler == null) {
                this.veventHandler = this.databinding.getValidationEventHandler();
            }
            this.setEventHandler = AttachmentUtil.mtomOverride((Message)m, (boolean)MessageUtils.getContextualBoolean((Message)m, (String)"set-jaxb-validation-event-handler", (boolean)true));
            if (isLoggableFinest) {
                LOG.finest("SetEventHandler is set to: " + this.setEventHandler);
            }
            if ((unwrapProperty = m.get((Object)"unwrap.jaxb.element")) == null) {
                unwrapProperty = m.getExchange().get((Object)"unwrap.jaxb.element");
            }
            if (unwrapProperty != null) {
                this.unwrapJAXBElement = Boolean.TRUE.equals(unwrapProperty);
                if (isLoggableFinest) {
                    LOG.finest("UnwrapJAXBElement is set to: " + this.unwrapJAXBElement);
                }
            }
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxb.io.DataReaderImpl", "setProperty");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private Unmarshaller createUnmarshaller() {
        Unmarshaller unmarshaller;
        block5: {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.entering("org.apache.cxf.jaxb.io.DataReaderImpl", "createUnmarshaller", new Object[0]);
            }
            try {
                Unmarshaller um = this.databinding.getJAXBUnmarshaller(this.setEventHandler, this.setEventHandler ? new WSUIDValidationHandler(this.veventHandler) : null);
                um.setSchema(this.schema);
                um.setAttachmentUnmarshaller(this.getAttachmentUnmarshaller());
                for (XmlAdapter<?, ?> adapter : this.databinding.getConfiguredXmlAdapters()) {
                    um.setAdapter(adapter);
                }
                unmarshaller = um;
                if (LOG == null || !LOG.isLoggable(Level.FINER)) break block5;
            }
            catch (UnmarshalException ex) {
                throw new Fault(new org.apache.cxf.common.i18n.Message("UNMARSHAL_ERROR", LOG, new Object[]{ex.getLinkedException().getMessage()}), (Throwable)ex);
            }
            catch (JAXBException ex) {
                throw new Fault(new org.apache.cxf.common.i18n.Message("UNMARSHAL_ERROR", LOG, new Object[]{ex.getMessage()}), (Throwable)ex);
            }
            unmarshaller = unmarshaller;
            LOG.exiting("org.apache.cxf.jaxb.io.DataReaderImpl", "createUnmarshaller", unmarshaller);
        }
        return unmarshaller;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Object read(MessagePartInfo part, T reader) {
        Object object;
        boolean noError;
        Unmarshaller um;
        block8: {
            Annotation[] anns;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.entering("org.apache.cxf.jaxb.io.DataReaderImpl", "read", new Object[]{part, reader});
            }
            boolean honorJaxbAnnotation = this.honorJAXBAnnotations(part);
            if (honorJaxbAnnotation && (anns = this.getJAXBAnnotation(part)).length > 0) {
                QName qname = new QName(null, part.getConcreteName().getLocalPart());
                Object obj = JAXBEncoderDecoder.unmarshalWithBridge(qname, part.getTypeClass(), anns, this.databinding.getContextClasses(), reader, this.getAttachmentUnmarshaller());
                this.onCompleteUnmarshalling();
                Object object2 = obj;
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    object2 = object2;
                    LOG.exiting("org.apache.cxf.jaxb.io.DataReaderImpl", "read", object2);
                }
                return object2;
            }
            um = this.createUnmarshaller();
            noError = false;
            Object obj = JAXBEncoderDecoder.unmarshall(um, reader, part, this.unwrapJAXBElement);
            this.onCompleteUnmarshalling();
            noError = true;
            Object object3 = obj;
            object = object3;
            if (LOG == null || !LOG.isLoggable(Level.FINER)) break block8;
            object = object;
            LOG.exiting("org.apache.cxf.jaxb.io.DataReaderImpl", "read", object);
        }
        return object;
        finally {
            if (noError) {
                this.databinding.releaseJAXBUnmarshaller(um);
            } else {
                JAXBUtils.closeUnmarshaller((Unmarshaller)um);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Object read(QName name, T input, Class<?> type) {
        Object object;
        boolean noError;
        Unmarshaller um;
        block6: {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.entering("org.apache.cxf.jaxb.io.DataReaderImpl", "read", new Object[]{name, input, type});
            }
            um = this.createUnmarshaller();
            noError = false;
            Object obj = JAXBEncoderDecoder.unmarshall(um, input, name, type, this.unwrapJAXBElement);
            this.onCompleteUnmarshalling();
            noError = true;
            Object object2 = obj;
            object = object2;
            if (LOG == null || !LOG.isLoggable(Level.FINER)) break block6;
            object = object;
            LOG.exiting("org.apache.cxf.jaxb.io.DataReaderImpl", "read", object);
        }
        return object;
        finally {
            if (noError) {
                this.databinding.releaseJAXBUnmarshaller(um);
            } else {
                JAXBUtils.closeUnmarshaller((Unmarshaller)um);
            }
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void onCompleteUnmarshalling() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.io.DataReaderImpl", "onCompleteUnmarshalling", new Object[0]);
        }
        if (this.setEventHandler && this.veventHandler instanceof UnmarshallerEventHandler) {
            try {
                ((UnmarshallerEventHandler)this.veventHandler).onUnmarshalComplete();
            }
            catch (UnmarshalException e) {
                if (e.getLinkedException() != null) {
                    throw new Fault(new org.apache.cxf.common.i18n.Message("UNMARSHAL_ERROR", LOG, new Object[]{e.getLinkedException().getMessage()}), (Throwable)e);
                }
                throw new Fault(new org.apache.cxf.common.i18n.Message("UNMARSHAL_ERROR", LOG, new Object[]{e.getMessage()}), (Throwable)e);
            }
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxb.io.DataReaderImpl", "onCompleteUnmarshalling");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @TraceOptions
    private static class WSUIDValidationHandler
    implements ValidationEventHandler {
        ValidationEventHandler origHandler;
        static final long serialVersionUID = 5919812788361131098L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        WSUIDValidationHandler(ValidationEventHandler o) {
            this.origHandler = o;
        }

        public boolean handleEvent(ValidationEvent event) {
            if (this.origHandler != null && this.origHandler.handleEvent(event)) {
                return true;
            }
            String msg = event.getMessage();
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("ValidationEvent message: " + msg);
            }
            return msg != null && msg.contains(":Id") && (msg.startsWith("cvc-type.3.1.1") || msg.startsWith("cvc-type.3.2.2") || msg.startsWith("cvc-complex-type.3.1.1") || msg.startsWith("cvc-complex-type.3.2.2"));
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"org.apache.cxf.jaxb.io.DataReaderImpl$WSUIDValidationHandler", WSUIDValidationHandler.class, null, null);
        }
    }
}

