/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.ra.inbound.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.SIDestinationAddress;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SIIncorrectCallException;
import com.ibm.websphere.sib.exception.SINotPossibleInCurrentConfigurationException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ejbcontainer.mdb.MDBMessageEndpointFactory;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.api.jms.service.JmsServiceFacade;
import com.ibm.ws.sib.ra.impl.SibRaUtils;
import com.ibm.ws.sib.ra.inbound.SibRaEndpointConfiguration;
import com.ibm.ws.sib.ra.inbound.SibRaReadAhead;
import com.ibm.ws.sib.ra.inbound.impl.SibRaLockedMessageEnumeration;
import com.ibm.ws.sib.ra.inbound.impl.SibRaMessagingEngineConnection;
import com.ibm.ws.sib.ra.inbound.impl.SibRaStringGenerator;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.AsynchConsumerCallback;
import com.ibm.wsspi.sib.core.ConsumerSession;
import com.ibm.wsspi.sib.core.DestinationType;
import com.ibm.wsspi.sib.core.LockedMessageEnumeration;
import com.ibm.wsspi.sib.core.SIBusMessage;
import com.ibm.wsspi.sib.core.SICoreConnection;
import com.ibm.wsspi.sib.core.SIMessageHandle;
import com.ibm.wsspi.sib.core.SelectionCriteria;
import com.ibm.wsspi.sib.core.SelectionCriteriaFactory;
import com.ibm.wsspi.sib.core.StoppableAsynchConsumerCallback;
import com.ibm.wsspi.sib.core.exception.SIConnectionDroppedException;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import com.ibm.wsspi.sib.core.exception.SIConnectionUnavailableException;
import com.ibm.wsspi.sib.core.exception.SIDestinationLockedException;
import com.ibm.wsspi.sib.core.exception.SIDurableSubscriptionAlreadyExistsException;
import com.ibm.wsspi.sib.core.exception.SIDurableSubscriptionMismatchException;
import com.ibm.wsspi.sib.core.exception.SIDurableSubscriptionNotFoundException;
import com.ibm.wsspi.sib.core.exception.SILimitExceededException;
import com.ibm.wsspi.sib.core.exception.SIMessageNotLockedException;
import com.ibm.wsspi.sib.core.exception.SINotAuthorizedException;
import com.ibm.wsspi.sib.core.exception.SISessionDroppedException;
import com.ibm.wsspi.sib.core.exception.SISessionUnavailableException;
import com.ibm.wsspi.sib.core.exception.SITemporaryDestinationNotFoundException;
import com.ibm.wsspi.sib.pacing.AsynchDispatchScheduler;
import com.ibm.wsspi.sib.pacing.AsynchResumeCallback;
import com.ibm.wsspi.sib.pacing.MessagePacingControl;
import com.ibm.wsspi.sib.pacing.MessagePacingControlFactory;
import java.lang.reflect.Method;
import java.util.List;
import javax.resource.ResourceException;
import javax.resource.spi.endpoint.MessageEndpointFactory;

abstract class SibRaListener
implements StoppableAsynchConsumerCallback {
    protected final SibRaMessagingEngineConnection _connection;
    protected final ConsumerSession _session;
    private final SelectionCriteriaFactory _selectionCriteriaFactory;
    protected int _maxActiveMessages;
    protected final SIDestinationAddress _destinationAddress;
    protected final boolean _strictMessageOrdering;
    private static final TraceComponent TRACE = SibRaUtils.getTraceComponent(SibRaListener.class);
    private static TraceNLS NLS = SibRaUtils.getTraceNls();
    private static final String CLASS_NAME = SibRaListener.class.getName();
    protected Reliability _unrecoverableReliability;
    protected final boolean _deleteUnrecoverableMessages;
    protected int _sequentialFailureThreshold;
    protected int _maxFailedDeliveries;
    private final MessageEndpointFactory _messageEndpointFactory;
    private boolean _sessionStopped = false;
    protected volatile boolean sibPacingSessionStarted = true;
    private volatile boolean mpcPacingSessionStarted = true;
    private volatile boolean sessionStarted = false;
    private volatile boolean sessionStarting = false;
    protected boolean callbackWaiting = false;
    protected boolean insideConsumeMessages = false;
    private final Object asyncResumeCallbackWaitLock = new Object(){};
    private final Object sessionStartingLock = new Object(){};
    protected Object insideConsumeMessagesLock = new Object(){};

    SibRaListener(SibRaMessagingEngineConnection connection, SIDestinationAddress destination, MessageEndpointFactory messageEndpointFactory) throws ResourceException {
        String methodName = "SibRaListener";
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"SibRaListener", (Object)new Object[]{connection, destination, messageEndpointFactory});
        }
        this._connection = connection;
        this._destinationAddress = destination;
        this._deleteUnrecoverableMessages = !connection.getEndpointActivation().isEndpointMethodTransactional();
        this._messageEndpointFactory = messageEndpointFactory;
        try {
            int maxBatchSize;
            int configuredAutoStopSequentialMessageFailure;
            block19: {
                MessagePacingControl mpc;
                this._selectionCriteriaFactory = JmsServiceFacade.getSelectionCriteriaFactory();
                this._session = this.createSession(destination);
                this._strictMessageOrdering = connection.getConnection().getDestinationConfiguration(destination).isStrictOrderingRequired();
                this._maxActiveMessages = connection.getEndpointConfiguration().getMaxConcurrency();
                String exceptionDestination = this._session.getConnection().getDestinationConfiguration(this._destinationAddress).getExceptionDestination();
                configuredAutoStopSequentialMessageFailure = connection.getEndpointConfiguration().getAutoStopSequentialMessageFailure();
                if ((this._strictMessageOrdering || exceptionDestination == null) && configuredAutoStopSequentialMessageFailure > 0) {
                    configuredAutoStopSequentialMessageFailure = 1;
                    if (this._strictMessageOrdering) {
                        SibTr.warning((TraceComponent)TRACE, (String)NLS.getFormattedMessage("MAXSEQUENTIALMESSAGEFAILURE_CONFIG_VALUE_CHANGED_CWSIV0906", new Object[]{this._connection.getEndpointConfiguration().getAutoStopSequentialMessageFailure(), configuredAutoStopSequentialMessageFailure}, null));
                    } else {
                        SibTr.warning((TraceComponent)TRACE, (String)NLS.getFormattedMessage("MAXSEQUENTIALMESSAGEFAILURE_EXCEPTION_DESTINATION_CWSIV0907", new Object[]{this._connection.getEndpointConfiguration().getAutoStopSequentialMessageFailure(), configuredAutoStopSequentialMessageFailure}, null));
                    }
                }
                maxBatchSize = connection.getEndpointConfiguration().getMaxBatchSize();
                if (this._strictMessageOrdering) {
                    this._maxActiveMessages = 1;
                    maxBatchSize = 1;
                    SibTr.warning((TraceComponent)TRACE, (String)"MAXCONCURRENCY_CONFIG_VALUE_CHANGED_CWSIV1101", (Object)new Object[]{this._connection.getEndpointConfiguration().getMaxConcurrency(), this._maxActiveMessages});
                }
                if ((mpc = MessagePacingControlFactory.getInstance()) != null && mpc.isActive()) {
                    maxBatchSize = mpc.overrideMaxBatchSize(connection.getEndpointConfiguration().getBusName(), destination.getDestinationName(), maxBatchSize);
                }
                this._sequentialFailureThreshold = connection.getEndpointConfiguration().getMaxSequentialMessageFailure();
                try {
                    this._maxFailedDeliveries = this._connection.getConnection().getDestinationConfiguration(this._session.getDestinationAddress()).getMaxFailedDeliveries();
                }
                catch (SIException exception) {
                    FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + "." + "SibRaListener"), (String)"1:350:1.68", (Object)this);
                    if (TRACE.isEventEnabled()) {
                        SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)exception));
                    }
                    this._sequentialFailureThreshold = -1;
                    if (!TRACE.isDebugEnabled()) break block19;
                    SibTr.debug((Object)this, (TraceComponent)TRACE, (String)"_sequentialFailureThreshold is now -1");
                }
            }
            int maxActiveMessages = this.getMaxActiveMessages();
            long messageLockExpiry = this.getMessageLockExpiry();
            try {
                long failingMsgDelay = connection.getEndpointConfiguration().getFailingMessageDelay();
                this._session.registerStoppableAsynchConsumerCallback((StoppableAsynchConsumerCallback)this, maxActiveMessages, messageLockExpiry, maxBatchSize, null, configuredAutoStopSequentialMessageFailure, failingMsgDelay);
            }
            catch (SIIncorrectCallException exception) {
                this._session.registerAsynchConsumerCallback((AsynchConsumerCallback)this, maxActiveMessages, messageLockExpiry, maxBatchSize, null);
            }
        }
        catch (SIException exception) {
            FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + "." + "SibRaListener"), (String)"1:393:1.68", (Object)this);
            this.close();
            if (TraceComponent.isAnyTracingEnabled() && TRACE.isEventEnabled()) {
                SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)exception));
            }
            throw new ResourceException(NLS.getFormattedMessage("LISTENER_CREATION_CWSIV0900", new Object[]{exception, destination.getDestinationName(), connection.getBusName(), connection.getConnection()}, null), (Throwable)exception);
        }
        catch (SIErrorException exception) {
            FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + "." + "SibRaListener"), (String)"1:415:1.68", (Object)this);
            this.close();
            if (TraceComponent.isAnyTracingEnabled() && TRACE.isEventEnabled()) {
                SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)exception));
            }
            throw new ResourceException(NLS.getFormattedMessage("LISTENER_CREATION_CWSIV0900", new Object[]{exception, destination.getDestinationName(), connection.getBusName(), connection.getConnection()}, null), (Throwable)exception);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + "." + "SibRaListener"), (String)"1:437:1.68", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && TRACE.isEventEnabled()) {
                SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)exception);
            }
            throw new ResourceException(NLS.getFormattedMessage("SELECTION_FACTORY_CWSIV0901", new Object[]{exception}, null), (Throwable)exception);
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"SibRaListener");
        }
    }

    void startConsumer() throws ResourceException {
        String methodName = "startConsumer";
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"startConsumer");
        }
        try {
            this.sessionStarted = true;
            this.startSession(false);
            this._sessionStopped = false;
        }
        catch (SIException exception) {
            FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + "." + "startConsumer"), (String)"1:476:1.68", (Object)this);
            this.close();
            if (TraceComponent.isAnyTracingEnabled() && TRACE.isEventEnabled()) {
                SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)exception));
            }
            throw new ResourceException(NLS.getFormattedMessage("LISTENER_CREATION_CWSIV0900", new Object[]{exception, this._session.getDestinationAddress().getDestinationName(), this._connection.getBusName(), this._connection.getConnection()}, null), (Throwable)exception);
        }
        catch (SIErrorException exception) {
            FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + "." + "startConsumer"), (String)"1:497:1.68", (Object)this);
            this.close();
            if (TraceComponent.isAnyTracingEnabled() && TRACE.isEventEnabled()) {
                SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)exception));
            }
            throw new ResourceException(NLS.getFormattedMessage("LISTENER_CREATION_CWSIV0900", new Object[]{exception, this._session.getDestinationAddress().getDestinationName(), this._connection.getBusName(), this._connection.getConnection()}, null), (Throwable)exception);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + "." + "startConsumer"), (String)"1:518:1.68", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && TRACE.isEventEnabled()) {
                SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)exception);
            }
            throw new ResourceException(NLS.getFormattedMessage("SELECTION_FACTORY_CWSIV0901", new Object[]{exception}, null), (Throwable)exception);
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"startConsumer");
        }
    }

    private final ConsumerSession createSession(SIDestinationAddress destination) throws SIDurableSubscriptionAlreadyExistsException, SIDurableSubscriptionNotFoundException, SIDurableSubscriptionMismatchException, SIConnectionDroppedException, SIConnectionUnavailableException, SIConnectionLostException, SILimitExceededException, SINotAuthorizedException, SIDestinationLockedException, SITemporaryDestinationNotFoundException, SIResourceException, SIErrorException, SIIncorrectCallException, SINotPossibleInCurrentConfigurationException {
        String methodName = "createSession";
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"createSession", (Object)new Object[]{destination});
        }
        SibRaEndpointConfiguration endpointConfiguration = this._connection.getEndpointConfiguration();
        Reliability reliability = null;
        this._unrecoverableReliability = this._connection.getEndpointActivation().isEndpointMethodTransactional() ? Reliability.NONE : Reliability.BEST_EFFORT_NONPERSISTENT;
        boolean noLocal = false;
        DestinationType destinationType = endpointConfiguration.getDestinationType();
        String selector = endpointConfiguration.getMessageSelector();
        String discriminator = endpointConfiguration.getDiscriminator();
        SelectionCriteria selectionCriteria = this._selectionCriteriaFactory.createSelectionCriteria(discriminator, selector, endpointConfiguration.getSelectorDomain());
        boolean bifurcatable = true;
        String alternateUser = null;
        SICoreConnection connection = this._connection.getConnection();
        ConsumerSession session = null;
        if (endpointConfiguration.isDurableSubscription()) {
            String subscriptionName = endpointConfiguration.getDurableSubscriptionName();
            String durableSubscriptionHome = endpointConfiguration.getDurableSubscriptionHome();
            String subscriptionDurability = endpointConfiguration.getSubscriptionDurability();
            boolean supportsMultipleConsumers = false;
            if (subscriptionDurability.equalsIgnoreCase("DurableShared")) {
                supportsMultipleConsumers = true;
            }
            boolean enableReadAhead = SibRaReadAhead.DEFAULT.equals(endpointConfiguration.getReadAhead()) ? !supportsMultipleConsumers : SibRaReadAhead.ON.equals(endpointConfiguration.getReadAhead());
            try {
                session = connection.createConsumerSessionForDurableSubscription(subscriptionName, durableSubscriptionHome, destination, selectionCriteria, supportsMultipleConsumers, false, reliability, enableReadAhead, this._unrecoverableReliability, true, alternateUser);
            }
            catch (SIDurableSubscriptionNotFoundException exception) {
                if (TraceComponent.isAnyTracingEnabled() && TRACE.isEventEnabled()) {
                    SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)exception));
                }
                connection.createDurableSubscription(subscriptionName, durableSubscriptionHome, destination, selectionCriteria, supportsMultipleConsumers, false, alternateUser);
                session = connection.createConsumerSessionForDurableSubscription(subscriptionName, durableSubscriptionHome, destination, selectionCriteria, supportsMultipleConsumers, false, reliability, enableReadAhead, this._unrecoverableReliability, true, alternateUser);
            }
            catch (SIDurableSubscriptionMismatchException exception) {
                if (TraceComponent.isAnyTracingEnabled() && TRACE.isEventEnabled()) {
                    SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)exception));
                }
                connection.deleteDurableSubscription(subscriptionName, durableSubscriptionHome);
                connection.createDurableSubscription(subscriptionName, durableSubscriptionHome, destination, selectionCriteria, supportsMultipleConsumers, false, alternateUser);
                session = connection.createConsumerSessionForDurableSubscription(subscriptionName, durableSubscriptionHome, destination, selectionCriteria, supportsMultipleConsumers, false, reliability, enableReadAhead, this._unrecoverableReliability, true, alternateUser);
            }
        } else {
            String subscriptionName = endpointConfiguration.getDurableSubscriptionName();
            String subscriptionDurability = endpointConfiguration.getSubscriptionDurability();
            boolean isNonDurableShared = false;
            if (subscriptionDurability.equalsIgnoreCase("NonDurableShared")) {
                isNonDurableShared = true;
            }
            boolean enableReadAhead = SibRaReadAhead.DEFAULT.equals(endpointConfiguration.getReadAhead()) ? DestinationType.TOPICSPACE.equals(destinationType) && !isNonDurableShared : SibRaReadAhead.ON.equals(endpointConfiguration.getReadAhead());
            if (!isNonDurableShared) {
                String allowMessageGathering = this._connection.getEndpointConfiguration().getAllowMessageGathering();
                if (allowMessageGathering != null) {
                    boolean allow = allowMessageGathering.equals("On");
                    try {
                        session = connection.createConsumerSession(destination, destinationType, selectionCriteria, reliability, enableReadAhead, false, this._unrecoverableReliability, true, alternateUser, true, allow, null);
                    }
                    catch (SIIncorrectCallException ex) {
                        session = connection.createConsumerSession(destination, destinationType, selectionCriteria, reliability, enableReadAhead, false, this._unrecoverableReliability, true, alternateUser);
                    }
                } else {
                    session = connection.createConsumerSession(destination, destinationType, selectionCriteria, reliability, enableReadAhead, false, this._unrecoverableReliability, true, alternateUser);
                }
            } else {
                session = connection.createSharedConsumerSession(subscriptionName, destination, destinationType, selectionCriteria, reliability, enableReadAhead, true, false, this._unrecoverableReliability, true, alternateUser, true, false, null);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"createSession", (Object)session);
        }
        return session;
    }

    final void close() {
        block9: {
            String methodName = "close";
            if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"close");
            }
            try {
                if (this._session != null) {
                    this.sessionStarted = false;
                    this.stopIfRequired();
                    this._session.close();
                }
            }
            catch (SISessionDroppedException sISessionDroppedException) {
            }
            catch (SIConnectionDroppedException sIConnectionDroppedException) {
            }
            catch (SIException exception) {
                FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + "." + "close"), (String)"1:827:1.68", (Object)this);
                if (TraceComponent.isAnyTracingEnabled() && TRACE.isEventEnabled()) {
                    SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)exception));
                }
            }
            catch (SIErrorException exception) {
                FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + "." + "close"), (String)"1:835:1.68", (Object)this);
                if (!TraceComponent.isAnyTracingEnabled() || !TRACE.isEventEnabled()) break block9;
                SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)exception));
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"close");
        }
    }

    final void stop() {
        block7: {
            String methodName = "stop";
            if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"stop");
            }
            try {
                if (this._session != null && !this._sessionStopped) {
                    this.sessionStarted = false;
                    this.stopIfRequired();
                }
            }
            catch (SIException exception) {
                FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + "." + "stop"), (String)"1:878:1.68", (Object)this);
                if (TraceComponent.isAnyTracingEnabled() && TRACE.isEventEnabled()) {
                    SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)exception));
                }
            }
            catch (SIErrorException exception) {
                FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + "." + "stop"), (String)"1:886:1.68", (Object)this);
                if (!TraceComponent.isAnyTracingEnabled() || !TRACE.isEventEnabled()) break block7;
                SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)exception));
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"stop");
        }
    }

    public abstract void internalConsumeMessages(LockedMessageEnumeration var1, AsynchDispatchScheduler var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void consumeMessages(LockedMessageEnumeration lockedMessages) {
        String methodName = "consumeMessages";
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"consumeMessages", (Object)lockedMessages);
        }
        if (this.sessionStarting) {
            if (TRACE.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)TRACE, (String)"Return this method, as startSession() is in progress.");
            }
            if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"consumeMessages");
            }
            return;
        }
        Object object = this.insideConsumeMessagesLock;
        synchronized (object) {
            this.insideConsumeMessages = true;
        }
        MessagePacingControl mpc = MessagePacingControlFactory.getInstance();
        if (mpc != null && mpc.isActive()) {
            AsynchResumeCallbackImpl asyncResumeCallback = new AsynchResumeCallbackImpl();
            AsynchDispatchScheduler aysnDispatchScheduler = mpc.preAsynchDispatch(this._connection.getEndpointConfiguration().getBusName(), this._destinationAddress.getDestinationName(), (Object)asyncResumeCallback);
            if (aysnDispatchScheduler.suspendAsynchDispatcher()) {
                this.mpcPacingSessionStarted = false;
                asyncResumeCallback.createCachedEnumeration(lockedMessages, aysnDispatchScheduler);
            } else {
                this.internalConsumeMessages(lockedMessages, aysnDispatchScheduler);
            }
        } else {
            this.internalConsumeMessages(lockedMessages, null);
        }
        Object object2 = this.insideConsumeMessagesLock;
        synchronized (object2) {
            block19: {
                this.insideConsumeMessages = false;
                try {
                    this.stopIfRequired();
                }
                catch (SIException exception) {
                    FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + "." + "consumeMessages"), (String)"1:979:1.68", (Object)this);
                    if (TRACE.isEventEnabled()) {
                        SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)exception));
                    }
                }
                catch (SIErrorException exception) {
                    FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + "." + "consumeMessages"), (String)"1:986:1.68", (Object)this);
                    if (!TRACE.isEventEnabled()) break block19;
                    SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)exception));
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"consumeMessages");
        }
    }

    abstract boolean isSessionBifurcated();

    abstract int getMaxActiveMessages();

    abstract long getMessageLockExpiry();

    static SIMessageHandle[] getMessageHandles(List messages) {
        SIMessageHandle[] messageHandles = new SIMessageHandle[messages.size()];
        for (int i = 0; i < messageHandles.length; ++i) {
            SIBusMessage message = (SIBusMessage)messages.get(i);
            messageHandles[i] = message.getMessageHandle();
        }
        return messageHandles;
    }

    public final String toString() {
        return this.getStringGenerator().getStringRepresentation();
    }

    protected abstract void processCachedMessage(SIBusMessage var1, LockedMessageEnumeration var2) throws SISessionDroppedException, SIConnectionDroppedException, SISessionUnavailableException, SIConnectionUnavailableException, SIConnectionLostException, SILimitExceededException, SIMessageNotLockedException, SIResourceException, SIIncorrectCallException;

    protected SibRaStringGenerator getStringGenerator() {
        SibRaStringGenerator generator = new SibRaStringGenerator(this);
        generator.addParent("connection", this._connection);
        generator.addField("session", this._session);
        return generator;
    }

    private void processEndpointDeActivation() {
        String methodName = "processEndpointDeActivation";
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"processEndpointDeActivation", (Object)new Object[0]);
        }
        String endpointName = null;
        if (this._messageEndpointFactory instanceof MDBMessageEndpointFactory) {
            try {
                endpointName = ((MDBMessageEndpointFactory)this._messageEndpointFactory).getMDBKey().toString();
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.ra.inbound.impl.SibRaListener", (String)"1059", (Object)this);
            }
            SibTr.warning((TraceComponent)TRACE, (String)"MESSAGE_ENDPOINT_PAUSED_AUTONOMICALLY_CWSIV0902", (Object)new Object[]{endpointName, this._destinationAddress});
            try {
                Class<?> busAction = Class.forName("com.ibm.ws.sib.ra.inbound.impl.SibRaBusSecurityAction");
                Method performBusSecurityAction = busAction.getDeclaredMethod("performBusSecurityAction", String.class, SIDestinationAddress.class);
                performBusSecurityAction.invoke(null, endpointName, this._destinationAddress);
            }
            catch (Exception ex) {
                FFDCFilter.processException((Throwable)ex, (String)(CLASS_NAME + "." + "processEndpointDeActivation"), (String)"1:1128:1.68");
                SibTr.error((TraceComponent)TRACE, (String)"INVOKE_MBEAN_EXCEPTION__CWSIV0903", (Object)new Object[]{endpointName, this._destinationAddress, ex});
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"processEndpointDeActivation");
        }
    }

    public void consumerSessionStopped() {
        String methodName = "consumerSessionStopped";
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"consumerSessionStopped", (Object)new Object[0]);
        }
        this._sessionStopped = true;
        this.processEndpointDeActivation();
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"consumerSessionStopped");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startSession(boolean deliverImmediately) throws SIException {
        String methodName = "startSession";
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"startSession", (Object)new Object[]{this, new Boolean(deliverImmediately)});
        }
        boolean sessionStartingByThisThread = false;
        Object object = this.sessionStartingLock;
        synchronized (object) {
            if (!this.sessionStarting && this.sibPacingSessionStarted && this.mpcPacingSessionStarted && this.sessionStarted) {
                this.sessionStarting = true;
                sessionStartingByThisThread = true;
            }
            if (TRACE.isDebugEnabled()) {
                SibTr.debug((TraceComponent)TRACE, (String)"startSession", (Object)("sibPacingSessionStarted: " + this.sibPacingSessionStarted + "\nmpcPacingSessionStarted: " + this.mpcPacingSessionStarted + "\ncallbackWaiting: " + this.callbackWaiting + "\nsessionStarted: " + this.sessionStarted + "\nsessionStartingByThisThread: " + sessionStartingByThisThread));
            }
        }
        if (sessionStartingByThisThread) {
            boolean startRequired = false;
            Object object2 = this.asyncResumeCallbackWaitLock;
            synchronized (object2) {
                if (this.callbackWaiting) {
                    this.asyncResumeCallbackWaitLock.notifyAll();
                    this.callbackWaiting = false;
                } else {
                    startRequired = true;
                }
            }
            if (startRequired) {
                this._session.start(deliverImmediately);
            }
            this.sessionStarting = false;
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"startSession");
        }
    }

    protected void stopIfRequired() throws SIException {
        String methodName = "stopIfRequired";
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"stopIfRequired", (Object)new Object[]{this});
        }
        if (TRACE.isDebugEnabled()) {
            SibTr.debug((TraceComponent)TRACE, (String)"stopIfRequired", (Object)("sibPacingSessionStarted: " + this.sibPacingSessionStarted + "\nmpcPacingSessionStarted: " + this.mpcPacingSessionStarted + "\nsessionStarted: " + this.sessionStarted));
        }
        if (!(this.sibPacingSessionStarted && this.mpcPacingSessionStarted && this.sessionStarted)) {
            this._session.stop();
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"stopIfRequired");
        }
    }

    private class AsynchResumeCallbackImpl
    implements AsynchResumeCallback,
    Runnable {
        private SibRaLockedMessageEnumeration _cachedEnumeration = null;
        private AsynchDispatchScheduler _cachedAsynchDispatchScheduler;

        private AsynchResumeCallbackImpl() {
        }

        public void createCachedEnumeration(LockedMessageEnumeration lme, AsynchDispatchScheduler asynchDispatchScheduler) {
            String methodName = "createCachedEnumeration";
            if (TRACE.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"createCachedEnumeration", (Object)new Object[]{lme, asynchDispatchScheduler});
            }
            this._cachedEnumeration = new SibRaLockedMessageEnumeration();
            this._cachedAsynchDispatchScheduler = asynchDispatchScheduler;
            SIBusMessage message = null;
            try {
                while ((message = lme.nextLocked()) != null) {
                    this._cachedEnumeration.add(message);
                    SibRaListener.this.processCachedMessage(message, lme);
                }
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)(CLASS_NAME + "." + "createCachedEnumeration"), (String)"1:1310:1.68", (Object)this);
                SibTr.error((TraceComponent)TRACE, (String)"RETRIEVE_MESSAGES_CWSIV1100", (Object)new Object[]{throwable, lme});
            }
            if (TRACE.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"createCachedEnumeration");
            }
        }

        public void resume() {
            block4: {
                String methodName = "resume";
                if (TRACE.isEntryEnabled()) {
                    SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"resume", (Object)this);
                }
                try {
                    Thread raListenerThread = new Thread(this);
                    raListenerThread.setName("SIBRAListenerThread");
                    raListenerThread.start();
                }
                catch (IllegalStateException ie) {
                    if (!TRACE.isDebugEnabled()) break block4;
                    SibTr.exception((TraceComponent)TRACE, (Exception)ie);
                }
            }
            if (TRACE.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"resume");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block17: {
                String methodName = "resume$Runnable";
                if (TRACE.isEntryEnabled()) {
                    SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"resume$Runnable");
                }
                SibRaListener.this.mpcPacingSessionStarted = true;
                Object object = SibRaListener.this.asyncResumeCallbackWaitLock;
                synchronized (object) {
                    while (!SibRaListener.this.sibPacingSessionStarted) {
                        try {
                            SibRaListener.this.callbackWaiting = true;
                            SibRaListener.this.asyncResumeCallbackWaitLock.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
                object = SibRaListener.this;
                synchronized (object) {
                    if (this._cachedEnumeration != null) {
                        if (TRACE.isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)TRACE, (String)"resuming with", (Object)new Object[]{this._cachedEnumeration, this._cachedAsynchDispatchScheduler});
                        }
                        SibRaListener.this.internalConsumeMessages(this._cachedEnumeration, this._cachedAsynchDispatchScheduler);
                        this._cachedEnumeration = null;
                        this._cachedAsynchDispatchScheduler = null;
                    }
                }
                try {
                    SibRaListener.this._session.start(true);
                }
                catch (SIException exception) {
                    FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + "." + "resume$Runnable"), (String)"1:1419:1.68", (Object)this);
                    if (TRACE.isEventEnabled()) {
                        SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)exception));
                    }
                }
                catch (SIErrorException exception) {
                    FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + "." + "resume$Runnable"), (String)"1:1427:1.68", (Object)this);
                    if (!TRACE.isEventEnabled()) break block17;
                    SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)exception));
                }
            }
            if (TRACE.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"resume$Runnable");
            }
        }
    }
}

