/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.SIDestinationAddress;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SINotPossibleInCurrentConfigurationException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.mfp.JsDestinationAddress;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.processor.exceptions.SIMPNoLocalisationsException;
import com.ibm.ws.sib.processor.impl.ConnectionImpl;
import com.ibm.ws.sib.processor.impl.corespitrace.CoreSPIBrowserSession;
import com.ibm.ws.sib.processor.impl.interfaces.BrowseCursor;
import com.ibm.ws.sib.processor.impl.interfaces.ConsumerManager;
import com.ibm.ws.sib.processor.impl.interfaces.DestinationHandler;
import com.ibm.ws.sib.processor.impl.interfaces.MPDestinationSession;
import com.ibm.ws.sib.processor.utils.SIMPUtils;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.BrowserSession;
import com.ibm.wsspi.sib.core.SIBusMessage;
import com.ibm.wsspi.sib.core.SICoreConnection;
import com.ibm.wsspi.sib.core.SelectionCriteria;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import com.ibm.wsspi.sib.core.exception.SIDiscriminatorSyntaxException;
import com.ibm.wsspi.sib.core.exception.SISelectorSyntaxException;
import com.ibm.wsspi.sib.core.exception.SISessionDroppedException;
import com.ibm.wsspi.sib.core.exception.SISessionUnavailableException;

public final class BrowserSessionImpl
implements BrowserSession,
MPDestinationSession {
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceNLS nls_cwsik = TraceNLS.getTraceNLS((String)"com.ibm.websphere.sib.CWSIKMessages");
    private static final TraceComponent tc = SibTr.register(BrowserSessionImpl.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private SelectionCriteria _selectionCriteria;
    private ConnectionImpl _conn;
    private boolean _closed;
    private DestinationHandler _dest;
    private BrowseCursor _browseCursor;
    private ConsumerManager _consumerManager;
    private SIDestinationAddress _destinationAddress;
    private SIBUuid12 uuid;

    public BrowserSessionImpl(DestinationHandler dest, SelectionCriteria selectionCriteria, ConnectionImpl conn, SIDestinationAddress address, boolean gatherMessages) throws SINotPossibleInCurrentConfigurationException, SIResourceException, SISelectorSyntaxException, SIDiscriminatorSyntaxException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"BrowserSessionImpl", (Object)new Object[]{dest, selectionCriteria, conn, address, gatherMessages});
        }
        this._conn = conn;
        this._dest = dest;
        this._selectionCriteria = selectionCriteria;
        this._destinationAddress = address;
        this.uuid = new SIBUuid12();
        if (dest != null) {
            if (!dest.isPubSub()) {
                JsDestinationAddress jsDestAddr = (JsDestinationAddress)this._destinationAddress;
                if (jsDestAddr.getME() == null && jsDestAddr.isLocalOnly() && dest.getLocalPtoPConsumerManager() != null) {
                    jsDestAddr.setME(dest.getMessageProcessor().getMessagingEngineUuid());
                }
                this._consumerManager = dest.chooseConsumerManager(gatherMessages ? dest.getUuid() : null, jsDestAddr.getME(), null);
                if (this._consumerManager == null) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)("ConsumerDispatcher not found (" + jsDestAddr.getME() + ")"));
                    }
                    SIMPNoLocalisationsException e = new SIMPNoLocalisationsException(nls_cwsik.getFormattedMessage("DELIVERY_ERROR_SIRC_26", new Object[]{jsDestAddr.getDestinationName()}, null));
                    e.setExceptionReason(26);
                    e.setExceptionInserts(new String[]{jsDestAddr.getDestinationName()});
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"BrowserSessionImpl", (Object)e);
                    }
                    throw e;
                }
                if (this._consumerManager.isLocked()) {
                    SINotPossibleInCurrentConfigurationException e = new SINotPossibleInCurrentConfigurationException(nls.getFormattedMessage("DESTINATION_IS_LOCKED_ERROR_CWSIP0085", new Object[]{dest.getName(), dest.getMessageProcessor().getMessagingEngineName()}, null));
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"BrowserSessionImpl", (Object)((Object)e));
                    }
                    throw e;
                }
                this._consumerManager.attachBrowser(this);
                this._browseCursor = this._consumerManager.getBrowseCursor(selectionCriteria);
            }
        } else {
            this._browseCursor = null;
        }
        this._closed = false;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"BrowserSessionImpl", (Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SIBusMessage next() throws SISessionUnavailableException, SISessionDroppedException, SIResourceException, SIConnectionLostException, SIErrorException {
        if (TraceComponent.isAnyTracingEnabled() && CoreSPIBrowserSession.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPIBrowserSession.tc, (String)"next", (Object)this);
        }
        JsMessage msg = null;
        BrowserSessionImpl browserSessionImpl = this;
        synchronized (browserSessionImpl) {
            this.checkNotClosed();
            if (this._browseCursor != null) {
                try {
                    msg = this._browseCursor.next();
                }
                catch (SISessionDroppedException e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.BrowserSessionImpl.next", (String)"1:265:1.78.1.7", (Object)this);
                    this.close();
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                    SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.BrowserSessionImpl", "1:274:1.78.1.7", e});
                    if (TraceComponent.isAnyTracingEnabled() && CoreSPIBrowserSession.tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)CoreSPIBrowserSession.tc, (String)"next", (Object)((Object)e));
                    }
                    throw e;
                }
                catch (SIResourceException e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.BrowserSessionImpl.next", (String)"1:287:1.78.1.7", (Object)this);
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                    SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.BrowserSessionImpl", "1:294:1.78.1.7", e});
                    if (TraceComponent.isAnyTracingEnabled() && CoreSPIBrowserSession.tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)CoreSPIBrowserSession.tc, (String)"next", (Object)((Object)e));
                    }
                    throw e;
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPIBrowserSession.tc, (String)"next", (Object)msg);
        }
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (TraceComponent.isAnyTracingEnabled() && CoreSPIBrowserSession.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPIBrowserSession.tc, (String)"close", (Object)this);
        }
        BrowserSessionImpl browserSessionImpl = this;
        synchronized (browserSessionImpl) {
            if (!this._closed) {
                this._conn.removeBrowserSession(this);
                this._close();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && CoreSPIBrowserSession.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPIBrowserSession.tc, (String)"close");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void _close() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"_close");
        }
        BrowserSessionImpl browserSessionImpl = this;
        synchronized (browserSessionImpl) {
            if (!this._closed) {
                if (this._consumerManager != null) {
                    this._consumerManager.detachBrowser(this);
                }
                if (this._browseCursor != null) {
                    try {
                        this._browseCursor.finished();
                    }
                    catch (SISessionDroppedException e) {
                        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.BrowserSessionImpl._close", (String)"1:363:1.78.1.7", (Object)this);
                        SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                        SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.BrowserSessionImpl._close", "1:370:1.78.1.7", SIMPUtils.getStackTrace(e)});
                    }
                }
                this._browseCursor = null;
                this._conn = null;
                this._closed = true;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"_close");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean _closeBrowserDestinationDeleted(DestinationHandler destinationHandler) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"_closeBrowserDestinationDeleted", (Object)destinationHandler);
        }
        if (destinationHandler == this._dest) {
            BrowserSessionImpl browserSessionImpl = this;
            synchronized (browserSessionImpl) {
                if (!this._closed) {
                    this._conn.removeBrowserSession(this);
                    if (this._consumerManager != null) {
                        this._consumerManager.detachBrowser(this);
                    }
                    if (this._browseCursor != null) {
                        try {
                            this._browseCursor.finished();
                        }
                        catch (SISessionDroppedException e) {
                            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.BrowserSessionImpl._closeBrowserDestinationDeleted", (String)"1:423:1.78.1.7", (Object)this);
                            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.BrowserSessionImpl._closeBrowserDestinationDeleted", "1:430:1.78.1.7", SIMPUtils.getStackTrace(e)});
                        }
                    }
                    this._browseCursor = null;
                    this._conn = null;
                    this._closed = true;
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"_closeBrowserDestinationDeleted", (Object)new Boolean(this._closed));
        }
        return this._closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkNotClosed() throws SISessionUnavailableException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"checkNotClosed");
        }
        BrowserSessionImpl browserSessionImpl = this;
        synchronized (browserSessionImpl) {
            if (this._closed) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"checkNotClosed", (Object)"Object closed");
                }
                throw new SISessionUnavailableException(nls.getFormattedMessage("OBJECT_CLOSED_ERROR_CWSIP0081", new Object[]{this._dest.getName(), this._dest.getMessageProcessor().getMessagingEngineName()}, null));
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"checkNotClosed");
        }
    }

    public SICoreConnection getConnection() throws SISessionUnavailableException {
        if (TraceComponent.isAnyTracingEnabled() && CoreSPIBrowserSession.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPIBrowserSession.tc, (String)"getConnection", (Object)this);
            SibTr.exit((TraceComponent)CoreSPIBrowserSession.tc, (String)"getConnection", (Object)this._conn);
        }
        this.checkNotClosed();
        return this._conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() throws SISessionUnavailableException, SISessionDroppedException, SIResourceException, SIConnectionLostException, SIErrorException {
        if (TraceComponent.isAnyTracingEnabled() && CoreSPIBrowserSession.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPIBrowserSession.tc, (String)"reset", (Object)this);
        }
        BrowserSessionImpl browserSessionImpl = this;
        synchronized (browserSessionImpl) {
            this.checkNotClosed();
            if (this._browseCursor != null) {
                try {
                    this._browseCursor.finished();
                }
                catch (SISessionDroppedException e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.BrowserSessionImpl.reset", (String)"1:525:1.78.1.7", (Object)this);
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                    SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.BrowserSessionImpl", "1:532:1.78.1.7", e});
                }
            }
            try {
                this._browseCursor = this._consumerManager.getBrowseCursor(this._selectionCriteria);
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.BrowserSessionImpl.reset", (String)"1:548:1.78.1.7", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)e);
                SIResourceException e2 = new SIResourceException((Throwable)e);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"reset", (Object)((Object)e2));
                }
                throw e2;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && CoreSPIBrowserSession.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPIBrowserSession.tc, (String)"reset");
        }
    }

    public SIDestinationAddress getDestinationAddress() {
        if (TraceComponent.isAnyTracingEnabled() && CoreSPIBrowserSession.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPIBrowserSession.tc, (String)"getDestinationAddress", (Object)this);
            SibTr.exit((TraceComponent)CoreSPIBrowserSession.tc, (String)"getDestinationAddress", (Object)this._destinationAddress);
        }
        return this._destinationAddress;
    }

    public DestinationHandler getNamedDestination() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getNamedDestination");
            SibTr.exit((TraceComponent)tc, (String)"getNamedDestination", (Object)this._dest);
        }
        return this._dest;
    }

    @Override
    public SIBUuid12 getUuid() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getUuid");
            SibTr.exit((TraceComponent)tc, (String)"getUuid", (Object)this.uuid);
        }
        return this.uuid;
    }
}

