/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.netty.internal.tcp;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.logging.LoggingHandler;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.SocketAddress;

@Trivial
@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
class TCPLoggingHandler
extends LoggingHandler {
    protected static final TraceComponent tc = Tr.register(TCPLoggingHandler.class, (String[])new String[]{"TCPChannel", "Netty"}, (String)"com.ibm.ws.tcpchannel.internal.resources.TCPChannelMessages", (String)TCPLoggingHandler.class.getName());
    protected static final AttributeKey<Integer> BYTES_READ_KEY = AttributeKey.valueOf((String)"BYTES_READ");
    static final long serialVersionUID = -8945886071110551247L;

    public TCPLoggingHandler() {
        super(TCPLoggingHandler.class);
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((Object)ctx.channel(), (TraceComponent)tc, (String)("handler added to" + ctx + ", channel " + ctx.channel()), (Object[])new Object[0]);
        }
        ctx.channel().attr(BYTES_READ_KEY).getAndSet((Object)0);
        super.handlerAdded(ctx);
    }

    public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((Object)ctx.channel(), (TraceComponent)tc, (String)("registered Logging Handler for channel: " + ctx.channel()), (Object[])new Object[0]);
        }
        ctx.fireChannelRegistered();
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((Object)ctx.channel(), (TraceComponent)tc, (String)("SocketChannel accepted, local: " + ctx.channel().localAddress() + " remote: " + ctx.channel().remoteAddress()), (Object[])new Object[0]);
        }
        ctx.fireChannelActive();
    }

    public void bind(ChannelHandlerContext ctx, SocketAddress localAddress, ChannelPromise promise) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((Object)ctx.channel(), (TraceComponent)tc, (String)("Calling bind, local: " + localAddress), (Object[])new Object[0]);
        }
        super.bind(ctx, localAddress, promise);
    }

    public void connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((Object)ctx.channel(), (TraceComponent)tc, (String)("Calling connect, local: " + localAddress + " remote: " + remoteAddress), (Object[])new Object[0]);
        }
        super.connect(ctx, remoteAddress, localAddress, promise);
    }

    public void disconnect(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((Object)ctx.channel(), (TraceComponent)tc, (String)("Channel disconnected, local: " + ctx.channel().localAddress() + " remote: " + ctx.channel().remoteAddress()), (Object[])new Object[0]);
        }
        ctx.disconnect(promise);
    }

    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((Object)ctx.channel(), (TraceComponent)tc, (String)("read completed. Read: " + ctx.channel().attr(BYTES_READ_KEY).getAndSet((Object)0) + " bytes"), (Object[])new Object[0]);
        }
        ctx.fireChannelReadComplete();
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((Object)ctx.channel(), (TraceComponent)tc, (String)("read (async) called for local: " + ctx.channel().localAddress() + " remote: " + ctx.channel().remoteAddress() + " bytes read: " + ((ByteBuf)msg).readableBytes()), (Object[])new Object[0]);
        }
        ctx.channel().attr(BYTES_READ_KEY).getAndSet((Object)((Integer)ctx.channel().attr(BYTES_READ_KEY).get() + ((ByteBuf)msg).readableBytes()));
        ctx.fireChannelRead(msg);
    }

    public void write(final ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((Object)ctx.channel(), (TraceComponent)tc, (String)("write (async) requested for local: " + ctx.channel().localAddress() + " remote: " + ctx.channel().remoteAddress() + (msg instanceof ByteBuf ? " bytes to be written: " + ((ByteBuf)msg).readableBytes() : " object to write: " + msg)), (Object[])new Object[0]);
        }
        final Integer bytesToWrite = ((ByteBuf)msg).readableBytes();
        ctx.write(msg, promise).addListener((GenericFutureListener)new ChannelFutureListener(){
            static final long serialVersionUID = -1736687312836491795L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            public void operationComplete(ChannelFuture future) throws Exception {
                if (future.isSuccess() && TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event((Object)ctx.channel(), (TraceComponent)tc, (String)("write (async) finished sucessfully for local: " + ctx.channel().localAddress() + " remote: " + ctx.channel().remoteAddress() + " wrote: " + bytesToWrite + " bytes"), (Object[])new Object[0]);
                } else if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event((Object)ctx.channel(), (TraceComponent)tc, (String)("write (async) FAILED for local: " + ctx.channel().localAddress() + " remote: " + ctx.channel().remoteAddress() + " did not write : " + bytesToWrite + " bytes"), (Object[])new Object[0]);
                }
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"io.openliberty.netty.internal.tcp.TCPLoggingHandler$1", 1.class, null, null);
            }
        });
    }

    public void flush(ChannelHandlerContext ctx) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((Object)ctx.channel(), (TraceComponent)tc, (String)("flush requested for local: " + ctx.channel().localAddress() + " remote: " + ctx.channel().remoteAddress()), (Object[])new Object[0]);
        }
        ctx.flush();
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((Object)ctx.channel(), (TraceComponent)tc, (String)("userEvent triggered for local: " + ctx.channel().localAddress() + " remote: " + ctx.channel().remoteAddress() + " event: " + evt), (Object[])new Object[0]);
        }
        super.userEventTriggered(ctx, evt);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((Object)ctx.channel(), (TraceComponent)tc, (String)("SocketChannel closed, local: " + ctx.channel().localAddress() + " remote: " + ctx.channel().remoteAddress()), (Object[])new Object[0]);
        }
        ctx.fireChannelInactive();
    }
}

