/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.orb.OBPortableServer;

import org.apache.yoko.orb.OB.ORBInstance;
import org.apache.yoko.orb.OBPortableServer.ActiveObjectOnlyStrategy;
import org.apache.yoko.orb.OBPortableServer.DefaultServantHolder;
import org.apache.yoko.orb.OBPortableServer.NonRetainStrategy;
import org.apache.yoko.orb.OBPortableServer.POAPolicies;
import org.apache.yoko.orb.OBPortableServer.RetainStrategy;
import org.apache.yoko.orb.OBPortableServer.ServantActivatorStrategy;
import org.apache.yoko.orb.OBPortableServer.ServantLocationStrategy;
import org.apache.yoko.orb.OBPortableServer.ServantLocatorStrategy;
import org.omg.PortableServer.RequestProcessingPolicyValue;
import org.omg.PortableServer.ServantRetentionPolicyValue;

class ServantLocationStrategyFactory {
    ServantLocationStrategyFactory() {
    }

    public static ServantLocationStrategy createServantLocationStrategy(POAPolicies policies, ORBInstance orbInstance) {
        if (policies.requestProcessingPolicy() == RequestProcessingPolicyValue.USE_ACTIVE_OBJECT_MAP_ONLY) {
            return new ActiveObjectOnlyStrategy(policies, orbInstance);
        }
        ServantLocatorStrategy servantLocator = null;
        ServantActivatorStrategy servantActivator = null;
        DefaultServantHolder defaultServant = null;
        if (policies.requestProcessingPolicy() == RequestProcessingPolicyValue.USE_DEFAULT_SERVANT) {
            defaultServant = new DefaultServantHolder();
        }
        if (policies.requestProcessingPolicy() == RequestProcessingPolicyValue.USE_SERVANT_MANAGER) {
            if (policies.servantRetentionPolicy() == ServantRetentionPolicyValue.RETAIN) {
                servantActivator = new ServantActivatorStrategy();
            } else {
                servantLocator = new ServantLocatorStrategy(orbInstance);
            }
        }
        if (policies.servantRetentionPolicy() == ServantRetentionPolicyValue.RETAIN) {
            return new RetainStrategy(policies, orbInstance, servantActivator, defaultServant);
        }
        return new NonRetainStrategy(servantLocator, defaultServant);
    }
}

