/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.util.actions;

import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.validator.internal.util.CollectionHelper;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;

public final class GetAnnotationAttributes {
    private static final Log LOG = LoggerFactory.make(MethodHandles.lookup());

    private GetAnnotationAttributes() {
    }

    public static Map<String, Object> action(Annotation annotation) {
        Method[] declaredMethods = annotation.annotationType().getDeclaredMethods();
        HashMap<String, Object> attributes = CollectionHelper.newHashMap(declaredMethods.length);
        for (Method m : declaredMethods) {
            if (m.isSynthetic()) continue;
            m.setAccessible(true);
            String attributeName = m.getName();
            try {
                attributes.put(m.getName(), m.invoke((Object)annotation, new Object[0]));
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw LOG.getUnableToGetAnnotationAttributeException(annotation.getClass(), attributeName, e);
            }
        }
        return CollectionHelper.toImmutableMap(attributes);
    }
}

