/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jpa.management;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.javaee.dd.common.PersistenceContextRef;
import com.ibm.ws.javaee.dd.common.Property;
import com.ibm.ws.jpa.management.AbstractJPAInjectionBinding;
import com.ibm.ws.jpa.management.JPAPCtxtAttributeAccessor;
import com.ibm.wsspi.injectionengine.ComponentNameSpaceConfiguration;
import com.ibm.wsspi.injectionengine.InjectionBinding;
import com.ibm.wsspi.injectionengine.InjectionConfigurationException;
import com.ibm.wsspi.injectionengine.InjectionException;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import jakarta.persistence.PersistenceContextType;
import jakarta.persistence.PersistenceProperty;
import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.util.List;
import java.util.Map;
import java.util.Properties;

class JPAPCtxtInjectionBinding
extends AbstractJPAInjectionBinding<PersistenceContext> {
    private static final TraceComponent tc = Tr.register(JPAPCtxtInjectionBinding.class, (String)"JPA", (String)"com.ibm.ws.jpa.jpa");
    private final JPAPCtxtAttributeAccessor ivAttributeAccessor;
    private boolean ivPuFromXML;
    private Boolean ivExtendedType;
    private boolean ivTypeFromXML;
    private Boolean ivUnsynchronized;
    private boolean ivSynchronizationFromXML;
    private Properties ivProperties;

    public JPAPCtxtInjectionBinding(PersistenceContextRef pCtxtRef, ComponentNameSpaceConfiguration compNSConfig, JPAPCtxtAttributeAccessor attributeAccessor) throws InjectionException {
        super(JPAPCtxtInjectionBinding.newPersistenceContext(pCtxtRef.getName(), pCtxtRef.getPersistenceUnitName(), pCtxtRef.getTypeValue(), pCtxtRef.getProperties()), pCtxtRef.getName(), pCtxtRef.getPersistenceUnitName(), compNSConfig);
        int synchronization;
        int type;
        this.ivAttributeAccessor = attributeAccessor;
        this.setInjectionClassType(EntityManager.class);
        String pUnitName = pCtxtRef.getPersistenceUnitName();
        if (pUnitName != null && pUnitName.length() > 0) {
            this.ivPuFromXML = true;
        }
        if ((type = pCtxtRef.getTypeValue()) != -1) {
            this.ivExtendedType = type == 1;
            this.ivTypeFromXML = true;
        }
        if ((synchronization = pCtxtRef.getSynchronizationValue()) != -1) {
            this.ivUnsynchronized = synchronization == 1;
            this.ivSynchronizationFromXML = true;
        }
        this.ivProperties = JPAPCtxtInjectionBinding.getPersistenceProperties(pCtxtRef);
    }

    public JPAPCtxtInjectionBinding(PersistenceContext pCtxt, ComponentNameSpaceConfiguration compNSConfig, JPAPCtxtAttributeAccessor attributeAccessor) throws InjectionException {
        super(pCtxt, pCtxt.name(), pCtxt.unitName(), compNSConfig);
        this.ivAttributeAccessor = attributeAccessor;
        this.setInjectionClassType(EntityManager.class);
        this.ivExtendedType = pCtxt.type() == PersistenceContextType.EXTENDED;
        this.ivUnsynchronized = attributeAccessor.isUnsynchronized(pCtxt);
        this.ivProperties = JPAPCtxtInjectionBinding.getPersistenceProperties(pCtxt);
    }

    public boolean isExtendedType() {
        return this.ivExtendedType != null && this.ivExtendedType != false;
    }

    public boolean isUnsynchronized() {
        return this.ivUnsynchronized != null && this.ivUnsynchronized != false;
    }

    public Properties getProperties() {
        return this.ivProperties;
    }

    public void merge(PersistenceContextRef pCtxtRef) throws InjectionException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("merge : " + pCtxtRef), (Object[])new Object[0]);
        }
        String thisUnitName = this.getPuName();
        String mergedUnitName = pCtxtRef.getPersistenceUnitName();
        int mergedType = pCtxtRef.getTypeValue();
        Boolean mergedExtendedType = null;
        if (mergedType != -1) {
            mergedExtendedType = mergedType == 1;
        }
        int mergedSync = pCtxtRef.getSynchronizationValue();
        Boolean mergedUnsynchronized = null;
        if (mergedSync != -1) {
            mergedUnsynchronized = mergedSync == 1;
        }
        Properties mergedProperties = JPAPCtxtInjectionBinding.getPersistenceProperties(pCtxtRef);
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("new=" + this.getJndiName() + ":" + mergedUnitName + ":" + mergedExtendedType + ":" + mergedUnsynchronized + ":" + mergedProperties), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("cur=" + this.getJndiName() + ":" + thisUnitName + ":" + this.ivExtendedType + ":" + this.ivProperties), (Object[])new Object[0]);
        }
        if (thisUnitName == null || thisUnitName.equals("")) {
            if (mergedUnitName != null) {
                this.setPuName(mergedUnitName);
                this.ivPuFromXML = true;
            }
        } else if (mergedUnitName != null && !mergedUnitName.equals("") && !thisUnitName.equals(mergedUnitName)) {
            Tr.error((TraceComponent)tc, (String)"CONFLICTING_XML_VALUES_CWWJP0041E", (Object[])new Object[]{this.ivNameSpaceConfig.getModuleName(), this.ivNameSpaceConfig.getApplicationName(), "persistence-unit-name", "persistence-context-ref", "persistence-context-ref-name", this.getJndiName(), thisUnitName, mergedUnitName});
            String exMsg = "CWWJP0041E: The " + this.ivNameSpaceConfig.getModuleName() + " module of the " + this.ivNameSpaceConfig.getApplicationName() + " application has conflicting configuration data in the XML deployment descriptor. Conflicting persistence-unit-name element values exist for multiple persistence-context-ref elements with the same persistence-context-ref-name element value : " + this.getJndiName() + ". The conflicting persistence-unit-name element values are " + thisUnitName + " and " + mergedUnitName + ".";
            throw new InjectionConfigurationException(exMsg);
        }
        if (this.ivExtendedType == null) {
            if (mergedExtendedType != null) {
                this.ivExtendedType = mergedExtendedType;
                this.ivTypeFromXML = true;
            }
        } else if (mergedExtendedType != null && this.ivExtendedType.booleanValue() != mergedExtendedType.booleanValue()) {
            Tr.error((TraceComponent)tc, (String)"CONFLICTING_XML_VALUES_CWWJP0041E", (Object[])new Object[]{this.ivNameSpaceConfig.getModuleName(), this.ivNameSpaceConfig.getApplicationName(), "persistence-context-type", "persistence-context-ref", "persistence-context-ref-name", this.getJndiName(), JPAPCtxtInjectionBinding.getTypeName(this.ivExtendedType), JPAPCtxtInjectionBinding.getTypeName(mergedExtendedType)});
            String exMsg = "CWWJP0041E: The " + this.ivNameSpaceConfig.getModuleName() + " module of the " + this.ivNameSpaceConfig.getApplicationName() + " application has conflicting configuration data in the XML deployment descriptor. Conflicting persistence-context-type element values exist for multiple persistence-context-ref elements with the same persistence-context-ref-name element value : " + this.getJndiName() + ". The conflicting persistence-context-type element values are " + JPAPCtxtInjectionBinding.getTypeName(this.ivExtendedType) + " and " + JPAPCtxtInjectionBinding.getTypeName(mergedExtendedType) + ".";
            throw new InjectionConfigurationException(exMsg);
        }
        if (this.ivUnsynchronized == null) {
            if (mergedUnsynchronized != null) {
                this.ivUnsynchronized = mergedUnsynchronized;
                this.ivSynchronizationFromXML = true;
            }
        } else if (mergedUnsynchronized != null && this.ivUnsynchronized.booleanValue() != mergedUnsynchronized.booleanValue()) {
            Tr.error((TraceComponent)tc, (String)"CONFLICTING_XML_VALUES_CWWJP0041E", (Object[])new Object[]{this.ivNameSpaceConfig.getModuleName(), this.ivNameSpaceConfig.getApplicationName(), "persistence-context-synchronization", "persistence-context-ref", "persistence-context-ref-name", this.getJndiName(), this.getSynchronizationName(this.ivUnsynchronized), this.getSynchronizationName(mergedUnsynchronized)});
            String exMsg = "CWWJP0041E: The " + this.ivNameSpaceConfig.getModuleName() + " module of the " + this.ivNameSpaceConfig.getApplicationName() + " application has conflicting configuration data in the XML deployment descriptor. Conflicting persistence-context-synchronization element values exist for multiple persistence-context-ref elements with the same persistence-context-ref-name element value : " + this.getJndiName() + ". The conflicting persistence-context-type element values are " + this.getSynchronizationName(this.ivUnsynchronized) + " and " + this.getSynchronizationName(mergedUnsynchronized) + ".";
            throw new InjectionConfigurationException(exMsg);
        }
        if (this.ivProperties.isEmpty()) {
            this.ivProperties = mergedProperties;
        } else if (!mergedProperties.isEmpty() && !this.ivProperties.equals(mergedProperties)) {
            Tr.error((TraceComponent)tc, (String)"CONFLICTING_XML_VALUES_CWWJP0041E", (Object[])new Object[]{this.ivNameSpaceConfig.getModuleName(), this.ivNameSpaceConfig.getApplicationName(), "persistence-property", "persistence-context-ref", "persistence-context-ref-name", this.getJndiName(), this.ivProperties, mergedProperties});
            String exMsg = "CWWJP0041E: The " + this.ivNameSpaceConfig.getModuleName() + " module of the " + this.ivNameSpaceConfig.getApplicationName() + " application has conflicting configuration data in the XML deployment descriptor. Conflicting persistence-property element values exist for multiple persistence-context-ref elements with the same persistence-context-ref-name element value : " + this.getJndiName() + ". The conflicting persistence-property element values are " + this.ivProperties + " and " + mergedProperties + ".";
            throw new InjectionConfigurationException(exMsg);
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("merge : " + (Object)((Object)this)));
        }
    }

    public void merge(PersistenceContext annotation, Class<?> instanceClass, Member member) throws InjectionException {
        String mergedUnitName;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("merge : " + annotation + ", " + instanceClass + ", " + member), (Object[])new Object[0]);
        }
        String thisUnitName = this.getPuName();
        if (!this.ivPuFromXML && (mergedUnitName = annotation.unitName()) != null && mergedUnitName.length() > 0) {
            if (!(this.isComplete() || thisUnitName != null && thisUnitName.length() != 0)) {
                this.setPuName(mergedUnitName);
            } else if (!mergedUnitName.equals(thisUnitName)) {
                Tr.error((TraceComponent)tc, (String)"CONFLICTING_ANNOTATION_VALUES_CWWJP0042E", (Object[])new Object[]{this.ivNameSpaceConfig.getDisplayName(), this.ivNameSpaceConfig.getModuleName(), this.ivNameSpaceConfig.getApplicationName(), "unitName", "@PersistenceContext", "name", this.getJndiName(), thisUnitName, mergedUnitName});
                String exMsg = "The " + this.ivNameSpaceConfig.getDisplayName() + " bean in the " + this.ivNameSpaceConfig.getModuleName() + " module of the " + this.ivNameSpaceConfig.getApplicationName() + " application has conflicting configuration data in source code annotations. Conflicting unitName attribute values exist for multiple @PersistenceContext annotations with the same name attribute value : " + this.getJndiName() + ". The conflicting unitName attribute values are " + thisUnitName + " and " + mergedUnitName + ".";
                throw new InjectionConfigurationException(exMsg);
            }
        }
        if (!this.ivTypeFromXML) {
            Boolean mergedExtendedType = annotation.type() == PersistenceContextType.EXTENDED;
            if (!this.isComplete() && this.ivExtendedType == null) {
                this.ivExtendedType = mergedExtendedType;
            }
        }
        if (!this.ivSynchronizationFromXML) {
            boolean mergedUnsynchronized = this.ivAttributeAccessor.isUnsynchronized(annotation);
            if (!this.isComplete() && this.ivUnsynchronized == null) {
                this.ivUnsynchronized = mergedUnsynchronized;
            } else if (this.ivUnsynchronized == null || this.ivUnsynchronized != mergedUnsynchronized) {
                Tr.error((TraceComponent)tc, (String)"CONFLICTING_ANNOTATION_VALUES_CWWJP0042E", (Object[])new Object[]{this.ivNameSpaceConfig.getDisplayName(), this.ivNameSpaceConfig.getModuleName(), this.ivNameSpaceConfig.getApplicationName(), "synchronization", "@PersistenceContext", "name", this.getJndiName(), this.getSynchronizationName(this.ivUnsynchronized), this.getSynchronizationName(mergedUnsynchronized)});
                String exMsg = "The " + this.ivNameSpaceConfig.getDisplayName() + " bean in the " + this.ivNameSpaceConfig.getModuleName() + " module of the " + this.ivNameSpaceConfig.getApplicationName() + " application has conflicting configuration data in source code annotations. Conflicting synchronization attribute values exist for multiple @PersistenceContext annotations with the same name attribute value : " + this.getJndiName() + ". The conflicting synchronization attribute values are " + this.getSynchronizationName(this.ivUnsynchronized) + " and " + this.getSynchronizationName(mergedUnsynchronized) + ".";
                throw new InjectionConfigurationException(exMsg);
            }
        }
        Properties mergedProperties = JPAPCtxtInjectionBinding.getPersistenceProperties(annotation);
        if (!this.isComplete() && !mergedProperties.isEmpty()) {
            mergedProperties.putAll((Map<?, ?>)this.ivProperties);
            this.ivProperties = mergedProperties;
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"merge", (Object)((Object)this));
        }
    }

    public void mergeSaved(InjectionBinding<PersistenceContext> injectionBinding) throws InjectionException {
        JPAPCtxtInjectionBinding pCtxtBinding = (JPAPCtxtInjectionBinding)injectionBinding;
        this.mergeSavedValue(this.getPuName(), pCtxtBinding.getPuName(), "persistence-unit-name");
        this.mergeSavedValue(JPAPCtxtInjectionBinding.getTypeName(this.ivExtendedType), JPAPCtxtInjectionBinding.getTypeName(pCtxtBinding.ivExtendedType), "persistence-context-type");
        this.mergeSavedValue(this.getSynchronizationName(this.ivUnsynchronized), this.getSynchronizationName(pCtxtBinding.ivUnsynchronized), "persistence-context-synchronization");
    }

    private static String getTypeName(Boolean extended) {
        return extended != null && extended != false ? "EXTENDED" : "TRANSACTION";
    }

    private String getSynchronizationName(Boolean unsynchronized) {
        return unsynchronized != null && unsynchronized != false ? "UNSYNCHRONIZED" : "SYNCHRONIZED";
    }

    private static Properties getPersistenceProperties(PersistenceContext pCtxt) {
        Properties properties = new Properties();
        for (PersistenceProperty property : pCtxt.properties()) {
            properties.put(property.name(), property.value());
        }
        return properties;
    }

    private static Properties getPersistenceProperties(PersistenceContextRef pCtxtRef) {
        Properties properties = new Properties();
        for (Property property : pCtxtRef.getProperties()) {
            properties.put(property.getName(), property.getValue());
        }
        return properties;
    }

    private static PersistenceContext newPersistenceContext(final String fJndiName, final String fUnitName, final int fCtxType, final List<Property> fCtxProperties) {
        return new PersistenceContext(){

            public Class<? extends Annotation> annotationType() {
                return PersistenceContext.class;
            }

            public String name() {
                return fJndiName;
            }

            public PersistenceProperty[] properties() {
                PersistenceProperty[] props = new PersistenceProperty[fCtxProperties.size()];
                int i = 0;
                for (Property property : fCtxProperties) {
                    final String name = property.getName();
                    final String value = property.getValue();
                    PersistenceProperty prop = new PersistenceProperty(){

                        public Class<? extends Annotation> annotationType() {
                            return PersistenceProperty.class;
                        }

                        public String name() {
                            return name;
                        }

                        public String value() {
                            return value;
                        }
                    };
                    props[i++] = prop;
                }
                return props;
            }

            public PersistenceContextType type() {
                if (fCtxType == 0) {
                    return PersistenceContextType.TRANSACTION;
                }
                return PersistenceContextType.EXTENDED;
            }

            public String unitName() {
                return fUnitName;
            }

            public String toString() {
                return "JPA.PersistenceContext(name=" + fJndiName + ", unitName=" + fUnitName + ")";
            }
        };
    }
}

