/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webserver.plugin.utility;

import com.ibm.ws.product.utility.CommandConsole;
import com.ibm.ws.product.utility.CommandTask;
import com.ibm.ws.product.utility.CommandTaskRegistry;
import com.ibm.ws.product.utility.ExecutionContext;
import com.ibm.ws.product.utility.ExecutionContextImpl;
import com.ibm.ws.webserver.plugin.utility.tasks.GeneratePluginTask;
import com.ibm.ws.webserver.plugin.utility.tasks.HelpTask;
import com.ibm.ws.webserver.plugin.utility.tasks.MergePluginFilesTask;
import com.ibm.ws.webserver.plugin.utility.utils.CommandUtils;
import com.ibm.ws.webserver.plugin.utility.utils.PluginUtilityConsole;

public class WebServerPluginUtility {
    static final String SCRIPT_NAME = "pluginUtility";
    private final PluginUtilityConsole commandConsole;
    CommandTaskRegistry taskResgistry = new CommandTaskRegistry();

    WebServerPluginUtility(PluginUtilityConsole cmdConsole) {
        this.commandConsole = cmdConsole;
    }

    void registerTask(CommandTask task) {
        this.taskResgistry.registerCommandTask(task.getTaskName(), task);
    }

    private CommandTask getTask(String taskName) {
        return this.taskResgistry.getCommandTask(taskName);
    }

    int runProgram(String[] args) {
        CommandTask task;
        if (!this.commandConsole.isStandardOutAvailable()) {
            this.commandConsole.printErrorMessage(CommandUtils.getMessage("error.missingIO", "stdout"));
            return 253;
        }
        if (!this.commandConsole.isStandardErrorAvailable()) {
            this.commandConsole.printInfoMessage(CommandUtils.getMessage("error.missingIO", "stderr"));
            return 252;
        }
        HelpTask help = new HelpTask(SCRIPT_NAME);
        this.registerTask(help);
        ExecutionContextImpl executionCtx = new ExecutionContextImpl((CommandConsole)this.commandConsole, args, this.taskResgistry);
        if (args.length == 0) {
            help.execute((ExecutionContext)executionCtx);
            return 0;
        }
        if (WebServerPluginUtility.looksLikeHelp(help, args[0])) {
            args[0] = help.getTaskName();
        }
        if ((task = this.getTask(args[0])) == null) {
            this.commandConsole.printlnErrorMessage(CommandUtils.getMessage("task.unknown", args[0]));
            help.execute((ExecutionContext)executionCtx);
            return 0;
        }
        try {
            task.execute((ExecutionContext)executionCtx);
        }
        catch (IllegalArgumentException e) {
            this.commandConsole.printlnErrorMessage("");
            this.commandConsole.printlnErrorMessage(CommandUtils.getMessage("error", e.getMessage()));
            help.execute((ExecutionContext)executionCtx);
            return 20;
        }
        return 0;
    }

    private static boolean looksLikeHelp(HelpTask help, String taskname) {
        int start;
        if (taskname == null) {
            return false;
        }
        int len = taskname.length();
        for (start = 0; start < len && !Character.isLetter(taskname.charAt(start)); ++start) {
        }
        return help.getTaskName().equalsIgnoreCase(taskname.substring(start).toLowerCase());
    }

    public static void main(String[] args) {
        PluginUtilityConsole console = new PluginUtilityConsole(System.console(), System.out, System.err);
        WebServerPluginUtility util = new WebServerPluginUtility(console);
        util.registerTask(new MergePluginFilesTask(SCRIPT_NAME));
        util.registerTask(new GeneratePluginTask(SCRIPT_NAME, console));
        int rc = util.runProgram(args);
        System.exit(rc);
    }
}

