/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.client.proxyqueue.queue;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.comms.client.ConsumerSessionProxy;
import com.ibm.ws.sib.comms.client.proxyqueue.AsynchConsumerProxyQueue;
import com.ibm.ws.sib.comms.client.proxyqueue.ProxyQueue;
import com.ibm.ws.sib.comms.client.proxyqueue.impl.ConversationHelper;
import com.ibm.ws.sib.comms.client.proxyqueue.impl.LockedMessageEnumerationImpl;
import com.ibm.ws.sib.comms.client.proxyqueue.queue.Queue;
import com.ibm.ws.sib.comms.client.proxyqueue.queue.QueueData;
import com.ibm.ws.sib.comms.common.CommsByteBuffer;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.LockedMessageEnumeration;
import com.ibm.wsspi.sib.core.exception.SIConnectionDroppedException;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import java.util.LinkedList;

public class AsynchConsumerQueue
implements Queue {
    private static String CLASS_NAME = AsynchConsumerQueue.class.getName();
    private static final TraceComponent tc = SibTr.register(AsynchConsumerQueue.class, (String)"SIBCommunications", (String)"com.ibm.ws.sib.comms.CWSICMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.comms.CWSICMessages");
    private boolean ordered = false;
    private int batchesReady = 0;
    private LinkedList<QueueData> queue = new LinkedList();
    private long batchesReceived = 0L;
    private long messagesReceived = 0L;
    private Object concurrentAccessLock = new Object();

    public AsynchConsumerQueue(boolean ordered) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>", (Object)("" + ordered));
        }
        this.ordered = ordered;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"<init>");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(QueueData queueData, short msgBatch) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"put", (Object)new Object[]{queueData, "" + msgBatch});
        }
        AsynchConsumerQueue asynchConsumerQueue = this;
        synchronized (asynchConsumerQueue) {
            if (!this.ordered && this.batchesReady == 1) {
                SIErrorException e = new SIErrorException(nls.getFormattedMessage("ASYNC_BATCH_ALREADY_READY_SICO1031", null, null));
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".put"), (String)"2-007-0001", (Object)this);
                throw e;
            }
            this.queue.addLast(queueData);
            if (!queueData.isChunkedMessage()) {
                this.notifyMessageReceived(queueData.isLastInBatch());
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("Put has completed: " + this));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"put");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void appendToLastMessage(CommsByteBuffer msgBuffer, boolean lastChunk) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"appendToLastMessage", (Object)new Object[]{msgBuffer, lastChunk});
        }
        AsynchConsumerQueue asynchConsumerQueue = this;
        synchronized (asynchConsumerQueue) {
            QueueData queueData = this.queue.getLast();
            queueData.addSlice(msgBuffer, lastChunk);
            if (lastChunk) {
                this.notifyMessageReceived(queueData.isLastInBatch());
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("Append has completed: " + this));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"appendToLastMessage");
        }
    }

    private void notifyMessageReceived(boolean lastInBatch) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"notifyMessageReceived", (Object)lastInBatch);
        }
        if (lastInBatch) {
            ++this.batchesReceived;
            ++this.batchesReady;
        }
        ++this.messagesReceived;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"notifyMessageReceived");
        }
    }

    @Override
    public synchronized boolean isEmpty(short sessionId) {
        QueueData data;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"isEmpty", (Object)("sessionId=" + sessionId));
        }
        boolean isEmpty = true;
        if (!this.isQueueEmpty() && (data = this.queue.getFirst()).getProxyQueue().getId() == sessionId && this.batchesReady > 0) {
            isEmpty = false;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"isEmpty", (Object)("" + isEmpty));
        }
        return isEmpty;
    }

    @Override
    public synchronized boolean isQueueEmpty() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"isQueueEmpty");
        }
        boolean result = this.queue.isEmpty();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"isQueueEmpty", (Object)("" + result));
        }
        return result;
    }

    @Override
    public synchronized void purge(short sessionId) {
        int x;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"purge", (Object)("" + sessionId));
        }
        int[] indexsToDelete = new int[this.queue.size()];
        int indexCount = 0;
        boolean completeBatchRemoved = false;
        for (x = 0; x < this.queue.size(); ++x) {
            QueueData data = this.queue.get(x);
            if (data.getProxyQueue().getId() != sessionId) continue;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Deleting item: " + data));
            }
            indexsToDelete[indexCount++] = x;
            completeBatchRemoved = data.isLastInBatch();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("Removing " + indexCount + " entries"));
        }
        for (x = indexCount - 1; x >= 0; --x) {
            this.queue.remove(indexsToDelete[x]);
        }
        if (completeBatchRemoved) {
            --this.batchesReady;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("Purge completed. Queue is now: " + this));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"purge");
        }
    }

    public String toString() {
        return "AsyncQueue@" + Integer.toHexString(this.hashCode()) + ":- CurDepth: " + this.queue.size() + ", ordered: " + this.ordered + ", messagesReceived: " + this.messagesReceived + ", batchesReceived: " + this.batchesReceived + ", batchesReady: " + this.batchesReady;
    }

    @Override
    public Object getConcurrentAccessLock() {
        return this.concurrentAccessLock;
    }

    private synchronized JsMessage[] getBatch(int batchSize, ConversationHelper convHelper) throws SIResourceException, SIConnectionDroppedException {
        QueueData qd;
        AsynchConsumerProxyQueue pq;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getBatch", (Object)new Object[]{batchSize, convHelper});
        }
        if (this.batchesReady == 0) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"No batches are ready!!");
            }
            SIErrorException e = new SIErrorException(nls.getFormattedMessage("ASYNC_BATCH_NOT_READY_SICO1033", null, null));
            FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".getBatch"), (String)"2-007-0003", (Object)this);
            throw e;
        }
        short currentSessionId = 0;
        JsMessage[] msg = new JsMessage[batchSize];
        QueueData data = null;
        for (int i = 0; i < msg.length; ++i) {
            data = this.queue.removeFirst();
            currentSessionId = data.getProxyQueue().getId();
            msg[i] = (JsMessage)data.getMessage();
            if (data.isLastInBatch()) break;
        }
        --this.batchesReady;
        if (!this.isQueueEmpty() && (pq = (AsynchConsumerProxyQueue)(qd = this.queue.get(0)).getProxyQueue()).getId() != currentSessionId) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Next data on the queue is for a different session:", (Object)pq);
            }
            pq.nudge();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getBatch", (Object)msg);
        }
        return msg;
    }

    @Override
    public void deliverBatch(int batchSize, short sessionId, ConversationHelper convHelper) {
        block20: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"deliverBatch", (Object)new Object[]{"" + batchSize, "" + sessionId, convHelper});
            }
            QueueData queueData = this.queue.get(0);
            AsynchConsumerProxyQueue proxyQueue = (AsynchConsumerProxyQueue)queueData.getProxyQueue();
            proxyQueue.setAsynchConsumerThread(Thread.currentThread());
            ConsumerSessionProxy cs = (ConsumerSessionProxy)proxyQueue.getDestinationSessionProxy();
            cs.resetCallbackThreadState();
            boolean unlockAllMessages = false;
            try {
                int remainingLockedMessages;
                JsMessage[] msgs = this.getBatch(batchSize, convHelper);
                LockedMessageEnumerationImpl lockedMsgEnum = new LockedMessageEnumerationImpl(proxyQueue, this, msgs, Thread.currentThread(), proxyQueue.getLMEOperationMonitor());
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)" ** About to call user callback **");
                }
                proxyQueue.getAsynchConsumerCallback().consumeMessages((LockedMessageEnumeration)lockedMsgEnum);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)" ** User callback has returned  **");
                }
                if ((remainingLockedMessages = lockedMsgEnum.getRemainingMessageCount()) != 0) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)("There are still " + remainingLockedMessages + " locked messages! - Unlocking them"));
                    }
                    lockedMsgEnum.unlockUnseen();
                }
            }
            catch (Throwable t) {
                FFDCFilter.processException((Throwable)t, (String)(CLASS_NAME + ".deliverBatch"), (String)"2-007-0005", (Object)this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"exception thrown");
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    SibTr.event((TraceComponent)tc, (String)"exception", (Object)t);
                }
                proxyQueue.setAsynchConsumerThread(null);
                cs.deliverAsyncException(t);
                unlockAllMessages = true;
            }
            proxyQueue.setAsynchConsumerThread(null);
            this.concurrentAccessLock.notifyAll();
            try {
                if (cs.performInCallbackActions()) {
                    if (!unlockAllMessages && proxyQueue.getStarted() && !proxyQueue.isStopping()) {
                        convHelper.requestNextMessageBatch();
                    } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)("Not requesting next message batch: unlockAllMessages=" + unlockAllMessages + "isStarted=" + proxyQueue.getStarted() + "isStopping=" + proxyQueue.isStopping()));
                    }
                }
            }
            catch (SIException e) {
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".deliverBatch"), (String)"2-007-0008", (Object)this);
                cs.deliverAsyncException(e);
            }
            if (unlockAllMessages) {
                try {
                    cs.unlockAll();
                }
                catch (SIException e) {
                    FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".deliverBatch"), (String)"2-007-0007", (Object)this);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"exception thrown");
                    }
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block20;
                    SibTr.event((TraceComponent)tc, (String)"exception", (Object)((Object)e));
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"deliverBatch");
        }
    }

    @Override
    public JsMessage get(short id) throws SIResourceException, SIConnectionLostException, SIConnectionDroppedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"get", (Object)id);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)"Method not permitted for async queues");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"get", (Object)"SIErrorException");
        }
        throw new SIErrorException();
    }

    @Override
    public void unlockAll() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"unlockAll");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"unlockAll");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitUntilEmpty(short sessionId) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"waitUntilEmpty", (Object)("sessionId=" + sessionId));
        }
        Object object = this.concurrentAccessLock;
        synchronized (object) {
            while (!this.isQueueEmptyForSessionId(sessionId)) {
                try {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"waiting");
                    }
                    this.concurrentAccessLock.wait();
                }
                catch (InterruptedException e) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) continue;
                    SibTr.exception((Object)this, (TraceComponent)tc, (Exception)e);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"waitUntilEmpty");
        }
    }

    private synchronized boolean isQueueEmptyForSessionId(short sessionId) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"isQueueEmptyForSessionId", (Object)("sessionId=" + sessionId));
        }
        boolean empty = true;
        for (QueueData data : this.queue) {
            ProxyQueue pq = data.getProxyQueue();
            if (pq.getId() != sessionId) continue;
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Found match: ", (Object)pq);
            }
            empty = false;
            break;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"isQueueEmptyForSessionId", (Object)empty);
        }
        return empty;
    }

    static {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#) SIB/ws/code/sib.comms.client.impl/src/com/ibm/ws/sib/comms/client/proxyqueue/queue/AsynchConsumerQueue.java, SIB.comms, WASX.SIB, uu1215.01 1.44");
        }
    }
}

