/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.dynamic.bundle;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.dynamic.bundle.DynamicBundleException;
import com.ibm.ws.dynamic.bundle.ManifestFactory;
import com.ibm.ws.dynamic.bundle.ServiceComponentDeclaration;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Formatter;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import org.eclipse.equinox.region.Region;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class BundleFactory
extends ManifestFactory {
    private static final TraceComponent tc = Tr.register(BundleFactory.class, (String)"DynamicBundle", null);
    private static final String EXTRAS_SHA_HEADER = "IBM-Extras-SHA";
    private static final String SHA_ALGORITHM = "SHA-256";
    private static final String SHA_ALGORITHM_DEFAULT = "SHA-1";
    private BundleContext bundleContext;
    private String bundleLocationPrefix = "VirtualBundle@";
    private String bundleLocation = null;
    private Region region = null;
    private String defaultInstance = null;
    private String metatypeXML = null;
    private final List<ServiceComponentDeclaration> components = new ArrayList<ServiceComponentDeclaration>();
    private static String shaAlgorithm;
    static final long serialVersionUID = -7509196236451085981L;

    public BundleFactory setBundleContext(BundleContext ctx) {
        this.bundleContext = ctx;
        return this;
    }

    public BundleFactory setBundleLocationPrefix(String prefix) {
        this.bundleLocationPrefix = prefix;
        return this;
    }

    public BundleFactory setBundleLocation(String loc) {
        this.bundleLocation = loc;
        return this;
    }

    public BundleFactory setRegion(Region region) {
        this.region = region;
        return this;
    }

    public BundleFactory setDefaultInstance(String defaultInstance) {
        this.defaultInstance = defaultInstance;
        return this;
    }

    public BundleFactory setMetatypeXML(String metatypeXML) {
        this.metatypeXML = metatypeXML;
        return this;
    }

    public BundleFactory declare(ServiceComponentDeclaration component) {
        this.components.add(component);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public Bundle createBundle() {
        String methodName = "createBundle(): ";
        if (this.bundleContext == null) {
            throw new IllegalStateException("bundleContext == null");
        }
        if (this.bundleLocation == null) {
            throw new IllegalStateException("bundleLocation == null");
        }
        try {
            String location = this.bundleLocationPrefix + this.bundleLocation;
            this.declareServiceComponents();
            this.computeExtrasSha();
            Manifest m = this.createManifest();
            Bundle bundle = this.bundleContext.getBundle(location);
            if (bundle != null) {
                if (this.sameManifests(m, bundle.getHeaders(""))) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"createBundle(): Using previously installed bundle", (Object[])new Object[]{bundle.getLocation(), bundle.getBundleId()});
                    }
                    return bundle;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"createBundle(): Updating previously installed bundle", (Object[])new Object[]{bundle.getLocation(), bundle.getBundleId()});
                }
            }
            InputStream in = this.getBundleInputStream(m);
            if (bundle != null) {
                Region oldRegion;
                block13: {
                    try {
                        bundle.stop();
                    }
                    catch (BundleException bundleException) {
                        void be;
                        FFDCFilter.processException((Throwable)bundleException, (String)"com.ibm.ws.dynamic.bundle.BundleFactory", (String)"160", (Object)this, (Object[])new Object[0]);
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block13;
                        Tr.debug((Object)this, (TraceComponent)tc, (String)"Exception while stopping bundle", (Object[])new Object[]{be});
                    }
                }
                if (this.region != null && !this.region.equals(oldRegion = this.region.getRegionDigraph().getRegion(bundle))) {
                    oldRegion.removeBundle(bundle);
                    this.region.addBundle(bundle);
                }
                bundle.update(in);
                return bundle;
            }
            if (this.region != null) {
                return this.region.installBundleAtLocation(location, in);
            }
            return this.bundleContext.installBundle(location, in);
        }
        catch (BundleException location) {
            void e;
            FFDCFilter.processException((Throwable)location, (String)"com.ibm.ws.dynamic.bundle.BundleFactory", (String)"184", (Object)this, (Object[])new Object[0]);
            throw new DynamicBundleException("Failed to create bundle", (Throwable)e);
        }
    }

    private void computeExtrasSha() {
        if (this.components.isEmpty() && this.defaultInstance == null && this.metatypeXML == null) {
            return;
        }
        try {
            MessageDigest shaDigest = this.getShaDigest();
            for (ServiceComponentDeclaration component : this.components) {
                shaDigest.update(component.toString().getBytes(StandardCharsets.UTF_8));
            }
            if (this.defaultInstance != null) {
                shaDigest.update(this.defaultInstance.getBytes(StandardCharsets.UTF_8));
            }
            if (this.metatypeXML != null) {
                shaDigest.update(this.metatypeXML.getBytes(StandardCharsets.UTF_8));
            }
            this.addAttributeValues(EXTRAS_SHA_HEADER, BundleFactory.getHexSHA(shaDigest));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            FFDCFilter.processException((Throwable)noSuchAlgorithmException, (String)"com.ibm.ws.dynamic.bundle.BundleFactory", (String)"206", (Object)this, (Object[])new Object[0]);
        }
    }

    @FFDCIgnore(value={NoSuchAlgorithmException.class})
    private MessageDigest getShaDigest() throws NoSuchAlgorithmException {
        if (shaAlgorithm == null) {
            try {
                shaAlgorithm = SHA_ALGORITHM;
                return MessageDigest.getInstance(SHA_ALGORITHM);
            }
            catch (NoSuchAlgorithmException e) {
                try {
                    shaAlgorithm = SHA_ALGORITHM_DEFAULT;
                    return MessageDigest.getInstance(SHA_ALGORITHM_DEFAULT);
                }
                catch (NoSuchAlgorithmException e2) {
                    shaAlgorithm = null;
                    throw e2;
                }
            }
        }
        return MessageDigest.getInstance(shaAlgorithm);
    }

    static String getHexSHA(MessageDigest digest) {
        Formatter hexFormat = new Formatter();
        for (byte b : digest.digest()) {
            hexFormat.format("%02x", b);
        }
        return hexFormat.toString();
    }

    private boolean sameManifests(Manifest m, Dictionary<String, String> headers) {
        Attributes mainAttrs = m.getMainAttributes();
        if (mainAttrs.size() != headers.size()) {
            return false;
        }
        for (Map.Entry<Object, Object> entry : mainAttrs.entrySet()) {
            if (entry.getValue().equals(headers.get(entry.getKey().toString()))) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private InputStream getBundleInputStream(Manifest manifest) {
        try {
            ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
            JarOutputStream jarOut = new JarOutputStream((OutputStream)bytesOut, manifest);
            for (ServiceComponentDeclaration component : this.components) {
                jarOut.putNextEntry(new JarEntry(component.getFileName()));
                jarOut.write(component.toString().getBytes(StandardCharsets.UTF_8));
                jarOut.closeEntry();
            }
            if (this.defaultInstance != null) {
                jarOut.putNextEntry(new JarEntry("OSGI-INF/wlp/defaultInstances.xml"));
                jarOut.write(this.defaultInstance.getBytes(StandardCharsets.UTF_8));
                jarOut.closeEntry();
            }
            if (this.metatypeXML != null) {
                jarOut.putNextEntry(new JarEntry("OSGI-INF/metatype/metatype.xml"));
                jarOut.write(this.metatypeXML.getBytes(StandardCharsets.UTF_8));
                jarOut.closeEntry();
            }
            jarOut.flush();
            jarOut.close();
            bytesOut.close();
            ByteArrayInputStream bytesIn = new ByteArrayInputStream(bytesOut.toByteArray());
            return bytesIn;
        }
        catch (IOException bytesOut) {
            void e;
            FFDCFilter.processException((Throwable)bytesOut, (String)"com.ibm.ws.dynamic.bundle.BundleFactory", (String)"295", (Object)this, (Object[])new Object[]{manifest});
            throw new DynamicBundleException("Could not create in-memory jar file for dynamic bundle", (Throwable)e);
        }
    }

    private void declareServiceComponents() {
        ArrayList<String> componentList = new ArrayList<String>();
        for (ServiceComponentDeclaration component : this.components) {
            componentList.add(component.getFileName());
        }
        this.declareServiceComponents(componentList);
    }

    @Override
    public BundleFactory setManifestVersion(String manifestVersion) {
        return (BundleFactory)super.setManifestVersion(manifestVersion);
    }

    @Override
    public BundleFactory setBundleName(String bundleName) {
        return (BundleFactory)super.setBundleName(bundleName);
    }

    @Override
    public BundleFactory setBundleVersion(Version bundleVersion) {
        return (BundleFactory)super.setBundleVersion(bundleVersion);
    }

    @Override
    public BundleFactory setBundleVendor(String vendor) {
        return (BundleFactory)super.setBundleVendor(vendor);
    }

    @Override
    public BundleFactory setBundleDescription(String desc) {
        return (BundleFactory)super.setBundleDescription(desc);
    }

    @Override
    public BundleFactory setBundleManifestVersion(String bundleManifestVersion) {
        return (BundleFactory)super.setBundleManifestVersion(bundleManifestVersion);
    }

    @Override
    public BundleFactory setBundleSymbolicName(String bundleSymbolicName) {
        return (BundleFactory)super.setBundleSymbolicName(bundleSymbolicName);
    }

    @Override
    public BundleFactory setLazyActivation(boolean lazy) {
        return (BundleFactory)super.setLazyActivation(lazy);
    }

    @Override
    public BundleFactory importPackages(String ... packages) {
        return (BundleFactory)super.importPackages(packages);
    }

    @Override
    public BundleFactory requireBundles(String ... bundles) {
        return (BundleFactory)super.requireBundles(bundles);
    }

    @Override
    public BundleFactory dynamicallyImportPackages(String ... packages) {
        return (BundleFactory)super.dynamicallyImportPackages(packages);
    }

    @Override
    public BundleFactory declareServiceComponents(String ... components) {
        return (BundleFactory)super.declareServiceComponents(components);
    }

    @Override
    public BundleFactory addAttributeValues(String name, Object ... values) {
        return (BundleFactory)super.addAttributeValues(name, values);
    }

    @Override
    public BundleFactory importPackages(Iterable<String> packages) {
        return (BundleFactory)super.importPackages(packages);
    }

    @Override
    public BundleFactory requireBundles(Iterable<String> bundles) {
        return (BundleFactory)super.requireBundles(bundles);
    }

    @Override
    public BundleFactory dynamicallyImportPackages(Iterable<String> packages) {
        return (BundleFactory)super.dynamicallyImportPackages(packages);
    }

    @Override
    public BundleFactory declareServiceComponents(Iterable<String> components) {
        return (BundleFactory)super.declareServiceComponents(components);
    }

    @Override
    public BundleFactory addManifestAttribute(String name, Iterable<? extends Object> values) {
        return (BundleFactory)super.addManifestAttribute(name, values);
    }
}

