/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.client.internal.jaas;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.client.jaas.modules.WSClientLoginModuleImpl;
import com.ibm.ws.security.jaas.common.JAASConfiguration;
import com.ibm.ws.security.jaas.common.JAASLoginContextEntry;
import com.ibm.ws.security.jaas.common.JAASLoginModuleConfig;
import com.ibm.wsspi.kernel.service.utils.ConcurrentServiceReferenceMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.security.auth.login.AppConfigurationEntry;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={JAASConfiguration.class}, configurationPolicy=ConfigurationPolicy.IGNORE, property={"service.vendor=IBM"})
public class JAASClientConfigurationImpl
implements JAASConfiguration {
    static final TraceComponent tc = Tr.register(JAASClientConfigurationImpl.class, (String)"security", (String)"com.ibm.ws.security.client.internal.resources.SecurityClientMessages");
    public static final Class<WSClientLoginModuleImpl> WSCLIENTLOGIN_MODULE_IMPL_CLASS = WSClientLoginModuleImpl.class;
    private ConcurrentServiceReferenceMap<String, JAASLoginContextEntry> jaasLoginContextEntries;
    public static final String WAS_IGNORE_CLIENT_CONTAINER_DD = "was.ignoreClientContainerDD";
    static final long serialVersionUID = -1063333654368296953L;

    public void setJaasLoginContextEntries(ConcurrentServiceReferenceMap<String, JAASLoginContextEntry> jaasLoginContextEntries) {
        this.jaasLoginContextEntries = jaasLoginContextEntries;
    }

    public Map<String, List<AppConfigurationEntry>> getEntries() {
        HashMap<String, List<AppConfigurationEntry>> jaasConfigurationEntries = new HashMap<String, List<AppConfigurationEntry>>();
        HashMap<String, String> jaasConfigIDs = new HashMap<String, String>();
        if (this.jaasLoginContextEntries != null) {
            Iterator lcEntries = this.jaasLoginContextEntries.getServices();
            while (lcEntries.hasNext()) {
                JAASLoginContextEntry loginContextEntry = (JAASLoginContextEntry)lcEntries.next();
                String entryName = loginContextEntry.getEntryName();
                List loginModules = loginContextEntry.getLoginModules();
                List<AppConfigurationEntry> appConfEntries = this.getLoginModules(loginModules, entryName);
                if (appConfEntries == null || appConfEntries.isEmpty()) continue;
                if (jaasConfigIDs.containsKey(entryName)) {
                    String id = (String)jaasConfigIDs.get(entryName);
                    Tr.warning((TraceComponent)tc, (String)"JAAS_LOGIN_CONTEXT_ENTRY_HAS_DUPLICATE_NAME", (Object[])new Object[]{entryName, id, loginContextEntry.getId()});
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("configure jaasContextLoginEntry id: " + loginContextEntry.getId()), (Object[])new Object[0]);
                    Tr.debug((TraceComponent)tc, (String)("configure jaasContextLoginEntry: " + entryName + " has " + appConfEntries.size() + " loginModule(s)"), (Object[])new Object[0]);
                    Tr.debug((TraceComponent)tc, (String)("appConfEntry: " + appConfEntries), (Object[])new Object[0]);
                }
                jaasConfigurationEntries.put(entryName, appConfEntries);
                jaasConfigIDs.put(entryName, loginContextEntry.getId());
            }
        }
        return jaasConfigurationEntries;
    }

    public List<AppConfigurationEntry> getLoginModules(List<JAASLoginModuleConfig> loginModules, String loginContextEntryName) {
        ArrayList<AppConfigurationEntry> loginModuleEntries = new ArrayList<AppConfigurationEntry>();
        for (JAASLoginModuleConfig loginModule : loginModules) {
            if (loginModule != null) {
                AppConfigurationEntry loginModuleEntry = this.createAppConfigurationEntry(loginModule, loginContextEntryName);
                loginModuleEntries.add(loginModuleEntry);
                continue;
            }
            throw new IllegalStateException("Missing login module: found: " + loginModules);
        }
        return loginModuleEntries;
    }

    public AppConfigurationEntry createAppConfigurationEntry(JAASLoginModuleConfig loginModule, String loginContextEntryName) {
        String loginModuleClassName = loginModule.getClassName();
        AppConfigurationEntry.LoginModuleControlFlag controlFlag = loginModule.getControlFlag();
        HashMap<String, Boolean> options = new HashMap<String, Boolean>();
        options.putAll(loginModule.getOptions());
        if ("WSLogin".equals(loginContextEntryName)) {
            options.put(WAS_IGNORE_CLIENT_CONTAINER_DD, true);
        } else {
            options.put(WAS_IGNORE_CLIENT_CONTAINER_DD, false);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("loginModuleClassName: " + loginModuleClassName + " options: " + ((Object)options).toString() + " controlFlag: " + controlFlag.toString()), (Object[])new Object[0]);
        }
        AppConfigurationEntry loginModuleEntry = new AppConfigurationEntry(loginModuleClassName, controlFlag, options);
        return loginModuleEntry;
    }
}

