/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.providers.extension;

import io.smallrye.common.annotation.CheckReturnValue;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.subscription.Cancellable;
import io.smallrye.reactive.messaging.EmitterConfiguration;
import io.smallrye.reactive.messaging.MutinyEmitter;
import io.smallrye.reactive.messaging.providers.extension.AbstractEmitter;
import io.smallrye.reactive.messaging.providers.i18n.ProviderExceptions;
import io.smallrye.reactive.messaging.providers.i18n.ProviderLogging;
import io.smallrye.reactive.messaging.providers.locals.ContextAwareMessage;
import io.vertx.core.Context;
import io.vertx.core.Vertx;
import org.eclipse.microprofile.reactive.messaging.Message;

public class MutinyEmitterImpl<T>
extends AbstractEmitter<T>
implements MutinyEmitter<T> {
    public MutinyEmitterImpl(EmitterConfiguration config, long defaultBufferSize) {
        super(config, defaultBufferSize);
    }

    @Override
    @CheckReturnValue
    public Uni<Void> send(T payload) {
        if (payload == null) {
            throw ProviderExceptions.ex.illegalArgumentForNullValue();
        }
        return this.sendMessage(Message.of(payload));
    }

    @Override
    public void sendAndAwait(T payload) {
        this.send(payload).await().indefinitely();
    }

    @Override
    public Cancellable sendAndForget(T payload) {
        return this.send(payload).subscribe().with(x -> {}, ProviderLogging.log::failureEmittingMessage);
    }

    @Override
    public <M extends Message<? extends T>> void send(M msg) {
        this.sendMessageAndForget(msg);
    }

    @Override
    public <M extends Message<? extends T>> Cancellable sendMessageAndForget(M msg) {
        return this.sendMessage(msg).subscribe().with(x -> {}, ProviderLogging.log::failureEmittingMessage);
    }

    @Override
    public <M extends Message<? extends T>> void sendMessageAndAwait(M msg) {
        this.sendMessage(msg).await().indefinitely();
    }

    @Override
    @CheckReturnValue
    public <M extends Message<? extends T>> Uni<Void> sendMessage(M msg) {
        if (msg == null) {
            throw ProviderExceptions.ex.illegalArgumentForNullValue();
        }
        Context context = Vertx.currentContext();
        Uni uni = Uni.createFrom().emitter(e -> {
            try {
                this.emit(ContextAwareMessage.withContextMetadata(msg).withAck(() -> {
                    e.complete(null);
                    return msg.ack();
                }).withNack(t -> {
                    e.fail(t);
                    return msg.nack(t);
                }));
            }
            catch (Exception t2) {
                msg.nack((Throwable)t2);
                throw t2;
            }
        });
        if (context != null) {
            uni = uni.emitOn(runnable -> context.runOnContext(x -> runnable.run()));
        }
        return uni;
    }
}

