/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.saml.sso20.slo;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.common.web.WebUtils;
import com.ibm.ws.security.saml.sso20.binding.BasicMessageContext;
import com.ibm.ws.security.saml.sso20.slo.SLOMessageContextUtils;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class SLOPostLogoutPageBuilder {
    private static TraceComponent tc = Tr.register(SLOPostLogoutPageBuilder.class, (String)"SAML20", (String)"com.ibm.ws.security.saml.sso20.internal.resources.SamlSso20Messages");
    private HttpServletRequest request = null;
    private BasicMessageContext<?, ?> messageContext = null;
    private SLOMessageContextUtils msgContextUtils = null;
    static final long serialVersionUID = 1688378885121112858L;

    public SLOPostLogoutPageBuilder(HttpServletRequest request, BasicMessageContext<?, ?> msgCtx) {
        this.request = request;
        this.messageContext = msgCtx;
        this.msgContextUtils = new SLOMessageContextUtils(this.messageContext);
    }

    public void writeDefaultLogoutPage(HttpServletResponse response) throws IOException {
        PrintWriter writer = response.getWriter();
        writer.println(this.getPostLogoutPageHtml());
        writer.close();
    }

    String getPostLogoutPageHtml() {
        String html = "<!DOCTYPE html>\n";
        html = html + "<html " + this.getHtmlLang() + ">\n";
        html = html + this.createHtmlHead() + "\n";
        html = html + this.createHtmlBody() + "\n";
        html = html + "</html>";
        return html;
    }

    String getHtmlLang() {
        if (this.request != null) {
            return "lang=\"" + this.request.getLocale() + "\"";
        }
        return "";
    }

    String createHtmlHead() {
        String html = "<head>\n";
        html = html + "<meta charset=\"utf-8\">\n";
        html = html + "<title>" + WebUtils.htmlEncode((String)this.getHtmlTitle()) + "</title>\n";
        html = html + "</head>";
        return html;
    }

    String getHtmlTitle() {
        return Tr.formatMessage((TraceComponent)tc, (Enumeration)this.request.getLocales(), (String)"POST_LOGOUT_PAGE_TITLE", (Object[])new Object[0]);
    }

    String createHtmlBody() {
        String html = "<body>\n";
        html = html + this.getBodyText() + "\n";
        html = html + "</body>";
        return html;
    }

    String getBodyText() {
        if (this.isSuccessStatusCode(this.msgContextUtils.getSloStatusCode())) {
            return Tr.formatMessage((TraceComponent)tc, (Enumeration)this.request.getLocales(), (String)"POST_LOGOUT_PAGE_SUCCESS_TEXT", (Object[])new Object[0]);
        }
        return Tr.formatMessage((TraceComponent)tc, (Enumeration)this.request.getLocales(), (String)"POST_LOGOUT_PAGE_FAILURE_TEXT", (Object[])new Object[0]);
    }

    boolean isSuccessStatusCode(String statusCodeValue) {
        if (statusCodeValue == null) {
            return false;
        }
        return statusCodeValue.equals("urn:oasis:names:tc:SAML:2.0:status:Success");
    }
}

