/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container.tu;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.websphere.sip.IBMSipSession;
import com.ibm.ws.sip.container.failover.repository.SessionRepository;
import com.ibm.ws.sip.container.parser.SipServletDesc;
import com.ibm.ws.sip.container.pmi.PerformanceMgr;
import com.ibm.ws.sip.container.properties.PropertiesStore;
import com.ibm.ws.sip.container.proxy.ProxyBranchImpl;
import com.ibm.ws.sip.container.router.SipRouter;
import com.ibm.ws.sip.container.router.SipServletInvokerListener;
import com.ibm.ws.sip.container.servlets.B2buaHelperImpl;
import com.ibm.ws.sip.container.servlets.IncomingSipServletRequest;
import com.ibm.ws.sip.container.servlets.SipApplicationSessionImpl;
import com.ibm.ws.sip.container.servlets.SipServletRequestImpl;
import com.ibm.ws.sip.container.servlets.SipServletResponseImpl;
import com.ibm.ws.sip.container.servlets.SipSessionImplementation;
import com.ibm.ws.sip.container.timer.Invite2xxRetransmitTimer;
import com.ibm.ws.sip.container.transaction.ClientTransaction;
import com.ibm.ws.sip.container.transaction.ClientTransactionListener;
import com.ibm.ws.sip.container.transaction.ServerTransactionListener;
import com.ibm.ws.sip.container.transaction.SipTransaction;
import com.ibm.ws.sip.container.tu.TUKey;
import com.ibm.ws.sip.container.tu.TransactionUserBase;
import com.ibm.ws.sip.container.tu.TransactionUserImpl;
import com.ibm.ws.sip.container.util.ContainerObjectPool;
import com.ibm.ws.sip.container.util.SipUtil;
import com.ibm.ws.sip.container.util.wlm.DialogAux;
import com.ibm.ws.sip.container.util.wlm.SipDialogContext;
import com.ibm.ws.sip.container.was.ThreadLocalStorage;
import jain.protocol.ip.sip.SipProvider;
import jain.protocol.ip.sip.address.SipURL;
import jain.protocol.ip.sip.message.Response;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import javax.servlet.ServletException;
import javax.servlet.sip.Address;
import javax.servlet.sip.B2buaHelper;
import javax.servlet.sip.SipApplicationSession;
import javax.servlet.sip.SipApplicationSessionListener;
import javax.servlet.sip.SipServletMessage;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;
import javax.servlet.sip.SipSession;
import javax.servlet.sip.SipSessionListener;
import javax.servlet.sip.UAMode;
import javax.servlet.sip.URI;
import javax.servlet.sip.ar.SipApplicationRoutingRegion;

public class TransactionUserWrapper
implements ServerTransactionListener,
ClientTransactionListener,
Serializable,
SipServletInvokerListener,
SipDialogContext {
    private static final transient LogMgr c_logger = Log.get(TransactionUserWrapper.class);
    private static final String MAX_TU_POOL_SIZE = "max.tu.pool.size";
    private static ContainerObjectPool s_tuPool = new ContainerObjectPool(TransactionUserImpl.class, "max.tu.pool.size");
    private transient TransactionUserImpl _transactionUser = null;
    private transient TransactionUserBase _baseTU = null;
    protected transient int _transactionsCounter = 0;
    protected transient int _NewTransactionsCounter = 0;
    private transient int _extraTransactionsCounter = 0;
    private transient boolean _invalidating = false;
    private transient boolean _partialInvalidate = false;
    protected transient boolean _cleaned = false;
    private final transient Object _syncObject = new Object();
    protected transient int _methodInWorkCounter = 0;
    boolean addedToInvalidateWhenReadyList = false;
    protected transient boolean _pendingMessageExists = false;
    private boolean _receivedFinalResponse = false;
    private transient ProxyBranchImpl branch = null;
    protected transient boolean _derived = false;
    private TransactionUserWrapper _origTUWrapper;

    public TransactionUserWrapper() {
    }

    public TransactionUserWrapper(SipServletRequestImpl sipMessage, boolean isServerTransaction, SipApplicationSessionImpl appSession, boolean pendingMessageExists) {
        this._baseTU = new TransactionUserBase();
        this._baseTU.initialize(this, sipMessage, appSession);
        this._transactionUser = TransactionUserWrapper.getTUImplObjectFromPool();
        this._transactionUser.initialize(this, sipMessage, isServerTransaction, appSession);
        this._baseTU.attachToSipAppSession();
        this._pendingMessageExists = pendingMessageExists;
    }

    public void setBranch(ProxyBranchImpl newBranch) {
        if (this.branch != null && !this.branch.equals(newBranch)) {
            this.branch.unrelateTU(this);
        }
        this.branch = newBranch;
    }

    public ProxyBranchImpl getBranch() {
        return this.branch;
    }

    public void createSessionsWhenListenerExists() {
        SipSession ss;
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(this, "createSessionsWhenListenerExists");
        }
        if (!PropertiesStore.getInstance().getProperties().getBoolean("createSessionsWhenListenersExist")) {
            if (c_logger.isTraceEntryExitEnabled()) {
                c_logger.traceExit((Object)this, "createSessionsWhenListenerExists", "not creating, custom property is false");
            }
            return;
        }
        SipApplicationSession sipApp = this.getApplicationSession(false);
        if (sipApp == null) {
            Collection<SipApplicationSessionListener> sasListeners = null;
            if (this.getSipServletDesc() != null && this.getSipServletDesc().getSipApp() != null) {
                sasListeners = this.getSipServletDesc().getSipApp().getAppSessionListeners();
            } else if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "createSessionsWhenListenerExists", "SipAppDesc was not found, SAS will not get created");
            }
            if (sasListeners != null && !sasListeners.isEmpty()) {
                this.getApplicationSession(true);
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(this, "createSessionsWhenListenerExists", "SAS listeners were found, SAS was created");
                }
            }
        }
        if ((ss = this.getSipSession(false)) == null) {
            Collection<SipSessionListener> ssListeners = null;
            if (sipApp != null) {
                ssListeners = ((SipApplicationSessionImpl)sipApp).getAppDescriptor().getSessionListeners();
            } else if (this.getSipServletDesc() != null && this.getSipServletDesc().getSipApp() != null) {
                ssListeners = this.getSipServletDesc().getSipApp().getSessionListeners();
            } else if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "createSessionsWhenListenerExists", "SipAppDesc was not found, SS will not get created");
            }
            if (ssListeners != null && !ssListeners.isEmpty()) {
                this.getSipSession(true);
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(this, "createSessionsWhenListenerExists", "SS listeners were found, SS was created");
                }
            }
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "createSessionsWhenListenerExists");
        }
    }

    public TransactionUserWrapper(TransactionUserWrapper originalTU) {
        this._baseTU = new TransactionUserBase();
        this._baseTU.initialize(this, originalTU);
        this._transactionUser = TransactionUserWrapper.getTUImplObjectFromPool();
        this._transactionUser.initializeDerivedTU(this, originalTU);
        this._baseTU.continueDerivedInitalization(originalTU);
        if (this.isProxying()) {
            this._transactionsCounter = 2;
            IncomingSipServletRequest origInRequest = (IncomingSipServletRequest)originalTU.getSipMessage();
            if (origInRequest == null) {
                this._NewTransactionsCounter = 1;
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(this, "TransactionUserWrapper", "For this Derived - Origianl Incoming request was already acknowledged with ACK on original TU = " + originalTU.getId());
                }
            } else {
                SipTransaction st = origInRequest.getTransaction();
                if (st.isTerminated()) {
                    this._NewTransactionsCounter = 1;
                    if (c_logger.isTraceDebugEnabled()) {
                        c_logger.traceDebug(this, "TransactionUserWrapper", "For this Derived - Origianl Incoming request was answered with final response for original TU = " + originalTU.getId());
                    }
                } else {
                    this._NewTransactionsCounter = 2;
                }
            }
        } else {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "TransactionUserWrapper", "Derived for UAC");
            }
            this._NewTransactionsCounter = 1;
            this._transactionsCounter = 1;
        }
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "TransactionUserWrapper", "New Derived with counter = " + this._NewTransactionsCounter);
        }
        this._derived = true;
        this._origTUWrapper = originalTU;
    }

    public void incrementTransactions() {
        ++this._transactionsCounter;
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "incrementTransactions", "new transaction was added, tu=" + this + " ,counter=" + this._transactionsCounter);
        }
    }

    public void decrementTransactions() {
        --this._transactionsCounter;
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "decrementTransactions", "transaction was removed, tu=" + this + " ,counter=" + this._transactionsCounter);
        }
    }

    private void adjustTransactionsCounter() {
        this._transactionsCounter -= this._extraTransactionsCounter;
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "adjustTransactionsCounter", "decrementing transactions by" + this._extraTransactionsCounter + " _transactionsCounter = " + this._transactionsCounter);
        }
        this._extraTransactionsCounter = 0;
    }

    public void addExtraTransaction() {
        ++this._extraTransactionsCounter;
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "addExtraTransaction", "extra transactions=" + this._extraTransactionsCounter + " _transactionsCounter = " + this._transactionsCounter);
        }
    }

    private void transactionInitated() {
        if (this.isRelatedToBranch()) {
            this.branch.incrementTransactionCounters();
        } else {
            this.incrementTransactions();
        }
    }

    public void transactionCompleted() {
        this.adjustTransactionsCounter();
        if (this.isRelatedToBranch()) {
            this.branch.decrementTransactionCounters();
        } else {
            this.decrementTransactions();
        }
    }

    public boolean isRelatedToBranch() {
        return this.branch != null;
    }

    public boolean hasOngoingTransactions() {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "hasOngoingTransactions", "hasOngoingTransactions: TU = " + this.getId() + " _NewTransactionsCounter = " + this._NewTransactionsCounter + " _transactionsCounter = " + this._transactionsCounter);
        }
        if (PropertiesStore.getInstance().getProperties().getBoolean("tuCounterTransactionFix")) {
            return this._NewTransactionsCounter > 0;
        }
        return this._transactionsCounter > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void completeTransactionForOriginalRequest(String requestMethod) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry((Object)this, "completeTransactionForOriginalRequest", (Object)("requestMethod=" + requestMethod));
        }
        boolean result = false;
        try {
            if (this.branch == null) {
                result = false;
                return;
            }
            SipServletRequestImpl origRequest = (SipServletRequestImpl)this.branch.getProxy().getOriginalRequest();
            TransactionUserWrapper origTU = origRequest.getTransactionUser();
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "completeTransactionForOriginalRequest", "origRequestTu=" + origTU + ", this TU=" + this);
            }
            String origMethod = origRequest.getMethod();
            if (origTU.equals(this) || !requestMethod.equals(origMethod)) {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(this, "completeTransactionForOriginalRequest", "origMethod=" + origMethod);
                }
                result = false;
                return;
            }
            origTU.transactionCompleted();
            origTU.invalidateIfReady();
            result = true;
        }
        finally {
            if (c_logger.isTraceEntryExitEnabled()) {
                c_logger.traceExit((Object)this, "completeTransactionForOriginalRequest", " invalidated original:" + result);
            }
        }
    }

    protected void transactionTerminated() {
        this.transactionTerminated(true, "");
    }

    protected void transactionTerminated(boolean isClient, String requestMethod) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(this, "transactionTerminated");
        }
        if (!isClient) {
            this.completeTransactionForOriginalRequest(requestMethod);
        }
        this.transactionCompleted();
        this.tryToInvalidate();
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "transactionTerminated");
        }
    }

    private void tryToInvalidate() {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry((Object)this, "tryToInvalidate", (Object)("TU = " + this.getId()));
        }
        if (this._invalidating) {
            this.reuseTU();
            SipApplicationSessionImpl appSession = (SipApplicationSessionImpl)this.getApplicationSession(false);
            if (appSession != null && appSession.isValid() && appSession.getInvalidateWhenReady() && appSession.isReadyToInvalidate()) {
                appSession.readyToInvalidate();
            }
        } else {
            this.invalidateIfReady();
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "tryToInvalidate");
        }
    }

    public void invalidateIfReady() {
        TransactionUserBase bTU;
        boolean shouldinvalidate;
        if (this.addedToInvalidateWhenReadyList) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "invalidateIfReady", "Already added to the invalidateWhenReadList. " + this + ", sessionID=" + this.getId());
            }
            return;
        }
        if (this.isInvalidating()) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "invalidateIfReady", "Already invalidating. " + this);
            }
            return;
        }
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "invalidateIfReady", "Adding to list: " + this + ", sessionID=" + this.getId());
        }
        if (shouldinvalidate = (bTU = this.isBaseTUAlive()).shouldInvokeInvalidateWhenReady()) {
            ThreadLocalStorage.setTuForInvalidate(this);
            this.addedToInvalidateWhenReadyList = true;
        }
    }

    public void setBase(TransactionUserBase bTU) {
        this._baseTU = bTU;
    }

    public void setTU(TransactionUserImpl tu) {
        this._transactionUser = tu;
    }

    public SipServletRequest createRequest(String method) {
        TransactionUserImpl impl = this.startToUseTU();
        SipServletRequest req = impl.createRequest(method);
        this.finishToUseTU(impl);
        return req;
    }

    public void addToTransactionUsersTable() {
        TransactionUserImpl impl = this.startToUseTU();
        impl.addToTransactionUsersTable();
        this.finishToUseTU(impl);
    }

    public void ensureTUActive() throws IllegalStateException {
        TransactionUserBase bTU = this.isBaseTUAlive();
        bTU.isBaseTUActive();
    }

    public void applicationSessionIvalidated(SipApplicationSession appSession) {
        TransactionUserBase bTU = this.isBaseTUAlive();
        bTU.applicationSessionIvalidated(appSession);
    }

    protected TransactionUserImpl isTransactionUserAlive() throws IllegalStateException {
        TransactionUserImpl impl = this.getTuImpl();
        if (impl == null) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "isTransactionUserAlive", "This Transaction User was ENDED,  " + this);
            }
            StringBuffer buff = new StringBuffer();
            buff.append("This TransactionUser was ENDED and REUSED. Transaction Id = ");
            buff.append(this.getTuBase().toString());
            buff.append(this);
            throw new IllegalStateException(buff.toString());
        }
        return impl;
    }

    public boolean isTransactionUserInvalidated() {
        boolean isTrasactionInvalidated = false;
        TransactionUserImpl impl = this._transactionUser;
        if (impl == null) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "isTransactionUserInvalidated", "This Transaction User was ENDED,  " + this);
            }
            isTrasactionInvalidated = true;
        }
        return isTrasactionInvalidated;
    }

    protected TransactionUserBase isBaseTUAlive() throws IllegalStateException {
        TransactionUserBase bTU = this.getTuBase();
        if (bTU == null) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "isBaseTUAlive", "This Base TU was ENDED,  " + this);
            }
            throw new IllegalStateException("This Base TU was ENDED and REUSED" + this);
        }
        return bTU;
    }

    public String getInternalCallId() {
        TransactionUserImpl impl = this.startToUseTU(false);
        String callId = null;
        if (impl != null) {
            callId = impl.getCallId();
            this.finishToUseTU(impl);
        }
        return callId;
    }

    public String getCallId() {
        TransactionUserImpl impl = this.startToUseTU();
        String callId = impl.getCallId();
        this.finishToUseTU(impl);
        return callId;
    }

    public long getInviteCseq() {
        TransactionUserImpl impl = this.startToUseTU();
        long cseq = impl.getInviteCseq();
        this.finishToUseTU(impl);
        return cseq;
    }

    public long getLocalCSeq() {
        TransactionUserImpl impl = this.startToUseTU();
        long cseq = impl.getLocalCSeq();
        this.finishToUseTU(impl);
        return cseq;
    }

    public long getRemoteCseq() {
        TransactionUserImpl impl = this.startToUseTU();
        long cseq = impl.getRemoteCseq();
        this.finishToUseTU(impl);
        return cseq;
    }

    public SipServletRequestImpl getSipMessage() {
        TransactionUserImpl impl = this.startToUseTU();
        SipServletRequestImpl request = impl.getSipMessage();
        this.finishToUseTU(impl);
        return request;
    }

    public String getId() {
        TransactionUserBase bTU = this.isBaseTUAlive();
        return bTU.getSharedId();
    }

    public void invalidateWhenReady() {
        TransactionUserBase bTU = this.isBaseTUAlive();
        bTU.callInvalidateWhenReady();
    }

    public Address getLocalParty() {
        TransactionUserImpl impl = this.startToUseTU();
        Address localParty = impl.getLocalParty();
        this.finishToUseTU(impl);
        return localParty;
    }

    public Address getRemoteParty() {
        TransactionUserImpl impl = this.startToUseTU();
        Address remoteParty = impl.getRemoteParty();
        this.finishToUseTU(impl);
        return remoteParty;
    }

    @Override
    public void processRequest(SipServletRequest request) {
        TransactionUserImpl impl = this.startToUseTU();
        if (impl == null) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "processRequest", "TransactionUserImpl is null, sending 481 error");
            }
            SipServletRequestImpl requestImpl = (SipServletRequestImpl)request;
            SipRouter.sendErrorResponse(requestImpl, 481);
        } else {
            if (!request.getMethod().equals("ACK")) {
                this.transactionInitated();
            }
            impl.processRequest(request);
        }
        this.finishToUseTU(impl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean onSendingResponse(SipServletResponse response) {
        Object object = this.getSynchronizer();
        synchronized (object) {
            TransactionUserImpl impl = this.startToUseTU();
            boolean rc = impl.onSendingResponse(response);
            this.finishToUseTU(impl);
            return rc;
        }
    }

    @Override
    public void processResponse(SipServletResponseImpl response) {
        TransactionUserImpl impl = this.startToUseTU();
        impl.processResponse(response);
        this.finishToUseTU(impl);
    }

    public String getLocalTag() {
        TransactionUserImpl impl = this.startToUseTU();
        String fromTag = impl.getLocalTag();
        this.finishToUseTU(impl);
        return fromTag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onTransactionCompleted() {
        Object object = this.getSynchronizer();
        synchronized (object) {
            TransactionUserImpl impl = this.startToUseTU();
            impl.onTransactionCompleted();
            this.finishToUseTU(impl);
        }
    }

    @Override
    public void processTimeout(SipServletRequestImpl req) {
        TransactionUserImpl impl = this.startToUseTU();
        impl.processTimeout(req);
        this.finishToUseTU(impl);
    }

    @Override
    public void processCompositionError(SipServletRequestImpl request) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(this, "processCompositionError");
        }
        TransactionUserImpl impl = this.startToUseTU();
        impl.generateCompositionErrorResponse(request);
        this.finishToUseTU(impl);
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "processCompositionError");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean onSendingRequest(SipServletRequestImpl request) {
        Object object = this.getSynchronizer();
        synchronized (object) {
            TransactionUserImpl impl = this.startToUseTU();
            if (!request.getMethod().equals("ACK")) {
                this.transactionInitated();
            }
            boolean rc = impl.onSendingRequest(request);
            this.finishToUseTU(impl);
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void servletInvoked(SipServletResponse response) {
        Object object = this.getSynchronizer();
        synchronized (object) {
            TransactionUserImpl impl = this.startToUseTU();
            impl.servletInvoked(response);
            this.finishToUseTU(impl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void servletInvoked(SipServletRequest request) {
        Object object = this.getSynchronizer();
        synchronized (object) {
            TransactionUserImpl impl = this.startToUseTU();
            impl.servletInvoked(request);
            this.finishToUseTU(impl);
        }
    }

    public void processStrayResponse(Response response, SipProvider provider) {
        TransactionUserImpl impl = this.startToUseTU();
        impl.processStrayResponse(response, provider);
        this.finishToUseTU(impl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSendingReliableProvisionalResponse(SipServletResponse response) {
        Object object = this.getSynchronizer();
        synchronized (object) {
            TransactionUserImpl impl = this.startToUseTU();
            impl.onSendingReliableProvisionalResponse(response);
            this.finishToUseTU(impl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSendingFinalResponseAfterProvisional(SipServletResponse response) {
        Object object = this.getSynchronizer();
        synchronized (object) {
            TransactionUserImpl impl = this.startToUseTU();
            impl.onSendingFinalResponseAfterProvisional(response);
            this.finishToUseTU(impl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSession(SipServletResponse response) {
        Object object = this.getSynchronizer();
        synchronized (object) {
            TransactionUserImpl impl = this.startToUseTU();
            impl.updateSession(response);
            this.finishToUseTU(impl);
        }
    }

    public String generateLocalTag() {
        TransactionUserImpl impl = this.startToUseTU();
        String toTag = impl.generateLocalTag();
        this.finishToUseTU(impl);
        return toTag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getNextRSegNumber() {
        Object object = this.getSynchronizer();
        synchronized (object) {
            TransactionUserImpl impl = this.startToUseTU();
            long rseq = impl.getNextRSegNumber();
            this.finishToUseTU(impl);
            return rseq;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanReliableObject() {
        Object object = this.getSynchronizer();
        synchronized (object) {
            TransactionUserImpl impl = this.startToUseTU();
            impl.cleanReliableObject();
            this.finishToUseTU(impl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getNextCSeqNumber() {
        Object object = this.getSynchronizer();
        synchronized (object) {
            TransactionUserImpl impl = this.startToUseTU();
            long nextCSeq = impl.getNextCSeqNumber();
            this.finishToUseTU(impl);
            return nextCSeq;
        }
    }

    public void setHandler(String name) throws ServletException {
        TransactionUserBase bTU = this.isBaseTUAlive();
        bTU.setHandler(name);
    }

    public void processSubsequentProxyResponse(SipServletResponse response) {
        TransactionUserImpl impl = this.startToUseTU();
        impl.processSubsequentProxyResponse(response);
        this.finishToUseTU(impl);
    }

    public String getInitialDialogMethod() {
        TransactionUserImpl impl = this.startToUseTU();
        String initialMethod = impl.getInitialDialogMethod();
        this.finishToUseTU(impl);
        return initialMethod;
    }

    public boolean wasAnsweredReliable() {
        TransactionUserImpl impl = this.startToUseTU();
        boolean rc = impl.wasAnsweredReliable();
        this.finishToUseTU(impl);
        return rc;
    }

    public boolean isProxying() {
        TransactionUserImpl impl = this.startToUseTU();
        boolean rc = impl.isProxying();
        this.finishToUseTU(impl);
        return rc;
    }

    public boolean isRRProxy() {
        TransactionUserBase bTU = this.isBaseTUAlive();
        if (this.isBaseTUDialog(bTU)) {
            TransactionUserImpl impl = this.startToUseTU();
            boolean rc = impl.isRRProxy();
            this.finishToUseTU(impl);
            return rc;
        }
        return false;
    }

    public void sendResponseToApplication(SipServletResponse response, SipServletInvokerListener listener) {
        TransactionUserImpl impl = this.startToUseTU();
        impl.sendResponseToApplication(response, listener);
        this.finishToUseTU(impl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIsProxying(boolean isProxying) {
        Object object = this.getSynchronizer();
        synchronized (object) {
            TransactionUserImpl impl = this.startToUseTU();
            impl.setIsProxying(isProxying);
            this.finishToUseTU(impl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIsRRProxying(boolean isRRProxy) {
        Object object = this.getSynchronizer();
        synchronized (object) {
            TransactionUserImpl impl = this.startToUseTU();
            impl.setIsRRProxying(isRRProxy);
            this.finishToUseTU(impl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIsVirtualBranch(Response response) {
        Object object = this.getSynchronizer();
        synchronized (object) {
            TransactionUserImpl impl = this.startToUseTU();
            impl.setIsVirtualBranch(response);
            this.removeTransaction(null);
            this.finishToUseTU(impl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateWithProxyReliableResponse(SipServletResponse response) {
        Object object = this.getSynchronizer();
        synchronized (object) {
            TransactionUserImpl impl = this.startToUseTU();
            impl.updateWithProxyReliableResponse(response);
            this.finishToUseTU(impl);
        }
    }

    public SipProvider getSipProvider() {
        TransactionUserImpl impl = this.startToUseTU();
        SipProvider provider = impl.getSipProvider();
        this.finishToUseTU(impl);
        return provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SipSession getSipSession(boolean create) {
        Object object = this.getSynchronizer();
        synchronized (object) {
            return this.getSipSessionFromBase(create);
        }
    }

    public SipSession getSipSessionFromBase(boolean create) {
        TransactionUserBase bTU = this.isBaseTUAlive();
        return bTU.getSipSession(create);
    }

    public List<IBMSipSession> getAllSipSessions() {
        return this.getAllSipSessions(true);
    }

    public List<IBMSipSession> getAllSipSessions(boolean create) {
        ArrayList<IBMSipSession> sessions = null;
        TransactionUserBase bTU = this.isBaseTUAlive();
        sessions = new ArrayList<IBMSipSession>(1);
        bTU.getAllSipSessions(sessions, create);
        return sessions;
    }

    public boolean isTUDialog() {
        TransactionUserBase bTU = this.isBaseTUAlive();
        return this.isBaseTUDialog(bTU);
    }

    boolean isBaseTUDialog(TransactionUserBase bTU) {
        return bTU.isDialog();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SipApplicationSession getApplicationSession(boolean create) {
        Object object = this.getSynchronizer();
        synchronized (object) {
            TransactionUserBase bTU = this.isBaseTUAlive();
            return bTU.getApplicationSession(create);
        }
    }

    public SipApplicationSessionImpl getAppSessionForInternalUse() {
        TransactionUserBase bTU = this.isBaseTUAlive();
        return (SipApplicationSessionImpl)bTU.getApplicationSession(false);
    }

    SipSessionImplementation getSipSessionForInternalUse() {
        TransactionUserBase bTU = this.isBaseTUAlive();
        return (SipSessionImplementation)bTU.getSipSession(false);
    }

    public SipServletDesc getSipServletDesc() {
        TransactionUserBase bTU = this.isBaseTUAlive();
        SipServletDesc desc = bTU.getSipServletDesc();
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry((Object)this, "getSipServletDesc", (Object)(desc + "this=" + this));
        }
        return desc;
    }

    public SipServletMessage getSipServletRequest() {
        TransactionUserImpl impl = this.startToUseTU();
        SipServletMessage msg = impl.getSipServletRequest();
        this.finishToUseTU(impl);
        return msg;
    }

    public void setSipServletDesc(SipServletDesc desc) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry((Object)this, "setSipServletDesc", (Object)(desc + " this=" + this));
        }
        TransactionUserBase bTU = this.isBaseTUAlive();
        bTU.setSipServletDesc(desc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setcSeq(long l) {
        Object object = this.getSynchronizer();
        synchronized (object) {
            TransactionUserImpl impl = this.startToUseTU();
            impl.setcSeq(l);
            this.finishToUseTU(impl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUsedDestination(SipURL lastUsedDestination) {
        Object object = this.getSynchronizer();
        synchronized (object) {
            TransactionUserImpl impl = this.startToUseTU();
            impl.setUsedDestination(lastUsedDestination);
            this.finishToUseTU(impl);
        }
    }

    @Override
    public SipURL getUsedDestination() {
        TransactionUserImpl impl = this.startToUseTU();
        SipURL destination = impl.getUsedDestination();
        this.finishToUseTU(impl);
        return destination;
    }

    public boolean hasSipSession() {
        TransactionUserBase bTU = this.isBaseTUAlive();
        return bTU.hasSipSession();
    }

    public SipSession.State getState() {
        TransactionUserBase bTU = this.isBaseTUAlive();
        return bTU.getState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStateToAfterInitial() {
        Object object = this.getSynchronizer();
        synchronized (object) {
            TransactionUserBase bTU = this.isBaseTUAlive();
            bTU.setStateToAfterInitial();
        }
    }

    public boolean isAfterInitial() {
        TransactionUserBase bTU = this.isBaseTUAlive();
        return bTU.isAfterInitialState();
    }

    public boolean canBeInvalidated() {
        TransactionUserBase bTU = this.isBaseTUAlive();
        return bTU.canBeInvalidated();
    }

    public void setSessionState(SipSession.State state, SipServletMessage message) {
        TransactionUserBase bTU = this.isBaseTUAlive();
        bTU.setSessionState(state, message);
    }

    public SipSession.State updateState(SipServletResponse response) {
        TransactionUserBase bTU = this.isBaseTUAlive();
        return bTU.updateState(response);
    }

    public void checkIfTerminateRequest(SipServletRequest request) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry((Object)this, "checkIfTerminateRequest", (Object)request.getMethod());
        }
        TransactionUserBase bTU = this.isBaseTUAlive();
        bTU.checkIfTerminateRequest(request);
    }

    public String getApplicationId() {
        TransactionUserBase bTU = this.isBaseTUAlive();
        return bTU.getApplicationId();
    }

    public String getSipSessionId() {
        TransactionUserBase bTU = this.isBaseTUAlive();
        return bTU.getSipSessionId();
    }

    public void transactionUserExpired() {
        this.logToContext(4098);
        if (this.getTuImpl() != null) {
            this.setTimeoutResponseCode();
        }
        this.invalidateTU(true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle2xxRetransmittion(Invite2xxRetransmitTimer timer2xxRetransmit) {
        Object object = this.getSynchronizer();
        synchronized (object) {
            TransactionUserImpl impl = this.startToUseTU(false);
            if (impl == null) {
                return;
            }
            timer2xxRetransmit.rescheduleNextTimer(this);
            this.finishToUseTU(impl);
        }
    }

    public void invalidateTU(boolean removeFromAppSession, boolean removeFromSessionsTbl) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry((Object)this, "invalidateTU", new Object[]{removeFromAppSession});
        }
        if (this._invalidating && !this._partialInvalidate) {
            return;
        }
        boolean partialInvalidate = this._partialInvalidate;
        this._invalidating = true;
        TransactionUserBase bTU = this.isBaseTUAlive();
        TUKey key = null;
        if (this.getTuImpl() != null) {
            TransactionUserImpl impl = this.startToUseTU();
            impl.invalidateTU();
            key = this.resetTempTUKeyValues();
            partialInvalidate = impl.isPendingCancelExists();
            this.finishToUseTU(impl);
            this.reuseTU();
            if (this._transactionUser == null) {
                partialInvalidate = false;
            }
        }
        if (partialInvalidate && !this._partialInvalidate) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "invalidateTU", "TU with underlying transaction was detected, delaying the invalidate till a provisional response is received.");
            }
            bTU.rescheduleExpTimer();
            this._partialInvalidate = true;
            return;
        }
        this._partialInvalidate = false;
        bTU.invalidateBase(removeFromAppSession);
        if (removeFromAppSession) {
            if (key != null) {
                SessionRepository.getInstance().removeTuWrapper(key, removeFromSessionsTbl);
            } else if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "invalidateTU", "key is null, not able to remove from maps");
            }
            ThreadLocalStorage.setTUKey(null);
        }
    }

    public TUKey resetTempTUKeyValues() {
        TUKey key = ThreadLocalStorage.getTUKey();
        if (this.isProxying()) {
            TransactionUserImpl impl = this.getTuImpl();
            if (impl.isVirtualBranch()) {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(this, "resetTempTUKeyValues", "Virtual Branch");
                }
                key.setup(this.getRemoteTag_2(), this.getRemoteTag(), impl.getCallId(), false);
            } else {
                String localId = this.getSharedIdForDS();
                key.setup(this.getRemoteTag(), this.getRemoteTag_2(), localId, true);
            }
        } else {
            TransactionUserImpl impl = this.getTuImpl();
            key.setup(this.getLocalTag(), this.getRemoteTag(), impl.getCallId(), false);
        }
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deletetIfNeeded(TransactionUserImpl tu) {
        if (this._transactionUser == null) {
            Object object = this._syncObject;
            synchronized (object) {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(this, "deletetIfNeeded", "_methodInWorkCounter = " + this._methodInWorkCounter + " _cleaned = " + this._cleaned);
                }
                if (this._methodInWorkCounter == 0 && !this._cleaned) {
                    this._cleaned = true;
                    tu.cleanTU();
                    TransactionUserWrapper.returnTUImplObjectToPool(tu);
                }
            }
        }
    }

    protected void deleteTU() {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(this, "deleteTU");
        }
        TransactionUserImpl impl = this.isTransactionUserAlive();
        this._transactionUser = null;
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "deleteTU", "The TU Impl going to be Deleted and Reused " + impl);
        }
        this.deletetIfNeeded(impl);
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "deleteTU");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProvider(SipProvider provider) {
        Object object = this.getSynchronizer();
        synchronized (object) {
            TransactionUserImpl impl = this.startToUseTU();
            impl.setProvider(provider);
            this.finishToUseTU(impl);
        }
    }

    public boolean isServerTransaction() {
        TransactionUserImpl impl = this.startToUseTU();
        boolean isServerTransaction = impl.isServerTransaction();
        this.finishToUseTU(impl);
        return isServerTransaction;
    }

    public Address getContactHeader() {
        TransactionUserImpl impl = this.startToUseTU();
        Address contact = impl.getContactHeader();
        this.finishToUseTU(impl);
        return contact;
    }

    public void logToContext(int state, Object info, Object extendedInfo) {
        TransactionUserBase bTU = this.isBaseTUAlive();
        bTU.logToContext(state, info, extendedInfo);
    }

    public void logToContext(int state, int info, Object extendedInfo) {
        TransactionUserBase bTU = this.isBaseTUAlive();
        bTU.logToContext(state, info, extendedInfo);
    }

    public void logToContext(int state, Object info) {
        TransactionUserBase bTU = this.isBaseTUAlive();
        bTU.logToContext(state, info);
    }

    public void logToContext(int state) {
        TransactionUserBase bTU = this.isBaseTUAlive();
        bTU.logToContext(state);
    }

    public void logToContext(int state, int info) {
        TransactionUserBase bTU = this.isBaseTUAlive();
        bTU.logToContext(state, info);
    }

    public void logToContext(int state, boolean info) {
        TransactionUserBase bTU = this.isBaseTUAlive();
        bTU.logToContext(state, info);
    }

    public String getSharedID() {
        TransactionUserBase bTU = this.isBaseTUAlive();
        return bTU.getSharedId();
    }

    public boolean isValid() {
        TransactionUserBase bTU = this.isBaseTUAlive();
        return bTU.isValid();
    }

    public boolean shouldBeReplicated(boolean forBootstrap) {
        TransactionUserImpl impl = this.startToUseTU(!forBootstrap);
        if (impl == null) {
            return false;
        }
        boolean rc = impl.shouldBeReplicated(forBootstrap);
        this.finishToUseTU(impl);
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setForwardToApplication(boolean b) {
        Object object = this.getSynchronizer();
        synchronized (object) {
            TransactionUserImpl impl = this.startToUseTU();
            impl.setForwardToApplication(b);
            this.finishToUseTU(impl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TransactionUserImpl startToUseTU(boolean mayThrow) {
        TransactionUserImpl impl = null;
        Object object = this._syncObject;
        synchronized (object) {
            if (mayThrow) {
                impl = this.isTransactionUserAlive();
            } else {
                impl = this.getTuImpl();
                if (impl == null) {
                    return null;
                }
            }
            ++this._methodInWorkCounter;
        }
        return impl;
    }

    protected TransactionUserImpl startToUseTU() {
        return this.startToUseTU(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finishToUseTU(TransactionUserImpl impl) {
        Object object = this._syncObject;
        synchronized (object) {
            --this._methodInWorkCounter;
        }
        this.deletetIfNeeded(impl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNexSipSessionId() {
        Object object = this.getSynchronizer();
        synchronized (object) {
            TransactionUserImpl impl = this.startToUseTU();
            int sessionId = impl.getNexSipSessionId();
            this.finishToUseTU(impl);
            return sessionId;
        }
    }

    public void setRelatedSessionData(String sessionId, String header) {
        TransactionUserImpl impl = this.startToUseTU();
        impl.setRelatedSessionId(sessionId);
        impl.setRelatedSessionHeader(header);
        this.finishToUseTU(impl);
    }

    public String getRelatedSipSessionId() {
        TransactionUserImpl impl = this.startToUseTU();
        String relatedId = impl.getRelatedSipSessionId();
        this.finishToUseTU(impl);
        return relatedId;
    }

    public String getRelatedSipSessionHeader() {
        TransactionUserImpl impl = this.startToUseTU();
        String relatedId = impl.getRelatedSipSessionHeader();
        this.finishToUseTU(impl);
        return relatedId;
    }

    public SipSession getRelatedSipSession() {
        TransactionUserBase bTU = this.isBaseTUAlive();
        return bTU.getRelatedSipSession();
    }

    public boolean isInvalidating() {
        if (this._invalidating) {
            return true;
        }
        TransactionUserImpl impl = this.startToUseTU();
        boolean invalidating = impl.isInvalidating();
        this.finishToUseTU(impl);
        return invalidating;
    }

    public void removeClientTransaction(ClientTransaction trnsaction) {
        TransactionUserImpl impl = this.startToUseTU(false);
        if (impl != null) {
            impl.removeClientTransaction(trnsaction);
            this.finishToUseTU(impl);
        } else if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "removeClientTransaction", "Related TU was already invalidated.");
        }
    }

    public void storeClientTransaction(ClientTransaction transaction) {
        TransactionUserImpl impl = this.startToUseTU();
        impl.storeClientTransaction(transaction);
        this.finishToUseTU(impl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clientTransactionTerminated(SipServletRequestImpl request) {
        Object object = this.getSynchronizer();
        synchronized (object) {
            if (!request.getMethod().equals("ACK")) {
                this.transactionTerminated();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serverTransactionTerminated(SipServletRequestImpl request) {
        Object object = this.getSynchronizer();
        synchronized (object) {
            if (!request.getMethod().equals("ACK")) {
                this.transactionTerminated(false, request.getMethod());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void originalServerTransactionTerminated(SipServletRequestImpl request) {
        Object object = this.getSynchronizer();
        synchronized (object) {
            if (!request.getMethod().equals("ACK")) {
                this.tryToInvalidate();
            }
        }
    }

    protected synchronized void reuseTU() {
        if (PropertiesStore.getInstance().getProperties().getBoolean("tuCounterTransactionFix")) {
            if (this._transactionsCounter == 0 && this._NewTransactionsCounter != 0 && PropertiesStore.getInstance().getProperties().getBoolean("tuCounterSystemOut")) {
                System.out.println("AvayayLeakFix: ERROR !!!! LEAK !!!  TU = " + this.getId() + " _transactionsCounter = " + this._transactionsCounter + " _NewTransactionsCounter = " + this._NewTransactionsCounter);
            }
            if (this._NewTransactionsCounter < 0) {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(this, "reuseTU", "_NewTransactionsCounter is less than 0 ");
                }
            } else if (this._NewTransactionsCounter == 0 && this._transactionUser != null && !this._transactionUser.isUnderlyingTransactionsBeingTerminated()) {
                if (PropertiesStore.getInstance().getProperties().getBoolean("tuCounterSystemOut")) {
                    System.out.println("AvayayLeakFix: deleting  TU = " + this.getId() + " _transactionsCounter = " + this._transactionsCounter + " _NewTransactionsCounter = " + this._NewTransactionsCounter);
                }
                this.deleteTU();
            } else if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "reuseTU", "This TU will be reused later as it still has open transactions " + this.getTuImpl());
            }
            return;
        }
        if (this._transactionsCounter < 0) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "reuseTU", "_transctionsCounter is less than 0 ");
            }
        } else if (this._transactionsCounter == 0 && this._transactionUser != null && !this._transactionUser.isUnderlyingTransactionsBeingTerminated()) {
            this.deleteTU();
        } else if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "reuseTU", "This TU will be reused later as it still has open transactions " + this.getTuImpl());
        }
    }

    protected void notifyTUOnActivation() {
        TransactionUserImpl transactionUser = this.getTuImpl();
        if (transactionUser != null) {
            transactionUser.notifyOnActivation();
        }
    }

    public String toString() {
        TransactionUserBase _baseTU = this.getTuBase();
        if (_baseTU != null) {
            this.isBaseTUAlive();
            StringBuffer _myInformation = new StringBuffer(_baseTU.toString());
            _myInformation.append(" Wrapper Info = ");
            _myInformation.append(super.toString());
            return _myInformation.toString();
        }
        return super.toString();
    }

    @Override
    public void setDialogAux(DialogAux da) {
        TransactionUserBase bTU = this.isBaseTUAlive();
        bTU.setDialogAux(da);
    }

    @Override
    public DialogAux getDialogAux() {
        TransactionUserBase bTU = this.isBaseTUAlive();
        return bTU.getDialogAux();
    }

    @Override
    public boolean canHaveDialog() {
        return this.isTUDialog();
    }

    @Override
    public int getDialogState() {
        TransactionUserBase bTU = this.isBaseTUAlive();
        return bTU.getWLMDialogState();
    }

    public void setOutboundInterface(InetSocketAddress address) {
        TransactionUserImpl impl = this.startToUseTU();
        impl.setOutboundInterface(address);
        this.finishToUseTU(impl);
    }

    public void setOutboundInterface(InetAddress address) {
        TransactionUserImpl impl = this.startToUseTU();
        impl.setOutboundInterface(address);
        this.finishToUseTU(impl);
    }

    public B2buaHelper getB2buaHelper(boolean create, UAMode mode) throws IllegalStateException {
        TransactionUserImpl impl = this.startToUseTU();
        B2buaHelperImpl helper = this.getTuImpl().getB2buaHelper(create, mode);
        this.finishToUseTU(impl);
        return helper;
    }

    public boolean isB2B() {
        TransactionUserImpl impl = this.startToUseTU();
        boolean isB2B = this.getTuImpl().isB2B();
        this.finishToUseTU(impl);
        return isB2B;
    }

    public boolean isUAS() {
        TransactionUserImpl impl = this.startToUseTU();
        boolean isUAS = this._transactionUser.isUAS();
        this.finishToUseTU(impl);
        return isUAS;
    }

    public List<SipServletMessage> getPendingMessages(UAMode mode) {
        TransactionUserImpl impl = this.startToUseTU();
        List<SipServletMessage> list = this.getTuImpl().getPendingMessages(mode);
        this.finishToUseTU(impl);
        return list;
    }

    public void removeB2BPendingMsg(SipServletMessage msg, UAMode mode) {
        TransactionUserImpl impl = this.startToUseTU();
        this.getTuImpl().removeB2BPendingMsg(msg, mode);
        this.finishToUseTU(impl);
    }

    public void addB2BPendingMsg(SipServletMessage msg, UAMode mode) {
        TransactionUserImpl impl = this.startToUseTU();
        this.getTuImpl().addB2BPendingMsg(msg, mode);
        this.finishToUseTU(impl);
    }

    public boolean isFailedResponseSent() {
        TransactionUserImpl impl = this.startToUseTU();
        boolean isFailedResponseSent = this.getTuImpl().isFailedResponseSent();
        this.finishToUseTU(impl);
        return isFailedResponseSent;
    }

    public boolean isTerminated() {
        TransactionUserImpl impl = this.startToUseTU();
        boolean isTerminated = this.getTuImpl().isTerminated();
        this.finishToUseTU(impl);
        return isTerminated;
    }

    public void setTimeoutResponseCode() {
        TransactionUserImpl impl = this.startToUseTU();
        impl.setSessionInvalidatedResponse(408);
        this.finishToUseTU(impl);
    }

    public void setB2buaMode() {
        TransactionUserImpl impl = this.startToUseTU();
        this.getTuImpl().setB2buaMode();
        this.finishToUseTU(impl);
    }

    public void setIsB2bua(boolean bool) {
        TransactionUserImpl impl = this.startToUseTU();
        impl.setIsB2bua(bool);
        this.finishToUseTU(impl);
    }

    public void setUASMode() {
        TransactionUserImpl impl = this.startToUseTU();
        this._transactionUser.setUASMode();
        this.finishToUseTU(impl);
    }

    public Vector<String> getRouteHeaders() {
        TransactionUserImpl impl = this.startToUseTU();
        Vector<String> routeHeaders = impl.getRouteHeaders();
        return routeHeaders;
    }

    public URI getSubscriberUri() {
        TransactionUserImpl impl = this.startToUseTU();
        URI subscriberURI = impl.getSubscriberURI();
        this.finishToUseTU(impl);
        return subscriberURI;
    }

    public void setSubscriberUri(URI subscriberURI) {
        TransactionUserImpl impl = this.startToUseTU();
        impl.setSubscriberURI(subscriberURI);
        this.finishToUseTU(impl);
    }

    public SipApplicationRoutingRegion getRegion() {
        TransactionUserImpl impl = this.startToUseTU();
        SipApplicationRoutingRegion region = impl.getRegion();
        this.finishToUseTU(impl);
        return region;
    }

    public void setRegion(SipApplicationRoutingRegion region) {
        TransactionUserImpl impl = this.startToUseTU();
        impl.setRegion(region);
        this.finishToUseTU(impl);
    }

    public int getPreferedOutboundIface(String transport) {
        TransactionUserImpl impl = this.startToUseTU();
        int preferedOutBoundIfaceIdx = impl.getPreferedOutboundIface(transport);
        this.finishToUseTU(impl);
        return preferedOutBoundIfaceIdx;
    }

    public int getOriginatorPreferedOutboundIface(String transport) {
        TransactionUserImpl impl = this.startToUseTU();
        int preferedOutBoundIfaceIdx = impl.getOriginatorPreferedOutboundIface(transport);
        this.finishToUseTU(impl);
        return preferedOutBoundIfaceIdx;
    }

    public TransactionUserWrapper createDerivedTU(Response response, String reason) {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "createDerivedTU", "New derived for proxy created. Reason - " + reason);
        }
        TransactionUserImpl impl = this.startToUseTU();
        TransactionUserWrapper derivedTU = null;
        derivedTU = new TransactionUserWrapper(this);
        if (derivedTU.isProxying()) {
            derivedTU.setRemoteTag_2(response.getToHeader().getTag(), false);
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "createDerivedTU", "New derived for proxy created");
            }
        }
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "createDerivedTU", "New derived " + derivedTU);
        }
        this.finishToUseTU(impl);
        return derivedTU;
    }

    public TransactionUserImpl getTuImpl() {
        return this._transactionUser;
    }

    public void setRemoteTag_2(String tag) {
        this.setRemoteTag_2(tag, true);
    }

    public void setRemoteTag_2(String tag, boolean replaceExistingTU) {
        TransactionUserImpl impl = this.startToUseTU();
        impl.setDestinationTagInProxy(tag, replaceExistingTU);
        this.finishToUseTU(impl);
    }

    void setRemoteTag(String tag) {
        TransactionUserImpl impl = this.startToUseTU();
        impl.setRemoteTag(tag);
        this.finishToUseTU(impl);
    }

    public String getRemoteTag_2() {
        TransactionUserImpl impl = this.startToUseTU();
        String rt = impl.getDestinationTagInProxy();
        this.finishToUseTU(impl);
        return rt;
    }

    public String getRemoteTag() {
        TransactionUserImpl impl = this.startToUseTU();
        String rt = impl.getRemoteTag();
        this.finishToUseTU(impl);
        return rt;
    }

    public String getSharedIdForDS() {
        TransactionUserImpl impl = this.startToUseTU();
        String rt = impl.getSharedIdForDS();
        this.finishToUseTU(impl);
        return rt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isProxingErrorResponse() {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(this, "isProxingErrorResponse");
        }
        boolean result = false;
        try {
            SipServletResponse res;
            if (this.branch != null && (res = this.branch.getResponse()) != null) {
                result = SipUtil.isErrorResponse(res.getStatus());
            }
            boolean bl = result;
            return bl;
        }
        finally {
            if (c_logger.isTraceEntryExitEnabled()) {
                c_logger.traceExit((Object)this, "isProxingErrorResponse", result);
            }
        }
    }

    public boolean canCreateDS() {
        TransactionUserBase bTU = this.isBaseTUAlive();
        return bTU.canCreateDS();
    }

    public boolean isDialog() {
        TransactionUserBase bTU = this.isBaseTUAlive();
        return bTU.isDialog();
    }

    public void setCanCreateDS(boolean flag) {
        TransactionUserBase bTU = this.isBaseTUAlive();
        bTU.setCanCreateDS(flag);
    }

    public boolean isProxyReceivedFinalResponse() {
        if (this.getTuImpl() == null) {
            return this._receivedFinalResponse;
        }
        TransactionUserImpl impl = this.startToUseTU();
        boolean receivedFinalResponse = impl.isProxyReceivedFinalResponse();
        this.finishToUseTU(impl);
        return receivedFinalResponse;
    }

    public TransactionUserBase getTuBase() {
        return this._baseTU;
    }

    public void setProxyReceivedFinalResponse(boolean receivedFinalResponse, int status) {
        this._receivedFinalResponse = receivedFinalResponse;
        TransactionUserImpl impl = this.startToUseTU();
        impl.setProxyReceivedFinalResponse(receivedFinalResponse, status);
        this.finishToUseTU(impl);
    }

    public boolean hasAnyRelatedTUGotFinalResponse() {
        if (this.branch == null) {
            return false;
        }
        return this.branch.hasAnyTUGotFinalResponse();
    }

    public int getLastProxyResponseStatus() {
        if (this.branch == null) {
            return -1;
        }
        return this.branch.getLatestFinalResponseStatus();
    }

    public String getAppName() {
        TransactionUserBase bTU = this.isBaseTUAlive();
        return bTU.getAppName();
    }

    public Object getSynchronizer() {
        this.isBaseTUAlive();
        return this._baseTU.getSynchronizer();
    }

    public Object getServiceSynchronizer() {
        this.isBaseTUAlive();
        return this._baseTU.getServiceSynchronizer();
    }

    public void setShouldBeReused() {
    }

    public void setSessionKeyBase(String keyBase) {
        this.isBaseTUAlive().setSessionKeyBase(keyBase);
        if (keyBase != null) {
            String sipAppID = this.getApplicationId();
            SessionRepository.getInstance().setSessionKeyBase(keyBase, sipAppID);
        }
    }

    public String getSessionKeyBaseKey() {
        return this.isBaseTUAlive().getSessionKeyBase();
    }

    public boolean isReadyToInvalidate() throws IllegalStateException {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(this, "isReadyToInvalidate");
        }
        boolean readyToInvalidate = true;
        SipSession.State state = this.getState();
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "isReadyToInvalidate", "state: " + (Object)((Object)state) + " , ongoing transactions: " + this._transactionsCounter);
        }
        if (this.hasOngoingTransactions()) {
            readyToInvalidate = false;
        } else if (this.isDialog()) {
            if (this.isProxying() && !this.isRRProxy()) {
                if (state != SipSession.State.CONFIRMED && state != SipSession.State.TERMINATED) {
                    if (c_logger.isTraceDebugEnabled()) {
                        c_logger.traceDebug(this, "isReadyToInvalidate", "none record route proxy is not ready to invalidate, state: " + (Object)((Object)state));
                    }
                    readyToInvalidate = false;
                }
            } else if (state != SipSession.State.INITIAL && state != SipSession.State.TERMINATED) {
                readyToInvalidate = false;
            }
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit((Object)this, "isReadyToInvalidate", readyToInvalidate);
        }
        return readyToInvalidate;
    }

    public boolean isJSR289Application() {
        SipServletDesc sd = this.getSipServletDesc();
        if (sd != null) {
            return sd.getSipApp().isJSR289Application();
        }
        return false;
    }

    public boolean isWaitingForPendingMessage() {
        return this._pendingMessageExists;
    }

    public void setInitialRequestProcessed() {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry((Object)this, "setInitialRequestProcessed", (Object)this._pendingMessageExists);
        }
        if (!this._pendingMessageExists) {
            return;
        }
        this._pendingMessageExists = false;
        SipApplicationSessionImpl appSession = this.getAppSessionForInternalUse();
        if (appSession == null || appSession != null && !appSession.isValid()) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "setInitialRequestProcessed", "App session invalidated, reinitialize synchronizer.");
            }
            this.getTuBase().reinitilize();
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "setInitialRequestProcessed");
        }
    }

    public static TransactionUserImpl getTUImplObjectFromPool() {
        if (PerformanceMgr.getInstance() != null) {
            PerformanceMgr.getInstance().incrementNotReplicatedSipSessionsCounter();
        }
        return (TransactionUserImpl)s_tuPool.get();
    }

    public static void returnTUImplObjectToPool(TransactionUserImpl tu) {
        s_tuPool.putBack(tu);
    }

    public boolean isDerived() {
        return this._derived;
    }

    public TransactionUserWrapper getOrigTUWrapper() {
        return this._origTUWrapper;
    }

    public void overridePendingMessagesByDerived(TransactionUserWrapper derivedTUWrapper) {
        for (SipServletMessage msg : this.getPendingMessages(UAMode.UAS)) {
            this.removeB2BPendingMsg(msg, UAMode.UAS);
        }
        for (SipServletMessage msg : derivedTUWrapper.getPendingMessages(UAMode.UAS)) {
            this.addB2BPendingMsg(msg, UAMode.UAS);
        }
    }

    @Override
    public void removeTransaction(String method) {
        --this._NewTransactionsCounter;
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "removeTransaction", "removeTransaction. TU = " + this.getId() + " _NewTransactionsCounter = " + this._NewTransactionsCounter);
        }
    }

    @Override
    public void addTransaction(String method) {
        ++this._NewTransactionsCounter;
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "addTransaction", "addTransaction. TU = " + this.getId() + " _NewTransactionsCounter = " + this._NewTransactionsCounter);
        }
    }
}

