/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jbatch.jms.internal;

import com.ibm.websphere.ras.annotation.Trivial;
import jakarta.jms.JMSException;
import jakarta.jms.MapMessage;
import jakarta.jms.Message;
import jakarta.jms.TextMessage;
import jakarta.json.JsonObject;
import java.util.Enumeration;
import java.util.Properties;

@Trivial
public class BatchJmsMessageHelper {
    public static void setJobParametersToJmsMessageBody(Properties parameters, MapMessage jmsMsg) throws JMSException {
        if (parameters != null) {
            Enumeration<?> e = parameters.propertyNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                String value = parameters.getProperty(key);
                jmsMsg.setString(key, value);
            }
        }
    }

    public static void setJobParametersToJmsMessageProperties(Properties parameters, Message jmsMsg) throws JMSException {
        if (parameters != null) {
            Enumeration<?> e = parameters.propertyNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                String value = parameters.getProperty(key);
                if (!BatchJmsMessageHelper.isValidJmsStringPropertyKey(key)) continue;
                jmsMsg.setStringProperty(key, value);
            }
        }
    }

    public static Properties getJobParametersFromJmsMessage(MapMessage msg) throws JMSException {
        Properties jobParameters = new Properties();
        Enumeration names = msg.getMapNames();
        while (names.hasMoreElements()) {
            String key = (String)names.nextElement();
            if (key.startsWith("com_ibm_ws_batch_internal")) continue;
            jobParameters.put(key, msg.getString(key));
        }
        return jobParameters;
    }

    public static boolean isValidJmsStringPropertyKey(String key) {
        if (key == null || key.isEmpty()) {
            return false;
        }
        if (key.equalsIgnoreCase("NULL") || key.equalsIgnoreCase("TRUE") || key.equalsIgnoreCase("FALSE") || key.equalsIgnoreCase("NOT") || key.equalsIgnoreCase("AND") || key.equalsIgnoreCase("OR") || key.equalsIgnoreCase("BETWEEN") || key.equalsIgnoreCase("LIKE") || key.equalsIgnoreCase("IN") || key.equalsIgnoreCase("IS") || key.equalsIgnoreCase("ESCAPE")) {
            return false;
        }
        char[] testChars = key.toCharArray();
        if (!Character.isJavaIdentifierStart(testChars[0])) {
            return false;
        }
        for (int i = 1; i < testChars.length; ++i) {
            if (Character.isJavaIdentifierPart(testChars[i])) continue;
            return false;
        }
        return true;
    }

    public static void setJobEventMessage(TextMessage eventMsg, JsonObject jsonObject) throws JMSException {
        BatchJmsMessageHelper.setMajorVersionToJmsMessage(eventMsg);
        BatchJmsMessageHelper.setMinorVersionToJmsMessage(eventMsg);
        if (jsonObject.getJsonNumber("instanceId") != null) {
            long instanceId = jsonObject.getJsonNumber("instanceId").longValue();
            BatchJmsMessageHelper.setInstanceIdToJobEventMessage(eventMsg, instanceId);
        }
        if (jsonObject.getJsonNumber("executionId") != null) {
            long executionId = jsonObject.getJsonNumber("executionId").longValue();
            BatchJmsMessageHelper.setExecutionIdToJobEventMessage(eventMsg, executionId);
        }
        if (jsonObject.getJsonNumber("stepExecutionId") != null) {
            long stepExecutionId = jsonObject.getJsonNumber("stepExecutionId").longValue();
            BatchJmsMessageHelper.setStepExecutionIdToJobEventMessage(eventMsg, stepExecutionId);
        }
        eventMsg.setText(jsonObject.toString());
    }

    public static String getJobEventMessage(TextMessage jmsMsg) throws JMSException {
        return jmsMsg.getText();
    }

    public static void setMajorVersionToJmsMessage(TextMessage jmsMsg) throws JMSException {
        jmsMsg.setIntProperty("com_ibm_ws_batch_events_majorVersion", 1);
    }

    public static void setMinorVersionToJmsMessage(TextMessage jmsMsg) throws JMSException {
        jmsMsg.setIntProperty("com_ibm_ws_batch_internalevents_minorVersion", 0);
    }

    public static void setInstanceIdToJobEventMessage(TextMessage jmsMsg, long intanceId) throws JMSException {
        jmsMsg.setLongProperty("com_ibm_ws_batch_internal_jobInstanceId", intanceId);
    }

    public static void setExecutionIdToJobEventMessage(TextMessage jmsMsg, long executionId) throws JMSException {
        jmsMsg.setLongProperty("com_ibm_ws_batch_internal_jobExecutionId", executionId);
    }

    public static void setStepExecutionIdToJobEventMessage(TextMessage jmsMsg, long stepExecutionId) throws JMSException {
        jmsMsg.setLongProperty("com_ibm_ws_batch_internal_stepExecutionId", stepExecutionId);
    }
}

