/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator.jcajce;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.jcajce.provider.symmetric.util.GcmSpecUtil;
import org.bouncycastle.jcajce.spec.AEADParameterSpec;
import org.bouncycastle.util.Arrays;

public class JceAEADCipherUtil {
    static void setUpAeadCipher(Cipher cipher, SecretKey secretKey, int n, byte[] byArray, int n2, byte[] byArray2) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (GcmSpecUtil.gcmSpecExtractable()) {
            AlgorithmParameterSpec algorithmParameterSpec;
            try {
                algorithmParameterSpec = GcmSpecUtil.extractGcmSpec(new GCMParameters(byArray, (n2 + 7) / 8).toASN1Primitive());
            }
            catch (InvalidParameterSpecException invalidParameterSpecException) {
                throw new InvalidAlgorithmParameterException(invalidParameterSpecException.getMessage());
            }
            cipher.init(n, (Key)secretKey, algorithmParameterSpec);
            cipher.updateAAD(byArray2);
        } else {
            AEADParameterSpec aEADParameterSpec = new AEADParameterSpec(byArray, n2, byArray2);
            cipher.init(n, (Key)secretKey, (AlgorithmParameterSpec)aEADParameterSpec);
        }
    }

    static class GCMParameters
    extends ASN1Object {
        private byte[] nonce;
        private int icvLen;

        public GCMParameters(byte[] byArray, int n) {
            this.nonce = Arrays.clone(byArray);
            this.icvLen = n;
        }

        public byte[] getNonce() {
            return Arrays.clone(this.nonce);
        }

        public int getIcvLen() {
            return this.icvLen;
        }

        @Override
        public ASN1Primitive toASN1Primitive() {
            ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector(2);
            aSN1EncodableVector.add(new DEROctetString(this.nonce));
            if (this.icvLen != 12) {
                aSN1EncodableVector.add(new ASN1Integer(this.icvLen));
            }
            return new DERSequence(aSN1EncodableVector);
        }
    }
}

