/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.openidconnect.web;

import com.ibm.oauth.core.api.attributes.AttributeList;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.openidconnect.server.plugins.OIDCBrowserStateUtil;
import com.ibm.ws.security.openidconnect.web.OidcSessionManagementUtil;
import com.ibm.ws.webcontainer.security.CookieHelper;
import com.ibm.ws.webcontainer.security.ReferrerURLCookieHandler;
import com.ibm.ws.webcontainer.security.WebAppSecurityCollaboratorImpl;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class BrowserState {
    private static TraceComponent tc = Tr.register(BrowserState.class, (String)"OpenIdConnect", (String)"com.ibm.ws.security.openidconnect.server.internal.resources.OidcServerMessages");
    static final long serialVersionUID = -3142004360067563088L;

    protected void generateState(HttpServletRequest request, AttributeList options) {
        String current = OIDCBrowserStateUtil.generateOIDCBrowserState(false);
        String salt = Long.toString(System.nanoTime(), 16);
        String clientId = request.getParameter("client_id");
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("clientId : " + clientId + " current browser session : " + current + " salt : " + salt), (Object[])new Object[0]);
        }
        String output = OidcSessionManagementUtil.calculateSessionState(clientId, current, salt);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("session_state : " + output), (Object[])new Object[0]);
        }
        options.setAttribute("session_state", "urn:ibm:names:oauth:response:attribute", new String[]{output});
    }

    protected void processSession(HttpServletRequest request, HttpServletResponse response) {
        String current = OIDCBrowserStateUtil.generateOIDCBrowserState(false);
        String original = this.getOriginalBrowserState(request);
        this.processBrowserStateCookie(original, current, response, request);
    }

    protected String getOriginalBrowserState(HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        String output = CookieHelper.getCookieValue((Cookie[])cookies, (String)"oidc_bsc");
        return output;
    }

    protected void processBrowserStateCookie(String original, String current, HttpServletResponse response, HttpServletRequest request) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("original browser state : " + original + " current browser state : " + current), (Object[])new Object[0]);
        }
        if (current != null && !current.equals(original)) {
            ReferrerURLCookieHandler handler = WebAppSecurityCollaboratorImpl.getGlobalWebAppSecurityConfig().createReferrerURLCookieHandler();
            Cookie c = handler.createCookie("oidc_bsc", current, false, request);
            response.addCookie(c);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"A browser session state cookie is set.", (Object[])new Object[0]);
            }
        }
    }
}

