/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsat.interceptor;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jaxws.bus.LibertyApplicationBus;
import com.ibm.ws.jaxws.globalhandler.GlobalHandlerInterceptor;
import com.ibm.ws.jaxws.wsat.Constants;
import com.ibm.ws.wsat.interceptor.WSATCompleteTransInterceptor;
import com.ibm.ws.wsat.service.WSATException;
import com.ibm.ws.wsat.utils.WSCoorUtil;
import com.ibm.ws.wsat.webservice.client.wscoor.CoordinationContext;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Unmarshaller;
import java.net.URI;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.interceptor.SoapInterceptor;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.headers.Header;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.apache.cxf.ws.policy.PolicyVerificationInInterceptor;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CoorContextInInterceptor
extends AbstractPhaseInterceptor<SoapMessage>
implements SoapInterceptor {
    final TraceComponent tc = Tr.register(CoorContextInInterceptor.class, (String)"WSAT", null);
    private String ctxId = null;
    private static final Set<QName> HEADERS = new HashSet<QName>();
    private Constants.AssertionStatus isOptional;

    public CoorContextInInterceptor(String phase) {
        super(phase);
        this.getAfter().add(PolicyVerificationInInterceptor.class.getName());
        this.getBefore().add(GlobalHandlerInterceptor.class.getName());
    }

    public void handleMessage(SoapMessage message) throws Fault {
        WSCoorUtil.assertAT((Message)message);
        CoordinationContext cc = null;
        this.isOptional = WSCoorUtil.isOptional((Message)message, true);
        List headers = message.getHeaders();
        if (headers != null && headers.size() > 0) {
            for (int i = 0; i < headers.size(); ++i) {
                Header soapHeader = (Header)headers.get(i);
                if (!soapHeader.getName().getLocalPart().equals("CoordinationContext")) continue;
                try {
                    JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{CoordinationContext.class});
                    Unmarshaller unmarshaller = jc.createUnmarshaller();
                    Element element = (Element)soapHeader.getObject();
                    if (TraceComponent.isAnyTracingEnabled() && this.tc.isDebugEnabled()) {
                        String elementString;
                        try {
                            elementString = StaxUtils.toString((Element)element);
                        }
                        catch (Exception e) {
                            elementString = "Exception " + e + " while getting string version of " + element;
                        }
                        Tr.debug((TraceComponent)this.tc, (String)"handleMessage", (Object[])new Object[]{"Extract the CoordinationContext from soap header", elementString});
                    }
                    cc = (CoordinationContext)unmarshaller.unmarshal((Node)element);
                    break;
                }
                catch (JAXBException e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.wsat.interceptor.CoorContextInInterceptor", (String)"120");
                    throw new Fault((Throwable)e);
                }
            }
        }
        if (cc == null) {
            if (this.isOptional == Constants.AssertionStatus.FALSE) {
                throw new Fault((Throwable)new WSATException("CoordinationContext is NULL"));
            }
            return;
        }
        WSCoorUtil.checkHandlerServiceReady();
        if (message.getExchange().isOneWay()) {
            throw new Fault((Throwable)new WSATException("WS-AT can not work on ONE-WAY webservice method"));
        }
        this.ctxId = cc.getIdentifier().getValue();
        if (TraceComponent.isAnyTracingEnabled() && this.tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)this.tc, (String)"handleMessage", (Object[])new Object[]{"Get cxtId from Extracted CoordinationContext", this.ctxId});
        }
        EndpointReferenceType epr = cc.getRegistrationService();
        if (TraceComponent.isAnyTracingEnabled() && this.tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)this.tc, (String)"handleMessage", (Object[])new Object[]{"Get Coordinator endpointRef from Extracted CoordinationContext", epr});
        }
        try {
            WSCoorUtil.getHandlerService().handleServerRequest(this.ctxId, epr, cc.getExpires().getValue());
        }
        catch (WSATException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.wsat.interceptor.CoorContextInInterceptor", (String)"146");
            throw new Fault((Throwable)e);
        }
        WSATCompleteTransInterceptor _comTransOut = new WSATCompleteTransInterceptor("post-protocol-ending", LibertyApplicationBus.Type.SERVER);
        Exchange ex = message.getExchange();
        Endpoint ep = (Endpoint)ex.get(Endpoint.class);
        ep.getOutInterceptors().add(_comTransOut);
    }

    public void handleFault(SoapMessage message) {
        WSCoorUtil.checkHandlerServiceReady();
        if (this.ctxId != null && !this.ctxId.equals("")) {
            try {
                if (TraceComponent.isAnyTracingEnabled() && this.tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)this.tc, (String)"handleFault", (Object[])new Object[]{"Execute handleServerFault for transaction", this.ctxId});
                }
                WSCoorUtil.getHandlerService().handleServerFault();
            }
            catch (WSATException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.wsat.interceptor.CoorContextInInterceptor", (String)"185");
            }
        } else if (TraceComponent.isAnyTracingEnabled() && this.tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)this.tc, (String)"handleFault", (Object[])new Object[]{"Cannot get transId, won't execute handleServerFault"});
        }
    }

    public Set<URI> getRoles() {
        return null;
    }

    public Set<QName> getUnderstoodHeaders() {
        return HEADERS;
    }

    static {
        HEADERS.add(new QName("http://docs.oasis-open.org/ws-tx/wscoor/2006/06", "CoordinationContext"));
    }
}

