/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.utilities.java.support.logic;

import com.google.common.base.Predicates;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.function.Function;
import net.shibboleth.utilities.java.support.logic.AllMatchPredicate;
import net.shibboleth.utilities.java.support.logic.AnyMatchPredicate;
import net.shibboleth.utilities.java.support.logic.CaseInsensitiveStringMatchPredicate;
import net.shibboleth.utilities.java.support.logic.Predicate;

public final class PredicateSupport {
    private PredicateSupport() {
    }

    @Nonnull
    public static <T> Predicate<Iterable<T>> allMatch(@Nonnull java.util.function.Predicate<T> target) {
        return new AllMatchPredicate<T>(target);
    }

    @Nonnull
    public static <T> Predicate<Iterable<T>> anyMatch(@Nonnull java.util.function.Predicate<T> target) {
        return new AnyMatchPredicate<T>(target);
    }

    @Nonnull
    public static Predicate<CharSequence> caseInsensitiveMatch(@Nonnull String target) {
        return new CaseInsensitiveStringMatchPredicate(target);
    }

    @Nonnull
    public static <T> Predicate<T> fromFunction(final @Nonnull Function<T, Boolean> function, final @Nonnull java.util.function.Predicate<? super T> defValue) {
        return new Predicate<T>(){

            @Override
            public boolean test(@Nullable T input) {
                Boolean result = (Boolean)function.apply(input);
                return result != null ? result.booleanValue() : defValue.test(input);
            }
        };
    }

    @Nonnull
    public static <T> Predicate<T> not(@Nonnull java.util.function.Predicate<? super T> predicate) {
        return predicate.negate()::test;
    }

    @Nonnull
    public static <T> Predicate<T> and(@Nonnull Iterable<? extends java.util.function.Predicate<? super T>> components) {
        ArrayList<com.google.common.base.Predicate> copy = new ArrayList<com.google.common.base.Predicate>();
        for (java.util.function.Predicate<T> predicate : components) {
            copy.add(predicate::test);
        }
        return arg_0 -> ((com.google.common.base.Predicate)Predicates.and(copy)).test(arg_0);
    }

    @SafeVarargs
    @Nonnull
    public static <T> Predicate<T> and(java.util.function.Predicate<? super T> ... components) {
        ArrayList<com.google.common.base.Predicate> copy = new ArrayList<com.google.common.base.Predicate>();
        for (java.util.function.Predicate<? super T> p : components) {
            copy.add(p::test);
        }
        return arg_0 -> ((com.google.common.base.Predicate)Predicates.and(copy)).test(arg_0);
    }

    @Nonnull
    public static <T> Predicate<T> and(@Nonnull java.util.function.Predicate<? super T> first, @Nonnull java.util.function.Predicate<? super T> second) {
        return t -> first.test(t) && second.test(t);
    }

    @Nonnull
    public static <T> Predicate<T> or(@Nonnull Iterable<? extends java.util.function.Predicate<? super T>> components) {
        ArrayList<com.google.common.base.Predicate> copy = new ArrayList<com.google.common.base.Predicate>();
        for (java.util.function.Predicate<T> predicate : components) {
            copy.add(predicate::test);
        }
        return arg_0 -> ((com.google.common.base.Predicate)Predicates.or(copy)).test(arg_0);
    }

    @SafeVarargs
    @Nonnull
    public static <T> Predicate<T> or(java.util.function.Predicate<? super T> ... components) {
        ArrayList<com.google.common.base.Predicate> copy = new ArrayList<com.google.common.base.Predicate>();
        for (java.util.function.Predicate<? super T> p : components) {
            copy.add(p::test);
        }
        return arg_0 -> ((com.google.common.base.Predicate)Predicates.or(copy)).test(arg_0);
    }

    @Nonnull
    public static <T> Predicate<T> or(@Nonnull java.util.function.Predicate<? super T> first, @Nonnull java.util.function.Predicate<? super T> second) {
        return t -> first.test(t) || second.test(t);
    }
}

