/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.utilities.java.support.httpclient;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.nio.charset.Charset;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.X509TrustManager;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.httpclient.HttpClientContextHandler;
import net.shibboleth.utilities.java.support.httpclient.TLSSocketFactoryBuilder;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.apache.http.HttpEntity;
import org.apache.http.ParseException;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HttpClientSupport {
    @Nonnull
    @NotEmpty
    public static final String CONTEXT_KEY_DYNAMIC_CONTEXT_HANDLERS = "java-support.DynamicContextHandlers";

    private HttpClientSupport() {
    }

    @Nonnull
    public static LayeredConnectionSocketFactory buildStrictTLSSocketFactory() {
        return new TLSSocketFactoryBuilder().setHostnameVerifier((HostnameVerifier)new DefaultHostnameVerifier()).build();
    }

    @Nonnull
    public static LayeredConnectionSocketFactory buildNoTrustTLSSocketFactory() {
        return new TLSSocketFactoryBuilder().setTrustManagers(Collections.singletonList(HttpClientSupport.buildNoTrustX509TrustManager())).setHostnameVerifier((HostnameVerifier)new NoopHostnameVerifier()).build();
    }

    @Nonnull
    public static X509TrustManager buildNoTrustX509TrustManager() {
        return new X509TrustManager(){
            private Logger log = LoggerFactory.getLogger((String)(HttpClientSupport.class.getName() + ".NoTrustX509TrustManager"));

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                this.log.trace("In getAcceptedIssuers");
                return null;
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                this.log.trace("In checkServerTrusted");
                if (chain != null) {
                    this.log.trace("Cert chain length: {}", (Object)chain.length);
                    for (X509Certificate cert : chain) {
                        this.log.trace("Cert key type: {}, subject: {}", (Object)cert.getPublicKey().getAlgorithm(), (Object)cert.getSubjectX500Principal().getName());
                    }
                } else {
                    this.log.trace("Cert chain was null");
                }
            }

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                this.log.trace("In checkClientTrusted");
            }
        };
    }

    @Nonnull
    public static List<HttpClientContextHandler> getDynamicContextHandlerList(@Nonnull HttpClientContext context) {
        Constraint.isNotNull(context, "HttpClientContext was null");
        ArrayList handlers = (ArrayList)context.getAttribute(CONTEXT_KEY_DYNAMIC_CONTEXT_HANDLERS, List.class);
        if (handlers == null) {
            handlers = new ArrayList();
            context.setAttribute(CONTEXT_KEY_DYNAMIC_CONTEXT_HANDLERS, handlers);
        }
        return handlers;
    }

    public static void addDynamicContextHandlerFirst(@Nonnull HttpClientContext context, @Nonnull HttpClientContextHandler handler) {
        HttpClientSupport.addDynamicContextHandlerFirst(context, handler, false);
    }

    public static void addDynamicContextHandlerFirst(@Nonnull HttpClientContext context, @Nonnull HttpClientContextHandler handler, boolean uniqueType) {
        Constraint.isNotNull(handler, "HttpClientContextHandler was null");
        List<HttpClientContextHandler> list = HttpClientSupport.getDynamicContextHandlerList(context);
        if (list.contains(handler) || uniqueType && list.stream().anyMatch(h -> handler.getClass().equals(h.getClass()))) {
            return;
        }
        list.add(0, handler);
    }

    public static void addDynamicContextHandlerLast(@Nonnull HttpClientContext context, @Nonnull HttpClientContextHandler handler) {
        HttpClientSupport.addDynamicContextHandlerLast(context, handler, false);
    }

    public static void addDynamicContextHandlerLast(@Nonnull HttpClientContext context, @Nonnull HttpClientContextHandler handler, boolean uniqueType) {
        Constraint.isNotNull(handler, "HttpClientContextHandler was null");
        List<HttpClientContextHandler> list = HttpClientSupport.getDynamicContextHandlerList(context);
        if (list.contains(handler) || uniqueType && list.stream().anyMatch(h -> handler.getClass().equals(h.getClass()))) {
            return;
        }
        list.add(handler);
    }

    /*
     * Exception decompiling
     */
    @Nullable
    public static String toString(@Nonnull HttpEntity entity, @Nullable Charset defaultCharset, int maxLength) throws IOException, ParseException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Nullable
    public static String toString(@Nonnull HttpEntity entity, @Nullable String defaultCharset, int maxLength) throws IOException, ParseException {
        return HttpClientSupport.toString(entity, defaultCharset != null ? Charset.forName(defaultCharset) : null, maxLength);
    }

    @Nullable
    public static String toString(@Nonnull HttpEntity entity, int maxLength) throws IOException, ParseException {
        return HttpClientSupport.toString(entity, (Charset)null, maxLength);
    }
}

