/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.proxyhandler;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ejs.util.am.Alarm;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.SIDestinationAddress;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SINotPossibleInCurrentConfigurationException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.admin.JsAdminUtils;
import com.ibm.ws.sib.mfp.JsDestinationAddress;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.mfp.control.SubscriptionMessage;
import com.ibm.ws.sib.mfp.control.SubscriptionMessageType;
import com.ibm.ws.sib.msgstore.AbstractItem;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.msgstore.NonLockingCursor;
import com.ibm.ws.sib.msgstore.transactions.Transaction;
import com.ibm.ws.sib.processor.impl.DestinationManager;
import com.ibm.ws.sib.processor.impl.ProducerSessionImpl;
import com.ibm.ws.sib.processor.impl.PubSubOutputHandler;
import com.ibm.ws.sib.processor.impl.store.filters.ClassEqualsFilter;
import com.ibm.ws.sib.processor.impl.store.itemstreams.SIMPItemStream;
import com.ibm.ws.sib.processor.proxyhandler.BusGroup;
import com.ibm.ws.sib.processor.proxyhandler.MESubscription;
import com.ibm.ws.sib.processor.proxyhandler.MultiMEProxyHandler;
import com.ibm.ws.sib.processor.proxyhandler.Neighbours;
import com.ibm.ws.sib.processor.utils.SIMPUtils;
import com.ibm.ws.sib.processor.utils.am.MPAlarmManager;
import com.ibm.ws.sib.transactions.LocalTransaction;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.SIBUuid8;
import com.ibm.ws.sib.utils.ras.FormattedWriter;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.SIBusMessage;
import com.ibm.wsspi.sib.core.SITransaction;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;

public final class Neighbour
extends SIMPItemStream
implements AlarmListener {
    private static final TraceComponent tc = SibTr.register(Neighbour.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final int PERSISTENT_VERSION = 1;
    private String iBusId;
    private BusGroup iBusGroup;
    private Hashtable iProxies;
    private MultiMEProxyHandler iProxyHandler;
    private JsDestinationAddress iRemoteQueue;
    private ProducerSessionImpl iProducerSession;
    private SIBUuid8 iMEUuid;
    private Neighbours iNeighbours;
    private DestinationManager iDestinationManager;
    private HashSet iPubSubOutputHandlers;
    private static final int REQUEST_TIMER = 300000;
    private boolean iRequestSent = false;
    private boolean iAlarmCancelled;
    private Alarm iAlarm;
    private boolean iRequestFailed = false;

    public Neighbour() {
    }

    Neighbour(MultiMEProxyHandler proxyHandler, SIBUuid8 meUUID, String busId, Neighbours neighbours) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"Neighbour", (Object)new Object[]{proxyHandler, meUUID, busId, neighbours});
        }
        this.iMEUuid = meUUID;
        this.iBusId = busId;
        this.intialiseNonPersistent(proxyHandler, neighbours);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"Neighbour", (Object)((Object)this));
        }
    }

    protected void intialiseNonPersistent(MultiMEProxyHandler proxyHandler, Neighbours neighbours) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"intialiseNonPersistent");
        }
        this.iProxyHandler = proxyHandler;
        this.iNeighbours = neighbours;
        this.iDestinationManager = this.iProxyHandler.getMessageProcessor().getDestinationManager();
        this.iRemoteQueue = SIMPUtils.createJsSystemDestinationAddress("SIMP.PROXY.QUEUE", this.iMEUuid, this.iBusId);
        if (this.iMEUuid == null) {
            this.iMEUuid = this.iRemoteQueue.getME();
        }
        this.iProxies = new Hashtable();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"intialiseNonPersistent");
        }
    }

    public final SIBUuid8 getUUID() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getUUID");
            SibTr.exit((TraceComponent)tc, (String)"getUUID", (Object)this.iMEUuid);
        }
        return this.iMEUuid;
    }

    public final String getBusId() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getBusId");
            SibTr.exit((TraceComponent)tc, (String)"getBusId", (Object)this.iBusId);
        }
        return this.iBusId;
    }

    BusGroup getBus() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getBus");
            SibTr.exit((TraceComponent)tc, (String)"getBus", (Object)this.iBusGroup);
        }
        return this.iBusGroup;
    }

    Hashtable getRegisteredProxies() {
        return this.iProxies;
    }

    void setBus(BusGroup busGroup) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setBus");
        }
        this.iBusGroup = busGroup;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setBus");
        }
    }

    void sendResetProxySubscriptions() throws SIResourceException {
        SubscriptionMessage message;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendResetProxySubscriptions");
        }
        if ((message = this.iBusGroup.generateResetSubscriptionMessage()) != null) {
            this.sendToNeighbour((JsMessage)message, null);
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("No subscriptions to forward to ME " + this.iMEUuid.toString()));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendResetProxySubscriptions");
        }
    }

    void sendRequestProxySubscriptions() throws SIResourceException {
        SubscriptionMessage message;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendRequestProxySubscriptions");
        }
        if ((message = this.iBusGroup.generateResetSubscriptionMessage()) != null) {
            message.setSubscriptionMessageType(SubscriptionMessageType.REQUEST);
            this.sendToNeighbour((JsMessage)message, null);
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("No subscriptions to forward to ME " + this.iMEUuid.toString()));
        }
        this.setRequestedProxySubscriptions();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendRequestProxySubscriptions");
        }
    }

    void sendReplyMessage() throws SIResourceException {
        SubscriptionMessage message;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendReplyMessage");
        }
        if ((message = this.iBusGroup.generateReplySubscriptionMessage()) != null) {
            this.sendToNeighbour((JsMessage)message, null);
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("No subscriptions to forward to ME " + this.iMEUuid.toString()));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendReplyMessage");
        }
    }

    private synchronized void createProducerSession() throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createProducerSession");
        }
        if (this.iProducerSession == null) {
            try {
                this.iProducerSession = (ProducerSessionImpl)this.iProxyHandler.getMessageProcessor().getSystemConnection().createSystemProducerSession((SIDestinationAddress)this.iRemoteQueue, null, null, null, null);
            }
            catch (SIException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.proxyhandler.Neighbour.createProducerSession", (String)"1:434:1.107", (Object)((Object)this));
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"createProducerSession", (Object)"SIResourceException");
                }
                throw new SIResourceException((Throwable)e);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createProducerSession");
        }
    }

    MESubscription proxyRegistered(SIBUuid12 topicSpaceUuid, String localTopicSpaceName, String topic, String foreignTSName, Transaction transaction, boolean foreignSecuredProxy, String MESubUserId) throws SIResourceException {
        String key;
        MESubscription sub;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"proxyRegistered", (Object)new Object[]{topicSpaceUuid, localTopicSpaceName, topic, foreignTSName, transaction, new Boolean(foreignSecuredProxy), MESubUserId});
        }
        if ((sub = (MESubscription)((Object)this.iProxies.get(key = BusGroup.subscriptionKey(topicSpaceUuid, topic)))) != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("Unmarking subscription " + (Object)((Object)sub)));
            }
            sub.unmark();
            boolean attrChanged = this.checkForeignSecurityAttributesChanged(sub, foreignSecuredProxy, MESubUserId);
            if (attrChanged) {
                try {
                    sub.requestUpdate(transaction);
                }
                catch (MessageStoreException e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.proxyhandler.Neighbour.proxyRegistered", (String)"1:522:1.107", (Object)((Object)this));
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                    SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.proxyhandler.Neighbour", "1:529:1.107", e});
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"proxyRegistered", (Object)"SIResourceException");
                    }
                    throw new SIResourceException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.proxyhandler.Neighbour", "1:539:1.107", e}, null), (Throwable)e);
                }
            }
            sub = null;
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Subscription being created");
            }
            sub = new MESubscription(topicSpaceUuid, localTopicSpaceName, topic, foreignTSName, foreignSecuredProxy, MESubUserId);
            try {
                this.addItem(sub, transaction);
            }
            catch (MessageStoreException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.proxyhandler.Neighbour.proxyRegistered", (String)"1:574:1.107", (Object)((Object)this));
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.proxyhandler.Neighbour", "1:581:1.107", e});
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"proxyRegistered", (Object)"SIResourceException");
                }
                throw new SIResourceException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.proxyhandler.Neighbour", "1:591:1.107", e}, null), (Throwable)e);
            }
            this.iProxies.put(key, sub);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"proxyRegistered", (Object)((Object)sub));
        }
        return sub;
    }

    protected void removeSubscription(SIBUuid12 topicSpace, String topic) {
        String key = BusGroup.subscriptionKey(topicSpace, topic);
        this.iProxies.remove(key);
    }

    MESubscription proxyDeregistered(SIBUuid12 topicSpace, String topic, Transaction transaction) throws SIResourceException {
        String key;
        MESubscription sub;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"proxyDeregistered", (Object)new Object[]{topicSpace, topic, transaction});
        }
        if ((sub = (MESubscription)((Object)this.iProxies.get(key = BusGroup.subscriptionKey(topicSpace, topic)))) != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("Subscription " + (Object)((Object)sub) + " being removed"));
            }
            try {
                sub.remove(transaction, sub.getLockID());
            }
            catch (MessageStoreException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.proxyhandler.Neighbour.proxyDeregistered", (String)"1:669:1.107", (Object)((Object)this));
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.proxyhandler.Neighbour", "1:676:1.107", e});
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"proxyDeregistered", (Object)"SIResourceException");
                }
                throw new SIResourceException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.proxyhandler.Neighbour", "1:686:1.107", e}, null), (Throwable)e);
            }
            this.iProxies.remove(key);
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"No Subscription to be removed");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"proxyDeregistered", (Object)((Object)sub));
        }
        return sub;
    }

    protected void addSubscription(SIBUuid12 topicSpace, String topic, MESubscription subscription) {
        String key = BusGroup.subscriptionKey(topicSpace, topic);
        this.iProxies.put(key, subscription);
    }

    protected MESubscription getSubscription(SIBUuid12 topicSpace, String topic) {
        return (MESubscription)((Object)this.iProxies.get(BusGroup.subscriptionKey(topicSpace, topic)));
    }

    void markAllProxies() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"markAllProxies");
        }
        Enumeration enu = this.iProxies.elements();
        while (enu.hasMoreElements()) {
            MESubscription sub = (MESubscription)((Object)enu.nextElement());
            sub.mark();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"markAllProxies");
        }
    }

    void sweepMarkedProxies(List topicSpaces, List topics, Transaction transaction, boolean okToForward) throws SIResourceException, SIException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sweepMarkedProxies", (Object)new Object[]{topicSpaces, topics, transaction, new Boolean(okToForward)});
        }
        Enumeration enu = this.iProxies.elements();
        while (enu.hasMoreElements()) {
            MESubscription sub = (MESubscription)((Object)enu.nextElement());
            if (!sub.isMarked()) continue;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("Subscription " + (Object)((Object)sub) + " being removed"));
            }
            this.proxyDeregistered(sub.getTopicSpaceUuid(), sub.getTopic(), transaction);
            boolean proxyDeleted = this.iNeighbours.deleteProxy(this.iDestinationManager.getDestinationInternal(sub.getTopicSpaceUuid(), false), sub, this, sub.getTopicSpaceUuid(), sub.getTopic(), true, false);
            String key = BusGroup.subscriptionKey(sub.getTopicSpaceUuid(), sub.getTopic());
            this.iProxies.remove(key);
            if (!okToForward || !proxyDeleted) continue;
            topics.add(sub.getTopic());
            topicSpaces.add(sub.getTopicSpaceUuid());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sweepMarkedProxies");
        }
    }

    void sendToNeighbour(JsMessage message, Transaction transaction) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendToNeighbour", (Object)new Object[]{message, transaction});
        }
        if (this.iProducerSession == null) {
            this.createProducerSession();
        }
        try {
            this.iProducerSession.send((SIBusMessage)message, (SITransaction)transaction);
        }
        catch (SIException e) {
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            SibTr.warning((TraceComponent)tc, (String)"PUBSUB_CONSISTENCY_ERROR_CWSIP0383", (Object)new Object[]{JsAdminUtils.getMENameByUuidForMessage((String)this.iMEUuid.toString()), e});
            SIResourceException ee = null;
            ee = !(e instanceof SIResourceException) ? new SIResourceException((Throwable)e) : (SIResourceException)((Object)e);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"sendToNeighbour", (Object)((Object)ee));
            }
            throw ee;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendToNeighbour");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void recoverSubscriptions(MultiMEProxyHandler proxyHandler) throws MessageStoreException, SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"recoverSubscriptions", (Object)((Object)proxyHandler));
        }
        this.iProxyHandler = proxyHandler;
        this.iProxies = new Hashtable();
        NonLockingCursor cursor = null;
        try {
            cursor = this.newNonLockingItemCursor(new ClassEqualsFilter(MESubscription.class));
            AbstractItem item = null;
            while ((item = cursor.next()) != null) {
                MESubscription sub = null;
                sub = (MESubscription)item;
                String key = BusGroup.subscriptionKey(sub.getTopicSpaceUuid(), sub.getTopic());
                this.iProxies.put(key, sub);
                this.iNeighbours.createProxy(this, this.iDestinationManager.getDestinationInternal(sub.getTopicSpaceUuid(), false), sub, sub.getTopicSpaceUuid(), sub.getTopic(), true);
                sub.eventPostCommitAdd(null);
            }
        }
        finally {
            if (cursor != null) {
                cursor.finished();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"recoverSubscriptions");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteDestination() throws SIConnectionLostException, SIResourceException, SIErrorException {
        Neighbour neighbour;
        block14: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"deleteDestination");
            }
            neighbour = this;
            synchronized (neighbour) {
                if (this.iProducerSession != null) {
                    this.iProducerSession.close();
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("Removing destination " + this.iRemoteQueue.getDestinationName()));
            }
            try {
                this.iDestinationManager.deleteSystemDestination(this.iRemoteQueue);
            }
            catch (SINotPossibleInCurrentConfigurationException e) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block14;
                SibTr.debug((TraceComponent)tc, (String)("Destination " + this.iRemoteQueue + " already deleted"));
            }
        }
        neighbour = this;
        synchronized (neighbour) {
            if (!this.iAlarmCancelled) {
                if (this.iAlarm != null) {
                    this.iAlarm.cancel();
                }
                this.iAlarmCancelled = true;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deleteDestination");
        }
    }

    public String toString() {
        return this.iMEUuid + ":" + this.iBusId;
    }

    public boolean equals(Object neighbour) {
        boolean equal = false;
        if (neighbour instanceof Neighbour && this.iMEUuid.equals((Object)((Neighbour)((Object)neighbour)).getUUID())) {
            equal = true;
        }
        return equal;
    }

    public int hashCode() {
        return this.iMEUuid.hashCode();
    }

    @Override
    public void restore(ObjectInputStream ois, int dataVersion) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"restore", (Object)new Object[]{ois, new Integer(dataVersion)});
        }
        try {
            HashMap hm = (HashMap)ois.readObject();
            byte[] meuuid = (byte[])hm.get("iMEUuid");
            this.iMEUuid = new SIBUuid8(meuuid);
            this.iBusId = (String)hm.get("iBusId");
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.proxyhandler.Neighbour.restore", (String)"1:1057:1.107", (Object)((Object)this));
            SibTr.exception((TraceComponent)tc, (Exception)e);
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.proxyhandler.Neighbour", "1:1064:1.107", e});
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"restore", (Object)"SIErrorException");
            }
            throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.proxyhandler.Neighbour", "1:1074:1.107", e}, null), (Throwable)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"restore");
        }
    }

    @Override
    public int getPersistentVersion() {
        return 1;
    }

    @Override
    public void getPersistentData(ObjectOutputStream oos) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getPersistentData", (Object)oos);
        }
        try {
            HashMap<String, Object> hm = new HashMap<String, Object>();
            hm.put("iMEUuid", this.iMEUuid.toByteArray());
            hm.put("iBusId", this.iBusId);
            oos.writeObject(hm);
        }
        catch (IOException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.proxyhandler.Neighbour.getPersistentData", (String)"1:1116:1.107", (Object)((Object)this));
            SibTr.exception((TraceComponent)tc, (Exception)e);
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.proxyhandler.Neighbour", "1:1123:1.107", e});
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getPersistentData", (Object)"SIErrorException");
            }
            throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.proxyhandler.Neighbour", "1:1133:1.107", e}, null), (Throwable)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getPersistentData");
        }
    }

    public boolean okToForward(String busName) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"okToForward", (Object)busName);
        }
        boolean returnVal = false;
        if (busName == null) {
            returnVal = true;
        } else if (!busName.equals(this.iBusId)) {
            returnVal = true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"okToForward", (Object)new Boolean(returnVal));
        }
        return returnVal;
    }

    protected void addPubSubOutputHandler(PubSubOutputHandler handler) {
        if (this.iPubSubOutputHandlers == null) {
            this.iPubSubOutputHandlers = new HashSet();
        }
        this.iPubSubOutputHandlers.add(handler);
    }

    protected HashSet getPubSubOutputHandlers() {
        return this.iPubSubOutputHandlers;
    }

    public void xmlWriteOn(FormattedWriter writer) throws IOException {
        writer.newLine();
        writer.taggedValue("iMEUuid", (Object)this.iMEUuid);
        writer.newLine();
        writer.taggedValue("iBusId", (Object)this.iBusId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setRequestedProxySubscriptions() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setRequestedProxySubscriptions");
        }
        MPAlarmManager manager = this.iProxyHandler.getMessageProcessor().getAlarmManager();
        this.iAlarm = manager.create(300000L, this);
        Neighbour neighbour = this;
        synchronized (neighbour) {
            this.iRequestSent = true;
            this.iAlarmCancelled = false;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setRequestedProxySubscriptions");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setRequestedProxySubscriptionsResponded() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setRequestedProxySubscriptionsResponded");
        }
        Neighbour neighbour = this;
        synchronized (neighbour) {
            this.iRequestSent = false;
            if (!this.iAlarmCancelled) {
                this.iAlarm.cancel();
            }
            this.iAlarmCancelled = true;
        }
        String meName = JsAdminUtils.getMENameByUuidForMessage((String)this.iMEUuid.toString());
        if (meName == null) {
            meName = this.iMEUuid.toString();
        }
        SibTr.push((Object)this.iProxyHandler.getMessageProcessor().getMessagingEngine());
        SibTr.info((TraceComponent)tc, (String)"NEIGHBOUR_REPLY_RECEIVED_INFO_CWSIP0382", (Object)new Object[]{meName});
        SibTr.pop();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setRequestedProxySubscriptionsResponded");
        }
    }

    boolean wasProxyRequestSent() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"wasProxyRequestSent");
            SibTr.exit((TraceComponent)tc, (String)"wasProxyRequestSent", (Object)new Boolean(this.iRequestSent));
        }
        return this.iRequestSent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void alarm(Object alarmContext) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"alarm", (Object)alarmContext);
        }
        Neighbour neighbour = this;
        synchronized (neighbour) {
            this.iAlarmCancelled = true;
            if (this.iRequestFailed) {
                this.iRequestFailed = false;
                SubscriptionMessage message = this.iBusGroup.generateResetSubscriptionMessage();
                message.setSubscriptionMessageType(SubscriptionMessageType.REQUEST);
                LocalTransaction transaction = this.iProxyHandler.getMessageProcessor().getTXManager().createLocalTransaction(true);
                try {
                    this.sendToNeighbour((JsMessage)message, (Transaction)transaction);
                    transaction.commit();
                }
                catch (SIException e) {
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                    this.iRequestFailed = true;
                }
                this.setRequestedProxySubscriptions();
            } else if (this.iRequestSent) {
                String meName = JsAdminUtils.getMENameByUuidForMessage((String)this.iMEUuid.toString());
                if (meName == null) {
                    meName = this.iMEUuid.toString();
                }
                SibTr.push((Object)this.iProxyHandler.getMessageProcessor().getMessagingEngine());
                SibTr.warning((TraceComponent)tc, (String)"NO_NEIGHBOUR_REPLY_WARNING_CWSIP0381", (Object)new Object[]{meName});
                SibTr.pop();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"alarm");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteSystemDestinations() throws SIConnectionLostException, SIResourceException, SIErrorException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deleteSystemDestinations");
        }
        Neighbour neighbour = this;
        synchronized (neighbour) {
            if (this.iProducerSession != null) {
                this.iProducerSession.close();
            }
        }
        List<JsDestinationAddress> systemDestinations = this.iDestinationManager.getAllSystemDestinations(this.iMEUuid);
        for (JsDestinationAddress destAddress : systemDestinations) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("Removing destination " + destAddress.getDestinationName()));
            }
            try {
                this.iDestinationManager.deleteSystemDestination(destAddress);
            }
            catch (SINotPossibleInCurrentConfigurationException e) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                SibTr.debug((TraceComponent)tc, (String)("Destination " + destAddress + " already deleted"));
            }
        }
        Neighbour neighbour2 = this;
        synchronized (neighbour2) {
            if (!this.iAlarmCancelled) {
                if (this.iAlarm != null) {
                    this.iAlarm.cancel();
                }
                this.iAlarmCancelled = true;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deleteSystemDestinations");
        }
    }

    private boolean checkForeignSecurityAttributesChanged(MESubscription sub, boolean foreignSecuredProxy, String MESubUserId) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"checkForeignSecurityAttributesChanged", (Object)new Object[]{sub, new Boolean(foreignSecuredProxy), MESubUserId});
        }
        boolean attrChanged = false;
        if (foreignSecuredProxy) {
            if (sub.isForeignSecuredProxy()) {
                if (MESubUserId != null) {
                    if (sub.getMESubUserId() != null) {
                        if (!MESubUserId.equals(sub.getMESubUserId())) {
                            sub.setMESubUserId(MESubUserId);
                            attrChanged = true;
                        }
                    } else {
                        sub.setMESubUserId(MESubUserId);
                        attrChanged = true;
                    }
                } else if (sub.getMESubUserId() != null) {
                    sub.setMESubUserId(null);
                    attrChanged = true;
                }
            } else {
                sub.setForeignSecuredProxy(true);
                sub.setMESubUserId(MESubUserId);
                attrChanged = true;
            }
        } else if (sub.isForeignSecuredProxy()) {
            sub.setForeignSecuredProxy(false);
            sub.setMESubUserId(null);
            attrChanged = true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"checkForeignSecurityAttributesChanged", (Object)new Boolean(attrChanged));
        }
        return attrChanged;
    }

    synchronized void resetListFailed() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"resetListFailed");
        }
        this.iRequestFailed = true;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"resetListFailed");
        }
    }
}

