/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.social.internal.utils;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.social.SocialLoginConfig;
import com.ibm.ws.security.social.error.SocialLoginException;
import com.ibm.ws.security.social.tai.SocialLoginTAI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class SocialTaiRequest {
    private static TraceComponent tc = Tr.register(SocialTaiRequest.class, (String)"SOCIAL", (String)"com.ibm.ws.security.social.resources.SocialMessages");
    protected String providerName;
    protected HttpServletRequest request;
    protected List<SocialLoginConfig> filteredConfigs = null;
    protected List<SocialLoginConfig> genericConfigs = null;
    SocialLoginConfig socialLoginConfig = null;
    SocialLoginException taiException = null;
    static final long serialVersionUID = -3769767144823836410L;

    public SocialTaiRequest(HttpServletRequest request) {
        this.request = request;
    }

    public void addFilteredConfig(SocialLoginConfig socialLoginConfig) {
        if (socialLoginConfig != null) {
            if (this.filteredConfigs == null) {
                this.filteredConfigs = new ArrayList<SocialLoginConfig>();
            }
            if (!this.filteredConfigs.contains(socialLoginConfig)) {
                this.filteredConfigs.add(socialLoginConfig);
            }
        }
    }

    public void setSpecifiedConfig(SocialLoginConfig socialLoginConfig) {
        this.socialLoginConfig = socialLoginConfig;
    }

    public void addGenericConfig(SocialLoginConfig socialLoginConfig) {
        if (socialLoginConfig != null) {
            if (this.genericConfigs == null) {
                this.genericConfigs = new ArrayList<SocialLoginConfig>();
            }
            if (!this.genericConfigs.contains(socialLoginConfig)) {
                this.genericConfigs.add(socialLoginConfig);
            }
        }
    }

    public String getProviderName() {
        if (this.providerName == null && this.socialLoginConfig != null) {
            this.providerName = this.socialLoginConfig.getUniqueId();
        }
        return this.providerName;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public List<SocialLoginConfig> getFilteredConfigs() {
        return this.filteredConfigs;
    }

    public List<SocialLoginConfig> getGenericConfigs() {
        return this.genericConfigs;
    }

    public Set<SocialLoginConfig> getAllMatchingConfigs() {
        HashSet<SocialLoginConfig> allConfigs = new HashSet<SocialLoginConfig>();
        if (this.socialLoginConfig != null) {
            allConfigs.add(this.socialLoginConfig);
        }
        if (this.filteredConfigs != null) {
            allConfigs.addAll(this.filteredConfigs);
        }
        if (this.genericConfigs != null) {
            allConfigs.addAll(this.genericConfigs);
        }
        return allConfigs;
    }

    public Set<String> getAllMatchingConfigIds() {
        HashSet<String> allConfigIds = new HashSet<String>();
        Set<SocialLoginConfig> allConfigs = this.getAllMatchingConfigs();
        for (SocialLoginConfig config : allConfigs) {
            allConfigIds.add(config.getUniqueId());
        }
        return allConfigIds;
    }

    protected boolean isLocalAuthEnabled() {
        return SocialLoginTAI.getSocialLoginWebappConfig() != null && SocialLoginTAI.getSocialLoginWebappConfig().isLocalAuthenticationEnabled();
    }

    /*
     * Enabled aggressive block sorting
     */
    public SocialLoginConfig getTheOnlySocialLoginConfig() throws SocialLoginException {
        if (this.taiException != null) {
            SocialLoginException exception = this.taiException;
            this.taiException = null;
            throw exception;
        }
        if (this.socialLoginConfig != null) return this.socialLoginConfig;
        if (this.filteredConfigs != null) {
            if (this.filteredConfigs.size() == 1 && !this.isLocalAuthEnabled()) {
                this.socialLoginConfig = this.filteredConfigs.get(0);
                return this.socialLoginConfig;
            }
            String configIds = this.getConfigIds(this.filteredConfigs);
            throw new SocialLoginException("SOCIAL_LOGIN_MANY_PROVIDERS", null, new Object[]{configIds});
        }
        if (this.genericConfigs == null) return this.socialLoginConfig;
        if (this.genericConfigs.size() == 1 && !this.isLocalAuthEnabled()) {
            this.socialLoginConfig = this.genericConfigs.get(0);
            return this.socialLoginConfig;
        }
        String configIds = this.getConfigIds(this.genericConfigs);
        throw new SocialLoginException("SOCIAL_LOGIN_MANY_PROVIDERS", null, new Object[]{configIds});
    }

    String getConfigIds(List<SocialLoginConfig> multiConfigs) {
        String result = "";
        if (multiConfigs == null) {
            return result;
        }
        boolean bInit = true;
        for (SocialLoginConfig socialLoginConfig : multiConfigs) {
            if (!bInit) {
                result = result.concat(", ");
            } else {
                bInit = false;
            }
            result = result.concat(socialLoginConfig.getUniqueId());
        }
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SocialTaiRequest [provider:").append(this.getProviderName()).append(" request:").append(this.request).append("]");
        return sb.toString();
    }

    public boolean hasServices() {
        return this.filteredConfigs != null || this.genericConfigs != null || this.socialLoginConfig != null;
    }

    public void setTaiException(SocialLoginException taiException) {
        this.taiException = taiException;
    }
}

