/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.helper;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.logging.SessionLog;

public class DBPlatformHelper {
    private static final String DEFAULTPLATFORM = "org.eclipse.persistence.platform.database.DatabasePlatform";
    private static final String PROPERTY_PATH = "org/eclipse/persistence/internal/helper/";
    private static final String VENDOR_NAME_TO_PLATFORM_RESOURCE_NAME = "org/eclipse/persistence/internal/helper/VendorNameToPlatformMapping.properties";
    private static List<String[]> _nameToVendorPlatform = null;

    public static String getDBPlatform(String vendorName, String minorVersion, String majorVersion, SessionLog logger) {
        DBPlatformHelper.initializeNameToVendorPlatform(logger);
        vendorName = vendorName == null ? "Vendor Not Found" : vendorName;
        minorVersion = minorVersion == null ? "0" : minorVersion;
        majorVersion = majorVersion == null ? "0" : majorVersion;
        String vendor = vendorName + "[" + minorVersion + ", " + majorVersion + "]";
        String detectedDbPlatform = DBPlatformHelper.matchVendorNameInProperties(vendor, _nameToVendorPlatform, logger);
        if (logger.shouldLog(3)) {
            logger.log(3, "connection", "dbPlatformHelper_detectedVendorPlatform", (Object)detectedDbPlatform);
        }
        if (detectedDbPlatform == null) {
            if (logger.shouldLog(5)) {
                logger.log(5, "connection", "dbPlatformHelper_defaultingPlatform", (Object)vendor, (Object)DEFAULTPLATFORM);
            }
            detectedDbPlatform = DEFAULTPLATFORM;
        }
        return detectedDbPlatform;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String[]> initializeNameToVendorPlatform(SessionLog logger) {
        Class<DBPlatformHelper> clazz = DBPlatformHelper.class;
        synchronized (DBPlatformHelper.class) {
            if (_nameToVendorPlatform == null) {
                _nameToVendorPlatform = new ArrayList<String[]>();
                try {
                    DBPlatformHelper.loadFromResource(_nameToVendorPlatform, VENDOR_NAME_TO_PLATFORM_RESOURCE_NAME, DBPlatformHelper.class.getClassLoader());
                }
                catch (IOException e) {
                    logger.log(6, "connection", "dbPlatformHelper_noMappingFound", (Object)VENDOR_NAME_TO_PLATFORM_RESOURCE_NAME);
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return _nameToVendorPlatform;
        }
    }

    private static String matchVendorNameInProperties(String vendorName, List<String[]> nameToVendorPlatform, SessionLog logger) {
        String dbPlatform = null;
        Iterator<String[]> iterator = nameToVendorPlatform.iterator();
        while (dbPlatform == null && iterator.hasNext()) {
            String[] entry = iterator.next();
            String regExpr = entry[0];
            String value = entry[1];
            if (logger.shouldLog(1)) {
                logger.log(1, "connection", "dbPlatformHelper_regExprDbPlatform", (Object)regExpr, (Object)value);
            }
            if (!DBPlatformHelper.matchPattern(regExpr, vendorName, logger)) continue;
            dbPlatform = value;
        }
        return dbPlatform;
    }

    private static boolean matchPattern(String regExp, String target, SessionLog logger) {
        boolean matches;
        block2: {
            matches = false;
            try {
                matches = Pattern.matches(regExp, target);
            }
            catch (PatternSyntaxException e) {
                if (!logger.shouldLog(3)) break block2;
                logger.log(3, "connection", "dbPlatformHelper_patternSyntaxException", (Object)e);
            }
        }
        return matches;
    }

    private static void loadFromResource(List<String[]> properties, String resourceName, ClassLoader classLoader) throws IOException {
        DBPlatformHelper.load(properties, resourceName, classLoader);
    }

    private static void load(List<String[]> properties, String resourceName, ClassLoader classLoader) throws IOException {
        try (BufferedReader bin = new BufferedReader(new InputStreamReader(DBPlatformHelper.openResourceInputStream(resourceName, classLoader)));){
            String line = bin.readLine();
            while (line != null) {
                String[] keyValue = DBPlatformHelper.validateLineForReturnAsKeyValueArray(line);
                if (keyValue != null) {
                    properties.add(keyValue);
                }
                line = bin.readLine();
            }
        }
    }

    private static InputStream openResourceInputStream(String resourceName, ClassLoader classLoader) {
        return PrivilegedAccessHelper.callDoPrivileged(() -> {
            if (classLoader != null) {
                return classLoader.getResourceAsStream(resourceName);
            }
            return ClassLoader.getSystemResourceAsStream(resourceName);
        });
    }

    private static String[] validateLineForReturnAsKeyValueArray(String line) {
        if (line == null || line.length() == 0) {
            return null;
        }
        if ((line = line.trim()).length() == 0 || line.startsWith("#")) {
            return null;
        }
        int indexOfEquals = line.indexOf(61);
        if (indexOfEquals == -1) {
            return null;
        }
        String key = line.substring(0, indexOfEquals);
        String value = line.substring(indexOfEquals + 1, line.length());
        return new String[]{key, value};
    }
}

