/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.security.authorization.jacc.internal.proxy;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.authorization.jacc.PolicyConfigurationManager;
import com.ibm.ws.security.authorization.jacc.common.PolicyProxy;
import com.ibm.ws.security.authorization.jacc.common.ProviderServiceProxy;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.security.authorization.jacc.ProviderService;
import io.openliberty.security.authorization.jacc.internal.proxy.JavaSePolicyProxyImpl;
import jakarta.security.jacc.PolicyConfigurationFactory;
import java.security.AccessController;
import java.security.Policy;
import java.security.PrivilegedAction;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={ProviderServiceProxy.class}, immediate=true, name="io.openliberty.security.authorization.jacc.provider.proxy", configurationPolicy=ConfigurationPolicy.IGNORE, property={"service.vendor=IBM"})
public class ProviderServiceProxyImpl
implements ProviderServiceProxy {
    private static final TraceComponent tc = Tr.register(ProviderServiceProxyImpl.class, null, null);
    private static final String JACC_FACTORY = "jakarta.security.jacc.PolicyConfigurationFactory.provider";
    private static final String JACC_FACTORY_EE9 = "jakarta.security.jacc.PolicyConfigurationFactory.provider";
    private static final String JACC_POLICY_PROVIDER = "javax.security.jacc.policy.provider";
    private static final String JACC_POLICY_PROVIDER_EE9 = "jakarta.security.jacc.policy.provider";
    static final String KEY_JACC_PROVIDER_SERVICE = "jaccProviderService";
    private final AtomicServiceReference<ProviderService> jaccProviderService = new AtomicServiceReference("jaccProviderService");
    private String policyName = null;
    private String factoryName = null;
    private String originalSystemPolicyName = null;
    private String originalSystemFactoryName = null;
    static final long serialVersionUID = -8132550692454607631L;

    @Reference(service=ProviderService.class, policy=ReferencePolicy.DYNAMIC, name="jaccProviderService")
    protected void setJaccProviderService(ServiceReference<ProviderService> reference) {
        this.jaccProviderService.setReference(reference);
        this.initializeSystemProperties(reference);
    }

    protected void unsetJaccProviderService(ServiceReference<ProviderService> reference) {
        this.jaccProviderService.unsetReference(reference);
        this.restoreSystemProperties();
    }

    public PolicyProxy getPolicyProxy(PolicyConfigurationManager pcm) {
        ProviderService providerService = (ProviderService)this.jaccProviderService.getService();
        if (providerService == null) {
            return null;
        }
        Policy policy = providerService.getPolicy();
        return policy == null ? null : new JavaSePolicyProxyImpl(policy);
    }

    public PolicyConfigurationFactory getPolicyConfigFactory() {
        ProviderService providerService = (ProviderService)this.jaccProviderService.getService();
        return providerService == null ? null : providerService.getPolicyConfigFactory();
    }

    public Object getProperty(String property) {
        ServiceReference serviceRef = this.jaccProviderService.getReference();
        return serviceRef == null ? null : serviceRef.getProperty(property);
    }

    public String getPolicyName() {
        return this.policyName;
    }

    public String getFactoryName() {
        return this.factoryName;
    }

    protected void activate(ComponentContext cc) {
        this.jaccProviderService.activate(cc);
    }

    protected void deactivate(ComponentContext cc) {
        this.jaccProviderService.deactivate(cc);
    }

    private void initializeSystemProperties(ServiceReference<ProviderService> reference) {
        Object obj = reference.getProperty(JACC_POLICY_PROVIDER);
        if (obj != null && obj instanceof String) {
            this.policyName = (String)obj;
        }
        if (this.policyName == null && (obj = reference.getProperty(JACC_POLICY_PROVIDER_EE9)) != null && obj instanceof String) {
            this.policyName = (String)obj;
        }
        if ((obj = reference.getProperty("jakarta.security.jacc.PolicyConfigurationFactory.provider")) != null && obj instanceof String) {
            this.factoryName = (String)obj;
        }
        if (this.factoryName == null && (obj = reference.getProperty("jakarta.security.jacc.PolicyConfigurationFactory.provider")) != null && obj instanceof String) {
            this.factoryName = (String)obj;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Meta data : policyName : " + this.policyName + " factoryName : " + this.factoryName), (Object[])new Object[0]);
        }
        this.originalSystemPolicyName = null;
        this.originalSystemFactoryName = null;
        AccessController.doPrivileged(new PrivilegedAction<Object>(){
            static final long serialVersionUID = 1084073018360095051L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Object run() {
                String systemFactoryName;
                String systemPolicyName = System.getProperty(ProviderServiceProxyImpl.JACC_POLICY_PROVIDER);
                if (systemPolicyName == null) {
                    systemPolicyName = System.getProperty(ProviderServiceProxyImpl.JACC_POLICY_PROVIDER_EE9);
                }
                if ((systemFactoryName = System.getProperty("jakarta.security.jacc.PolicyConfigurationFactory.provider")) == null) {
                    systemFactoryName = System.getProperty("jakarta.security.jacc.PolicyConfigurationFactory.provider");
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("System properties : policyName : " + systemPolicyName + " factoryName : " + systemFactoryName), (Object[])new Object[0]);
                }
                if (systemPolicyName == null) {
                    if (ProviderServiceProxyImpl.this.policyName != null) {
                        System.setProperty(ProviderServiceProxyImpl.JACC_POLICY_PROVIDER, ProviderServiceProxyImpl.this.policyName);
                        System.setProperty(ProviderServiceProxyImpl.JACC_POLICY_PROVIDER_EE9, ProviderServiceProxyImpl.this.policyName);
                    } else if (ProviderServiceProxyImpl.this.policyName == null) {
                        Tr.error((TraceComponent)tc, (String)"JACC_POLICY_IS_NOT_SET", (Object[])new Object[0]);
                        return null;
                    }
                } else if (ProviderServiceProxyImpl.this.policyName == null) {
                    ProviderServiceProxyImpl.this.policyName = systemPolicyName;
                } else if (!systemPolicyName.equals(ProviderServiceProxyImpl.this.policyName)) {
                    Tr.warning((TraceComponent)tc, (String)"JACC_INCONSISTENT_POLICY_CLASS", (Object[])new Object[]{systemPolicyName, ProviderServiceProxyImpl.this.policyName});
                    System.setProperty(ProviderServiceProxyImpl.JACC_POLICY_PROVIDER, ProviderServiceProxyImpl.this.policyName);
                    System.setProperty(ProviderServiceProxyImpl.JACC_POLICY_PROVIDER_EE9, ProviderServiceProxyImpl.this.policyName);
                    ProviderServiceProxyImpl.this.originalSystemPolicyName = systemPolicyName;
                }
                if (systemFactoryName == null) {
                    if (ProviderServiceProxyImpl.this.factoryName != null) {
                        System.setProperty("jakarta.security.jacc.PolicyConfigurationFactory.provider", ProviderServiceProxyImpl.this.factoryName);
                        System.setProperty("jakarta.security.jacc.PolicyConfigurationFactory.provider", ProviderServiceProxyImpl.this.factoryName);
                    } else if (ProviderServiceProxyImpl.this.factoryName == null) {
                        Tr.error((TraceComponent)tc, (String)"JACC_FACTORY_IS_NOT_SET", (Object[])new Object[0]);
                        return null;
                    }
                } else if (ProviderServiceProxyImpl.this.factoryName == null) {
                    ProviderServiceProxyImpl.this.factoryName = systemFactoryName;
                } else if (!systemFactoryName.equals(ProviderServiceProxyImpl.this.factoryName)) {
                    Tr.warning((TraceComponent)tc, (String)"JACC_INCONSISTENT_FACTORY_CLASS", (Object[])new Object[]{systemFactoryName, ProviderServiceProxyImpl.this.factoryName});
                    System.setProperty("jakarta.security.jacc.PolicyConfigurationFactory.provider", ProviderServiceProxyImpl.this.factoryName);
                    System.setProperty("jakarta.security.jacc.PolicyConfigurationFactory.provider", ProviderServiceProxyImpl.this.factoryName);
                    ProviderServiceProxyImpl.this.originalSystemFactoryName = systemFactoryName;
                }
                return null;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"io.openliberty.security.authorization.jacc.internal.proxy.ProviderServiceProxyImpl$1", 1.class, null, null);
            }
        });
    }

    private void restoreSystemProperties() {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){
            static final long serialVersionUID = -9108951242981663231L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Object run() {
                if (ProviderServiceProxyImpl.this.originalSystemPolicyName != null) {
                    System.setProperty(ProviderServiceProxyImpl.JACC_POLICY_PROVIDER, ProviderServiceProxyImpl.this.originalSystemPolicyName);
                    System.setProperty(ProviderServiceProxyImpl.JACC_POLICY_PROVIDER_EE9, ProviderServiceProxyImpl.this.originalSystemPolicyName);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("PolicyName system property is restored by : " + ProviderServiceProxyImpl.this.originalSystemPolicyName), (Object[])new Object[0]);
                    }
                }
                if (ProviderServiceProxyImpl.this.originalSystemFactoryName != null) {
                    System.setProperty("jakarta.security.jacc.PolicyConfigurationFactory.provider", ProviderServiceProxyImpl.this.originalSystemFactoryName);
                    System.setProperty("jakarta.security.jacc.PolicyConfigurationFactory.provider", ProviderServiceProxyImpl.this.originalSystemFactoryName);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("PolicyName system property is restored by : " + ProviderServiceProxyImpl.this.originalSystemFactoryName), (Object[])new Object[0]);
                    }
                }
                return null;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"io.openliberty.security.authorization.jacc.internal.proxy.ProviderServiceProxyImpl$2", 2.class, null, null);
            }
        });
    }
}

