/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.audit.event;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.security.audit.AuditEvent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.audit.source.utils.AuditUtils;
import com.ibm.ws.webcontainer.security.AuthenticationResult;
import com.ibm.ws.webcontainer.security.WebRequest;
import jakarta.servlet.http.HttpServletRequest;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class AuthenticationFailoverEvent
extends AuditEvent {
    private static final TraceComponent tc = Tr.register(AuthenticationFailoverEvent.class, (String)"WebAppSecurity", (String)"com.ibm.ws.webcontainer.security.resources.WebAppSecurityMessages");
    static final long serialVersionUID = 2551091212489034618L;

    public AuthenticationFailoverEvent() {
        this.set("eventName", "SECURITY_AUTHN_FAILOVER");
        this.setInitiator((Map)AuditEvent.STD_INITIATOR.clone());
        this.setObserver((Map)AuditEvent.STD_OBSERVER.clone());
        this.setTarget((Map)AuditEvent.STD_TARGET.clone());
    }

    /*
     * WARNING - void declaration
     */
    public AuthenticationFailoverEvent(WebRequest webreq, AuthenticationResult authResult, HashMap extraAuditData, Integer statusCode) {
        block26: {
            this();
            try {
                String agent;
                HttpServletRequest req = webreq.getHttpServletRequest();
                if (req != null && req.getRemoteAddr() != null) {
                    this.set("initiator.host.address", req.getRemoteAddr());
                }
                if ((agent = req.getHeader("User-Agent")) != null) {
                    this.set("initiator.host.agent", agent);
                }
                this.set("target.name", URLDecoder.decode(req.getRequestURI(), "UTF-8"));
                this.set("target.appname", AuditUtils.getJ2EEComponentName());
                if (req.getQueryString() != null) {
                    String str = URLDecoder.decode(req.getQueryString(), "UTF-8");
                    str = AuditUtils.hidePassword(str);
                    this.set("target.params", str);
                }
                if (extraAuditData.get("originalAuthType") != null) {
                    this.set("target.authtype.original", extraAuditData.get("originalAuthType"));
                }
                if (extraAuditData.get("failoverAuthType") != null) {
                    this.set("target.authtype.failover", extraAuditData.get("failoverAuthType"));
                }
                this.set("target.host.address", req.getLocalAddr() + ":" + req.getLocalPort());
                this.set("target.credential.type", authResult.getAuditCredType());
                if (authResult.getAuditCredValue() != null) {
                    this.set("target.credential.token", authResult.getAuditCredValue());
                } else if (req.getUserPrincipal() != null && req.getUserPrincipal().getName() != null) {
                    this.set("target.credential.token", req.getUserPrincipal().getName());
                }
                String sessionID = AuditUtils.getSessionID(req);
                if (sessionID != null) {
                    this.set("target.session", sessionID);
                }
                this.set("target.realm", AuditUtils.getRealmName());
                this.set("target.method", AuditUtils.getRequestMethod(req));
                String arOutcome = authResult.getAuditOutcome();
                switch (authResult.getStatus()) {
                    case SUCCESS: {
                        this.setOutcome(arOutcome != null ? arOutcome : "success");
                        if (statusCode != null) {
                            this.set("reason.reasonCode", statusCode);
                            this.set("reason.reasonType", AuditUtils.getRequestScheme(req));
                        }
                        break;
                    }
                    case FAILURE: {
                        this.setOutcome(arOutcome != null ? arOutcome : "failure");
                        if (statusCode != null) {
                            this.set("reason.reasonCode", statusCode);
                            this.set("reason.reasonType", AuditUtils.getRequestScheme(req));
                        }
                        break;
                    }
                    case SEND_401: {
                        this.setOutcome(arOutcome != null ? arOutcome : "challenge");
                        if (statusCode != null) {
                            this.set("reason.reasonCode", statusCode);
                            this.set("reason.reasonType", AuditUtils.getRequestScheme(req));
                        }
                        break;
                    }
                    case REDIRECT: {
                        this.setOutcome(arOutcome != null ? arOutcome : "redirect");
                        if (statusCode != null) {
                            this.set("reason.reasonCode", statusCode);
                            this.set("reason.reasonType", AuditUtils.getRequestScheme(req));
                        }
                        break;
                    }
                    case TAI_CHALLENGE: {
                        this.setOutcome(arOutcome != null ? arOutcome : "tai_challenge");
                        if (statusCode != null) {
                            this.set("reason.reasonCode", statusCode);
                            this.set("reason.reasonType", AuditUtils.getRequestScheme(req));
                        }
                        break;
                    }
                    case REDIRECT_TO_PROVIDER: {
                        this.setOutcome(arOutcome != null ? arOutcome : "redirect_to_provider");
                        if (statusCode != null) {
                            this.set("reason.reasonCode", statusCode);
                            this.set("reason.reasonType", AuditUtils.getRequestScheme(req));
                        }
                        break;
                    }
                    default: {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Unknown AuthenticationResult: " + authResult.getStatus()), (Object[])new Object[0]);
                        }
                        break;
                    }
                }
            }
            catch (Exception req) {
                void e;
                FFDCFilter.processException((Throwable)req, (String)"com.ibm.ws.security.audit.event.AuthenticationFailoverEvent", (String)"140", (Object)((Object)this), (Object[])new Object[]{webreq, authResult, extraAuditData, statusCode});
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block26;
                Tr.debug((TraceComponent)tc, (String)"Internal error creating AuthenticationEvent", (Object[])new Object[]{e});
            }
        }
    }
}

