/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore.cache.links;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.msgstore.AbstractItem;
import com.ibm.ws.sib.msgstore.Filter;
import com.ibm.ws.sib.msgstore.ItemStream;
import com.ibm.ws.sib.msgstore.MessageStore;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.msgstore.MismatchedMessageStoreException;
import com.ibm.ws.sib.msgstore.NonLockingCursor;
import com.ibm.ws.sib.msgstore.OutOfCacheSpace;
import com.ibm.ws.sib.msgstore.PersistenceException;
import com.ibm.ws.sib.msgstore.ReferenceStream;
import com.ibm.ws.sib.msgstore.SevereMessageStoreException;
import com.ibm.ws.sib.msgstore.cache.links.AbstractItemLink;
import com.ibm.ws.sib.msgstore.cache.links.ItemStreamLink;
import com.ibm.ws.sib.msgstore.cache.links.LinkOwner;
import com.ibm.ws.sib.msgstore.cache.statemodel.ListStatistics;
import com.ibm.ws.sib.msgstore.impl.MessageStoreImpl;
import com.ibm.ws.sib.msgstore.list.LinkedList;
import com.ibm.ws.sib.msgstore.list.UnprioritizedNonlockingCursor;
import com.ibm.ws.sib.msgstore.persistence.Persistable;
import com.ibm.ws.sib.msgstore.persistence.PersistentMessageStore;
import com.ibm.ws.sib.msgstore.persistence.TupleTypeEnum;
import com.ibm.ws.sib.msgstore.transactions.Transaction;
import com.ibm.ws.sib.msgstore.transactions.impl.PersistentTransaction;
import com.ibm.ws.sib.utils.ras.FormattedWriter;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public final class RootMembership
extends LinkOwner {
    public static final long MEMBER_KEY = -2L;
    public static final long MEMBERSHIP_KEY = -3L;
    private static TraceComponent tc = SibTr.register(RootMembership.class, (String)"SIBMessageStore", (String)"com.ibm.ws.sib.msgstore.CWSISMessages");
    private LinkedList _itemStreams;
    private final MessageStoreImpl _messageStore;
    private long _nextItemStreamSequenceToIssue = 0L;
    private final ListStatistics _statistics;

    public RootMembership(MessageStoreImpl messageStore, Persistable persistable) throws OutOfCacheSpace, SevereMessageStoreException {
        super(persistable, true);
        this._messageStore = messageStore;
        this._statistics = new ListStatistics(this);
        this._restoreStateAvailable(this, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _buildStreamTree(HashMap tupleMap) throws SevereMessageStoreException {
        this._itemStreams = new LinkedList();
        ArrayList children = (ArrayList)tupleMap.remove(this.getID());
        for (int i = 0; null != children && i < children.size(); ++i) {
            Persistable tuple = (Persistable)children.get(i);
            tuple.setContainingStream(this.getTuple());
            ItemStreamLink childLink = null;
            if (!tuple.getTupleType().equals(TupleTypeEnum.ITEM_STREAM)) {
                throw new SevereMessageStoreException("Wrong tuple type in ItemStream:" + tuple.getTupleType());
            }
            childLink = new ItemStreamLink(this, tuple);
            if (null != childLink) {
                childLink.restoreState(tuple);
                if (childLink.isInStore()) {
                    this._messageStore.register(childLink);
                }
                childLink._initializeChildren(tupleMap);
            }
            long seq = tuple.getSequence();
            RootMembership rootMembership = this;
            synchronized (rootMembership) {
                if (seq >= this._nextItemStreamSequenceToIssue) {
                    this._nextItemStreamSequenceToIssue = seq + 1L;
                }
                continue;
            }
        }
    }

    private final HashMap _buildTupleMap(PersistentMessageStore pm) throws PersistenceException {
        HashMap<Long, ArrayList<Persistable>> tupleMap = new HashMap<Long, ArrayList<Persistable>>();
        List list = pm.readAllStreams();
        for (Persistable tuple : list) {
            long parent = tuple.getContainingStreamId();
            Long key = parent;
            ArrayList<Persistable> siblings = (ArrayList<Persistable>)tupleMap.get(key);
            if (null == siblings) {
                siblings = new ArrayList<Persistable>();
                tupleMap.put(key, siblings);
            }
            siblings.add(tuple);
        }
        return tupleMap;
    }

    private void _recoverStreamsWithInDoubts(PersistentMessageStore pm) throws PersistenceException, SevereMessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"_recoverStreamsWithInDoubts");
        }
        for (Long id : pm.identifyStreamsWithIndoubtItems()) {
            LinkOwner link = (LinkOwner)this._messageStore.getLink(id);
            if (null != link) {
                link.loadOwnedLinks();
                continue;
            }
            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
            SibTr.debug((Object)this, (TraceComponent)tc, (String)"no item?");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"_recoverStreamsWithInDoubts");
        }
    }

    public final void addItemStream(ItemStream itemStream, long lockID, Transaction transaction) throws MessageStoreException {
        MessageStore tranStore;
        MessageStoreImpl messageStore = this.getMessageStoreImpl();
        if (messageStore != (tranStore = ((PersistentTransaction)transaction).getOwningMessageStore())) {
            MismatchedMessageStoreException mmse = new MismatchedMessageStoreException("Transaction supplied on add does not originate from this MessageStore! MS: " + (Object)((Object)messageStore) + ", Tran.MS: " + tranStore);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.event((Object)this, (TraceComponent)tc, (String)("Transaction supplied on add does not originate from this MessageStore! MS: " + (Object)((Object)messageStore) + ", Tran.MS: " + tranStore), (Object)mmse);
            }
            throw mmse;
        }
        int strategy = itemStream.getStorageStrategy();
        long itemID = messageStore.getUniqueValue(strategy);
        TupleTypeEnum type = TupleTypeEnum.ITEM_STREAM;
        Persistable childPersistable = this.getTuple().createPersistable(itemID, type);
        childPersistable.setStorageStrategy(strategy);
        ItemStreamLink link = new ItemStreamLink(itemStream, (LinkOwner)this, childPersistable);
        link.setParentWasSpillingAtAddTime(this.getListStatistics().isSpilling());
        messageStore.registerLink(link, (AbstractItem)itemStream);
        link.cmdAdd(this, lockID, (PersistentTransaction)transaction);
    }

    @Override
    public final void append(AbstractItemLink link) throws SevereMessageStoreException {
        if (!link.isItemStreamLink()) {
            throw new SevereMessageStoreException("Cannot add this directly to message store");
        }
        this._itemStreams.append(link);
    }

    @Override
    public final SevereMessageStoreException assertCanDelete(PersistentTransaction transaction) {
        return new SevereMessageStoreException("cannot delete root");
    }

    @Override
    public final void checkSpillLimits() {
    }

    @Override
    public final void eventWatermarkBreached() {
    }

    public final boolean expirableExpire() {
        return false;
    }

    public final ItemStream findFirstMatchingItemStream(Filter filter) throws MessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"findFirstMatchingItemStream", (Object)filter);
        }
        ItemStream item = (ItemStream)this._itemStreams.findFirstMatching(filter);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"findFirstMatchingItemStream", (Object)item);
        }
        return item;
    }

    final ItemStream getItemStream() {
        return null;
    }

    @Override
    public final ListStatistics getListStatistics() {
        return this._statistics;
    }

    public final long getMembershipKey() {
        return -3L;
    }

    @Override
    public final MessageStoreImpl getMessageStoreImpl() {
        return this._messageStore;
    }

    @Override
    public ListStatistics getParentStatistics() {
        return this._statistics;
    }

    final ReferenceStream getReferenceStream() {
        return null;
    }

    public final TupleTypeEnum getTupleType() {
        return TupleTypeEnum.ROOT;
    }

    public final void initialize() throws PersistenceException, SevereMessageStoreException {
        PersistentMessageStore pm = this._messageStore.getPersistentMessageStore();
        HashMap tupleMap = this._buildTupleMap(pm);
        this._buildStreamTree(tupleMap);
        this._recoverStreamsWithInDoubts(pm);
    }

    @Override
    public final void linkAvailable(AbstractItemLink link) {
    }

    @Override
    public final boolean loadOwnedLinks() {
        return false;
    }

    public final NonLockingCursor newNonLockingItemStreamCursor(Filter filter) {
        return new UnprioritizedNonlockingCursor(this._itemStreams, filter);
    }

    @Override
    public synchronized long nextSequence() {
        return this._nextItemStreamSequenceToIssue++;
    }

    public final ItemStream removeFirstMatchingItemStream(Filter filter, PersistentTransaction transaction) throws MessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"removeFirstMatchingItemStream");
        }
        ItemStream item = (ItemStream)this._itemStreams.removeFirstMatching(filter, transaction);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"removeFirstMatchingItemStream", (Object)item);
        }
        return item;
    }

    @Override
    protected final String xmlTagName() {
        return "root";
    }

    @Override
    protected final void xmlWriteChildrenOn(FormattedWriter writer) throws IOException {
        super.xmlWriteChildrenOn(writer);
        this.xmlWriteItemStreamsOn(writer);
    }

    public final void xmlWriteItemStreamsOn(FormattedWriter writer) throws IOException {
        if (null != this._itemStreams) {
            this._itemStreams.xmlWriteOn(writer, "itemStreams");
        }
    }
}

