/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.logging.hpel.reader;

import com.ibm.websphere.logging.hpel.reader.HpelPlainFormatter;
import com.ibm.websphere.logging.hpel.reader.RepositoryLogRecord;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class HpelAdvancedFormatter
extends HpelPlainFormatter {
    private static final String svAdvancedPadding = "          ";
    private String svLineSeparatorPlusAdvancedPadding;
    private static final ArrayList<ExtensionMapping> COMPATIBLE_EXTENSIONS = new ArrayList();
    private static final int ORG_INDEX = 1;
    private static final int PRODUCT_INDEX = 2;
    private static final int COMPONENT_INDEX = 3;
    private static final int THREAD_INDEX = 4;
    private static final Set<String> PRIVATE_EXTENSIONS = new HashSet<String>();

    public HpelAdvancedFormatter() {
        this.svLineSeparatorPlusAdvancedPadding = this.lineSeparator + svAdvancedPadding;
    }

    @Override
    public String formatRecord(RepositoryLogRecord record, Locale locale) {
        if (null == record) {
            throw new IllegalArgumentException("Record cannot be null");
        }
        StringBuilder sb = new StringBuilder(300);
        String lineSeparatorPlusPadding = "";
        this.createEventHeader(record, sb);
        sb.append(this.lineSeparator);
        sb.append(svAdvancedPadding);
        lineSeparatorPlusPadding = this.svLineSeparatorPlusAdvancedPadding;
        sb.append(this.formatMessage(record, locale));
        if (record.getStackTrace() != null) {
            sb.append(lineSeparatorPlusPadding);
            sb.append(record.getStackTrace());
        }
        return sb.toString();
    }

    @Override
    public String getFooter() {
        return "";
    }

    protected void createEventHeader(RepositoryLogRecord record, StringBuilder buffer) {
        if (null == record) {
            throw new IllegalArgumentException("Record cannot be null");
        }
        if (null == buffer) {
            throw new IllegalArgumentException("Buffer cannot be null");
        }
        this.createEventTimeStamp(record, buffer);
        HpelAdvancedFormatter.formatThreadID(record, buffer);
        buffer.append(HpelAdvancedFormatter.mapLevelToType(record));
        ExtensionMapping map = COMPATIBLE_EXTENSIONS.get(0);
        buffer.append(map.newKey).append("=");
        String value = map.getExtension(record);
        if (value != null) {
            buffer.append(value);
        }
        buffer.append(" source=");
        buffer.append(record.getLoggerName());
        if (record.getSourceClassName() != null && record.getSourceClassName() != "") {
            buffer.append(" class=");
            buffer.append(record.getSourceClassName());
        }
        if (record.getSourceMethodName() != null && record.getSourceMethodName() != "") {
            buffer.append(" method=");
            buffer.append(record.getSourceMethodName());
        }
        for (int i = 1; i < COMPATIBLE_EXTENSIONS.size(); ++i) {
            map = COMPATIBLE_EXTENSIONS.get(i);
            value = map.getExtension(record);
            if (value == null && i != 1 && i != 2 && i != 3) continue;
            buffer.append(" ").append(map.newKey).append("=");
            if (4 == i) {
                buffer.append("[");
            }
            buffer.append(value);
            if (4 != i) continue;
            buffer.append("]");
        }
        Map<String, String> extensions = record.getExtensions();
        if (extensions != null) {
            for (Map.Entry<String, String> extension : record.getExtensions().entrySet()) {
                if (PRIVATE_EXTENSIONS.contains(extension.getKey())) continue;
                buffer.append(" ").append(extension.getKey()).append("=[").append(extension.getValue()).append("]");
            }
        }
    }

    @Override
    protected String appendUnusedParms(String message, Object[] args) {
        String returnValue = message;
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < args.length; ++i) {
            buffer.append(" parm");
            buffer.append(i);
            buffer.append("=");
            if (args[i] == null) {
                buffer.append("null");
                continue;
            }
            buffer.append(args[i].toString());
        }
        returnValue = returnValue.concat(buffer.toString());
        return returnValue;
    }

    @Override
    public void setLineSeparator(String lineSeparator) {
        super.setLineSeparator(lineSeparator);
        this.svLineSeparatorPlusAdvancedPadding = lineSeparator + svAdvancedPadding;
    }

    static {
        String EDE_CORRELATIONID_NAME = "correlationId";
        String EDE_ORGANIZATION_NAME = "organization";
        String EDE_VERSION_NAME = "version";
        String EDE_LOCALIZABLE_NAME = "localizable";
        String EDE_RAWDATA_NAME = "rawData";
        String EDE_COMPONENT_NAME = "component";
        String EDE_PROCESSID_NAME = "processId";
        String EDE_PROCESSNAME_NAME = "processName";
        String EDE_PRODUCT_NAME = "product";
        String EDE_FLATSTACKTRACE_NAME = "flatStackTrace";
        String EDE_ADDRESSSPACEID_NAME = "addressSpaceId";
        String EDE_JOBNAME_NAME = "jobName";
        String EDE_SERVER_NAME = "serverName";
        String EDE_SYSTEMJOBID_NAME = "jobId";
        String EDE_SYSTEMNAME_NAME = "systemName";
        String EDE_TCBADDRESS_NAME = "tcbAddress";
        String EDE_TID_NAME = "pthreadId";
        String EDE_CORRELATOR_NAME = "ORBRequestId";
        for (String[] stringArray : new String[][]{{"UOW", "correlationId"}, {"org", "organization"}, {"prod", "product"}, {"component", "component"}, {"thread", "pthreadId"}}) {
            COMPATIBLE_EXTENSIONS.add(new ExtensionMapping(stringArray[0], stringArray[1]));
            PRIVATE_EXTENSIONS.add(stringArray[0]);
            PRIVATE_EXTENSIONS.add(stringArray[1]);
        }
        for (String[] stringArray : new String[]{"version", "localizable", "rawData", "processId", "processName", "flatStackTrace", "addressSpaceId", "jobName", "serverName", "jobId", "systemName", "tcbAddress", "ORBRequestId"}) {
            PRIVATE_EXTENSIONS.add((String)stringArray);
        }
    }

    private static final class ExtensionMapping {
        final String newKey;
        final String oldKey;

        ExtensionMapping(String newKey, String oldKey) {
            this.newKey = newKey;
            this.oldKey = oldKey;
        }

        String getExtension(RepositoryLogRecord record) {
            String result = record.getExtension(this.newKey);
            if (result == null) {
                result = record.getExtension(this.oldKey);
            }
            return result;
        }
    }
}

