/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.anno.targets.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.anno.service.internal.AnnotationServiceImpl_Logging;
import com.ibm.ws.anno.targets.internal.AnnotationTargetsImpl_Targets;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.anno.classsource.ClassSource_Aggregate;
import com.ibm.wsspi.anno.targets.AnnotationTargets_Targets;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.List;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.Index;
import org.jboss.jandex.MethodInfo;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class AnnotationTargetsImpl_JandexConverter {
    public static final TraceComponent tc = Tr.register(AnnotationTargetsImpl_JandexConverter.class, (String)"com.ibm.ws.anno", (String)"com.ibm.ws.anno.resources.internal.AnnoMessages");
    public static final String PACKAGE_INFO_CLASS_NAME = "package-info";
    protected final String hashText;
    protected final AnnotationTargetsImpl_Targets annotationTargets;
    static final long serialVersionUID = -3170324263873137875L;

    public static boolean isPackageName(String name) {
        return name.endsWith(PACKAGE_INFO_CLASS_NAME);
    }

    public static String stripPackageNameFromClassName(String className) {
        return className.substring(0, className.length() - (PACKAGE_INFO_CLASS_NAME.length() + 1));
    }

    public AnnotationTargetsImpl_JandexConverter(AnnotationTargetsImpl_Targets annotationTargets) {
        this.annotationTargets = annotationTargets;
        this.hashText = AnnotationServiceImpl_Logging.getBaseHash(this);
    }

    public AnnotationTargetsImpl_Targets getAnnotationTargets() {
        return this.annotationTargets;
    }

    protected String internClassName(String className) {
        return this.getAnnotationTargets().internClassName(className, true);
    }

    protected String internClassName(DotName name) {
        return this.internClassName(name.toString());
    }

    protected String[] internClassNames(List<DotName> dotNames) {
        int numNames = dotNames.size();
        String[] i_names = new String[numNames];
        for (int nameNo = 0; nameNo < numNames; ++nameNo) {
            i_names[nameNo] = this.internClassName(dotNames.get(nameNo));
        }
        return i_names;
    }

    protected boolean i_recordScannedClassName(ClassSource_Aggregate.ScanPolicy scanPolicy, String i_classSourceName, String i_className) {
        return this.annotationTargets.i_placeClass(i_classSourceName, i_className) && this.annotationTargets.i_addScannedClassName(i_className, scanPolicy);
    }

    protected void i_recordSuperclassName(String i_className, String i_superclassName) {
        this.annotationTargets.i_setSuperclassName(i_className, i_superclassName);
    }

    protected void i_recordInterfaceNames(String i_className, String[] i_interfaceNames) {
        this.annotationTargets.i_setInterfaceNames(i_className, i_interfaceNames);
    }

    protected void i_recordReferencedClassName(String i_className) {
        this.annotationTargets.i_addReferencedClassName(i_className);
    }

    protected void i_removeReferencedClassName(String i_className) {
        this.annotationTargets.i_removeReferencedClassName(i_className);
    }

    protected void jandex_recordAnnotation(ClassSource_Aggregate.ScanPolicy scanPolicy, AnnotationTargets_Targets.AnnotationCategory annotationCategory, String i_className, DotName annotationClassDotName) {
        this.annotationTargets.i_recordAnnotation(scanPolicy, annotationCategory, i_className, this.internClassName(annotationClassDotName));
    }

    public void convertIndex(String i_classSourceName, Index index, ClassSource_Aggregate.ScanPolicy scanPolicy) {
        Collection knownClasses = index.getKnownClasses();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ] Classes [ {1} ]", this.hashText, Integer.toString(knownClasses.size())), (Object[])new Object[0]);
        }
        for (ClassInfo jandexClassInfo : knownClasses) {
            this.convertClassInfo(i_classSourceName, jandexClassInfo, scanPolicy);
        }
    }

    public void convertClassInfo(String i_classSourceName, ClassInfo jandexClassInfo, ClassSource_Aggregate.ScanPolicy scanPolicy) {
        List interfaceDotNames;
        String i_className;
        String methodName = "convertClassInfo";
        DotName classDotName = jandexClassInfo.name();
        String className = classDotName.toString();
        if (AnnotationTargetsImpl_JandexConverter.isPackageName(className)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ] Package load [ {1} ]", this.hashText, className), (Object[])new Object[0]);
            }
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ] Class load [ {1} ]", this.hashText, className), (Object[])new Object[0]);
        }
        if (!this.i_recordScannedClassName(scanPolicy, i_classSourceName, i_className = this.internClassName(className))) {
            System.out.println(methodName + " WARNING: Duplicate class [ " + i_className + " ]");
            return;
        }
        this.i_removeReferencedClassName(i_className);
        DotName superClassDotName = jandexClassInfo.superName();
        if (superClassDotName != null) {
            String superClassName = superClassDotName.toString();
            String i_superclassName = this.internClassName(superClassName);
            this.i_recordSuperclassName(i_className, i_superclassName);
            this.i_recordReferencedClassName(i_superclassName);
        }
        if ((interfaceDotNames = jandexClassInfo.interfaceNames()) != null && interfaceDotNames.size() > 0) {
            String[] i_interfaceNames = this.internClassNames(interfaceDotNames);
            this.i_recordInterfaceNames(i_className, i_interfaceNames);
            for (String i_interfaceName : i_interfaceNames) {
                this.i_recordReferencedClassName(i_interfaceName);
            }
        }
        if (scanPolicy == ClassSource_Aggregate.ScanPolicy.EXTERNAL) {
            return;
        }
        for (AnnotationInstance jandexClassAnnotation : jandexClassInfo.classAnnotations()) {
            this.jandex_recordAnnotation(scanPolicy, AnnotationTargets_Targets.AnnotationCategory.CLASS, i_className, jandexClassAnnotation.name());
        }
        for (FieldInfo jandexFieldInfo : jandexClassInfo.fields()) {
            for (AnnotationInstance jandexFieldAnnotation : jandexFieldInfo.annotations()) {
                this.jandex_recordAnnotation(scanPolicy, AnnotationTargets_Targets.AnnotationCategory.FIELD, i_className, jandexFieldAnnotation.name());
            }
        }
        for (MethodInfo jandexMethodInfo : jandexClassInfo.methods()) {
            for (AnnotationInstance jandexMethodAnnotation : jandexMethodInfo.annotations()) {
                this.jandex_recordAnnotation(scanPolicy, AnnotationTargets_Targets.AnnotationCategory.METHOD, i_className, jandexMethodAnnotation.name());
            }
        }
    }
}

