/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.reactive.messaging;

import io.smallrye.common.annotation.Experimental;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Logger;
import org.eclipse.microprofile.reactive.messaging.Metadata;

public interface Message<T> {
    public static final Logger LOGGER = Logger.getLogger(Message.class.getName());
    public static final Function<Metadata, CompletionStage<Void>> EMPTY_ACK = m -> CompletableFuture.completedFuture(null);
    public static final BiFunction<Throwable, Metadata, CompletionStage<Void>> EMPTY_NACK = (t, m) -> CompletableFuture.completedFuture(null);

    private static Function<Metadata, CompletionStage<Void>> validateAck(Function<Metadata, CompletionStage<Void>> ackM) {
        return ackM != null ? ackM : EMPTY_ACK;
    }

    private static Function<Metadata, CompletionStage<Void>> validateAck(Supplier<CompletionStage<Void>> ack) {
        return ack != null ? m -> (CompletionStage)ack.get() : EMPTY_ACK;
    }

    private static BiFunction<Throwable, Metadata, CompletionStage<Void>> validateNack(BiFunction<Throwable, Metadata, CompletionStage<Void>> nackM) {
        return nackM != null ? nackM : EMPTY_NACK;
    }

    private static BiFunction<Throwable, Metadata, CompletionStage<Void>> validateNack(Function<Throwable, CompletionStage<Void>> nack) {
        return nack != null ? (t, m) -> (CompletionStage)nack.apply((Throwable)t) : EMPTY_NACK;
    }

    private static Function<Metadata, CompletionStage<Void>> wrapAck(Message<?> message) {
        Function<Metadata, CompletionStage<Void>> ackM = message.getAckWithMetadata();
        return ackM != null ? ackM : Message.validateAck(message.getAck());
    }

    private static BiFunction<Throwable, Metadata, CompletionStage<Void>> wrapNack(Message<?> message) {
        BiFunction<Throwable, Metadata, CompletionStage<Void>> nackM = message.getNackWithMetadata();
        return nackM != null ? nackM : Message.validateNack(message.getNack());
    }

    private static <T> Message<T> newMessage(final T payload, final Metadata metadata) {
        return new Message<T>(){

            @Override
            public T getPayload() {
                return payload;
            }

            @Override
            public Metadata getMetadata() {
                return metadata;
            }
        };
    }

    private static <T> Message<T> newMessage(final T payload, final Function<Metadata, CompletionStage<Void>> actualAck) {
        return new Message<T>(){

            @Override
            public T getPayload() {
                return payload;
            }

            @Override
            public Function<Metadata, CompletionStage<Void>> getAckWithMetadata() {
                return actualAck;
            }
        };
    }

    private static <T> Message<T> newMessage(final T payload, final Metadata metadata, final Function<Metadata, CompletionStage<Void>> actualAck) {
        return new Message<T>(){

            @Override
            public T getPayload() {
                return payload;
            }

            @Override
            public Metadata getMetadata() {
                return metadata;
            }

            @Override
            public Function<Metadata, CompletionStage<Void>> getAckWithMetadata() {
                return actualAck;
            }
        };
    }

    private static <T> Message<T> newMessage(final T payload, final Function<Metadata, CompletionStage<Void>> actualAck, final BiFunction<Throwable, Metadata, CompletionStage<Void>> actualNack) {
        return new Message<T>(){

            @Override
            public T getPayload() {
                return payload;
            }

            @Override
            public Function<Metadata, CompletionStage<Void>> getAckWithMetadata() {
                return actualAck;
            }

            @Override
            public BiFunction<Throwable, Metadata, CompletionStage<Void>> getNackWithMetadata() {
                return actualNack;
            }
        };
    }

    private static <T> Message<T> newMessage(final T payload, final Metadata metadata, final Function<Metadata, CompletionStage<Void>> actualAck, final BiFunction<Throwable, Metadata, CompletionStage<Void>> actualNack) {
        return new Message<T>(){

            @Override
            public T getPayload() {
                return payload;
            }

            @Override
            public Metadata getMetadata() {
                return metadata;
            }

            @Override
            public Function<Metadata, CompletionStage<Void>> getAckWithMetadata() {
                return actualAck;
            }

            @Override
            public BiFunction<Throwable, Metadata, CompletionStage<Void>> getNackWithMetadata() {
                return actualNack;
            }
        };
    }

    public static <T> Message<T> of(T payload) {
        return () -> payload;
    }

    public static <T> Message<T> of(T payload, Metadata metadata) {
        return Message.newMessage(payload, metadata == null ? Metadata.empty() : metadata);
    }

    public static <T> Message<T> of(T payload, Iterable<Object> metadata) {
        return Message.newMessage(payload, Metadata.from(metadata));
    }

    public static <T> Message<T> of(T payload, Supplier<CompletionStage<Void>> ack) {
        return Message.newMessage(payload, Message.validateAck(ack));
    }

    public static <T> Message<T> of(T payload, Function<Metadata, CompletionStage<Void>> ackM) {
        return Message.newMessage(payload, Message.validateAck(ackM));
    }

    public static <T> Message<T> of(T payload, Metadata metadata, Supplier<CompletionStage<Void>> ack) {
        return Message.newMessage(payload, metadata == null ? Metadata.empty() : metadata, Message.validateAck(ack));
    }

    public static <T> Message<T> of(T payload, Iterable<Object> metadata, Supplier<CompletionStage<Void>> ack) {
        return Message.newMessage(payload, Metadata.from(metadata), Message.validateAck(ack));
    }

    public static <T> Message<T> of(T payload, Iterable<Object> metadata, Function<Metadata, CompletionStage<Void>> ackM) {
        return Message.newMessage(payload, Metadata.from(metadata), Message.validateAck(ackM));
    }

    @Experimental(value="nack support is a SmallRye-only feature")
    public static <T> Message<T> of(T payload, Supplier<CompletionStage<Void>> ack, Function<Throwable, CompletionStage<Void>> nack) {
        return Message.newMessage(payload, Message.validateAck(ack), Message.validateNack(nack));
    }

    @Experimental(value="nack support is a SmallRye-only feature")
    public static <T> Message<T> of(T payload, Function<Metadata, CompletionStage<Void>> ack, BiFunction<Throwable, Metadata, CompletionStage<Void>> nack) {
        return Message.newMessage(payload, Message.validateAck(ack), Message.validateNack(nack));
    }

    @Experimental(value="nack support is a SmallRye-only feature")
    public static <T> Message<T> of(T payload, Iterable<Object> metadata, Supplier<CompletionStage<Void>> ack, Function<Throwable, CompletionStage<Void>> nack) {
        return Message.newMessage(payload, Metadata.from(metadata), Message.validateAck(ack), Message.validateNack(nack));
    }

    @Experimental(value="nack support is a SmallRye-only feature")
    public static <T> Message<T> of(T payload, Iterable<Object> metadata, Function<Metadata, CompletionStage<Void>> ackM, BiFunction<Throwable, Metadata, CompletionStage<Void>> nackM) {
        return Message.newMessage(payload, Metadata.from(metadata), Message.validateAck(ackM), Message.validateNack(nackM));
    }

    @Experimental(value="metadata propagation is a SmallRye-specific feature")
    public static <T> Message<T> of(T payload, Metadata metadata, Supplier<CompletionStage<Void>> ack, Function<Throwable, CompletionStage<Void>> nack) {
        return Message.newMessage(payload, metadata == null ? Metadata.empty() : metadata, Message.validateAck(ack), Message.validateNack(nack));
    }

    @Experimental(value="metadata propagation is a SmallRye-specific feature")
    public static <T> Message<T> of(T payload, Metadata metadata, Function<Metadata, CompletionStage<Void>> ackM, BiFunction<Throwable, Metadata, CompletionStage<Void>> nackM) {
        return Message.newMessage(payload, metadata == null ? Metadata.empty() : metadata, Message.validateAck(ackM), Message.validateNack(nackM));
    }

    default public <P> Message<P> withPayload(P payload) {
        return Message.of(payload, Metadata.from(this.getMetadata()), Message.wrapAck(this), Message.wrapNack(this));
    }

    default public Message<T> withMetadata(Iterable<Object> metadata) {
        return Message.of(this.getPayload(), Metadata.from(metadata), Message.wrapAck(this), Message.wrapNack(this));
    }

    default public Message<T> withMetadata(Metadata metadata) {
        return Message.of(this.getPayload(), Metadata.from(metadata), Message.wrapAck(this), Message.wrapNack(this));
    }

    default public Message<T> withAck(Supplier<CompletionStage<Void>> supplier) {
        return Message.of(this.getPayload(), this.getMetadata(), Message.validateAck(supplier), Message.wrapNack(this));
    }

    @Experimental(value="metadata propagation is a SmallRye-specific feature")
    default public Message<T> withAckWithMetadata(Function<Metadata, CompletionStage<Void>> supplier) {
        return Message.of(this.getPayload(), this.getMetadata(), supplier, Message.wrapNack(this));
    }

    @Experimental(value="metadata propagation is a SmallRye-specific feature")
    default public Message<T> withNack(Function<Throwable, CompletionStage<Void>> nack) {
        return Message.of(this.getPayload(), this.getMetadata(), Message.wrapAck(this), Message.validateNack(nack));
    }

    @Experimental(value="metadata propagation is a SmallRye-specific feature")
    default public Message<T> withNackWithMetadata(BiFunction<Throwable, Metadata, CompletionStage<Void>> nack) {
        return Message.of(this.getPayload(), this.getMetadata(), Message.wrapAck(this), nack);
    }

    public T getPayload();

    default public Metadata getMetadata() {
        return Metadata.empty();
    }

    default public <M> Optional<M> getMetadata(Class<? extends M> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("`clazz` must not be `null`");
        }
        for (Object item : this.getMetadata()) {
            if (!clazz.isInstance(item)) continue;
            return Optional.of(item);
        }
        return Optional.empty();
    }

    default public Supplier<CompletionStage<Void>> getAck() {
        return () -> Objects.requireNonNullElse(this.getAckWithMetadata(), EMPTY_ACK).apply(this.getMetadata());
    }

    @Experimental(value="metadata propagation is a SmallRye-specific feature")
    default public Function<Metadata, CompletionStage<Void>> getAckWithMetadata() {
        return null;
    }

    default public Function<Throwable, CompletionStage<Void>> getNack() {
        return reason -> Objects.requireNonNullElse(this.getNackWithMetadata(), EMPTY_NACK).apply((Throwable)reason, this.getMetadata());
    }

    @Experimental(value="metadata propagation is a SmallRye-specific feature")
    default public BiFunction<Throwable, Metadata, CompletionStage<Void>> getNackWithMetadata() {
        return null;
    }

    default public CompletionStage<Void> ack() {
        return this.ack(this.getMetadata());
    }

    @Experimental(value="metadata propagation is a SmallRye-specific feature")
    default public CompletionStage<Void> ack(Metadata metadata) {
        Function<Metadata, CompletionStage<Void>> ackM = this.getAckWithMetadata();
        if (ackM != null) {
            return ackM.apply(metadata);
        }
        Supplier<CompletionStage<Void>> ack = this.getAck();
        if (ack != null) {
            return ack.get();
        }
        return CompletableFuture.completedFuture(null);
    }

    default public CompletionStage<Void> nack(Throwable reason) {
        return this.nack(reason, this.getMetadata());
    }

    @Experimental(value="nack support is a SmallRye-only feature; metadata propagation is a SmallRye-specific feature")
    default public CompletionStage<Void> nack(Throwable reason, Metadata metadata) {
        if (reason == null) {
            throw new IllegalArgumentException("The reason must not be `null`");
        }
        BiFunction<Throwable, Metadata, CompletionStage<Void>> nackM = this.getNackWithMetadata();
        if (nackM != null) {
            return nackM.apply(reason, metadata);
        }
        Function<Throwable, CompletionStage<Void>> nack = this.getNack();
        if (nack == null) {
            LOGGER.warning(String.format("A message has been nacked, but no nack function has been provided. The reason was: %s", reason.getMessage()));
            LOGGER.finer(String.format("The full failure is: %s", reason));
            return CompletableFuture.completedFuture(null);
        }
        return nack.apply(reason);
    }

    default public <C> C unwrap(Class<C> unwrapType) {
        if (unwrapType == null) {
            throw new IllegalArgumentException("The target class must not be `null`");
        }
        try {
            return unwrapType.cast(this);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Cannot unwrap an instance of " + this.getClass().getName() + " to " + unwrapType.getName(), e);
        }
    }

    default public Message<T> addMetadata(Object metadata) {
        return Message.of(this.getPayload(), this.getMetadata().with(metadata), Message.wrapAck(this), Message.wrapNack(this));
    }

    default public <R> Message<R> thenApply(Function<Message<T>, Message<R>> modifier) {
        return modifier.apply(this);
    }
}

