/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.messaging.handler.impl;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.function.Function;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.handler.AbstractMessageHandler;
import org.opensaml.messaging.handler.MessageHandlerException;

public abstract class AbstractMessageChannelSecurity
extends AbstractMessageHandler {
    @Nonnull
    private Function<MessageContext, BaseContext> parentContextLookupStrategy = new Function<MessageContext, BaseContext>(){

        @Override
        @Nullable
        public BaseContext apply(@Nullable MessageContext input) {
            return input;
        }
    };
    @Nullable
    private BaseContext parentContext;

    public void setParentContextLookupStrategy(@Nonnull Function<MessageContext, BaseContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.parentContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Parent context lookup strategy cannot be null");
    }

    protected boolean doPreInvoke(@Nonnull MessageContext messageContext) throws MessageHandlerException {
        if (!super.doPreInvoke(messageContext)) {
            return false;
        }
        this.parentContext = this.parentContextLookupStrategy.apply(messageContext);
        return this.parentContext != null;
    }

    protected BaseContext getParentContext() {
        return this.parentContext;
    }
}

