/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.cdi.producer;

import graphql.schema.GraphQLSchema;
import io.smallrye.graphql.bootstrap.Bootstrap;
import io.smallrye.graphql.cdi.config.GraphQLConfig;
import io.smallrye.graphql.execution.ExecutionService;
import io.smallrye.graphql.execution.SchemaPrinter;
import io.smallrye.graphql.schema.model.Schema;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Produces;
import jakarta.inject.Inject;

@ApplicationScoped
public class GraphQLProducer {
    @Inject
    GraphQLConfig graphQLConfig;
    @Produces
    SchemaPrinter schemaPrinter;
    @Produces
    ExecutionService executionService;
    @Produces
    GraphQLSchema graphQLSchema;
    @Produces
    Schema schema;

    public void setSchema(Schema schema) {
        this.schema = schema;
    }

    public GraphQLSchema initialize(Schema schema) {
        this.schema = schema;
        return this.initialize();
    }

    public GraphQLSchema initialize(Schema schema, GraphQLConfig graphQLConfig) {
        this.schema = schema;
        this.graphQLConfig = graphQLConfig;
        return this.initialize();
    }

    public GraphQLSchema initialize() {
        this.graphQLSchema = Bootstrap.bootstrap(this.schema, this.graphQLConfig);
        this.executionService = new ExecutionService(this.graphQLConfig, this.graphQLSchema, this.schema.getBatchOperations());
        this.schemaPrinter = new SchemaPrinter(this.graphQLConfig);
        return this.graphQLSchema;
    }
}

