/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.io.smallrye.graphql.component;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import jakarta.annotation.Priority;
import jakarta.enterprise.context.Dependent;
import jakarta.interceptor.AroundInvoke;
import jakarta.interceptor.Interceptor;
import jakarta.interceptor.InvocationContext;
import java.lang.reflect.Method;
import org.eclipse.microprofile.graphql.GraphQLApi;

@Trivial
@Dependent
@GraphQLApi
@Interceptor
@Priority(value=0)
@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@TraceOptions
public class TracingInterceptor {
    private static final TraceComponent tc = Tr.register(TracingInterceptor.class, (String)"GraphQL", (String)"com.ibm.ws.io.smallrye.graphql.SmallRyeGraphQL");
    static final long serialVersionUID = -682075320166878648L;

    @AroundInvoke
    @FFDCIgnore(value={Exception.class})
    public Object logInvocation(InvocationContext ctx) throws Exception {
        block4: {
            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block4;
            Method m = ctx.getMethod();
            String fqMethodName = m.getDeclaringClass().getName() + "." + m.getName();
            Tr.debug((TraceComponent)tc, (String)("Invoking: " + fqMethodName), (Object[])ctx.getParameters());
            Object returnObj = null;
            try {
                returnObj = ctx.proceed();
            }
            catch (Exception e) {
                try {
                    Tr.debug((TraceComponent)tc, (String)"Caught exception", (Object[])new Object[]{e});
                    throw e;
                }
                catch (Throwable throwable) {
                    Tr.debug((TraceComponent)tc, (String)("Invoked: " + fqMethodName), (Object[])new Object[]{returnObj});
                    throw throwable;
                }
            }
            Tr.debug((TraceComponent)tc, (String)("Invoked: " + fqMethodName), (Object[])new Object[]{returnObj});
            return returnObj;
        }
        return ctx.proceed();
    }
}

