/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.api.jms.impl;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.SIDestinationAddress;
import com.ibm.websphere.sib.api.jms.ApiJmsConstants;
import com.ibm.websphere.sib.api.jms.JmsFactoryFactory;
import com.ibm.websphere.sib.api.jms.JmsMsgConsumer;
import com.ibm.websphere.sib.api.jms.JmsMsgProducer;
import com.ibm.websphere.sib.api.jms.JmsQueue;
import com.ibm.websphere.sib.api.jms.JmsTopic;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.ws.sib.api.jms.JmsInternalConstants;
import com.ibm.ws.sib.api.jms.JmsInternalsFactory;
import com.ibm.ws.sib.api.jms.JmsSession;
import com.ibm.ws.sib.api.jms.impl.AysncSendDetails;
import com.ibm.ws.sib.api.jms.impl.ConsumerProperties;
import com.ibm.ws.sib.api.jms.impl.JmsBytesMessageImpl;
import com.ibm.ws.sib.api.jms.impl.JmsConnectionImpl;
import com.ibm.ws.sib.api.jms.impl.JmsDestinationImpl;
import com.ibm.ws.sib.api.jms.impl.JmsDurableSubscriberImpl;
import com.ibm.ws.sib.api.jms.impl.JmsErrorUtils;
import com.ibm.ws.sib.api.jms.impl.JmsMapMessageImpl;
import com.ibm.ws.sib.api.jms.impl.JmsMessageImpl;
import com.ibm.ws.sib.api.jms.impl.JmsMsgConsumerImpl;
import com.ibm.ws.sib.api.jms.impl.JmsMsgProducerImpl;
import com.ibm.ws.sib.api.jms.impl.JmsObjectMessageImpl;
import com.ibm.ws.sib.api.jms.impl.JmsQueueBrowserImpl;
import com.ibm.ws.sib.api.jms.impl.JmsStreamMessageImpl;
import com.ibm.ws.sib.api.jms.impl.JmsTemporaryQueueImpl;
import com.ibm.ws.sib.api.jms.impl.JmsTemporaryTopicImpl;
import com.ibm.ws.sib.api.jms.impl.JmsTextMessageImpl;
import com.ibm.ws.sib.api.jms.impl.MessageProxyInvocationHandler;
import com.ibm.ws.sib.api.jmsra.JmsJcaSession;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.Distribution;
import com.ibm.wsspi.sib.core.OrderingContext;
import com.ibm.wsspi.sib.core.SICoreConnection;
import com.ibm.wsspi.sib.core.SITransaction;
import com.ibm.wsspi.sib.core.SIXAResource;
import com.ibm.wsspi.sib.core.exception.SIConnectionDroppedException;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import com.ibm.wsspi.sib.core.exception.SIConnectionUnavailableException;
import com.ibm.wsspi.sib.core.exception.SIDestinationLockedException;
import com.ibm.wsspi.sib.core.exception.SIDurableSubscriptionNotFoundException;
import com.ibm.wsspi.sib.core.exception.SIInvalidDestinationPrefixException;
import com.ibm.wsspi.sib.core.exception.SINotAuthorizedException;
import com.ibm.wsspi.sib.core.exception.SITemporaryDestinationNotFoundException;
import jakarta.jms.BytesMessage;
import jakarta.jms.CompletionListener;
import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.InvalidDestinationException;
import jakarta.jms.InvalidSelectorException;
import jakarta.jms.JMSException;
import jakarta.jms.JMSSecurityException;
import jakarta.jms.MapMessage;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageListener;
import jakarta.jms.MessageProducer;
import jakarta.jms.ObjectMessage;
import jakarta.jms.Queue;
import jakarta.jms.QueueBrowser;
import jakarta.jms.StreamMessage;
import jakarta.jms.TemporaryQueue;
import jakarta.jms.TemporaryTopic;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import jakarta.jms.TopicSubscriber;
import jakarta.jms.TransactionRolledBackException;
import jakarta.resource.spi.IllegalStateException;
import jakarta.resource.spi.LocalTransactionException;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;

public class JmsSessionImpl
implements JmsSession,
ApiJmsConstants,
JmsInternalConstants {
    private static TraceComponent tc = SibTr.register(JmsSessionImpl.class, (String)"SIBJms_External", (String)"com.ibm.websphere.sib.api.jms.CWSIAJMSMessages");
    private final Map passThruProps;
    private final SICoreConnection coreConnection;
    private final JmsConnectionImpl connection;
    private final JmsJcaSession jcaSession;
    private final boolean transacted;
    private final int acknowledgeMode;
    private final boolean isManaged;
    private int uncommittedReceiveCount = 0;
    private final int dupsCommitThreshold;
    private int state = 1;
    private final Object stateLock = new Object();
    private final Object asyncDeliveryLock = new Object();
    private final Object sessionSyncLock = new Object();
    private final List producers;
    private final List syncConsumers;
    private final List asyncConsumers;
    private final Object consumerListsLock = new Object();
    private final List browsers;
    private final byte[] currentMessageID;
    private OrderingContext orderingContext;
    private static final byte[] MSG_ID_PAD_BYTES = new byte[]{17, 10, 19, 79, 33, 32, 74, 77, 83, 0, 0, 0, 0, 0, 0, 0};
    private boolean rolledBackDueToConnectionFailure = false;
    private static final int PROD_CONS_WARNING_THRESHOLD = 100;
    private static final int DEFAULT_DUPS_THRESHOLD = 20;
    private final LinkedBlockingQueue<AysncSendDetails> _asyncSendQueue = new LinkedBlockingQueue();
    private Thread _asyncSendRunThread = null;
    private static final int AsyncSendKillCommand = 7777;
    static final ThreadLocal<JmsSessionImpl> asyncThreadLocal = new ThreadLocal();
    private volatile AysncSendDetails currentAsyncSendObject = null;
    private static final ThreadLocal<JmsSessionImpl> asyncReceiverThreadLocal = new ThreadLocal();

    JmsSessionImpl(boolean transacted, int acknowledgeMode, SICoreConnection coreConnection, JmsConnectionImpl connection, JmsJcaSession jcaSession) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"JmsSessionImpl", (Object)new Object[]{transacted, acknowledgeMode, coreConnection, connection, jcaSession});
        }
        this.transacted = transacted;
        this.acknowledgeMode = acknowledgeMode;
        this.connection = connection;
        this.coreConnection = coreConnection;
        this.jcaSession = jcaSession;
        this.isManaged = connection.isManaged();
        this.passThruProps = connection.getPassThruProps();
        this.dupsCommitThreshold = 20;
        this.producers = Collections.synchronizedList(new ArrayList());
        this.syncConsumers = Collections.synchronizedList(new ArrayList());
        this.asyncConsumers = Collections.synchronizedList(new ArrayList());
        this.browsers = Collections.synchronizedList(new ArrayList());
        if (coreConnection == null) {
            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "JCA_RESOURCE_EXC_CWSIA0005", null, null, "JmsSessionImpl.constructor#2", this, tc);
        }
        try {
            byte[] messageIDStem = coreConnection.createUniqueId();
            int messageIDStemLength = messageIDStem.length;
            this.currentMessageID = new byte[24];
            System.arraycopy(messageIDStem, 0, this.currentMessageID, 0, messageIDStemLength);
            int charsNeeded = 16 - messageIDStemLength;
            if (charsNeeded > 0) {
                System.arraycopy(MSG_ID_PAD_BYTES, 0, this.currentMessageID, messageIDStemLength, charsNeeded);
            }
        }
        catch (SIException sice) {
            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0053", new Object[]{sice, "JmsSessionImpl.<constructor>"}, sice, null, this, tc);
        }
        try {
            this.orderingContext = connection.allocateOrderingContext();
        }
        catch (SIException sice) {
            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0053", new Object[]{sice, "JmsSessionImpl.<constructor>"}, sice, null, this, tc);
        }
        if (connection.getState() == 2) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"start session because connection was started");
            }
            this.start();
        } else {
            this.stop();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"JmsSessionImpl");
        }
    }

    private Message createMessageProxy(Message msgObject) {
        Message retObj;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"createMessageProxy", (Object)msgObject);
        }
        try {
            retObj = (Message)Proxy.newProxyInstance(msgObject.getClass().getClassLoader(), msgObject.getClass().getInterfaces(), (InvocationHandler)new MessageProxyInvocationHandler(msgObject));
        }
        catch (Exception e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Exception caught while trying to createMessageProxy ", (Object)e);
            }
            retObj = msgObject;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"createMessageProxy", (Object)retObj);
        }
        return retObj;
    }

    public BytesMessage createBytesMessage() throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"createBytesMessage");
        }
        this.checkNotClosed();
        JmsBytesMessageImpl bm = new JmsBytesMessageImpl();
        this.setMessageProperties(bm);
        if (!this.isManaged) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"createBytesMessage", (Object)(bm.getClass() + "@" + System.identityHashCode(bm)));
            }
            return (BytesMessage)this.createMessageProxy(bm);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"createBytesMessage", (Object)(bm.getClass() + "@" + System.identityHashCode(bm)));
        }
        return bm;
    }

    public MapMessage createMapMessage() throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"createMapMessage");
        }
        this.checkNotClosed();
        JmsMapMessageImpl msg = new JmsMapMessageImpl();
        if (!this.isManaged) {
            msg = (MapMessage)this.createMessageProxy(msg);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"createMapMessage", (Object)(msg.getClass() + "@" + System.identityHashCode(msg)));
        }
        return msg;
    }

    public Message createMessage() throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"createMessage");
        }
        this.checkNotClosed();
        JmsMessageImpl msg = new JmsMessageImpl();
        if (!this.isManaged) {
            msg = this.createMessageProxy(msg);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"createMessage", (Object)(msg.getClass() + "@" + System.identityHashCode(msg)));
        }
        return msg;
    }

    public ObjectMessage createObjectMessage() throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"createObjectMessage");
        }
        this.checkNotClosed();
        ObjectMessage msg = this.createObjectMessage(null);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"createObjectMessage", (Object)(msg.getClass() + "@" + System.identityHashCode(msg)));
        }
        return msg;
    }

    public ObjectMessage createObjectMessage(Serializable object) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"createObjectMessage", (Object)(object == null ? "null" : object.getClass()));
        }
        this.checkNotClosed();
        JmsObjectMessageImpl om = new JmsObjectMessageImpl(object);
        this.setMessageProperties(om);
        if (!this.isManaged) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"createObjectMessage", (Object)(om.getClass() + "@" + System.identityHashCode(om)));
            }
            return (ObjectMessage)this.createMessageProxy(om);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"createObjectMessage", (Object)(om.getClass() + "@" + System.identityHashCode(om)));
        }
        return om;
    }

    public StreamMessage createStreamMessage() throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"createStreamMessage");
        }
        this.checkNotClosed();
        JmsStreamMessageImpl msg = new JmsStreamMessageImpl();
        if (!this.isManaged) {
            msg = (StreamMessage)this.createMessageProxy(msg);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"createStreamMessage");
        }
        return msg;
    }

    public TextMessage createTextMessage() throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"createTextMessage");
        }
        this.checkNotClosed();
        JmsTextMessageImpl msg = new JmsTextMessageImpl();
        if (!this.isManaged) {
            msg = (TextMessage)this.createMessageProxy(msg);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"createTextMessage", (Object)(msg.getClass() + "@" + System.identityHashCode(msg)));
        }
        return msg;
    }

    public TextMessage createTextMessage(String text) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"createTextMessage", (Object)text);
        }
        this.checkNotClosed();
        JmsTextMessageImpl msg = new JmsTextMessageImpl(text);
        if (!this.isManaged) {
            msg = (TextMessage)this.createMessageProxy(msg);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"createTextMessage", (Object)(msg.getClass() + "@" + System.identityHashCode(msg)));
        }
        return msg;
    }

    public boolean getTransacted() throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getTransacted");
        }
        this.checkNotClosed();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getTransacted", (Object)this.transacted);
        }
        return this.transacted;
    }

    public int getAcknowledgeMode() throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getAcknowledgeMode");
        }
        this.checkNotClosed();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getAcknowledgeMode", (Object)this.acknowledgeMode);
        }
        return this.acknowledgeMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"commit");
        }
        Object object = this.sessionSyncLock;
        synchronized (object) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"got lock");
            }
            this.checkNotClosed();
            this.checkSynchronousUsage("commit");
            if (this.acknowledgeMode != 0) {
                throw (jakarta.jms.IllegalStateException)JmsErrorUtils.newThrowable(jakarta.jms.IllegalStateException.class, "INVALID_OP_FOR_NONTRANS_SESSION_CWSIA0042", new Object[]{"commit"}, tc);
            }
            if (!this.isManaged) {
                this.validateCloseCommitRollback("commit");
                this.waitForAsyncSendCompletion();
            }
            this.commitTransaction();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"commit");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"rollback");
        }
        Object object = this.sessionSyncLock;
        synchronized (object) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"got lock");
            }
            this.checkNotClosed();
            this.checkSynchronousUsage("rollback");
            if (this.acknowledgeMode != 0) {
                throw (jakarta.jms.IllegalStateException)JmsErrorUtils.newThrowable(jakarta.jms.IllegalStateException.class, "INVALID_OP_FOR_NONTRANS_SESSION_CWSIA0042", new Object[]{"rollback"}, tc);
            }
            if (!this.isManaged) {
                this.validateCloseCommitRollback("rollback");
                this.waitForAsyncSendCompletion();
            }
            this.rollbackTransaction();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"rollback");
        }
    }

    public void close() throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"close");
        }
        this.close(false);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"close");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close(boolean tidyUp) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"close", (Object)new Object[]{tidyUp});
        }
        if (!this.isManaged) {
            this.validateCloseCommitRollback("close");
            this.validateStopCloseForMessageListener("close");
        }
        if (this.getState() != 3) {
            int i;
            Object[] cons;
            if (!this.isManaged && null != this._asyncSendRunThread && this._asyncSendRunThread.isAlive()) {
                this.addtoAsysncSendQueue(null, null, null, 7777, null);
                this.waitForAsyncSendCompletion();
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("session " + this + " closing sync consumers."));
            }
            List list = this.syncConsumers;
            synchronized (list) {
                cons = this.syncConsumers.toArray();
                for (i = 0; i < cons.length; ++i) {
                    ((MessageConsumer)cons[i]).close();
                }
                this.syncConsumers.clear();
            }
            this.stop();
            this.setState(3);
            switch (this.acknowledgeMode) {
                case 0: {
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    this.commitTransaction();
                    break;
                }
                case 1: {
                    break;
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"session closing producers.");
            }
            list = this.producers;
            synchronized (list) {
                Object[] prods = this.producers.toArray();
                for (i = 0; i < prods.length; ++i) {
                    ((JmsMsgProducerImpl)prods[i]).close(tidyUp);
                }
                this.producers.clear();
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"session closing async consumers.");
            }
            list = this.asyncConsumers;
            synchronized (list) {
                cons = this.asyncConsumers.toArray();
                for (i = 0; i < cons.length; ++i) {
                    ((MessageConsumer)cons[i]).close();
                }
                this.asyncConsumers.clear();
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"session closing queue browsers.");
            }
            list = this.browsers;
            synchronized (list) {
                Object[] brow = this.browsers.toArray();
                for (i = 0; i < brow.length; ++i) {
                    ((QueueBrowser)brow[i]).close();
                }
                this.browsers.clear();
            }
            try {
                this.jcaSession.close();
            }
            catch (SIException sice) {
                throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0053", new Object[]{sice, "JmsSessionImpl.close"}, sice, "JmsSessionImpl.close#1", this, tc);
            }
            this.connection.removeSession(this);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"close");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recover() throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"recover");
        }
        Object object = this.sessionSyncLock;
        synchronized (object) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"got lock");
            }
            this.checkNotClosed();
            this.checkSynchronousUsage("recover");
            switch (this.acknowledgeMode) {
                case 2: {
                    if (this.uncommittedReceiveCount <= 0) break;
                    this.rollbackTransaction();
                    break;
                }
                case 3: {
                    if (this.uncommittedReceiveCount <= 0) break;
                    this.commitTransaction();
                    break;
                }
                case 0: {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exit((Object)this, (TraceComponent)tc, (String)"recover");
                    }
                    throw (jakarta.jms.IllegalStateException)JmsErrorUtils.newThrowable(jakarta.jms.IllegalStateException.class, "INVALID_OP_FOR_TRANS_SESSION_CWSIA0050", new Object[]{"recover"}, tc);
                }
                case 1: {
                    this.uncommittedReceiveCount = 0;
                    break;
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"recover");
        }
    }

    public MessageListener getMessageListener() throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getMessageListener");
        }
        this.checkNotClosed();
        if (this.isManaged) {
            throw (jakarta.jms.IllegalStateException)JmsErrorUtils.newThrowable(jakarta.jms.IllegalStateException.class, "MGD_ENV_CWSIA0052", new Object[]{"Session.getMessageListener"}, tc);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)"getMessageListener() optional, not implemented");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getMessageListener", null);
        }
        return null;
    }

    public void setMessageListener(MessageListener listener) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setMessageListener", (Object)listener);
        }
        this.checkNotClosed();
        if (this.isManaged) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"setMessageListener", (Object)listener);
            }
            throw (jakarta.jms.IllegalStateException)JmsErrorUtils.newThrowable(jakarta.jms.IllegalStateException.class, "MGD_ENV_CWSIA0052", new Object[]{"Session.setMessageListener"}, tc);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)"setMessageListener(MessageListener) optional, not implemented");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setMessageListener", (Object)listener);
        }
        throw (jakarta.jms.IllegalStateException)JmsErrorUtils.newThrowable(jakarta.jms.IllegalStateException.class, "UNSUPPORTED_OPERATION_CWSIA0045", new Object[]{"Session.setMessageListener"}, tc);
    }

    public void run() {
    }

    public MessageProducer createProducer(Destination destination) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"createProducer", (Object)destination);
        }
        this.checkNotClosed();
        JmsMsgProducer producer = this.instantiateProducer(destination);
        this.producers.add(producer);
        if (this.producers.size() % 100 == 0) {
            String errorLocation = JmsErrorUtils.getFirstApplicationStackString();
            SibTr.warning((TraceComponent)tc, (String)"MANY_PRODUCERS_WARNING_CWSIA0055", (Object)new Object[]{"" + this.producers.size(), errorLocation});
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"createProducer", (Object)producer);
        }
        return producer;
    }

    public MessageConsumer createConsumer(Destination destination) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"createConsumer", (Object)destination);
        }
        this.checkNotClosed();
        MessageConsumer messageConsumer = this.createConsumer(destination, null, false);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"createConsumer", (Object)messageConsumer);
        }
        return messageConsumer;
    }

    public MessageConsumer createConsumer(Destination destination, String messageSelector) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"createConsumer", (Object)new Object[]{destination, messageSelector});
        }
        this.checkNotClosed();
        MessageConsumer messageConsumer = this.createConsumer(destination, messageSelector, false);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"createConsumer", (Object)messageConsumer);
        }
        return messageConsumer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageConsumer createConsumer(Destination destination, String messageSelector, boolean noLocal) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"createConsumer", (Object)new Object[]{destination, null, messageSelector, noLocal});
        }
        try {
            MessageConsumer messageConsumer = this.createConsumer(destination, null, messageSelector, noLocal, false);
            return messageConsumer;
        }
        finally {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"createConsumer");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MessageConsumer createConsumer(Destination destination, String name, String messageSelector, boolean noLocal, boolean isSharedNonDurable) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"createConsumer", (Object)new Object[]{destination, messageSelector, noLocal, isSharedNonDurable});
        }
        JmsMsgConsumer consumer = null;
        this.checkNotClosed();
        if (destination == null) {
            throw (InvalidDestinationException)JmsErrorUtils.newThrowable(InvalidDestinationException.class, "INVALID_VALUE_CWSIA0048", new Object[]{"Destination", "null"}, tc);
        }
        if (isSharedNonDurable && (name == null || "".equals(name))) {
            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "INVALID_VALUE_CWSIA0048", new Object[]{"sharedSubscriptionName", name}, tc);
        }
        JmsDestinationImpl nativeDest = JmsDestinationImpl.checkNativeInstance(destination);
        JmsDestinationImpl.checkBlockedStatus(nativeDest);
        ConsumerProperties newProps = new ConsumerProperties(nativeDest, null, messageSelector, null, false, true, noLocal, name, this.connection.getClientID(), isSharedNonDurable, null);
        Object object = this.stateLock;
        synchronized (object) {
            consumer = this.instantiateConsumer(newProps);
            this.syncConsumers.add(consumer);
            int totalConsumers = this.syncConsumers.size() + this.asyncConsumers.size();
            if (totalConsumers % 100 == 0) {
                String errorLocation = JmsErrorUtils.getFirstApplicationStackString();
                SibTr.warning((TraceComponent)tc, (String)"MANY_CONSUMERS_WARNING_CWSIA0059", (Object)new Object[]{"" + totalConsumers, errorLocation});
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"createConsumer", (Object)consumer);
        }
        return consumer;
    }

    public Queue createQueue(String queueName) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"createQueue", (Object)queueName);
        }
        this.checkNotClosed();
        JmsQueue queue = JmsFactoryFactory.getInstance().createQueue(queueName);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"createQueue", (Object)queue);
        }
        return queue;
    }

    public Topic createTopic(String topicName) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"createTopic", (Object)topicName);
        }
        this.checkNotClosed();
        JmsTopic topic = JmsFactoryFactory.getInstance().createTopic(topicName);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"createTopic", (Object)topic);
        }
        return topic;
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"createDurableSubscriber", (Object)new Object[]{topic, name});
        }
        this.checkNotClosed();
        TopicSubscriber durableSubscriber = this.createDurableSubscriber(topic, name, null, false);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"createDurableSubscriber", (Object)durableSubscriber);
        }
        return durableSubscriber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TopicSubscriber createDurableSubscriber(Topic topic, String name, String messageSelector, boolean noLocal) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"createDurableSubscriber", (Object)new Object[]{topic, name, messageSelector, noLocal});
        }
        try {
            TopicSubscriber topicSubscriber = this.createDurableSubscriber(topic, name, messageSelector, noLocal, false, true);
            return topicSubscriber;
        }
        finally {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"createDurableSubscriber");
            }
        }
    }

    private TopicSubscriber createDurableSubscriber(Topic topic, String name, String messageSelector, boolean noLocal, boolean isSharedDurable, boolean isNonSharedDurable) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"createDurableSubscriber", (Object)new Object[]{topic, name, messageSelector, noLocal, isSharedDurable, isNonSharedDurable});
        }
        this.checkNotClosed();
        if (topic == null) {
            throw (InvalidDestinationException)JmsErrorUtils.newThrowable(InvalidDestinationException.class, "INVALID_VALUE_CWSIA0048", new Object[]{"Topic", "null"}, tc);
        }
        if (name == null || "".equals(name)) {
            throw (InvalidDestinationException)JmsErrorUtils.newThrowable(InvalidDestinationException.class, "INVALID_VALUE_CWSIA0048", new Object[]{"name", name}, tc);
        }
        JmsDestinationImpl nativeDest = JmsDestinationImpl.checkNativeInstance((Destination)topic);
        JmsDestinationImpl.checkBlockedStatus(nativeDest);
        String clientID = this.connection.getClientID();
        if (isNonSharedDurable && (clientID == null || "".equals(clientID))) {
            throw (jakarta.jms.IllegalStateException)JmsErrorUtils.newThrowable(jakarta.jms.IllegalStateException.class, "INVALID_VALUE_CWSIA0048", new Object[]{"clientID", clientID}, tc);
        }
        String durSubHome = (String)this.passThruProps.get("durableSubscriptionHome");
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("DurableSubHome : " + durSubHome));
        }
        if (durSubHome == null || "".equals(durSubHome)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"User Error - No durableSubscriptionHome was specified.");
            }
            throw (jakarta.jms.IllegalStateException)JmsErrorUtils.newThrowable(jakarta.jms.IllegalStateException.class, "DURABLE_SUB_HOME_NOT_SPECIFIED_CWSIA0056", null, tc);
        }
        String sharedSubs = (String)this.passThruProps.get("shareDurableSubscriptions");
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("shareDurableSubs: " + sharedSubs));
        }
        boolean supportsMultiple = false;
        if (sharedSubs == null || "".equals(sharedSubs) || "InCluster".equals(sharedSubs)) {
            boolean isCloned = JmsConnectionImpl.isClonedServer();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("isClonedServer: " + isCloned));
            }
            supportsMultiple = isCloned;
        } else {
            supportsMultiple = "AlwaysShared".equals(sharedSubs);
        }
        if (isSharedDurable) {
            supportsMultiple = true;
        }
        if (isNonSharedDurable) {
            supportsMultiple = false;
        }
        ConsumerProperties newProps = new ConsumerProperties(nativeDest, null, messageSelector, null, false, true, noLocal, name, clientID, supportsMultiple, durSubHome);
        JmsDurableSubscriberImpl durableSubscriber = new JmsDurableSubscriberImpl(this.coreConnection, this, newProps);
        this.syncConsumers.add(durableSubscriber);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"createDurableSubscriber", (Object)durableSubscriber);
        }
        return durableSubscriber;
    }

    public QueueBrowser createBrowser(Queue queue) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"createBrowser", (Object)queue);
        }
        this.checkNotClosed();
        QueueBrowser queueBrowser = this.createBrowser(queue, null);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"createBrowser", (Object)queueBrowser);
        }
        return queueBrowser;
    }

    public QueueBrowser createBrowser(Queue queue, String messageSelector) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"createBrowser", (Object)new Object[]{queue, messageSelector});
        }
        this.checkNotClosed();
        if (queue == null) {
            throw (InvalidDestinationException)JmsErrorUtils.newThrowable(InvalidDestinationException.class, "INVALID_VALUE_CWSIA0048", new Object[]{"Queue", "null"}, tc);
        }
        JmsDestinationImpl jmsDestination = JmsDestinationImpl.checkNativeInstance((Destination)queue);
        JmsDestinationImpl.checkBlockedStatus(jmsDestination);
        JmsQueueBrowserImpl queueBrowser = new JmsQueueBrowserImpl(this, jmsDestination, messageSelector);
        this.browsers.add(queueBrowser);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"createBrowser", (Object)queueBrowser);
        }
        return queueBrowser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TemporaryQueue createTemporaryQueue() throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"createTemporaryQueue");
        }
        JmsTemporaryQueueImpl temporaryQueue = null;
        this.checkNotClosed();
        Object object = this.stateLock;
        synchronized (object) {
            String prefix = (String)this.passThruProps.get("tempQueueNamePrefix");
            SIDestinationAddress temporaryQueueAddr = this.createTemporaryDestination(Distribution.ONE, prefix);
            temporaryQueue = new JmsTemporaryQueueImpl(temporaryQueueAddr, this);
            this.connection.addTemporaryDestination(temporaryQueue);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"createTemporaryQueue", (Object)temporaryQueue);
        }
        return temporaryQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TemporaryTopic createTemporaryTopic() throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"createTemporaryTopic");
        }
        JmsTemporaryTopicImpl temporaryTopic = null;
        this.checkNotClosed();
        Object object = this.stateLock;
        synchronized (object) {
            String prefix = (String)this.passThruProps.get("tempTopicNamePrefix");
            SIDestinationAddress temporaryTopicAddr = this.createTemporaryDestination(Distribution.ALL, prefix);
            temporaryTopic = new JmsTemporaryTopicImpl(temporaryTopicAddr, this);
            this.connection.addTemporaryDestination(temporaryTopic);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"createTemporaryTopic", (Object)temporaryTopic);
        }
        return temporaryTopic;
    }

    public void unsubscribe(String subName) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"unsubscribe", (Object)subName);
        }
        this.checkNotClosed();
        if (subName == null || "".equals(subName)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"unsubscribe", (Object)subName);
            }
            throw (InvalidDestinationException)JmsErrorUtils.newThrowable(InvalidDestinationException.class, "INVALID_VALUE_CWSIA0048", new Object[]{"name", subName}, tc);
        }
        String clientID = this.connection.getClientID();
        String subscriptionName = JmsInternalsFactory.getSharedUtils().getCoreDurableSubName(clientID, subName);
        String durableSubHome = (String)this.passThruProps.get("durableSubscriptionHome");
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("subscriptionName: " + subscriptionName + "  durableSubHome: " + durableSubHome));
        }
        if (durableSubHome == null || "".equals(durableSubHome)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"User Error - No durableSubscriptionHome was specified.");
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"unsubscribe", (Object)subName);
            }
            throw (jakarta.jms.IllegalStateException)JmsErrorUtils.newThrowable(jakarta.jms.IllegalStateException.class, "DURABLE_SUB_HOME_NOT_SPECIFIED_CWSIA0056", null, tc);
        }
        try {
            this.coreConnection.deleteDurableSubscription(subscriptionName, durableSubHome);
        }
        catch (SIConnectionUnavailableException sioce) {
            throw (jakarta.jms.IllegalStateException)JmsErrorUtils.newThrowable(jakarta.jms.IllegalStateException.class, "CONN_CLOSED_CWSIA0041", null, sioce, null, this, tc);
        }
        catch (SIDestinationLockedException sidle) {
            throw (jakarta.jms.IllegalStateException)JmsErrorUtils.newThrowable(jakarta.jms.IllegalStateException.class, "DSUB_LOCKED_CWSIA0043", null, sidle, null, this, tc);
        }
        catch (SIDurableSubscriptionNotFoundException sidnfe) {
            throw (InvalidDestinationException)JmsErrorUtils.newThrowable(InvalidDestinationException.class, "DURABLE_SUB_DOES_NOT_EXIST_CWSIA0054", new Object[]{subscriptionName}, sidnfe, null, this, tc);
        }
        catch (SINotAuthorizedException sinae) {
            throw (JMSSecurityException)JmsErrorUtils.newThrowable(JMSSecurityException.class, "NOT_AUTH_CWSIA0044", null, sinae, null, this, tc);
        }
        catch (SIException sice) {
            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0053", new Object[]{sice, "JmsSessionImpl.unsubscribe (#5)"}, sice, "JmsSessionImpl.unsubscribe#5", this, tc);
        }
        finally {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"unsubscribe", (Object)subName);
            }
        }
    }

    boolean isManaged() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"isManaged");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"isManaged", (Object)this.isManaged);
        }
        return this.isManaged;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getState() {
        int currentState;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getState");
        }
        Object object = this.stateLock;
        synchronized (object) {
            currentState = this.state;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getState", (Object)currentState);
        }
        return currentState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setState(int newState) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setState", (Object)newState);
        }
        int oldState = -1;
        if (newState == 3 || newState == 2 || newState == 1) {
            Object object = this.stateLock;
            synchronized (object) {
                oldState = this.state;
                this.state = newState;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setState", (Object)oldState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkNotClosed() throws JMSException {
        int currentState;
        Object object = this.stateLock;
        synchronized (object) {
            currentState = this.state;
        }
        if (currentState == 3) {
            throw (jakarta.jms.IllegalStateException)JmsErrorUtils.newThrowable(jakarta.jms.IllegalStateException.class, "SESSION_CLOSED_CWSIA0049", null, tc);
        }
    }

    Map getPassThruProps() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getPassThruProps");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getPassThruProps", (Object)this.passThruProps);
        }
        return this.passThruProps;
    }

    Object getAsyncDeliveryLock() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getAsyncDeliveryLock");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getAsyncDeliveryLock", (Object)this.asyncDeliveryLock);
        }
        return this.asyncDeliveryLock;
    }

    Connection getConnection() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getConnection");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getConnection", (Object)this.connection);
        }
        return this.connection;
    }

    SICoreConnection getCoreConnection() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getCoreConnection");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getCoreConnection", (Object)this.coreConnection);
        }
        return this.coreConnection;
    }

    JmsMsgProducer instantiateProducer(Destination jmsDestination) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"instantiateProducer", (Object)jmsDestination);
        }
        JmsMsgProducerImpl messageProducer = new JmsMsgProducerImpl(jmsDestination, this.coreConnection, this);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"instantiateProducer", (Object)messageProducer);
        }
        return messageProducer;
    }

    OrderingContext getOrderingContext() {
        return this.orderingContext;
    }

    JmsMsgConsumer instantiateConsumer(ConsumerProperties consumerProperties) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"instantiateConsumer", (Object)consumerProperties);
        }
        JmsMsgConsumerImpl messageConsumer = new JmsMsgConsumerImpl(this.coreConnection, this, consumerProperties);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"instantiateConsumer", (Object)messageConsumer);
        }
        return messageConsumer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void start() throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"start");
        }
        Object object = this.stateLock;
        synchronized (object) {
            JMSException excReceived = null;
            Object[] syncList = this.syncConsumers.toArray();
            for (int i = 0; i < syncList.length; ++i) {
                try {
                    ((JmsMsgConsumerImpl)syncList[i]).start();
                    continue;
                }
                catch (JMSException e) {
                    if (excReceived != null) continue;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"JMSException received at Session.start. Will continue trying to start the remaining consumers.");
                    }
                    excReceived = e;
                }
            }
            Iterator asyncList = this.asyncConsumers.iterator();
            while (asyncList.hasNext()) {
                try {
                    ((JmsMsgConsumerImpl)asyncList.next()).start();
                }
                catch (JMSException e) {
                    if (excReceived != null) continue;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"JMSException received at Session.start. Will continue trying to start the remaining asynch consumers.");
                    }
                    excReceived = e;
                }
            }
            if (excReceived != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"An exception was received during Session.start. Propogate to Connection.");
                }
                throw excReceived;
            }
            this.setState(2);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"start");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stop() throws JMSException {
        Object[] cons;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"stop");
        }
        if (!this.isManaged) {
            this.validateStopCloseForMessageListener("stop");
        }
        this.setState(1);
        JMSException excReceived = null;
        Object object = this.consumerListsLock;
        synchronized (object) {
            List list = this.syncConsumers;
            synchronized (list) {
                Iterator i = this.syncConsumers.iterator();
                while (i.hasNext()) {
                    try {
                        ((JmsMsgConsumerImpl)i.next()).stop();
                    }
                    catch (JMSException e) {
                        if (excReceived != null) continue;
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)tc, (String)"JMSException received at Session.stop. Will continue trying to stop the remaining consumers.");
                        }
                        excReceived = e;
                    }
                }
            }
            cons = this.asyncConsumers.toArray();
        }
        for (int i = 0; i < cons.length; ++i) {
            try {
                ((JmsMsgConsumerImpl)cons[i]).stop();
                continue;
            }
            catch (JMSException e) {
                if (excReceived != null) continue;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"JMSException received at Session.stop. Will continue trying to stop the remaining async consumers.");
                }
                excReceived = e;
            }
        }
        if (excReceived != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"An exception was received during Session.stop. Propogate to Connection.");
            }
            throw excReceived;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"stop");
        }
    }

    public int getProducerCount() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getProducerCount");
        }
        int producerCount = this.producers.size();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getProducerCount", (Object)producerCount);
        }
        return producerCount;
    }

    public int getConsumerCount() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getConsumerCount");
        }
        int consumerCount = this.syncConsumers.size();
        consumerCount += this.asyncConsumers.size();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getConsumerCount", (Object)consumerCount);
        }
        return consumerCount;
    }

    void removeProducer(JmsMsgProducerImpl producer) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"removeProducer", (Object)producer);
        }
        this.producers.remove(producer);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"removeProducer");
        }
    }

    void removeConsumer(JmsMsgConsumerImpl consumer) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"removeConsumer", (Object)consumer);
        }
        if (this.acknowledgeMode == 3 && this.uncommittedReceiveCount > 0) {
            this.commitTransaction();
        }
        this.syncConsumers.remove(consumer);
        this.asyncConsumers.remove(consumer);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"removeConsumer");
        }
    }

    void removeBrowser(JmsQueueBrowserImpl browser) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"removeBrowser", (Object)browser);
        }
        this.browsers.remove(browser);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"removeBrowser");
        }
    }

    void notifyMessagePreConsume(SITransaction transaction) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"notifyMessagePreConsume", (Object)transaction);
        }
        if (!(transaction instanceof SIXAResource)) {
            ++this.uncommittedReceiveCount;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled() && this.uncommittedReceiveCount % 100 == 0) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("session " + this + " uncommittedReceiveCount : " + this.uncommittedReceiveCount));
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"notifyMessagePreConsume");
        }
    }

    void notifyMessagePostConsume() throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"notifyMessagePostConsume");
        }
        if (this.acknowledgeMode == 3 && this.uncommittedReceiveCount >= this.dupsCommitThreshold) {
            this.commitTransaction();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"notifyMessagePostConsume");
        }
    }

    void notifyMessageConsumed(SITransaction transaction) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"notifyMessageConsumed", (Object)transaction);
        }
        this.notifyMessagePreConsume(transaction);
        this.notifyMessagePostConsume();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"notifyMessageConsumed");
        }
    }

    SITransaction getTransaction() throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getTransaction");
        }
        SITransaction transaction = null;
        try {
            transaction = this.jcaSession.getCurrentTransaction();
        }
        catch (IllegalStateException ise) {
            throw (jakarta.jms.IllegalStateException)JmsErrorUtils.newThrowable(jakarta.jms.IllegalStateException.class, "EXCEPTION_RECEIVED_CWSIA0053", new Object[]{ise, "JmsSessionImpl.getTransaction (#1)"}, ise, null, this, tc);
        }
        catch (Exception e) {
            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0053", new Object[]{e, "JmsSessionImpl.getTransaction (#2)"}, e, "JmsSessionImpl.getTransaction#2", this, tc);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getTransaction", (Object)transaction);
        }
        return transaction;
    }

    void commitTransaction() throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"commitTransaction");
        }
        try {
            this.jcaSession.commitLocalTransaction();
            this.uncommittedReceiveCount = 0;
        }
        catch (IllegalStateException ise) {
            throw (jakarta.jms.IllegalStateException)JmsErrorUtils.newThrowable(jakarta.jms.IllegalStateException.class, "EXCEPTION_RECEIVED_CWSIA0053", new Object[]{ise, "JmsSessionImpl.commitTransaction (#1)"}, ise, "JmsSessionImpl.commitTransaction#1", this, tc);
        }
        catch (LocalTransactionException lte) {
            throw (jakarta.jms.IllegalStateException)JmsErrorUtils.newThrowable(jakarta.jms.IllegalStateException.class, "EXCEPTION_RECEIVED_CWSIA0053", new Object[]{lte, "JmsSessionImpl.commitTransaction (#2)"}, lte, "JmsSessionImpl.commitTransaction#2", this, tc);
        }
        catch (SIConnectionDroppedException e) {
            this.rolledBackDueToConnectionFailure = true;
            throw (TransactionRolledBackException)JmsErrorUtils.newThrowable(TransactionRolledBackException.class, "EXCEPTION_RECEIVED_CWSIA0053", new Object[]{e, "JmsSessionImpl.commitTransaction (#4)"}, e, "JmsSessionImpl.commitTransaction#4", this, tc);
        }
        catch (SIConnectionLostException e) {
            this.rolledBackDueToConnectionFailure = true;
            throw (TransactionRolledBackException)JmsErrorUtils.newThrowable(TransactionRolledBackException.class, "EXCEPTION_RECEIVED_CWSIA0053", new Object[]{e, "JmsSessionImpl.commitTransaction (#5)"}, e, "JmsSessionImpl.commitTransaction#5", this, tc);
        }
        catch (Exception e) {
            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0053", new Object[]{e, "JmsSessionImpl.commitTransaction (#3)"}, e, "JmsSessionImpl.commitTransaction#3", this, tc);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"commitTransaction");
        }
    }

    void rollbackTransaction() throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"rollbackTransaction");
        }
        try {
            if (this.rolledBackDueToConnectionFailure) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"rolledBackDueToConnectionFailure = true");
                }
                return;
            }
            this.jcaSession.rollbackLocalTransaction();
            this.uncommittedReceiveCount = 0;
        }
        catch (IllegalStateException ise) {
            throw (jakarta.jms.IllegalStateException)JmsErrorUtils.newThrowable(jakarta.jms.IllegalStateException.class, "EXCEPTION_RECEIVED_CWSIA0053", new Object[]{ise, "JmsSessionImpl.rollbackTransaction (#1)"}, ise, null, this, tc);
        }
        catch (LocalTransactionException lte) {
            throw (jakarta.jms.IllegalStateException)JmsErrorUtils.newThrowable(jakarta.jms.IllegalStateException.class, "EXCEPTION_RECEIVED_CWSIA0053", new Object[]{lte, "JmsSessionImpl.rollbackTransaction (#2)"}, lte, "JmsSessionImpl.rollbackTransaction#2", this, tc);
        }
        catch (Exception e) {
            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0053", new Object[]{e, "JmsSessionImpl.rollbackTransaction (#3)"}, e, "JmsSessionImpl.rollbackTransaction#3", this, tc);
        }
        finally {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"commitTransaction");
            }
        }
    }

    int getAndResetCommitCount() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getAndResetCommitCount");
        }
        int currentUncommittedReceiveCount = this.uncommittedReceiveCount;
        this.uncommittedReceiveCount = 0;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getAndResetCommitCount", (Object)currentUncommittedReceiveCount);
        }
        return currentUncommittedReceiveCount;
    }

    byte[] createMessageID() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"createMessageID");
        }
        int currentOffset = this.currentMessageID.length;
        int counterEndPosition = this.currentMessageID.length - 8;
        do {
            int n = --currentOffset;
            this.currentMessageID[n] = (byte)(this.currentMessageID[n] + 1);
        } while (this.currentMessageID[currentOffset] == 0 && currentOffset > counterEndPosition);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"createMessageID", (Object)this.currentMessageID);
        }
        return this.currentMessageID;
    }

    private SIDestinationAddress createTemporaryDestination(Distribution destType, String prefix) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"createTemporaryDestination", (Object)new Object[]{destType, prefix});
        }
        SIDestinationAddress da = null;
        try {
            da = this.getCoreConnection().createTemporaryDestination(destType, prefix);
        }
        catch (SIInvalidDestinationPrefixException siidpe) {
            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "INVALID_VALUE_CWSIA0048", new Object[]{"TempDestPrefix", prefix}, siidpe, null, this, tc);
        }
        catch (SIConnectionLostException sice) {
            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0053", new Object[]{sice, "JmsSessionImpl.createTemporaryDestination (#2)"}, sice, null, this, tc);
        }
        catch (SINotAuthorizedException sinae) {
            String userID;
            block11: {
                userID = "<unknown>";
                try {
                    userID = this.coreConnection.getResolvedUserid();
                }
                catch (SIException e) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block11;
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("failed to get resovledUserId: " + (Object)((Object)e)));
                }
            }
            throw (JMSSecurityException)JmsErrorUtils.newThrowable(JMSSecurityException.class, "AUTHORIZATION_FAILED_CWSIA0057", new Object[]{userID}, sinae, null, this, tc);
        }
        catch (SIConnectionUnavailableException sioce) {
            throw (jakarta.jms.IllegalStateException)JmsErrorUtils.newThrowable(jakarta.jms.IllegalStateException.class, "CONNECTION_CLOSED_CWSIA0051", null, sioce, null, this, tc);
        }
        catch (SIException sice) {
            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0053", new Object[]{sice, "JmsSessionImpl.createTemporaryDestination (#5)"}, sice, null, this, tc);
        }
        catch (Exception e) {
            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0053", new Object[]{e, "JmsSessionImpl.createTemporaryDestination (#6)"}, e, "JmsSessionImpl.createTemporaryDestination#6", this, tc);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"createTemporaryDestination", (Object)da);
        }
        return da;
    }

    protected void deleteTemporaryDestination(SIDestinationAddress dest) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"deleteTemporaryDestination", (Object)dest);
        }
        try {
            this.getCoreConnection().deleteTemporaryDestination(dest);
        }
        catch (SITemporaryDestinationNotFoundException e) {
            throw (jakarta.jms.IllegalStateException)JmsErrorUtils.newThrowable(jakarta.jms.IllegalStateException.class, "DESTINATION_DOES_NOT_EXIST_CWSIA0052", new Object[]{dest.getDestinationName()}, e, null, this, tc);
        }
        catch (SIDestinationLockedException sidle) {
            throw (jakarta.jms.IllegalStateException)JmsErrorUtils.newThrowable(jakarta.jms.IllegalStateException.class, "DEST_LOCKED_CWSIA0058", null, sidle, null, this, tc);
        }
        catch (SINotAuthorizedException sinae) {
            String userID;
            block12: {
                userID = "<unknown>";
                try {
                    userID = this.coreConnection.getResolvedUserid();
                }
                catch (SIException e) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block12;
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("failed to get resovledUserId: " + (Object)((Object)e)));
                }
            }
            throw (JMSSecurityException)JmsErrorUtils.newThrowable(JMSSecurityException.class, "AUTHORIZATION_FAILED_CWSIA0057", new Object[]{userID}, sinae, null, this, tc);
        }
        catch (SIConnectionLostException sice) {
            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0053", new Object[]{sice, "JmsSessionImpl.deleteTemporaryDestination (#3)"}, sice, null, this, tc);
        }
        catch (SIConnectionUnavailableException sioce) {
            throw (jakarta.jms.IllegalStateException)JmsErrorUtils.newThrowable(jakarta.jms.IllegalStateException.class, "CONNECTION_CLOSED_CWSIA0051", null, sioce, null, this, tc);
        }
        catch (SIException sice) {
            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0053", new Object[]{sice, "JmsSessionImpl.deleteTemporaryDestination (#6)"}, sice, "JmsSessionImpl.deleteTemporaryDestination#6", this, tc);
        }
        catch (Exception e) {
            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0053", new Object[]{e, "JmsSessionImpl.deleteTemporaryDestination (#7)"}, e, "JmsSessionImpl.deleteTemporaryDestination#7", this, tc);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"deleteTemporaryDestination");
        }
    }

    boolean isAsync() {
        boolean isAsync;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"isAsync");
        }
        boolean bl = isAsync = !this.asyncConsumers.isEmpty() && this.getState() == 2;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"isAsync", (Object)isAsync);
        }
        return isAsync;
    }

    void checkSynchronousUsage(String methodName) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"checkSynchronousUsage", (Object)methodName);
        }
        if (this.isAsync() && !Thread.holdsLock(this.asyncDeliveryLock)) {
            throw (JMSException)JmsErrorUtils.newThrowable(jakarta.jms.IllegalStateException.class, "ASYNC_IN_PROGRESS_CWSIA0082", new Object[]{methodName}, tc);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"checkSynchronousUsage");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerSyncConsumer(MessageConsumer consumer) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"registerSyncConsumer", (Object)consumer);
        }
        Object object = this.consumerListsLock;
        synchronized (object) {
            this.asyncConsumers.remove(consumer);
            if (!this.syncConsumers.contains(consumer)) {
                this.syncConsumers.add(consumer);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"registerSyncConsumer");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerAsyncConsumer(MessageConsumer consumer) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"registerAsyncConsumer", (Object)consumer);
        }
        Object object = this.consumerListsLock;
        synchronized (object) {
            this.syncConsumers.remove(consumer);
            if (!this.asyncConsumers.contains(consumer)) {
                this.asyncConsumers.add(consumer);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"registerAsyncConsumer");
        }
    }

    Object getSessionSyncLock() {
        return this.sessionSyncLock;
    }

    private void setMessageProperties(JmsMessageImpl msg) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setMessageProperties", (Object)(msg.getClass() + "@" + System.identityHashCode(msg)));
        }
        String prodProp = (String)this.passThruProps.get("producerDoesNotModifyPayloadAfterSet");
        String consProp = (String)this.passThruProps.get("consumerDoesNotModifyPayloadAfterGet");
        msg.producerWontModifyPayloadAfterSet = prodProp.equalsIgnoreCase("true");
        msg.consumerWontModifyPayloadAfterGet = consProp.equalsIgnoreCase("true");
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setMessageProperties");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageConsumer createDurableConsumer(Topic topic, String name) throws InvalidDestinationException, jakarta.jms.IllegalStateException, JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"createDurableConsumer", (Object)new Object[]{topic, name});
        }
        TopicSubscriber messageConsumer = null;
        try {
            messageConsumer = this.createDurableSubscriber(topic, name, null, false, false, true);
        }
        finally {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"createDurableConsumer", (Object)messageConsumer);
            }
        }
        return messageConsumer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageConsumer createDurableConsumer(Topic topic, String name, String messageSelector, boolean noLocal) throws InvalidDestinationException, InvalidSelectorException, jakarta.jms.IllegalStateException, JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"createDurableConsumer", (Object)new Object[]{topic, name, messageSelector, noLocal});
        }
        TopicSubscriber messageConsumer = null;
        try {
            messageConsumer = this.createDurableSubscriber(topic, name, messageSelector, noLocal, false, true);
        }
        finally {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"createDurableConsumer", (Object)messageConsumer);
            }
        }
        return messageConsumer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageConsumer createSharedConsumer(Topic topic, String sharedSubscriptionName) throws JMSException, InvalidDestinationException, InvalidSelectorException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"createSharedConsumer", (Object)new Object[]{topic, sharedSubscriptionName});
        }
        MessageConsumer messageConsumer = null;
        try {
            messageConsumer = this.createConsumer((Destination)topic, sharedSubscriptionName, null, false, true);
        }
        finally {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"createSharedConsumer", (Object)messageConsumer);
            }
        }
        return messageConsumer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageConsumer createSharedConsumer(Topic topic, String sharedSubscriptionName, String messageSelector) throws JMSException, InvalidDestinationException, InvalidSelectorException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"createSharedConsumer", (Object)new Object[]{topic, sharedSubscriptionName, messageSelector});
        }
        MessageConsumer messageConsumer = null;
        try {
            messageConsumer = this.createConsumer((Destination)topic, sharedSubscriptionName, messageSelector, false, true);
        }
        finally {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"createSharedConsumer", (Object)messageConsumer);
            }
        }
        return messageConsumer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageConsumer createSharedDurableConsumer(Topic topic, String name) throws JMSException, InvalidDestinationException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"createSharedDurableConsumer", (Object)new Object[]{topic, name});
        }
        TopicSubscriber messageConsumer = null;
        try {
            messageConsumer = this.createDurableSubscriber(topic, name, null, false, true, false);
        }
        finally {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"createSharedDurableConsumer", (Object)messageConsumer);
            }
        }
        return messageConsumer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageConsumer createSharedDurableConsumer(Topic topic, String name, String messageSelector) throws InvalidDestinationException, jakarta.jms.IllegalStateException, JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"createSharedDurableConsumer", (Object)new Object[]{topic, name, messageSelector});
        }
        TopicSubscriber messageConsumer = null;
        try {
            messageConsumer = this.createDurableSubscriber(topic, name, messageSelector, false, true, false);
        }
        finally {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"createSharedDurableConsumer", (Object)messageConsumer);
            }
        }
        return messageConsumer;
    }

    void validateStopCloseForMessageListener(String functionCall) throws jakarta.jms.IllegalStateException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"validateStopForMessageListener");
        }
        if (asyncReceiverThreadLocal.get() != null && asyncReceiverThreadLocal.get() == this) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Message Listener onMessage called stop on its own Context/connection.");
            }
            if (functionCall.equalsIgnoreCase("stop")) {
                throw (jakarta.jms.IllegalStateException)JmsErrorUtils.newThrowable(jakarta.jms.IllegalStateException.class, "INVALID_METHOD_CWSIA0517", new Object[]{this}, tc);
            }
            throw (jakarta.jms.IllegalStateException)JmsErrorUtils.newThrowable(jakarta.jms.IllegalStateException.class, "INVALID_METHOD_CWSIA0518", new Object[]{this}, tc);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"validateStopForMessageListener");
        }
    }

    static void pushMsgListenerSessionToThreadLocal(JmsSession sess) {
        asyncReceiverThreadLocal.set((JmsSessionImpl)sess);
    }

    static void removeMsgListenerSessionFromThreadLocal() {
        asyncReceiverThreadLocal.remove();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForAsyncSendCompletion() {
        boolean success = true;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"waitForAsyncSendCompletion");
        }
        while (!this._asyncSendQueue.isEmpty() || this.currentAsyncSendObject != null) {
            if (null == this._asyncSendRunThread || !this._asyncSendRunThread.isAlive()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"waitForAsyncSendCompletion: async thread not running, aborting wait");
                }
                success = false;
                break;
            }
            try {
                LinkedBlockingQueue<AysncSendDetails> linkedBlockingQueue = this._asyncSendQueue;
                synchronized (linkedBlockingQueue) {
                    this._asyncSendQueue.wait(20000L);
                }
            }
            catch (InterruptedException e) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"waitForAsyncSendCompletion got interrupted", (Object)e);
                }
                success = false;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"waitForAsyncSendCompletion", (Object)new Boolean(success));
        }
    }

    void validateCloseCommitRollback(String functionCall) throws jakarta.jms.IllegalStateException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"validateCloseCommitRollback", (Object)functionCall);
        }
        if (asyncThreadLocal.get() != null && asyncThreadLocal.get() == this) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"OnComplete/onException called roolback/commit/close on its own Context/Session.");
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"validateCloseCommitRollback");
            }
            throw (jakarta.jms.IllegalStateException)JmsErrorUtils.newThrowable(jakarta.jms.IllegalStateException.class, "INVALID_METHOD_CWSIA0515", new Object[]{functionCall, this}, tc);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"validateCloseCommitRollback");
        }
    }

    void addtoAsysncSendQueue(JmsMsgProducerImpl msgProducer, CompletionListener cListner, Message msg, int sendMethodType, Object[] params) {
        block7: {
            boolean startThread = false;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"addtoAsysncSendQueue", (Object)new Object[]{msgProducer, cListner, cListner, sendMethodType, params});
            }
            if (null == this._asyncSendRunThread || !this._asyncSendRunThread.isAlive()) {
                this._asyncSendRunThread = new Thread(new AsyncSendTask());
                this._asyncSendRunThread.setDaemon(true);
                startThread = true;
            }
            if (msg != null && msg instanceof JmsMessageImpl) {
                ((JmsMessageImpl)msg).setAsyncSendInProgress(true);
            }
            this._asyncSendQueue.offer(new AysncSendDetails(msgProducer, cListner, msg, sendMethodType, params));
            if (startThread) {
                try {
                    this._asyncSendRunThread.start();
                }
                catch (Exception e) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block7;
                    SibTr.debug((TraceComponent)tc, (String)"addtoAsysncSendQueue: starting asyncRunThread failed", (Object)e);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"addtoAsysncSendQueue");
        }
    }

    private class AsyncSendTask
    implements Runnable {
        private AsyncSendTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block34: {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.entry((Object)this, (TraceComponent)tc, (String)"AsyncSendTask$run");
                }
                try {
                    LinkedBlockingQueue linkedBlockingQueue;
                    if (JmsSessionImpl.this._asyncSendQueue.isEmpty()) {
                        linkedBlockingQueue = JmsSessionImpl.this._asyncSendQueue;
                        synchronized (linkedBlockingQueue) {
                            JmsSessionImpl.this.currentAsyncSendObject = null;
                            JmsSessionImpl.this._asyncSendQueue.notifyAll();
                        }
                    }
                    while ((JmsSessionImpl.this.currentAsyncSendObject = (AysncSendDetails)JmsSessionImpl.this._asyncSendQueue.take()) != null) {
                        try {
                            if (JmsSessionImpl.this.currentAsyncSendObject.getSendMethodType() == 7777) {
                                JmsSessionImpl.this._asyncSendQueue.clear();
                                linkedBlockingQueue = JmsSessionImpl.this._asyncSendQueue;
                                synchronized (linkedBlockingQueue) {
                                    JmsSessionImpl.this.currentAsyncSendObject = null;
                                    JmsSessionImpl.this._asyncSendQueue.notifyAll();
                                    break;
                                }
                            }
                            asyncThreadLocal.set(JmsSessionImpl.this);
                            JmsSessionImpl.this.currentAsyncSendObject.getMsgProducer().sendCalledFromAsynsSendRunThread(JmsSessionImpl.this.currentAsyncSendObject.getMsg(), JmsSessionImpl.this.currentAsyncSendObject.getSendMethodType(), JmsSessionImpl.this.currentAsyncSendObject.getParams(), JmsSessionImpl.this.currentAsyncSendObject.getCListner());
                            asyncThreadLocal.remove();
                        }
                        catch (Throwable e) {
                            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                            SibTr.debug((TraceComponent)tc, (String)"Caught exception in AsyncRun thread ", (Object)e);
                        }
                        finally {
                            if (JmsSessionImpl.this._asyncSendQueue.isEmpty()) {
                                linkedBlockingQueue = JmsSessionImpl.this._asyncSendQueue;
                                synchronized (linkedBlockingQueue) {
                                    JmsSessionImpl.this.currentAsyncSendObject = null;
                                    JmsSessionImpl.this._asyncSendQueue.notifyAll();
                                }
                            }
                            asyncThreadLocal.remove();
                        }
                    }
                }
                catch (InterruptedException e) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)"Async thread got interrupted ", (Object)e);
                    }
                }
                catch (Throwable e) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block34;
                    SibTr.debug((TraceComponent)tc, (String)"Caught exception in AsyncRun thread ", (Object)e);
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"AsyncSendTask$run");
            }
        }
    }
}

