/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.soap.soap11.encoder.http.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletResponse;
import net.shibboleth.utilities.java.support.net.HttpServletSupport;
import net.shibboleth.utilities.java.support.xml.SerializeSupport;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectBuilderFactory;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.encoder.MessageEncodingException;
import org.opensaml.messaging.encoder.servlet.BaseHttpServletResponseXMLMessageEncoder;
import org.opensaml.soap.common.SOAPObjectBuilder;
import org.opensaml.soap.messaging.SOAPMessagingSupport;
import org.opensaml.soap.messaging.context.SOAP11Context;
import org.opensaml.soap.soap11.Body;
import org.opensaml.soap.soap11.Envelope;
import org.opensaml.soap.soap11.Fault;
import org.opensaml.soap.soap11.Header;
import org.opensaml.soap.wsaddressing.Action;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class HTTPSOAP11Encoder
extends BaseHttpServletResponseXMLMessageEncoder {
    private final Logger log = LoggerFactory.getLogger(HTTPSOAP11Encoder.class);
    private SOAPObjectBuilder<Envelope> envBuilder;
    private SOAPObjectBuilder<Body> bodyBuilder;

    public HTTPSOAP11Encoder() {
        XMLObjectBuilderFactory builderFactory = XMLObjectProviderRegistrySupport.getBuilderFactory();
        this.envBuilder = (SOAPObjectBuilder)builderFactory.getBuilderOrThrow(Envelope.DEFAULT_ELEMENT_NAME);
        this.bodyBuilder = (SOAPObjectBuilder)builderFactory.getBuilderOrThrow(Body.DEFAULT_ELEMENT_NAME);
    }

    public void prepareContext() throws MessageEncodingException {
        MessageContext messageContext = this.getMessageContext();
        Object payload = null;
        Fault fault = SOAPMessagingSupport.getSOAP11Fault(messageContext);
        if (fault != null) {
            this.log.debug("Saw SOAP 1.1 Fault payload with fault code, replacing any existing context message: {}", fault.getCode() != null ? fault.getCode().getValue() : null);
            payload = fault;
            messageContext.setMessage(null);
        } else {
            payload = messageContext.getMessage();
        }
        if (payload == null || !(payload instanceof XMLObject)) {
            throw new MessageEncodingException("No outbound XML message or Fault contained in message context");
        }
        if (payload instanceof Envelope) {
            this.storeSOAPEnvelope((Envelope)payload);
        } else {
            this.buildAndStoreSOAPMessage((XMLObject)payload);
        }
    }

    protected void doEncode() throws MessageEncodingException {
        Envelope envelope = this.getSOAPEnvelope();
        Element envelopeElem = this.marshallMessage(envelope);
        this.prepareHttpServletResponse();
        try {
            SerializeSupport.writeNode((Node)envelopeElem, (OutputStream)this.getHttpServletResponse().getOutputStream());
        }
        catch (IOException e) {
            throw new MessageEncodingException("Problem writing SOAP envelope to servlet output stream", (Exception)e);
        }
    }

    protected void storeSOAPEnvelope(Envelope envelope) {
        ((SOAP11Context)this.getMessageContext().getSubcontext(SOAP11Context.class, true)).setEnvelope(envelope);
    }

    protected Envelope getSOAPEnvelope() {
        return ((SOAP11Context)this.getMessageContext().getSubcontext(SOAP11Context.class, true)).getEnvelope();
    }

    protected void buildAndStoreSOAPMessage(@Nonnull XMLObject payload) {
        Body body;
        Envelope envelope = this.getSOAPEnvelope();
        if (envelope == null) {
            envelope = this.envBuilder.buildObject();
            this.storeSOAPEnvelope(envelope);
        }
        if ((body = envelope.getBody()) == null) {
            body = this.bodyBuilder.buildObject();
            envelope.setBody(body);
        }
        if (!body.getUnknownXMLObjects().isEmpty()) {
            this.log.warn("Existing SOAP Envelope Body already contained children");
        }
        body.getUnknownXMLObjects().add(payload);
    }

    protected void prepareHttpServletResponse() throws MessageEncodingException {
        HttpServletResponse response = this.getHttpServletResponse();
        HttpServletSupport.addNoCacheHeaders((HttpServletResponse)response);
        HttpServletSupport.setUTF8Encoding((HttpServletResponse)response);
        HttpServletSupport.setContentType((HttpServletResponse)response, (String)"text/xml");
        String soapAction = this.getSOAPAction();
        if (soapAction != null) {
            response.setHeader("SOAPAction", soapAction);
        } else {
            response.setHeader("SOAPAction", "");
        }
        response.setStatus(this.getHTTPResponseStatusCode());
    }

    protected String getSOAPAction() {
        Envelope env = this.getSOAPEnvelope();
        Header header = env.getHeader();
        if (header == null) {
            return null;
        }
        List<XMLObject> objList = header.getUnknownXMLObjects(Action.ELEMENT_NAME);
        if (objList == null || objList.isEmpty()) {
            return null;
        }
        return ((Action)objList.get(0)).getURI();
    }

    protected int getHTTPResponseStatusCode() {
        Body body;
        List<XMLObject> faults;
        Integer contextStatus = ((SOAP11Context)this.getMessageContext().getSubcontext(SOAP11Context.class, true)).getHTTPResponseStatus();
        if (contextStatus != null) {
            return contextStatus;
        }
        Envelope envelope = this.getSOAPEnvelope();
        if (envelope != null && envelope.getBody() != null && !(faults = (body = envelope.getBody()).getUnknownXMLObjects(Fault.DEFAULT_ELEMENT_NAME)).isEmpty()) {
            return 500;
        }
        return 200;
    }

    protected XMLObject getMessageToLog() {
        return ((SOAP11Context)this.getMessageContext().getSubcontext(SOAP11Context.class, true)).getEnvelope();
    }
}

