/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.security.crypto.dh;

import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.crypto.KeyAgreement;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.interfaces.DHPublicKey;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x9.DomainParameters;
import org.opensaml.security.crypto.KeySupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DHSupport {
    private static final Logger LOG = LoggerFactory.getLogger(DHSupport.class);

    private DHSupport() {
    }

    @Nonnull
    public static byte[] performKeyAgreement(@Nonnull DHPublicKey publicKey, @Nonnull DHPrivateKey privateKey, @Nullable String provider) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        Constraint.isNotNull((Object)publicKey, (String)"DHPublicKey was null");
        Constraint.isNotNull((Object)privateKey, (String)"DHPrivateKey was null");
        KeyAgreement keyAgreement = null;
        keyAgreement = provider != null ? KeyAgreement.getInstance("DiffieHellman", provider) : KeyAgreement.getInstance("DiffieHellman");
        keyAgreement.init(privateKey);
        keyAgreement.doPhase(publicKey, true);
        return keyAgreement.generateSecret();
    }

    @Nonnull
    public static KeyPair generateCompatibleKeyPair(@Nonnull DHPublicKey publicKey, @Nullable String provider) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException {
        Constraint.isNotNull((Object)publicKey, (String)"DHPublicKey was null");
        return KeySupport.generateKeyPair("DiffieHellman", publicKey.getParams(), provider);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static BigInteger getPrimeQDomainParameter(@Nonnull DHPublicKey publicKey) {
        Constraint.isNotNull((Object)publicKey, (String)"DHPublicKey was null");
        try (ASN1InputStream input = new ASN1InputStream(publicKey.getEncoded());){
            SubjectPublicKeyInfo spki = SubjectPublicKeyInfo.getInstance((Object)input.readObject());
            if (spki.getAlgorithm().getParameters() != null) {
                DomainParameters dp = DomainParameters.getInstance((Object)spki.getAlgorithm().getParameters());
                BigInteger bigInteger2 = dp.getQ();
                return bigInteger2;
            }
            BigInteger bigInteger = null;
            return bigInteger;
        }
        catch (Exception e) {
            LOG.warn("Error processing DHPublicKey for prime Q parameter", (Throwable)e);
            return null;
        }
    }
}

