/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.saml.sso20.rs;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.saml.sso20.binding.BasicMessageContext;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import net.shibboleth.utilities.java.support.xml.ParserPool;
import net.shibboleth.utilities.java.support.xml.QNameSupport;
import net.shibboleth.utilities.java.support.xml.SerializeSupport;
import net.shibboleth.utilities.java.support.xml.XMLParserException;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.Unmarshaller;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.messaging.decoder.MessageDecodingException;
import org.opensaml.saml.common.SAMLObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class ByteArrayDecoder {
    private static final TraceComponent tc = Tr.register(ByteArrayDecoder.class, (String)"SAML20", (String)"com.ibm.ws.security.saml.sso20.internal.resources.SamlSso20Messages");
    ParserPool parserPool = XMLObjectProviderRegistrySupport.getParserPool();
    static final long serialVersionUID = -6992732078811542430L;

    protected void doDecode(BasicMessageContext<?, ?> messageContext, ByteArrayInputStream byteArrayInputStream) throws MessageDecodingException {
        ByteArrayInputStream base64DecodedMessage = byteArrayInputStream;
        SAMLObject inboundMessage = (SAMLObject)this.unmarshallMessage(base64DecodedMessage);
        messageContext.getMessageContext().setMessage((Object)inboundMessage);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Decoded SAML message", (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - void declaration
     */
    public XMLObject unmarshallMessage(InputStream messageStream) throws MessageDecodingException {
        try {
            Unmarshaller unmarshaller;
            Document messageDoc = this.parserPool.parse(messageStream);
            Element messageElem = messageDoc.getDocumentElement();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Resultant DOM message was:\n{}", (Object[])new Object[]{messageElem == null ? "null" : SerializeSupport.nodeToString((Node)messageElem)});
                Tr.debug((TraceComponent)tc, (String)"Unmarshalling message", (Object[])new Object[0]);
            }
            if ((unmarshaller = XMLObjectProviderRegistrySupport.getUnmarshallerFactory().getUnmarshaller(messageElem)) == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Unable to unmarshall message, no unmarshaller registered for message element " + QNameSupport.getNodeQName((Node)messageElem)), (Object[])new Object[0]);
                }
                throw new MessageDecodingException("Unable to unmarshall message, no unmarshaller registered for message element " + QNameSupport.getNodeQName((Node)messageElem));
            }
            XMLObject message = unmarshaller.unmarshall(messageElem);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Message succesfully unmarshalled", (Object[])new Object[0]);
            }
            return message;
        }
        catch (XMLParserException messageDoc) {
            void e;
            FFDCFilter.processException((Throwable)messageDoc, (String)"com.ibm.ws.security.saml.sso20.rs.ByteArrayDecoder", (String)"97", (Object)this, (Object[])new Object[]{messageStream});
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("XMLParserException e:" + e), (Object[])new Object[0]);
            }
            throw new MessageDecodingException("Encountered error parsing message into its DOM representation", (Exception)e);
        }
        catch (UnmarshallingException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.saml.sso20.rs.ByteArrayDecoder", (String)"102", (Object)this, (Object[])new Object[]{messageStream});
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("UnmarshallingException e:" + (Object)((Object)e)), (Object[])new Object[0]);
            }
            throw new MessageDecodingException("Encountered error unmarshalling message from its DOM representation", (Exception)((Object)e));
        }
    }
}

