/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.stack.transport.sip.chfw;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sip.container.pmi.PerformanceMgr;
import com.ibm.ws.sip.parser.util.InetAddressCache;
import com.ibm.ws.sip.properties.SipPropertiesMap;
import com.ibm.ws.sip.stack.context.MessageContext;
import com.ibm.ws.sip.stack.dispatch.Dispatcher;
import com.ibm.ws.sip.stack.transaction.transport.Hop;
import com.ibm.ws.sip.stack.transaction.transport.UseCompactHeaders;
import com.ibm.ws.sip.stack.transaction.transport.connections.SIPConnection;
import com.ibm.ws.sip.stack.transaction.transport.connections.SipMessageByteBuffer;
import com.ibm.ws.sip.stack.transaction.transport.routers.SLSPRouter;
import com.ibm.ws.sip.stack.transaction.util.ApplicationProperties;
import com.ibm.ws.sip.stack.transport.sip.chfw.BaseConnection;
import com.ibm.ws.sip.stack.transport.sip.chfw.SipUdpConnection;
import com.ibm.ws.sip.stack.transport.sip.chfw.SipUdpInboundChannel;
import com.ibm.ws.sip.stack.transport.sip.chfw.UdpSender;
import com.ibm.ws.sip.stack.util.StackTaskDurationMeasurer;
import com.ibm.wsspi.bytebuffer.WsByteBuffer;
import com.ibm.wsspi.channelfw.ChannelFramework;
import com.ibm.wsspi.channelfw.ChannelFrameworkFactory;
import com.ibm.wsspi.channelfw.ConnectionLink;
import com.ibm.wsspi.channelfw.ConnectionReadyCallback;
import com.ibm.wsspi.channelfw.OutboundConnectionLink;
import com.ibm.wsspi.channelfw.OutboundProtocol;
import com.ibm.wsspi.channelfw.OutboundVirtualConnection;
import com.ibm.wsspi.channelfw.VirtualConnection;
import com.ibm.wsspi.channelfw.VirtualConnectionFactory;
import com.ibm.wsspi.channelfw.base.OutboundProtocolLink;
import com.ibm.wsspi.channelfw.exception.ChainException;
import com.ibm.wsspi.channelfw.exception.ChannelException;
import com.ibm.wsspi.udpchannel.UDPBuffer;
import com.ibm.wsspi.udpchannel.UDPContext;
import com.ibm.wsspi.udpchannel.UDPReadCompletedCallback;
import com.ibm.wsspi.udpchannel.UDPReadRequestContext;
import com.ibm.wsspi.udpchannel.UDPRequestContext;
import com.ibm.wsspi.udpchannel.UDPRequestContextFactory;
import com.ibm.wsspi.udpchannel.UDPWriteCompletedCallback;
import com.ibm.wsspi.udpchannel.UDPWriteRequestContext;
import jain.protocol.ip.sip.ListeningPoint;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.NoSuchElementException;

public class SipUdpConnLink
extends OutboundProtocolLink
implements OutboundProtocol,
UDPReadCompletedCallback,
UDPWriteCompletedCallback,
UdpSender {
    private static final TraceComponent tc = Tr.register(SipUdpConnLink.class);
    private static final LogMgr c_logger = Log.get(SipUdpConnLink.class);
    private static HashMap s_instances = new HashMap();
    private static SipUdpConnLink s_connectingInstance = null;
    private ConnectionLink m_linkOnDeviceSide = null;
    private ConnectionReadyCallback m_linkOnApplicationSide = null;
    private VirtualConnection m_vc = null;
    private boolean m_connected;
    private SipUdpInboundChannel m_channel;
    private SendThread m_sendThread;
    private WsByteBuffer m_outboundBuffer;
    private String m_receiveBufferSizeSocket;
    private String m_sendBufferSizeSocket;
    private String m_receiveBufferSizeChannel;
    private boolean m_needToLearnRouterEndpoint;

    static SipUdpConnLink instance(SipUdpInboundChannel channel) {
        ListeningPoint lp = channel.getListeningPoint();
        SipUdpConnLink connLink = (SipUdpConnLink)s_instances.get(lp);
        if (connLink == null) {
            connLink = new SipUdpConnLink(channel);
            s_instances.put(lp, connLink);
        }
        return connLink;
    }

    private SipUdpConnLink(SipUdpInboundChannel channel) {
        this.m_channel = channel;
        this.m_sendThread = new SendThread(this);
        this.m_connected = false;
        this.m_outboundBuffer = null;
        this.m_sendThread.start();
        SipPropertiesMap config = ApplicationProperties.getProperties();
        this.m_receiveBufferSizeSocket = config.getString("receiveBufferSizeSocket");
        if (this.m_receiveBufferSizeSocket.equals("") || this.m_receiveBufferSizeSocket.length() == 0) {
            this.m_receiveBufferSizeSocket = null;
        }
        this.m_sendBufferSizeSocket = config.getString("sendBufferSizeSocket");
        if (!this.m_sendBufferSizeSocket.equals("") || this.m_sendBufferSizeSocket.length() == 0) {
            this.m_sendBufferSizeSocket = null;
        }
        this.m_receiveBufferSizeChannel = config.getString("receiveBufferSizeChannel");
        if (this.m_receiveBufferSizeChannel.equals("") || this.m_receiveBufferSizeChannel.length() == 0) {
            this.m_receiveBufferSizeChannel = null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"<init>", (Object[])new Object[]{"receiveBufferSizeSocket [" + this.m_receiveBufferSizeSocket + "] sendBufferSizeSocket [" + this.m_sendBufferSizeSocket + "] receiveBufferSizeChannel [" + this.m_receiveBufferSizeChannel + ']'});
        }
    }

    static SipUdpConnLink getPendingConnection() {
        SipUdpConnLink current = s_connectingInstance;
        s_connectingInstance = null;
        return current;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connect(MessageContext messageContext) throws IOException {
        String outboundChainName = this.m_channel.getOutboundChainName();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"<connect>", (Object[])new Object[]{"outboundChainName = " + outboundChainName});
        }
        try {
            ChannelFramework cf = ChannelFrameworkFactory.getChannelFramework();
            VirtualConnectionFactory factory = cf.getOutboundVCFactory(outboundChainName);
            Class<SipUdpConnLink> clazz = SipUdpConnLink.class;
            synchronized (SipUdpConnLink.class) {
                s_connectingInstance = this;
                VirtualConnection vc = factory.createConnection();
                // ** MonitorExit[var6_8] (shouldn't be in output)
                this.setVirtualConnection(vc);
                if (!(vc instanceof OutboundVirtualConnection)) {
                    throw new IllegalStateException("Not an OutboundVirtualConnection");
                }
                this.setConnectionProperties(vc);
                OutboundVirtualConnection outboundConnection = (OutboundVirtualConnection)vc;
                String localHostname = null;
                int localPort = 0;
                if (messageContext != null && messageContext.getSipConnection() != null) {
                    localHostname = messageContext.getSipConnection().getSIPListenningConnection().getListeningPoint().getHost();
                }
                UDPRequestContext connectRequestContext = UDPRequestContextFactory.getRef().createUDPRequestContext(localHostname, localPort);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"<connect>", (Object[])new Object[]{"connectAsynch..."});
                }
                outboundConnection.connectAsynch((Object)connectRequestContext, (ConnectionReadyCallback)this);
            }
        }
        catch (ChannelException e2) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"connect", (Object[])new Object[]{"ChannelException", e2});
            }
            throw new IOException(e2.getMessage());
        }
        catch (ChainException e3) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"connect", (Object[])new Object[]{"ChainException", e3});
            }
            throw new IOException(e3.getMessage());
        }
        catch (Exception e4) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"connect", (Object[])new Object[]{"Exception", e4});
            }
            throw new IOException(e4.getMessage());
        }
    }

    @Override
    public void send(MessageContext messageContext, UseCompactHeaders useCompactHeaders) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("SipUdpConnLink.send: " + System.identityHashCode(messageContext) + " isconnected = " + this.m_connected), (Object[])new Object[0]);
        }
        if (!this.m_connected) {
            this.connect(messageContext);
        }
        this.m_sendThread.queue(messageContext);
    }

    protected boolean sendNow(MessageContext messageContext) throws IOException {
        UDPWriteRequestContext writeCtx;
        SipMessageByteBuffer message = messageContext.getSipMessageByteBuffer();
        messageContext.setSipMessageByteBuffer(null);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("SipUdpConnLink.sendNow: " + System.identityHashCode(message)), (Object[])new Object[0]);
        }
        if (message == null) {
            throw new IOException("message is null in SipUdpConnLink.sendNow");
        }
        if (this.m_outboundBuffer != null) {
            throw new IOException("previous send not completed in SipUdpConnLink.sendNow");
        }
        UDPContext connectionContext = (UDPContext)this.m_linkOnDeviceSide.getChannelAccessor();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"sendNow", (Object[])new Object[]{"SipUdpConnLink = " + this.hashCode() + "connectionContext = " + connectionContext.hashCode() + " localAddress = " + connectionContext.getLocalAddress() + " localPort = " + connectionContext.getLocalPort() + " m_linkOnDeviceSide = " + this.m_linkOnDeviceSide.hashCode()});
        }
        if ((writeCtx = connectionContext.getWriteInterface()) == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"sendNow", (Object[])new Object[]{"Error: no write context"});
            }
            return false;
        }
        SIPConnection sipConnection = messageContext.getSipConnection();
        String remoteHost = sipConnection.getRemoteHost();
        int remotePort = sipConnection.getRemotePort();
        InetSocketAddress address = InetAddressCache.getInetSocketAddress(remoteHost, remotePort);
        this.m_outboundBuffer = BaseConnection.stackBufferToWsBuffer(message);
        writeCtx.setBuffer(this.m_outboundBuffer);
        VirtualConnection connection = writeCtx.write((SocketAddress)address, (UDPWriteCompletedCallback)this, false);
        boolean complete = connection != null;
        return complete;
    }

    public void complete(VirtualConnection connection, UDPReadRequestContext readCtx) {
        do {
            boolean drop;
            if (drop = Dispatcher.instance().isOverLoaded()) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug((Object)this, (TraceComponent)tc, (String)"complete", (Object[])new Object[]{"Warning: dropping request under overloaded situation"});
                continue;
            }
            UDPBuffer packet = readCtx.getUDPBuffer();
            WsByteBuffer buffer = packet.getBuffer();
            SocketAddress address = packet.getAddress();
            if (address == null) {
                if (!c_logger.isInfoEnabled()) continue;
                c_logger.info("complete", null, "A message in order to use UDP connection link");
                continue;
            }
            if (address instanceof InetSocketAddress) {
                InetSocketAddress inetAddress = (InetSocketAddress)address;
                SipUdpConnection datagram = new SipUdpConnection(this.m_channel, this);
                datagram.setRemoteAddress(inetAddress);
                datagram.messageReceived(buffer);
                if (!this.m_needToLearnRouterEndpoint) continue;
                this.m_needToLearnRouterEndpoint = false;
                Hop slsp = datagram.getKey();
                if (slsp == null) continue;
                SLSPRouter.getInstance().addSLSP(slsp);
                continue;
            }
            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
            Tr.debug((Object)this, (TraceComponent)tc, (String)"complete", (Object[])new Object[]{"Error: expected InetSocketAddress, got [" + (address == null ? "null" : address.getClass().getName()) + ']'});
        } while ((connection = readCtx.read((UDPReadCompletedCallback)this, false)) != null);
    }

    public void error(VirtualConnection vc, UDPReadRequestContext rsc, IOException e2) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"SipUdpConnLink(read).error", (Object[])new Object[]{"IOException", e2});
        }
        this.close(vc, e2);
    }

    public void complete(VirtualConnection connection, UDPWriteRequestContext writeCtx) {
        this.m_sendThread.sendComplete();
    }

    void releaseOutboundBuffer() {
        this.m_outboundBuffer.release();
        this.m_outboundBuffer = null;
    }

    public void error(VirtualConnection vc, UDPWriteRequestContext writeCtx, IOException e2) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            if (e2 == null) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"SipUdpConnLink(write).error (no exception)", (Object[])new Object[0]);
            } else {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"SipUdpConnLink(write).error", (Object[])new Object[]{"IOException", e2});
            }
        }
        this.close(vc, e2);
    }

    public void connect(Object address) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Object[] params = new Object[]{address};
            Tr.debug((Object)this, (TraceComponent)tc, (String)"connect", (Object[])params);
        }
        super.connect(address);
    }

    public void connectAsynch(Object address) {
        ((OutboundConnectionLink)this.getDeviceLink()).connectAsynch(address);
    }

    private void setConnectionProperties(VirtualConnection vc) {
        Map stateMap = vc.getStateMap();
        if (this.m_sendBufferSizeSocket != null) {
            stateMap.put("sendBufferSizeSocket", this.m_sendBufferSizeSocket);
        }
        if (this.m_receiveBufferSizeSocket != null) {
            stateMap.put("receiveBufferSizeSocket", this.m_receiveBufferSizeSocket);
        }
        if (this.m_receiveBufferSizeChannel != null) {
            stateMap.put("receiveBufferSizeChannel", this.m_receiveBufferSizeChannel);
        }
    }

    public Object getChannelAccessor() {
        throw new IllegalStateException("Not implemented and should not be used");
    }

    public void close(VirtualConnection vc, Exception e2) {
        if (!this.m_connected) {
            return;
        }
        this.m_connected = false;
        s_instances.remove(this.m_channel.getListeningPoint());
        this.m_channel.connectionClosed();
        ConnectionLink device = this.getDeviceLink();
        if (device != null) {
            device.close(vc, e2);
        }
        this.m_sendThread.terminate();
    }

    public void destroy(Exception e2) {
        this.m_vc = null;
        this.m_linkOnDeviceSide = null;
        this.m_linkOnApplicationSide = null;
    }

    public VirtualConnection getVirtualConnection() {
        return this.m_vc;
    }

    protected void setVirtualConnection(VirtualConnection vc) {
        this.m_vc = vc;
    }

    public ConnectionReadyCallback getApplicationCallback() {
        return this.m_linkOnApplicationSide;
    }

    public void setApplicationCallback(ConnectionReadyCallback next) {
        this.m_linkOnApplicationSide = next;
    }

    public ConnectionLink getDeviceLink() {
        return this.m_linkOnDeviceSide;
    }

    public void setDeviceLink(ConnectionLink next) {
        this.m_linkOnDeviceSide = next;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"setDeviceLink, link = ", (Object[])new Object[]{this.m_linkOnDeviceSide.hashCode()});
        }
    }

    public void ready(VirtualConnection vc) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"ready", (Object[])new Object[]{"this [" + this + "] vc [" + vc + ']'});
        }
        if (!this.m_connected) {
            this.m_connected = true;
        }
        UDPContext connectionContext = (UDPContext)this.m_linkOnDeviceSide.getChannelAccessor();
        UDPReadRequestContext readCtx = connectionContext.getReadInterface();
        this.complete(vc, readCtx);
        VirtualConnection connection = readCtx.read((UDPReadCompletedCallback)this, false);
        if (connection != null) {
            this.complete(connection, readCtx);
        }
    }

    protected void postConnectProcessing(VirtualConnection conn) {
    }

    public String getProtocol() {
        return null;
    }

    private static class SendThread
    extends Thread {
        private final SipUdpConnLink m_connLink;
        private final LinkedList<MessageContext> m_outMessages;
        private volatile boolean m_locked;
        private volatile boolean m_running;

        SendThread(SipUdpConnLink connLink) {
            super("SipUdpConnLink.SendThread");
            this.m_connLink = connLink;
            this.m_outMessages = new LinkedList();
            this.m_locked = false;
            this.m_running = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void queue(MessageContext messageContext) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("SipUdpConnLink$SendThread.queue: " + System.identityHashCode(messageContext)), (Object[])new Object[0]);
            }
            LinkedList<MessageContext> linkedList = this.m_outMessages;
            synchronized (linkedList) {
                if (PerformanceMgr.getInstance().isTaskDurationOutboundQueuePMIEnabled() && messageContext != null) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((Object)this, (TraceComponent)tc, (String)"SipUdpConnLink$SendThread.queue", (Object[])new Object[]{"start measuring task duration"});
                    }
                    messageContext.setStackTaskDurationMeasurer(new StackTaskDurationMeasurer());
                    messageContext.getSipContainerQueueDuration().startMeasuring();
                }
                if (messageContext != null) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((Object)this, (TraceComponent)tc, (String)"SipUdpConnLink$SendThread.queue", (Object[])new Object[]{"update QueueMonitoring outbound queue statistics - task queued"});
                    }
                    PerformanceMgr.getInstance().updateQueueMonitoringTaskQueuedInOutboundQueue();
                }
                this.m_outMessages.addLast(messageContext);
                this.m_outMessages.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void sendComplete() {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"SipUdpConnLink$SendThread.sendComplete", (Object[])new Object[0]);
            }
            SendThread sendThread = this;
            synchronized (sendThread) {
                this.m_connLink.releaseOutboundBuffer();
                this.m_locked = false;
                this.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void terminate() {
            LinkedList<MessageContext> linkedList = this.m_outMessages;
            synchronized (linkedList) {
                this.m_running = false;
                this.m_outMessages.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block21: {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"SipUdpConnLink thread started", (Object[])new Object[0]);
                }
                try {
                    while (this.m_running) {
                        boolean immediate;
                        MessageContext messageContext = null;
                        Object object = this.m_outMessages;
                        synchronized (object) {
                            block22: {
                                if (this.m_outMessages.isEmpty() || !this.m_connLink.m_connected) {
                                    this.m_outMessages.wait();
                                }
                                if (!this.m_running) {
                                    break;
                                }
                                try {
                                    messageContext = this.m_outMessages.removeFirst();
                                    if (messageContext == null || !PerformanceMgr.getInstance().isTaskDurationOutboundQueuePMIEnabled()) break block22;
                                    PerformanceMgr.getInstance().measureTaskDurationOutboundQueue(messageContext.getSipContainerQueueDuration().takeTimeMeasurement());
                                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                        Tr.debug((Object)this, (TraceComponent)tc, (String)"run", (Object[])new Object[]{"update QueueMonitoring outbound queue statistics - task dequeued"});
                                    }
                                    PerformanceMgr.getInstance().updateQueueMonitoringTaskDequeuedFromOutboundQueue();
                                }
                                catch (NoSuchElementException e2) {
                                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                        Tr.debug((Object)this, (TraceComponent)tc, (String)"run", (Object[])new Object[]{"Trying to remove message from empty list"});
                                    }
                                    continue;
                                }
                            }
                        }
                        object = this;
                        synchronized (object) {
                            if (this.m_locked) {
                                this.wait();
                            }
                        }
                        if (!this.m_running) break;
                        this.m_locked = true;
                        try {
                            immediate = this.m_connLink.sendNow(messageContext);
                            messageContext.writeComplete();
                        }
                        catch (IOException e3) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug((Object)this, (TraceComponent)tc, (String)"run", (Object[])new Object[]{"IOException", e3});
                            }
                            messageContext.writeError(e3);
                            immediate = true;
                        }
                        if (!immediate) continue;
                        this.sendComplete();
                    }
                }
                catch (InterruptedException e4) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block21;
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"run", (Object[])new Object[]{"InterruptedException", e4});
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"SipUdpConnLink thread terminated", (Object[])new Object[0]);
            }
        }
    }
}

