/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container.properties;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.sip.properties.CoreProperties;
import com.ibm.ws.sip.properties.CustPropSource;
import com.ibm.ws.sip.properties.SipPropertiesMap;
import com.ibm.ws.sip.properties.StackProperties;

public class PropertiesStore {
    private static final LogMgr c_logger = Log.get(PropertiesStore.class);
    protected volatile SipPropertiesMap m_properties = null;
    private static PropertiesStore c_instance = new PropertiesStore();

    public static PropertiesStore getInstance() {
        return c_instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SipPropertiesMap getProperties() {
        SipPropertiesMap result = this.m_properties;
        if (result == null) {
            PropertiesStore propertiesStore = this;
            synchronized (propertiesStore) {
                result = this.m_properties;
                if (result == null) {
                    this.m_properties = result = new SipPropertiesMap();
                    this.loadDefaultProperties();
                }
            }
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "getProperties", "Properties set by default values: " + this.m_properties.logProprs(CustPropSource.DEFAULT));
            }
        }
        return result;
    }

    protected void loadDefaultProperties() {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(PropertiesStore.class.getName(), "loadDefaultProperties");
        }
        CoreProperties.loadDefaultProperties(this.m_properties);
        StackProperties.loadDefaultProperties(this.m_properties);
    }
}

