/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container.load;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.sip.container.load.ConcurentLoadListener;
import com.ibm.ws.sip.container.load.LoadCounterAbs;

public class ApplicationQueueCounter
extends LoadCounterAbs {
    private static final LogMgr c_logger = Log.get(ApplicationQueueCounter.class);
    private long _counter = 0L;
    private ConcurentLoadListener _lstr = null;

    public ApplicationQueueCounter(int maximumAllowed, int waterMarkSize, int initialWeight, ConcurentLoadListener lstr) {
        super(maximumAllowed, waterMarkSize, initialWeight, 3);
        this._lstr = lstr;
    }

    @Override
    public void setCounter(long queueSize) {
        this._counter = queueSize;
        if (this.calculateNewWeight(queueSize)) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "setCounter", "Try to set new weight = " + this.getWeight());
            }
            this._lstr.setNewWeight(this, queueSize);
        }
    }

    @Override
    public long getCurrentLoad() {
        return this._counter;
    }

    @Override
    void reset() {
    }

    @Override
    public void decrement() {
    }

    @Override
    public void increment() {
    }

    @Override
    public String getCurrentState() {
        StringBuffer buff = new StringBuffer();
        buff.append(this._myInfo);
        buff.append(" Counter = ");
        buff.append(this._counter);
        return buff.toString();
    }
}

