/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jain.protocol.ip.sip.message;

import com.ibm.ws.jain.protocol.ip.sip.address.URIImpl;
import com.ibm.ws.jain.protocol.ip.sip.message.MessageImpl;
import com.ibm.ws.jain.protocol.ip.sip.message.RequestLine;
import com.ibm.ws.sip.parser.util.CharsBuffer;
import jain.protocol.ip.sip.SipParseException;
import jain.protocol.ip.sip.address.URI;
import jain.protocol.ip.sip.header.AuthorizationHeader;
import jain.protocol.ip.sip.header.HeaderIterator;
import jain.protocol.ip.sip.header.HeaderParseException;
import jain.protocol.ip.sip.header.HideHeader;
import jain.protocol.ip.sip.header.MaxForwardsHeader;
import jain.protocol.ip.sip.header.PriorityHeader;
import jain.protocol.ip.sip.header.ProxyAuthorizationHeader;
import jain.protocol.ip.sip.header.ResponseKeyHeader;
import jain.protocol.ip.sip.header.SubjectHeader;
import jain.protocol.ip.sip.header.ViaHeader;
import jain.protocol.ip.sip.message.Request;
import java.util.List;

public class RequestImpl
extends MessageImpl
implements Request {
    private static final long serialVersionUID = 2735560974454675635L;
    public static final String INFO = "INFO";
    public static final String PRACK = "PRACK";
    public static final String SUBSCRIBE = "SUBSCRIBE";
    public static final String NOTIFY = "NOTIFY";
    public static final String PUBLISH = "PUBLISH";
    public static final String MESSAGE = "MESSAGE";
    public static final String REFER = "REFER";
    public static final String UPDATE = "UPDATE";
    public static final String KEEPALIVE = "KEEPALIVE";
    public static final String PROXYERROR = "PROXYERROR";
    RequestLine m_requestLine = new RequestLine();

    @Override
    public void addViaHeader(ViaHeader viaHeader) throws IllegalArgumentException {
        this.addHeader(viaHeader, true);
    }

    @Override
    public String getMethod() throws SipParseException {
        return this.m_requestLine.getMethod();
    }

    public void setMethod(String method) throws IllegalArgumentException, SipParseException {
        if (method == null) {
            throw new IllegalArgumentException("Request: null method");
        }
        if (method.length() == 0) {
            throw new SipParseException("Request: Empty method", "");
        }
        this.m_requestLine.setMethod(method);
    }

    @Override
    public URI getRequestURI() throws SipParseException {
        return this.m_requestLine.getURI();
    }

    @Override
    public void setRequestURI(URI requestURI) throws IllegalArgumentException {
        if (requestURI == null) {
            throw new IllegalArgumentException("Request: Null requestURI");
        }
        if (!(requestURI instanceof URIImpl)) {
            throw new IllegalArgumentException("Request: requestURI must befrom IBM Jain SIP implementation");
        }
        this.m_requestLine.setURI(requestURI);
    }

    @Override
    public AuthorizationHeader getAuthorizationHeader() throws HeaderParseException {
        return (AuthorizationHeader)this.getHeader("Authorization", true);
    }

    @Override
    public boolean hasAuthorizationHeader() {
        return this.hasHeaders("Authorization");
    }

    @Override
    public void setAuthorizationHeader(AuthorizationHeader authorizationHeader) throws IllegalArgumentException {
        this.setHeader(authorizationHeader, true);
    }

    @Override
    public void removeAuthorizationHeader() {
        this.removeHeaders("Authorization");
    }

    @Override
    public HideHeader getHideHeader() throws HeaderParseException {
        return (HideHeader)this.getHeader("Hide", true);
    }

    @Override
    public boolean hasHideHeader() {
        return this.hasHeaders("Hide");
    }

    @Override
    public void setHideHeader(HideHeader hideHeader) throws IllegalArgumentException {
        this.setHeader(hideHeader, true);
    }

    @Override
    public void removeHideHeader() {
        this.removeHeaders("Hide");
    }

    @Override
    public MaxForwardsHeader getMaxForwardsHeader() throws HeaderParseException {
        return (MaxForwardsHeader)this.getHeader("Max-Forwards", true);
    }

    @Override
    public boolean hasMaxForwardsHeader() {
        return this.hasHeaders("Max-Forwards");
    }

    @Override
    public void setMaxForwardsHeader(MaxForwardsHeader maxForwardsHeader) throws IllegalArgumentException {
        this.setHeader(maxForwardsHeader, true);
    }

    @Override
    public void removeMaxForwardsHeader() {
        this.removeHeaders("Max-Forwards");
    }

    @Override
    public ProxyAuthorizationHeader getProxyAuthorizationHeader() throws HeaderParseException {
        return (ProxyAuthorizationHeader)this.getHeader("Proxy-Authorization", true);
    }

    @Override
    public boolean hasProxyAuthorizationHeader() {
        return this.hasHeaders("Proxy-Authorization");
    }

    @Override
    public void setProxyAuthorizationHeader(ProxyAuthorizationHeader proxyAuthorizationHeader) throws IllegalArgumentException {
        this.setHeader(proxyAuthorizationHeader, true);
    }

    @Override
    public void removeProxyAuthorizationHeader() {
        this.removeHeaders("Proxy-Authorization");
    }

    @Override
    public HeaderIterator getProxyRequireHeaders() {
        return this.getHeaders("Proxy-Require");
    }

    @Override
    public boolean hasProxyRequireHeaders() {
        return this.hasHeaders("Proxy-Require");
    }

    @Override
    public void setProxyRequireHeaders(List proxyRequireHeaders) throws IllegalArgumentException {
        this.setHeaders("Proxy-Require", proxyRequireHeaders);
    }

    @Override
    public void removeProxyRequireHeaders() {
        this.removeHeaders("Proxy-Require");
    }

    @Override
    public HeaderIterator getRequireHeaders() {
        return this.getHeaders("Require");
    }

    @Override
    public boolean hasRequireHeaders() {
        return this.hasHeaders("Require");
    }

    @Override
    public void setRequireHeaders(List requireHeaders) throws IllegalArgumentException {
        this.setHeaders("Require", requireHeaders);
    }

    @Override
    public void removeRequireHeaders() {
        this.removeHeaders("Require");
    }

    @Override
    public HeaderIterator getRouteHeaders() {
        return this.getHeaders("Route");
    }

    @Override
    public boolean hasRouteHeaders() {
        return this.hasHeaders("Route");
    }

    @Override
    public void setRouteHeaders(List routeHeaders) throws IllegalArgumentException {
        this.setHeaders("Route", routeHeaders);
    }

    @Override
    public void removeRouteHeaders() {
        this.removeHeaders("Route");
    }

    @Override
    public ResponseKeyHeader getResponseKeyHeader() throws HeaderParseException {
        return (ResponseKeyHeader)this.getHeader("Response-Key", true);
    }

    @Override
    public boolean hasResponseKeyHeader() {
        return this.hasHeaders("Response-Key");
    }

    @Override
    public void setResponseKeyHeader(ResponseKeyHeader responseKeyHeader) throws IllegalArgumentException {
        this.setHeader(responseKeyHeader, true);
    }

    @Override
    public void removeResponseKeyHeader() {
        this.removeHeaders("Response-Key");
    }

    @Override
    public PriorityHeader getPriorityHeader() throws HeaderParseException {
        return (PriorityHeader)this.getHeader("Priority", true);
    }

    @Override
    public boolean hasPriorityHeader() {
        return this.hasHeaders("Priority");
    }

    @Override
    public void setPriorityHeader(PriorityHeader priorityHeader) throws IllegalArgumentException {
        this.setHeader(priorityHeader, true);
    }

    @Override
    public void removePriorityHeader() {
        this.removeHeaders("Priority");
    }

    @Override
    public SubjectHeader getSubjectHeader() throws HeaderParseException {
        return (SubjectHeader)this.getHeader("Subject", true);
    }

    @Override
    public boolean hasSubjectHeader() {
        return this.hasHeaders("Subject");
    }

    @Override
    public void setSubjectHeader(SubjectHeader subjectHeader) throws IllegalArgumentException {
        this.setHeader(subjectHeader, true);
    }

    @Override
    public void removeSubjectHeader() {
        this.removeHeaders("Subject");
    }

    @Override
    public int getVersionMajor() throws SipParseException {
        String major = this.m_requestLine.getSipVersion().getVersionMajor();
        try {
            int ret = Integer.parseInt(major);
            return ret;
        }
        catch (NumberFormatException ex) {
            throw new SipParseException(ex.getMessage());
        }
    }

    @Override
    public void setVersion(int versionMajor, int versionMinor) throws SipParseException {
        super.setVersion(versionMajor, versionMinor);
        this.m_requestLine.setSipVersion(this.getVersion());
    }

    @Override
    public boolean isRequest() {
        return true;
    }

    @Override
    public String getStartLine() {
        return this.m_requestLine.toString();
    }

    @Override
    public void writeStartLineToBuffer(CharsBuffer buffer, boolean network) {
        this.m_requestLine.writeToCharBuffer(buffer, network);
    }

    public void setRequestLine(RequestLine requestLine) {
        this.m_requestLine = requestLine;
    }

    @Override
    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public String toString() {
        return super.toString();
    }

    public long getOriginInviteTransaction() {
        return -1L;
    }
}

