/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jbatch.jms.internal.listener.impl;

import com.ibm.jbatch.container.ws.WSJobRepository;
import com.ibm.tx.jta.XAResourceNotAvailableException;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ejbcontainer.mdb.MDBMessageEndpointFactory;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.jbatch.jms.internal.BatchOperationGroup;
import com.ibm.ws.jbatch.jms.internal.listener.BatchJmsEndpointListener;
import com.ibm.ws.jbatch.jms.internal.listener.impl.BaseMessageEndpointFactory;
import com.ibm.ws.jbatch.jms.internal.listener.impl.BatchJmsExecutor;
import com.ibm.ws.jbatch.jms.internal.listener.impl.ExtendedMessageEndpointHandler;
import com.ibm.ws.jbatch.jms.internal.listener.impl.MessageEndpointHandler;
import com.ibm.ws.jca.service.EndpointActivationService;
import com.ibm.ws.jca.service.WSMessageEndpointFactory;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.tx.rrs.RRSXAResourceFactory;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.MessageListener;
import jakarta.resource.ResourceException;
import jakarta.resource.spi.UnavailableException;
import jakarta.resource.spi.endpoint.MessageEndpoint;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.rmi.RemoteException;
import java.util.Optional;
import java.util.Properties;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
class MessageEndpointFactoryImpl
extends BaseMessageEndpointFactory
implements WSMessageEndpointFactory,
MDBMessageEndpointFactory {
    private static final TraceComponent tc = Tr.register(MessageEndpointFactoryImpl.class, (String)"wsbatch", null);
    private final String jndiName;
    private Object activationSpec;
    boolean isRRSTransactional = false;
    BatchJmsExecutor.EndpointActivationServiceInfo endpointActivationServiceInfo;
    private boolean runtimeActivated;
    private final J2EEName j2eeName;
    private final RRSXAResourceFactory xaResourceFactory;
    private final ConnectionFactory connFactory;
    private final BatchOperationGroup opGroup;
    private final WSJobRepository jobRepo;
    static final long serialVersionUID = -2427314020223257012L;

    public MessageEndpointFactoryImpl(J2EEName j2eeName, RRSXAResourceFactory xaResourceFactory, ConnectionFactory connFactory, BatchOperationGroup opGroup, WSJobRepository jobRepo, String jndiName) throws RemoteException {
        super(MessageEndpointFactoryImpl.getProxyConstructor());
        this.j2eeName = j2eeName;
        this.xaResourceFactory = xaResourceFactory;
        this.connFactory = connFactory;
        this.opGroup = opGroup;
        this.jobRepo = jobRepo;
        this.jndiName = jndiName;
    }

    @Override
    public J2EEName getJ2EEName() {
        return this.j2eeName;
    }

    @Override
    XAResource getRRSXAResource(Xid xid) throws XAResourceNotAvailableException {
        return this.xaResourceFactory.getTwoPhaseXAResource(xid);
    }

    @Override
    ConnectionFactory getConnectionFactory() {
        if (this.runtimeActivated) {
            return this.connFactory;
        }
        throw new IllegalStateException("ManagedEndpointFactoryImpl = " + this + " is not active, but getConnectionFactory() called.");
    }

    @Override
    BatchOperationGroup getBatchOperationGroup() {
        return this.opGroup;
    }

    @Override
    WSJobRepository getWSJobRepository() {
        return this.jobRepo;
    }

    /*
     * WARNING - void declaration
     */
    private static Constructor<?> getProxyConstructor() throws RemoteException {
        Class<?> proxyClass = MessageEndpointFactoryImpl.createMessageEndpointProxy();
        try {
            return proxyClass.getConstructor(InvocationHandler.class);
        }
        catch (Throwable throwable) {
            void t;
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.jbatch.jms.internal.listener.impl.MessageEndpointFactoryImpl", (String)"167", null, (Object[])new Object[0]);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"MEF initialization failed for JmsEndpointListener.", (Object[])new Object[0]);
            }
            throw new RemoteException("Unable to get Proxy Constructor Method object", (Throwable)t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void activateEndpointInternal() throws ResourceException {
        ResourceException rex;
        block25: {
            BatchJmsExecutor.EndpointActivationServiceInfo info = this.endpointActivationServiceInfo;
            EndpointActivationService eas = info.service;
            boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
            Object asInstance = null;
            rex = null;
            if (eas == null && info.id.endsWith(info.id)) {
                Tr.warning((TraceComponent)tc, (String)"warning.batch.activation.spec.not.found", (Object[])new Object[]{this.j2eeName.getComponent(), info.id});
                return;
            }
            try {
                boolean activate;
                Constructor constructor = this.ivProxyCTOR;
                synchronized (constructor) {
                    if (this.ivState == 0) {
                        activate = true;
                        this.ivState = 1;
                    } else if (this.ivState == 2) {
                        if (isTraceOn && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"endpoint already active", (Object[])new Object[0]);
                        }
                        activate = false;
                    } else {
                        activate = false;
                        rex = new ResourceException("can not activate until deactivate completes");
                    }
                }
                if (!activate) break block25;
                Properties actProp = new Properties();
                String authAlias = null;
                asInstance = eas.activateEndpoint((WSMessageEndpointFactory)this, actProp, authAlias, this.jndiName, null, null);
                Constructor constructor2 = this.ivProxyCTOR;
                synchronized (constructor2) {
                    this.activationSpec = asInstance;
                    this.ivState = (byte)2;
                    this.ivProxyCTOR.notifyAll();
                }
                this.setRRSTransactional();
            }
            catch (ResourceException actProp) {
                void ex;
                FFDCFilter.processException((Throwable)actProp, (String)"com.ibm.ws.jbatch.jms.internal.listener.impl.MessageEndpointFactoryImpl", (String)"233", (Object)this, (Object[])new Object[0]);
                Constructor authAlias = this.ivProxyCTOR;
                synchronized (authAlias) {
                    this.ivState = 0;
                    this.activationSpec = null;
                    this.unsetRecoveryID();
                }
                rex = ex;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("error activateEndpointInternal " + ex.toString()), (Object[])new Object[0]);
                    Exception link1 = (Exception)ex.getCause();
                    if (link1 != null) {
                        Tr.debug((Object)this, (TraceComponent)tc, (String)("error activateEndpointInternal link1 " + link1.toString()), (Object[])new Object[0]);
                        Exception link2 = (Exception)link1.getCause();
                        if (link2 != null) {
                            Tr.debug((Object)this, (TraceComponent)tc, (String)("error activateEndpointInternal link2 " + link2.toString()), (Object[])new Object[0]);
                        }
                    }
                }
            }
            catch (Throwable ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.jbatch.jms.internal.listener.impl.MessageEndpointFactoryImpl", (String)"252", (Object)this, (Object[])new Object[0]);
                Constructor constructor = this.ivProxyCTOR;
                synchronized (constructor) {
                    this.ivState = 0;
                    this.activationSpec = null;
                    this.unsetRecoveryID();
                }
                rex = new ResourceException(ex);
            }
        }
        if (rex != null) {
            throw rex;
        }
        this.runtimeActivated = true;
    }

    @FFDCIgnore(value={NoSuchMethodException.class})
    private void setRRSTransactional() {
        try {
            this.ivRRSTransactional = (Boolean)this.activationSpec.getClass().getMethod("getRRSTransactional", new Class[0]).invoke(this.activationSpec, new Object[0]);
        }
        catch (NoSuchMethodException x) {
            this.ivRRSTransactional = false;
        }
        catch (Exception x) {
            FFDCFilter.processException((Throwable)x, (String)"com.ibm.ws.jbatch.jms.internal.listener.impl.MessageEndpointFactoryImpl", (String)"278", (Object)this, (Object[])new Object[0]);
            boolean bl = this.ivRRSTransactional = x == null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)(" setRRSTransactional set isRRSTransactional=" + this.isRRSTransactional), (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    void deactivateEndpointInternal() throws ResourceException {
        if (!this.runtimeActivated) {
            return;
        }
        this.runtimeActivated = false;
        EndpointActivationService eas = this.endpointActivationServiceInfo.service;
        ResourceException rex = null;
        Constructor constructor = this.ivProxyCTOR;
        synchronized (constructor) {
            if (this.ivState == 2 || this.ivState == 4) {
                this.ivState = (byte)3;
                if (null == this.activationSpec) {
                    this.ivState = 0;
                }
            } else if (this.ivState != 0) {
                throw new ResourceException("illegal state for deactivate");
            }
        }
        if (eas != null && this.isEndpointActive()) {
            try {
                eas.deactivateEndpoint(this.activationSpec, (WSMessageEndpointFactory)this);
            }
            catch (ResourceException resourceException) {
                void ex;
                FFDCFilter.processException((Throwable)resourceException, (String)"com.ibm.ws.jbatch.jms.internal.listener.impl.MessageEndpointFactoryImpl", (String)"333", (Object)this, (Object[])new Object[0]);
                rex = ex;
            }
            catch (Throwable ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.jbatch.jms.internal.listener.impl.MessageEndpointFactoryImpl", (String)"335", (Object)this, (Object[])new Object[0]);
                rex = new ResourceException(ex);
            }
        }
        constructor = this.ivProxyCTOR;
        synchronized (constructor) {
            this.activationSpec = null;
            this.unsetRecoveryID();
            this.ivState = 0;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("ENDPOINT_DEACTIVATED " + this.getJ2EEName().toString()), (Object[])new Object[0]);
        }
        if (rex != null) {
            throw rex;
        }
    }

    void unsetRecoveryID() {
        this.ivRecoveryId = 0;
        this.ivRecoveryIdKnown = false;
    }

    @Override
    boolean isEndpointActive() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("activationSpec : " + this.activationSpec), (Object[])new Object[0]);
        }
        return this.activationSpec != null;
    }

    private static Class<?> createMessageEndpointProxy() {
        Class[] interfaces = new Class[]{MessageEndpoint.class, MessageListener.class};
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("createMessageEndpointProxy: CLASSLOADER= " + BatchJmsEndpointListener.class.getClassLoader()), (Object[])new Object[0]);
        }
        return Proxy.getProxyClass(BatchJmsEndpointListener.class.getClassLoader(), interfaces);
    }

    @Trivial
    public void messageEndpointForcefullyDeactivated() {
        throw new UnsupportedOperationException();
    }

    @Override
    MessageEndpointHandler createEndpointHandler() {
        return Optional.ofNullable(this.xaResourceFactory).map(f -> this.createExtendedEndpointHandler()).orElseGet(() -> super.createEndpointHandler());
    }

    private MessageEndpointHandler createExtendedEndpointHandler() {
        return new ExtendedMessageEndpointHandler(this, this.ivRecoveryId, this.ivRRSTransactional);
    }

    @Override
    public MessageEndpoint createEndpoint(XAResource xaResource, long timeout) throws UnavailableException {
        return super.createEndpoint(xaResource, 0L);
    }

    public int getMaxEndpoints() {
        return this.endpointActivationServiceInfo.maxEndpoints;
    }

    public Object getMDBKey() {
        return this.j2eeName;
    }

    public String getActivationSpecId() {
        return this.endpointActivationServiceInfo.id;
    }

    public void setJCAVersion(int majorJCAVer, int minorJCAVer) {
        this.majorJCAVersion = majorJCAVer;
        this.minorJCAVersion = minorJCAVer;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("MessageEndpointFactoryImpl.setJCAVersionJCA: Version " + this.majorJCAVersion + "." + this.minorJCAVersion + " is set"), (Object[])new Object[0]);
        }
    }
}

