/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.openapi.impl.validation;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.microprofile.openapi.impl.validation.OASValidationResult;
import com.ibm.ws.microprofile.openapi.impl.validation.TypeValidator;
import com.ibm.ws.microprofile.openapi.impl.validation.ValidationHelper;
import com.ibm.ws.microprofile.openapi.impl.validation.ValidatorUtils;
import com.ibm.ws.microprofile.openapi.utils.OpenAPIModelWalker;
import org.eclipse.microprofile.openapi.models.Operation;
import org.eclipse.microprofile.openapi.models.responses.APIResponses;

public class OperationValidator
extends TypeValidator<Operation> {
    private static final TraceComponent tc = Tr.register(OperationValidator.class);
    private static final OperationValidator INSTANCE = new OperationValidator();

    public static OperationValidator getInstance() {
        return INSTANCE;
    }

    private OperationValidator() {
    }

    @Override
    public void validate(ValidationHelper helper, OpenAPIModelWalker.Context context, String key, Operation t) {
        if (t != null) {
            String id = t.getOperationId();
            if (id != null && helper.addOperationId(id)) {
                String message = Tr.formatMessage((TraceComponent)tc, (String)"operationIdsMustBeUnique", (Object[])new Object[]{id});
                helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation("operationId"), message));
            }
            APIResponses responses = t.getResponses();
            ValidatorUtils.validateRequiredField(responses, context, "responses").ifPresent(helper::addValidationEvent);
        }
    }
}

