/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.security.crypto.ec;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.security.spec.ECParameterSpec;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotLive;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.security.crypto.ec.EnhancedECParameterSpec;
import org.opensaml.security.crypto.ec.NamedCurve;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NamedCurveRegistry {
    private final Logger log = LoggerFactory.getLogger(NamedCurveRegistry.class);
    private Map<String, NamedCurve> byOID = new HashMap<String, NamedCurve>();
    private Map<String, NamedCurve> byURI = new HashMap<String, NamedCurve>();
    private Map<String, NamedCurve> byName = new HashMap<String, NamedCurve>();
    private Map<EnhancedECParameterSpec, NamedCurve> byParamSpec = new HashMap<EnhancedECParameterSpec, NamedCurve>();

    public void register(@Nonnull NamedCurve curve) {
        Constraint.isNotNull((Object)curve, (String)"NamedCurve was null in registration");
        this.byOID.put(curve.getObjectIdentifier(), curve);
        this.byURI.put(curve.getURI(), curve);
        this.byName.put(curve.getName(), curve);
        this.byParamSpec.put(new EnhancedECParameterSpec(curve.getParameterSpec()), curve);
        this.log.debug("Registered NamedCurve: {}", (Object)curve);
    }

    public void deregister(@Nonnull NamedCurve curve) {
        Constraint.isNotNull((Object)curve, (String)"NamedCurve was null in deregistration");
        this.byOID.remove(curve.getObjectIdentifier());
        this.byURI.remove(curve.getURI());
        this.byName.remove(curve.getName());
        this.byParamSpec.remove(new EnhancedECParameterSpec(curve.getParameterSpec()));
        this.log.debug("Deregistered NamedCurve: {}", (Object)curve);
    }

    public void deregisterByOID(@Nonnull String oid) {
        Constraint.isNotNull((Object)oid, (String)"OID was null in NamedCurve deregistration");
        NamedCurve curve = this.getByOID(oid);
        if (curve != null) {
            this.deregister(curve);
        }
    }

    public void deregisterByURI(@Nonnull String uri) {
        Constraint.isNotNull((Object)uri, (String)"URI was null in NamedCurve deregistration");
        NamedCurve curve = this.getByURI(uri);
        if (curve != null) {
            this.deregister(curve);
        }
    }

    public void deregisterByName(@Nonnull String name) {
        Constraint.isNotNull((Object)name, (String)"Name was null in NamedCurve deregistration");
        NamedCurve curve = this.getByName(name);
        if (curve != null) {
            this.deregister(curve);
        }
    }

    public void deregisterByParameterSpec(@Nonnull ECParameterSpec spec) {
        Constraint.isNotNull((Object)spec, (String)"ECParameterSpec was null in NamedCurve deregistration");
        NamedCurve curve = this.getByParameterSpec(spec);
        if (curve != null) {
            this.deregister(curve);
        }
    }

    public void clear() {
        this.byOID.clear();
        this.byURI.clear();
        this.byName.clear();
        this.byParamSpec.clear();
        this.log.debug("Cleared all registered NamedCurves");
    }

    @Nonnull
    @NonnullElements
    @Unmodifiable
    @NotLive
    public Set<NamedCurve> getRegisteredCurves() {
        return Collections.unmodifiableSet(new HashSet<NamedCurve>(this.byOID.values()));
    }

    @Nullable
    public NamedCurve getByOID(@Nonnull String oid) {
        Constraint.isNotNull((Object)oid, (String)"OID was null in NamedCurve lookup");
        return this.byOID.get(StringSupport.trimOrNull((String)oid));
    }

    @Nullable
    public NamedCurve getByURI(@Nonnull String uri) {
        Constraint.isNotNull((Object)uri, (String)"URI was null in NamedCurve lookup");
        return this.byURI.get(StringSupport.trimOrNull((String)uri));
    }

    @Nullable
    public NamedCurve getByName(@Nonnull String name) {
        Constraint.isNotNull((Object)name, (String)"Name was null in NamedCurve lookup");
        return this.byName.get(StringSupport.trimOrNull((String)name));
    }

    @Nullable
    public NamedCurve getByParameterSpec(@Nonnull ECParameterSpec spec) {
        Constraint.isNotNull((Object)spec, (String)"ECParameterSpec was null in NamedCurve lookup");
        return this.byParamSpec.get(new EnhancedECParameterSpec(spec));
    }
}

