/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.openidconnect.clients.common;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.openidconnect.clients.common.OidcSessionCache;
import com.ibm.ws.security.openidconnect.clients.common.OidcSessionInfo;
import com.ibm.ws.security.openidconnect.clients.common.OidcSessionsStore;
import io.openliberty.security.common.osgi.SecurityOSGiUtils;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class InMemoryOidcSessionCache
implements OidcSessionCache {
    private static final TraceComponent tc = Tr.register(InMemoryOidcSessionCache.class, (String)"OPENIDCONNECT", (String)"com.ibm.ws.security.openidconnect.clients.common.resources.OidcClientMessages");
    private final PrivilegedAction<ScheduledExecutorService> getScheduledExecutorServiceAction = new GetScheduledExecutorServiceAction();
    private final Set<OidcSessionInfo> invalidatedSessions = Collections.synchronizedSet(new HashSet());
    private final Map<String, OidcSessionsStore> subToOidcSessionsMap = Collections.synchronizedMap(new HashMap());
    private long timeoutInMilliSeconds = 600000L;
    private ScheduledExecutorService evictionSchedule;
    static final long serialVersionUID = -2338483342107592340L;

    public InMemoryOidcSessionCache() {
        this(0L);
    }

    public InMemoryOidcSessionCache(long timeoutInMilliSeconds) {
        if (timeoutInMilliSeconds > 0L) {
            this.timeoutInMilliSeconds = timeoutInMilliSeconds;
        }
        this.scheduleEvictionTask();
    }

    private void scheduleEvictionTask() {
        this.evictionSchedule = System.getSecurityManager() == null ? this.getScheduledExecutorService() : AccessController.doPrivileged(this.getScheduledExecutorServiceAction);
        if (this.evictionSchedule != null) {
            this.evictionSchedule.scheduleWithFixedDelay(new EvictionTask(), this.timeoutInMilliSeconds, this.timeoutInMilliSeconds, TimeUnit.MILLISECONDS);
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Failed to obtain a ScheduledExecutorService", (Object[])new Object[0]);
        }
    }

    @Override
    public boolean insertSession(OidcSessionInfo oidcSessionInfo) {
        String sub = oidcSessionInfo.getSub();
        if (sub == null || sub.isEmpty()) {
            return false;
        }
        if (!this.subToOidcSessionsMap.containsKey(sub)) {
            OidcSessionsStore httpSessionsStore = new OidcSessionsStore();
            this.subToOidcSessionsMap.put(sub, httpSessionsStore);
        }
        String sid = oidcSessionInfo.getSid();
        OidcSessionsStore httpSessionsStore = this.subToOidcSessionsMap.get(sub);
        return httpSessionsStore.insertSession(sid, oidcSessionInfo);
    }

    @Override
    public Map<String, OidcSessionsStore> getSubMap() {
        return this.subToOidcSessionsMap;
    }

    @Override
    public boolean invalidateSession(String sub, String sid) {
        if (sub == null || sub.isEmpty()) {
            return false;
        }
        OidcSessionsStore httpSessionsStore = this.subToOidcSessionsMap.get(sub);
        if (httpSessionsStore == null) {
            return false;
        }
        OidcSessionInfo sessionToInvalidate = httpSessionsStore.getSession(sid);
        if (sessionToInvalidate == null) {
            return false;
        }
        httpSessionsStore.removeSession(sid);
        return this.invalidatedSessions.add(sessionToInvalidate);
    }

    @Override
    public boolean invalidateSessionBySessionId(String sub, String oidcSessionId) {
        if (sub == null || sub.isEmpty()) {
            return false;
        }
        OidcSessionsStore httpSessionsStore = this.subToOidcSessionsMap.get(sub);
        if (httpSessionsStore == null) {
            return false;
        }
        OidcSessionInfo sessionAssociatedWithSessionId = httpSessionsStore.removeSessionBySessionId(oidcSessionId);
        if (sessionAssociatedWithSessionId == null) {
            return false;
        }
        return this.invalidatedSessions.add(sessionAssociatedWithSessionId);
    }

    @Override
    public boolean invalidateSessions(String sub) {
        if (sub == null || sub.isEmpty()) {
            return false;
        }
        OidcSessionsStore httpSessionsStore = this.subToOidcSessionsMap.get(sub);
        if (httpSessionsStore == null) {
            return false;
        }
        List<OidcSessionInfo> sessionsToInvalidate = httpSessionsStore.getSessions();
        if (sessionsToInvalidate.size() == 0) {
            return false;
        }
        httpSessionsStore.removeSessions();
        return this.invalidatedSessions.addAll(sessionsToInvalidate);
    }

    @Override
    public boolean removeInvalidatedSession(OidcSessionInfo sessionInfo) {
        return this.invalidatedSessions.remove(sessionInfo);
    }

    @Override
    public boolean isSessionInvalidated(OidcSessionInfo sessionInfo) {
        return this.invalidatedSessions.contains(sessionInfo);
    }

    private ScheduledExecutorService getScheduledExecutorService() {
        return (ScheduledExecutorService)SecurityOSGiUtils.getService(this.getClass(), ScheduledExecutorService.class);
    }

    protected synchronized void evictStaleEntries() {
        this.removeExpiredSessionsFromInvalidatedSessions();
        this.removeExpiredSessionsFromSubToOidcSessionsMap();
    }

    private void removeExpiredSessionsFromInvalidatedSessions() {
        for (OidcSessionInfo session : this.invalidatedSessions) {
            long expInMillis;
            long currentTimeInMillis = System.currentTimeMillis();
            if (currentTimeInMillis <= (expInMillis = new Long(session.getExp()).longValue())) continue;
            this.invalidatedSessions.remove(session);
        }
    }

    private void removeExpiredSessionsFromSubToOidcSessionsMap() {
        for (String sub : this.subToOidcSessionsMap.keySet()) {
            OidcSessionsStore store = this.subToOidcSessionsMap.get(sub);
            List<OidcSessionInfo> sessions = store.getSessions();
            for (OidcSessionInfo session : sessions) {
                long expInMillis;
                long currentTimeInMillis = System.currentTimeMillis();
                if (currentTimeInMillis <= (expInMillis = new Long(session.getExp()).longValue())) continue;
                store.removeSessionBySessionId(session.getSessionId());
            }
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private class GetScheduledExecutorServiceAction
    implements PrivilegedAction<ScheduledExecutorService> {
        static final long serialVersionUID = -3691773903187582572L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private GetScheduledExecutorServiceAction() {
        }

        @Override
        public ScheduledExecutorService run() {
            return InMemoryOidcSessionCache.this.getScheduledExecutorService();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.openidconnect.clients.common.InMemoryOidcSessionCache$GetScheduledExecutorServiceAction", GetScheduledExecutorServiceAction.class, (String)"OPENIDCONNECT", (String)"com.ibm.ws.security.openidconnect.clients.common.resources.OidcClientMessages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private class EvictionTask
    implements Runnable {
        static final long serialVersionUID = 9089039944801656261L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private EvictionTask() {
        }

        @Override
        public void run() {
            InMemoryOidcSessionCache.this.evictStaleEntries();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.openidconnect.clients.common.InMemoryOidcSessionCache$EvictionTask", EvictionTask.class, (String)"OPENIDCONNECT", (String)"com.ibm.ws.security.openidconnect.clients.common.resources.OidcClientMessages");
        }
    }
}

