/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.saml.sso20.rs;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.security.WebTrustAssociationFailedException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.saml.Constants;
import com.ibm.ws.security.saml.SsoConfig;
import com.ibm.ws.security.saml.SsoRequest;
import com.ibm.ws.security.saml.SsoSamlService;
import com.ibm.ws.security.saml.error.SamlException;
import com.ibm.ws.security.saml.sso20.binding.BasicMessageContext;
import com.ibm.ws.security.saml.sso20.internal.Authenticator;
import com.ibm.ws.security.saml.sso20.internal.utils.UserData;
import com.ibm.ws.security.saml.sso20.rs.RsSamlConsumer;
import com.ibm.ws.security.saml.sso20.token.Saml20TokenImpl;
import com.ibm.wsspi.security.tai.TAIResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.Subject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opensaml.saml.saml2.core.Assertion;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class RsSamlHandler {
    private static TraceComponent tc = Tr.register(RsSamlHandler.class, (String)"SAML20", (String)"com.ibm.ws.security.saml.sso20.internal.resources.SamlSso20Messages");
    String strHeaderName = null;
    HttpServletRequest request;
    HttpServletResponse response;
    SsoSamlService ssoSamlService;
    static final long serialVersionUID = -8595336360299759123L;

    public RsSamlHandler(HttpServletRequest request, HttpServletResponse response, SsoSamlService ssoSamlService) {
        this.request = request;
        this.response = response;
        this.ssoSamlService = ssoSamlService;
    }

    public Constants.SamlSsoVersion getSamlVersion() {
        return Constants.SamlSsoVersion.SAMLSSO20;
    }

    /*
     * WARNING - void declaration
     */
    public Map<String, Object> handleRequest() throws SamlException {
        HashMap<String, Object> results = new HashMap<String, Object>();
        TAIResult forbiddenTaiResult = this.badResult(401);
        try {
            if (this.request == null || this.response == null || this.ssoSamlService == null) {
                throw new Exception("Missing Parameter: request:" + this.request + " response:" + this.response + " ssoSamlService:" + this.ssoSamlService);
            }
            SsoRequest samlRequest = new SsoRequest(this.ssoSamlService.getProviderId(), Constants.EndpointType.ACS, this.request, Constants.SamlSsoVersion.SAMLSSO20, this.ssoSamlService);
            this.request.setAttribute("Saml20Request", (Object)samlRequest);
            return this.handleRequest(this.request, this.response, samlRequest);
        }
        catch (SamlException samlRequest) {
            void e;
            FFDCFilter.processException((Throwable)samlRequest, (String)"com.ibm.ws.security.saml.sso20.rs.RsSamlHandler", (String)"85", (Object)this, (Object[])new Object[0]);
            results.put(SamlException.class.getName(), e.getErrorMessage());
            results.put(TAIResult.class.getName(), forbiddenTaiResult);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.saml.sso20.rs.RsSamlHandler", (String)"88", (Object)this, (Object[])new Object[0]);
            results.put(Exception.class.getName(), e);
            results.put(TAIResult.class.getName(), forbiddenTaiResult);
        }
        return results;
    }

    public Map<String, Object> handleRequest(HttpServletRequest request, HttpServletResponse response, SsoRequest samlRequest) throws SamlException {
        HashMap<String, Object> results = new HashMap<String, Object>();
        SsoSamlService samlService = samlRequest.getSsoSamlService();
        SsoConfig rsSamlConfig = samlRequest.getSsoConfig();
        ArrayList<String> headerNames = rsSamlConfig.getHeaderNames();
        this.strHeaderName = rsSamlConfig.getHeaderName();
        String headerContent = this.getHeaderContent(request, headerNames);
        if (headerContent == null || headerContent.isEmpty()) {
            throw new SamlException("RS_EMPTY_SAML_ASSERTION", null, new Object[]{this.strHeaderName});
        }
        RsSamlConsumer<?, ?, ?> rsSamlConsumer = RsSamlConsumer.getInstance();
        BasicMessageContext<?, ?> rsSamlContext = rsSamlConsumer.handleSAMLResponse(request, response, samlService, samlRequest, headerContent);
        Assertion validAssertion = rsSamlContext.getValidatedAssertion();
        Saml20TokenImpl saml20Token = new Saml20TokenImpl(validAssertion);
        UserData userData = new UserData(validAssertion, saml20Token);
        Authenticator authenticator = new Authenticator(samlService, userData);
        TAIResult taiResult = authenticator.authenticateRS(request, response, samlRequest);
        results.put(TAIResult.class.getName(), taiResult);
        if (taiResult.getStatus() == 200) {
            Subject subject = taiResult.getSubject();
            results.put(Subject.class.getName(), subject);
        }
        return results;
    }

    String getHeaderContent(HttpServletRequest request, ArrayList<String> headerNames) {
        String headerContent = this.getHdrNameContent(request, headerNames);
        if (headerContent == null) {
            headerContent = this.getAuthorizationContent(request, headerNames);
        }
        return headerContent;
    }

    protected String getAuthorizationContent(HttpServletRequest request, ArrayList<String> headerNames) {
        String tokenValue = null;
        String authorizationContent = request.getHeader("Authorization");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("header content of Authorization: " + authorizationContent), (Object[])new Object[0]);
        }
        if (authorizationContent != null && !(authorizationContent = authorizationContent.trim()).isEmpty()) {
            for (String headerName : headerNames) {
                int iSize = headerName.length();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("headerName '" + headerName + "'"), (Object[])new Object[0]);
                }
                if (!authorizationContent.startsWith(headerName) || authorizationContent.length() <= iSize + 1) continue;
                Character charSeparator = Character.valueOf(authorizationContent.charAt(iSize));
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("separator '" + charSeparator + "'"), (Object[])new Object[0]);
                }
                if (charSeparator.charValue() != '=' && charSeparator.charValue() != ' ') continue;
                this.strHeaderName = headerName;
                tokenValue = authorizationContent.substring(iSize + 1);
                if (tokenValue != null && tokenValue.startsWith("\"")) {
                    tokenValue = tokenValue.substring(1, tokenValue.length() - 1);
                }
                if (!tc.isDebugEnabled()) break;
                Tr.debug((TraceComponent)tc, (String)("[" + tokenValue + "]"), (Object[])new Object[0]);
                break;
            }
        }
        return tokenValue;
    }

    protected String getHdrNameContent(HttpServletRequest request, ArrayList<String> headerNames) {
        String tokenValue = null;
        int iCnt = 0;
        for (String headerName : headerNames) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("headerName(" + iCnt++ + "): '" + headerName + "'"), (Object[])new Object[0]);
            }
            if ((tokenValue = request.getHeader(headerName)) == null) continue;
            this.strHeaderName = headerName;
            if (!tc.isDebugEnabled()) break;
            Tr.debug((TraceComponent)tc, (String)("Header name found in request: " + headerName), (Object[])new Object[0]);
            break;
        }
        return tokenValue;
    }

    /*
     * WARNING - void declaration
     */
    TAIResult badResult(int iStatus) throws SamlException {
        TAIResult result = null;
        try {
            result = TAIResult.create((int)iStatus);
        }
        catch (WebTrustAssociationFailedException webTrustAssociationFailedException) {
            void e;
            FFDCFilter.processException((Throwable)webTrustAssociationFailedException, (String)"com.ibm.ws.security.saml.sso20.rs.RsSamlHandler", (String)"246", (Object)this, (Object[])new Object[]{iStatus});
            throw new SamlException((Exception)e);
        }
        return result;
    }
}

