/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.impl.persistence;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.common.crypto.CryptoUtils;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.Duration;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Stream;
import org.ehcache.CachePersistenceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
final class FileUtils {
    private static final Logger Log;
    private static final int DEL = 127;
    private static final char ESCAPE = '%';
    private static final Set<Character> ILLEGALS;
    static final long serialVersionUID = -5074356890306755081L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    FileUtils() {
    }

    static void createLocationIfRequiredAndVerify(File rootDirectory) {
        if (!rootDirectory.exists()) {
            if (!rootDirectory.mkdirs()) {
                throw new IllegalArgumentException("Directory couldn't be created: " + rootDirectory.getAbsolutePath());
            }
        } else if (!rootDirectory.isDirectory()) {
            throw new IllegalArgumentException("Location is not a directory: " + rootDirectory.getAbsolutePath());
        }
        if (!rootDirectory.canWrite()) {
            throw new IllegalArgumentException("Location isn't writable: " + rootDirectory.getAbsolutePath());
        }
    }

    static File createSubDirectory(File mainDirectory, String name) throws CachePersistenceException {
        FileUtils.validateName(name);
        File subDirectory = new File(mainDirectory, name);
        FileUtils.create(subDirectory);
        return subDirectory;
    }

    static void validateName(String name) {
        if (!name.matches("[a-zA-Z0-9\\-_]+")) {
            throw new IllegalArgumentException("Name is invalid for persistence context: " + name);
        }
    }

    static void create(File directory) throws CachePersistenceException {
        if (directory.isDirectory()) {
            Log.debug("Reusing {}", (Object)directory.getAbsolutePath());
        } else if (directory.mkdir()) {
            Log.debug("Created {}", (Object)directory.getAbsolutePath());
        } else if (directory.isDirectory()) {
            Log.debug("Reusing {}", (Object)directory.getAbsolutePath());
        } else {
            throw new CachePersistenceException("Unable to create or reuse directory: " + directory.getAbsolutePath());
        }
    }

    static boolean tryRecursiveDelete(File file) {
        try {
            org.terracotta.utilities.io.Files.deleteTree(file.toPath(), Duration.ofMillis(250L), FileUtils::gc);
            return true;
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"org.ehcache.impl.persistence.FileUtils", (String)"108", null, (Object[])new Object[]{file});
            return false;
        }
    }

    private static void gc() {
        System.gc();
        System.runFinalization();
    }

    static String safeIdentifier(String name) {
        if (CryptoUtils.isFips140_3EnabledWithBetaGuard()) {
            return FileUtils.safeIdentifier(name, false);
        }
        return FileUtils.safeIdentifier(name, true);
    }

    static String safeIdentifier(String name, boolean withSha1) {
        int len = name.length();
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char c = name.charAt(i);
            if (c <= ' ' || c >= '\u007f' || ILLEGALS.contains(Character.valueOf(c)) || c == '%') {
                sb.append('%');
                sb.append(String.format("%04x", c));
                continue;
            }
            sb.append(c);
        }
        if (withSha1) {
            sb.append("_").append(FileUtils.sha1(name));
        }
        return sb.toString();
    }

    private static String sha1(String input) {
        StringBuilder sb = new StringBuilder();
        for (byte b : FileUtils.getSha1Digest().digest(input.getBytes(StandardCharsets.UTF_8))) {
            sb.append(Integer.toHexString((b & 0xF0) >>> 4));
            sb.append(Integer.toHexString(b & 0xF));
        }
        return sb.toString();
    }

    /*
     * WARNING - void declaration
     */
    private static MessageDigest getSha1Digest() {
        try {
            MessageDigest digest = CryptoUtils.isFips140_3EnabledWithBetaGuard() ? MessageDigest.getInstance("SHA-256") : MessageDigest.getInstance("SHA-1");
            return digest;
        }
        catch (NoSuchAlgorithmException digest) {
            void e;
            FFDCFilter.processException((Throwable)digest, (String)"org.ehcache.impl.persistence.FileUtils", (String)"168", null, (Object[])new Object[0]);
            throw new AssertionError((Object)e.getMessage());
        }
    }

    /*
     * WARNING - void declaration
     */
    static boolean isDirectoryEmpty(Path path) throws IOException {
        boolean bl;
        block8: {
            Stream<Path> entries2 = Files.list(path);
            try {
                boolean bl2 = bl = !entries2.findFirst().isPresent();
                if (entries2 == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    FFDCFilter.processException((Throwable)throwable, (String)"org.ehcache.impl.persistence.FileUtils", (String)"174", null, (Object[])new Object[]{path});
                    if (entries2 != null) {
                        try {
                            entries2.close();
                        }
                        catch (Throwable throwable2) {
                            FFDCFilter.processException((Throwable)throwable2, (String)"org.ehcache.impl.persistence.FileUtils", (String)"174", null, (Object[])new Object[]{path});
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (UncheckedIOException entries2) {
                    void e;
                    FFDCFilter.processException((Throwable)entries2, (String)"org.ehcache.impl.persistence.FileUtils", (String)"176", null, (Object[])new Object[]{path});
                    throw e.getCause();
                }
            }
            entries2.close();
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"org.ehcache.impl.persistence.FileUtils", FileUtils.class, null, null);
        Log = LoggerFactory.getLogger(FileUtils.class);
        ILLEGALS = new HashSet<Character>();
        ILLEGALS.add(Character.valueOf('/'));
        ILLEGALS.add(Character.valueOf('\\'));
        ILLEGALS.add(Character.valueOf('<'));
        ILLEGALS.add(Character.valueOf('>'));
        ILLEGALS.add(Character.valueOf(':'));
        ILLEGALS.add(Character.valueOf('\"'));
        ILLEGALS.add(Character.valueOf('|'));
        ILLEGALS.add(Character.valueOf('?'));
        ILLEGALS.add(Character.valueOf('*'));
        ILLEGALS.add(Character.valueOf('.'));
    }
}

