/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxb;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.annotation.XmlAccessOrder;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorOrder;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlList;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import javax.xml.namespace.QName;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.jaxb.JAXBBeanInfo;
import org.apache.cxf.common.jaxb.JAXBContextProxy;
import org.apache.cxf.common.jaxb.JAXBUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.common.xmlschema.SchemaCollection;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.jaxb.JAXBDataBinding;
import org.apache.cxf.jaxb.Utils;
import org.apache.cxf.service.ServiceModelVisitor;
import org.apache.cxf.service.model.FaultInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.service.model.SchemaInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaAnnotated;
import org.apache.ws.commons.schema.XmlSchemaComplexType;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaForm;
import org.apache.ws.commons.schema.XmlSchemaParticle;
import org.apache.ws.commons.schema.XmlSchemaSequence;
import org.apache.ws.commons.schema.XmlSchemaSequenceMember;
import org.apache.ws.commons.schema.XmlSchemaSimpleType;
import org.apache.ws.commons.schema.XmlSchemaSimpleTypeContent;
import org.apache.ws.commons.schema.XmlSchemaSimpleTypeList;
import org.apache.ws.commons.schema.XmlSchemaType;
import org.apache.ws.commons.schema.utils.NamespaceMap;
import org.apache.ws.commons.schema.utils.NamespacePrefixList;

@TraceObjectField(fieldName="LOG", fieldDesc="Ljava/util/logging/Logger;")
class JAXBSchemaInitializer
extends ServiceModelVisitor {
    private static final Logger LOG = LogUtils.getLogger(JAXBSchemaInitializer.class);
    private SchemaCollection schemas;
    private JAXBContextProxy context;
    private final boolean qualifiedSchemas;
    static final long serialVersionUID = 1854110037177020534L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    JAXBSchemaInitializer(ServiceInfo serviceInfo, SchemaCollection col, JAXBContext context, boolean q, String defaultNs) {
        super(serviceInfo);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBSchemaInitializer", "<init>", new Object[]{serviceInfo, col, context, q, defaultNs});
        }
        this.schemas = col;
        this.context = JAXBUtils.createJAXBContextProxy((JAXBContext)context, (SchemaCollection)serviceInfo.getXmlSchemaCollection(), (String)defaultNs);
        this.qualifiedSchemas = q;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxb.JAXBSchemaInitializer", "<init>", (Object)this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    static Class<?> getArrayComponentType(Type cls) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBSchemaInitializer", "getArrayComponentType", new Object[]{cls});
        }
        if (cls instanceof Class) {
            if (((Class)cls).isArray()) {
                Class<?> clazz = ((Class)cls).getComponentType();
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    clazz = clazz;
                    LOG.exiting("org.apache.cxf.jaxb.JAXBSchemaInitializer", "getArrayComponentType", clazz);
                }
                return clazz;
            }
            Class clazz = (Class)cls;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                clazz = clazz;
                LOG.exiting("org.apache.cxf.jaxb.JAXBSchemaInitializer", "getArrayComponentType", clazz);
            }
            return clazz;
        }
        if (cls instanceof ParameterizedType) {
            int n = 0;
            Type[] typeArray = ((ParameterizedType)cls).getActualTypeArguments();
            int n2 = typeArray.length;
            if (n < n2) {
                Type t2 = typeArray[n];
                Class<?> clazz = JAXBSchemaInitializer.getArrayComponentType(t2);
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    clazz = clazz;
                    LOG.exiting("org.apache.cxf.jaxb.JAXBSchemaInitializer", "getArrayComponentType", clazz);
                }
                return clazz;
            }
        } else if (cls instanceof GenericArrayType) {
            GenericArrayType gt = (GenericArrayType)cls;
            Class ct = (Class)gt.getGenericComponentType();
            Class<?> clazz = Array.newInstance(ct, 0).getClass();
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                clazz = clazz;
                LOG.exiting("org.apache.cxf.jaxb.JAXBSchemaInitializer", "getArrayComponentType", clazz);
            }
            return clazz;
        }
        Class<?> clazz = null;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            clazz = clazz;
            LOG.exiting("org.apache.cxf.jaxb.JAXBSchemaInitializer", "getArrayComponentType", clazz);
        }
        return clazz;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JAXBBeanInfo getBeanInfo(Type cls) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBSchemaInitializer", "getBeanInfo", new Object[]{cls});
        }
        boolean isLoggableFinest = LOG.isLoggable(Level.FINEST);
        if (cls instanceof Class) {
            if (((Class)cls).isArray()) {
                if (isLoggableFinest) {
                    LOG.finest("getBeanInfo: Class is array");
                }
                JAXBBeanInfo jAXBBeanInfo = this.getBeanInfo(((Class)cls).getComponentType());
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    jAXBBeanInfo = jAXBBeanInfo;
                    LOG.exiting("org.apache.cxf.jaxb.JAXBSchemaInitializer", "getBeanInfo", jAXBBeanInfo);
                }
                return jAXBBeanInfo;
            }
            if (isLoggableFinest) {
                LOG.finest("getBeanInfo: Class is not array");
            }
            JAXBBeanInfo jAXBBeanInfo = this.getBeanInfo((Class)cls);
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                jAXBBeanInfo = jAXBBeanInfo;
                LOG.exiting("org.apache.cxf.jaxb.JAXBSchemaInitializer", "getBeanInfo", jAXBBeanInfo);
            }
            return jAXBBeanInfo;
        }
        if (cls instanceof ParameterizedType) {
            int n;
            int n2;
            Type[] t3;
            if (isLoggableFinest) {
                LOG.finest("getBeanInfo: Class is ParameterizedType");
                t3 = ((ParameterizedType)cls).getActualTypeArguments();
                LOG.finest("getBeanInfo: ParameterizedType arguments size:" + (t3 != null ? Integer.valueOf(t3.length) : "null"));
            }
            if ((n2 = 0) < (n = (t3 = ((ParameterizedType)cls).getActualTypeArguments()).length)) {
                Type t2 = t3[n2];
                if (isLoggableFinest) {
                    LOG.finest("getBeanInfo: Invoking getBeanInfo for type: " + (t2 != null ? t2.getTypeName() : "null"));
                }
                JAXBBeanInfo jAXBBeanInfo = this.getBeanInfo(t2);
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    jAXBBeanInfo = jAXBBeanInfo;
                    LOG.exiting("org.apache.cxf.jaxb.JAXBSchemaInitializer", "getBeanInfo", jAXBBeanInfo);
                }
                return jAXBBeanInfo;
            }
        } else if (cls instanceof GenericArrayType) {
            GenericArrayType gt = (GenericArrayType)cls;
            Class<?> ct = (Class<?>)gt.getGenericComponentType();
            ct = Array.newInstance(ct, 0).getClass();
            if (isLoggableFinest) {
                LOG.finest("getBeanInfo: GenericArrayType class ct: " + (ct != null ? ct.getName() : "null"));
            }
            JAXBBeanInfo jAXBBeanInfo = this.getBeanInfo(ct);
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                jAXBBeanInfo = jAXBBeanInfo;
                LOG.exiting("org.apache.cxf.jaxb.JAXBSchemaInitializer", "getBeanInfo", jAXBBeanInfo);
            }
            return jAXBBeanInfo;
        }
        if (isLoggableFinest) {
            LOG.finest("getBeanInfo: returning null");
        }
        JAXBBeanInfo jAXBBeanInfo = null;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            jAXBBeanInfo = jAXBBeanInfo;
            LOG.exiting("org.apache.cxf.jaxb.JAXBSchemaInitializer", "getBeanInfo", jAXBBeanInfo);
        }
        return jAXBBeanInfo;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JAXBBeanInfo getBeanInfo(Class<?> cls) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBSchemaInitializer", "getBeanInfo", new Object[]{cls});
        }
        JAXBBeanInfo jAXBBeanInfo = JAXBSchemaInitializer.getBeanInfo(this.context, cls);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            jAXBBeanInfo = jAXBBeanInfo;
            LOG.exiting("org.apache.cxf.jaxb.JAXBSchemaInitializer", "getBeanInfo", jAXBBeanInfo);
        }
        return jAXBBeanInfo;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static JAXBBeanInfo getBeanInfo(JAXBContextProxy context, Class<?> cls) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBSchemaInitializer", "getBeanInfo", new Object[]{context, cls});
        }
        JAXBBeanInfo jAXBBeanInfo = JAXBUtils.getBeanInfo((JAXBContextProxy)context, cls);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            jAXBBeanInfo = jAXBBeanInfo;
            LOG.exiting("org.apache.cxf.jaxb.JAXBSchemaInitializer", "getBeanInfo", jAXBBeanInfo);
        }
        return jAXBBeanInfo;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void begin(MessagePartInfo part) {
        boolean hasType;
        JAXBBeanInfo beanInfo;
        Annotation[] anns;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBSchemaInitializer", "begin", new Object[]{part});
        }
        if (part.getTypeQName() != null || part.getElementQName() != null) {
            this.checkForExistence(part);
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.exiting("org.apache.cxf.jaxb.JAXBSchemaInitializer", "begin");
            }
            return;
        }
        Class<?> clazz = part.getTypeClass();
        if (clazz == null) {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.exiting("org.apache.cxf.jaxb.JAXBSchemaInitializer", "begin");
            }
            return;
        }
        boolean isFromWrapper = part.getMessageInfo().getOperation().isUnwrapped();
        boolean isList = false;
        if (clazz.isArray()) {
            if (isFromWrapper && !Byte.TYPE.equals(clazz.getComponentType())) {
                clazz = clazz.getComponentType();
            } else if (!isFromWrapper) {
                for (Annotation a : anns = (Annotation[])part.getProperty("parameter.annotations")) {
                    if (!(a instanceof XmlList)) continue;
                    part.setProperty("honor.jaxb.annotations", (Object)Boolean.TRUE);
                    clazz = clazz.getComponentType();
                    isList = true;
                }
            }
        }
        anns = (Annotation[])part.getProperty("parameter.annotations");
        XmlJavaTypeAdapter jta = JAXBSchemaInitializer.findFromTypeAdapter(this.context, clazz, anns);
        JAXBBeanInfo jtaBeanInfo = null;
        if (jta != null) {
            jtaBeanInfo = JAXBSchemaInitializer.findFromTypeAdapter(this.context, jta.value());
        }
        if (jtaBeanInfo != (beanInfo = this.getBeanInfo(clazz)) && jta != null) {
            beanInfo = jtaBeanInfo;
            if (anns == null) {
                anns = new Annotation[]{jta};
            } else {
                boolean found = false;
                for (Annotation t : anns) {
                    if (t != jta) continue;
                    found = true;
                }
                if (!found) {
                    Annotation[] tmp = new Annotation[anns.length + 1];
                    System.arraycopy(anns, 0, tmp, 0, anns.length);
                    tmp[anns.length] = jta;
                    anns = tmp;
                }
            }
            part.setProperty("parameter.annotations", (Object)anns);
            part.setProperty("honor.jaxb.annotations", (Object)Boolean.TRUE);
        }
        if (beanInfo == null) {
            if (Exception.class.isAssignableFrom(clazz)) {
                QName name = (QName)part.getMessageInfo().getProperty("elementName");
                part.setElementQName(name);
                this.buildExceptionType(part, clazz);
            }
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.exiting("org.apache.cxf.jaxb.JAXBSchemaInitializer", "begin");
            }
            return;
        }
        boolean isElement = beanInfo.isElement() && !Boolean.TRUE.equals(part.getMessageInfo().getOperation().getProperty("operation.force.types"));
        boolean bl = hasType = !beanInfo.getTypeNames().isEmpty();
        if (isElement && isFromWrapper && hasType) {
            isElement = false;
        }
        part.setElement(isElement);
        if (isElement) {
            QName name = new QName(beanInfo.getElementNamespaceURI(null), beanInfo.getElementLocalName(null));
            XmlSchemaElement el = this.schemas.getElementByQName(name);
            if (el != null && el.getRef().getTarget() != null) {
                part.setTypeQName(el.getRef().getTargetQName());
            } else {
                part.setElementQName(name);
            }
            part.setXmlSchema((XmlSchemaAnnotated)el);
        } else {
            QName typeName = this.getTypeName(beanInfo);
            if (typeName != null) {
                XmlSchemaType type = this.schemas.getTypeByQName(typeName);
                if (isList && type instanceof XmlSchemaSimpleType) {
                    XmlSchemaSimpleType simpleType = new XmlSchemaSimpleType(type.getParent(), false);
                    XmlSchemaSimpleTypeList list = new XmlSchemaSimpleTypeList();
                    XmlSchemaSimpleType stype = (XmlSchemaSimpleType)type;
                    list.setItemTypeName(stype.getQName());
                    simpleType.setContent((XmlSchemaSimpleTypeContent)list);
                    part.setXmlSchema((XmlSchemaAnnotated)simpleType);
                    if (part.getConcreteName() == null) {
                        part.setConcreteName(new QName(null, part.getName().getLocalPart()));
                    }
                } else {
                    part.setTypeQName(typeName);
                    part.setXmlSchema((XmlSchemaAnnotated)type);
                }
            }
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxb.JAXBSchemaInitializer", "begin");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    static XmlJavaTypeAdapter findFromTypeAdapter(JAXBContextProxy context, Class<?> clazz, Annotation[] anns) {
        JAXBBeanInfo ret;
        XmlJavaTypeAdapter xjta;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBSchemaInitializer", "findFromTypeAdapter", new Object[]{context, clazz, anns});
        }
        if (anns != null) {
            for (Annotation a : anns) {
                JAXBBeanInfo ret2;
                if (!XmlJavaTypeAdapter.class.isAssignableFrom(a.annotationType()) || (ret2 = JAXBSchemaInitializer.findFromTypeAdapter(context, ((XmlJavaTypeAdapter)a).value())) == null) continue;
                XmlJavaTypeAdapter xmlJavaTypeAdapter = (XmlJavaTypeAdapter)a;
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    xmlJavaTypeAdapter = xmlJavaTypeAdapter;
                    LOG.exiting("org.apache.cxf.jaxb.JAXBSchemaInitializer", "findFromTypeAdapter", xmlJavaTypeAdapter);
                }
                return xmlJavaTypeAdapter;
            }
        }
        if (clazz != null && (xjta = clazz.getAnnotation(XmlJavaTypeAdapter.class)) != null && (ret = JAXBSchemaInitializer.findFromTypeAdapter(context, xjta.value())) != null) {
            XmlJavaTypeAdapter xmlJavaTypeAdapter = xjta;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                xmlJavaTypeAdapter = xmlJavaTypeAdapter;
                LOG.exiting("org.apache.cxf.jaxb.JAXBSchemaInitializer", "findFromTypeAdapter", xmlJavaTypeAdapter);
            }
            return xmlJavaTypeAdapter;
        }
        XmlJavaTypeAdapter xmlJavaTypeAdapter = null;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            xmlJavaTypeAdapter = xmlJavaTypeAdapter;
            LOG.exiting("org.apache.cxf.jaxb.JAXBSchemaInitializer", "findFromTypeAdapter", xmlJavaTypeAdapter);
        }
        return xmlJavaTypeAdapter;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    static JAXBBeanInfo findFromTypeAdapter(JAXBContextProxy context, Class<? extends XmlAdapter> aclass) {
        Type tp;
        Class<? extends XmlAdapter> c2;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBSchemaInitializer", "findFromTypeAdapter", new Object[]{context, aclass});
        }
        Type sp = c2.getGenericSuperclass();
        for (c2 = aclass; !XmlAdapter.class.equals(c2) && c2 != null; c2 = c2.getSuperclass()) {
            sp = c2.getGenericSuperclass();
        }
        if (sp instanceof ParameterizedType && (tp = ((ParameterizedType)sp).getActualTypeArguments()[0]) instanceof Class) {
            JAXBBeanInfo jAXBBeanInfo = JAXBSchemaInitializer.getBeanInfo(context, (Class)tp);
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                jAXBBeanInfo = jAXBBeanInfo;
                LOG.exiting("org.apache.cxf.jaxb.JAXBSchemaInitializer", "findFromTypeAdapter", jAXBBeanInfo);
            }
            return jAXBBeanInfo;
        }
        JAXBBeanInfo jAXBBeanInfo = null;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            jAXBBeanInfo = jAXBBeanInfo;
            LOG.exiting("org.apache.cxf.jaxb.JAXBSchemaInitializer", "findFromTypeAdapter", jAXBBeanInfo);
        }
        return jAXBBeanInfo;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private QName getTypeName(JAXBBeanInfo beanInfo) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBSchemaInitializer", "getTypeName", new Object[]{beanInfo});
        }
        Iterator itr = beanInfo.getTypeNames().iterator();
        if (!itr.hasNext()) {
            QName qName = null;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                qName = qName;
                LOG.exiting("org.apache.cxf.jaxb.JAXBSchemaInitializer", "getTypeName", qName);
            }
            return qName;
        }
        QName qName = (QName)itr.next();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            qName = qName;
            LOG.exiting("org.apache.cxf.jaxb.JAXBSchemaInitializer", "getTypeName", qName);
        }
        return qName;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void checkForExistence(MessagePartInfo part) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBSchemaInitializer", "checkForExistence", new Object[]{part});
        }
        QName qn = part.getElementQName();
        if (qn != null) {
            XmlSchemaElement el = this.schemas.getElementByQName(qn);
            if (el == null) {
                JAXBBeanInfo beanInfo;
                Class<?> clazz = part.getTypeClass();
                if (clazz == null) {
                    if (LOG != null && LOG.isLoggable(Level.FINER)) {
                        LOG.exiting("org.apache.cxf.jaxb.JAXBSchemaInitializer", "checkForExistence");
                    }
                    return;
                }
                boolean isFromWrapper = part.getMessageInfo().getOperation().isUnwrapped();
                if (isFromWrapper && clazz.isArray() && !Byte.TYPE.equals(clazz.getComponentType())) {
                    clazz = clazz.getComponentType();
                }
                if ((beanInfo = this.getBeanInfo(clazz)) == null) {
                    if (Exception.class.isAssignableFrom(clazz)) {
                        QName name = (QName)part.getMessageInfo().getProperty("elementName");
                        part.setElementQName(name);
                        this.buildExceptionType(part, clazz);
                    }
                    if (LOG != null && LOG.isLoggable(Level.FINER)) {
                        LOG.exiting("org.apache.cxf.jaxb.JAXBSchemaInitializer", "checkForExistence");
                    }
                    return;
                }
                QName typeName = this.getTypeName(beanInfo);
                this.createBridgeXsElement(part, qn, typeName);
            } else if (part.getXmlSchema() == null) {
                part.setXmlSchema((XmlSchemaAnnotated)el);
            }
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxb.JAXBSchemaInitializer", "checkForExistence");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void createBridgeXsElement(MessagePartInfo part, QName qn, QName typeName) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBSchemaInitializer", "createBridgeXsElement", new Object[]{part, qn, typeName});
        }
        SchemaInfo schemaInfo = this.serviceInfo.getSchema(qn.getNamespaceURI());
        if (schemaInfo != null) {
            XmlSchemaElement el = schemaInfo.getElementByQName(qn);
            if (el == null) {
                this.createXsElement(schemaInfo.getSchema(), part, typeName, schemaInfo);
            } else if (!typeName.equals(el.getSchemaTypeName())) {
                throw new Fault(new Message("CANNOT_CREATE_ELEMENT", LOG, new Object[]{qn, typeName, el.getSchemaTypeName()}));
            }
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.exiting("org.apache.cxf.jaxb.JAXBSchemaInitializer", "createBridgeXsElement");
            }
            return;
        }
        XmlSchema schema = this.schemas.newXmlSchemaInCollection(qn.getNamespaceURI());
        if (this.qualifiedSchemas) {
            schema.setElementFormDefault(XmlSchemaForm.QUALIFIED);
        }
        schemaInfo = new SchemaInfo(qn.getNamespaceURI(), this.qualifiedSchemas, false);
        schemaInfo.setSchema(schema);
        this.createXsElement(schema, part, typeName, schemaInfo);
        NamespaceMap nsMap = new NamespaceMap();
        nsMap.add("tns", schema.getTargetNamespace());
        nsMap.add("xsd", "http://www.w3.org/2001/XMLSchema");
        schema.setNamespaceContext((NamespacePrefixList)nsMap);
        this.serviceInfo.addSchema(schemaInfo);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxb.JAXBSchemaInitializer", "createBridgeXsElement");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private XmlSchemaElement createXsElement(XmlSchema schema, MessagePartInfo part, QName typeName, SchemaInfo schemaInfo) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBSchemaInitializer", "createXsElement", new Object[]{schema, part, typeName, schemaInfo});
        }
        XmlSchemaElement el = new XmlSchemaElement(schema, true);
        el.setName(part.getElementQName().getLocalPart());
        el.setNillable(true);
        el.setSchemaTypeName(typeName);
        part.setXmlSchema((XmlSchemaAnnotated)el);
        schemaInfo.setElement(null);
        XmlSchemaElement xmlSchemaElement = el;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            xmlSchemaElement = xmlSchemaElement;
            LOG.exiting("org.apache.cxf.jaxb.JAXBSchemaInitializer", "createXsElement", xmlSchemaElement);
        }
        return xmlSchemaElement;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void end(FaultInfo fault) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBSchemaInitializer", "end", new Object[]{fault});
        }
        boolean isLoggableFinest = LOG.isLoggable(Level.FINEST);
        if (isLoggableFinest) {
            LOG.finest("end: Processing Fault: " + fault.getFaultName());
        }
        MessagePartInfo part = fault.getFirstMessagePart();
        if (isLoggableFinest) {
            LOG.finest("end: Fault message part: " + (part != null ? part.toString() : "null"));
        }
        Class cls = part.getTypeClass();
        Class cl2 = (Class)fault.getProperty(Class.class.getName());
        if (isLoggableFinest) {
            LOG.finest("end: part type cls: " + (cls != null ? cls.getName() : "null"));
            LOG.finest("end: Fault property class cl2: " + (cl2 != null ? cl2.getName() : "null"));
        }
        if (cls != cl2) {
            JAXBBeanInfo beanInfo;
            QName name = (QName)fault.getProperty("elementName");
            part.setElementQName(name);
            if (isLoggableFinest) {
                LOG.finest("end: elementName: " + name);
            }
            if ((beanInfo = this.getBeanInfo(cls)) == null) {
                throw new Fault(new Message("NO_BEAN_INFO", LOG, new Object[]{cls.getName()}));
            }
            SchemaInfo schemaInfo = this.serviceInfo.getSchema(part.getElementQName().getNamespaceURI());
            if (schemaInfo != null && !this.isExistSchemaElement(schemaInfo.getSchema(), part.getElementQName())) {
                XmlSchemaElement el = new XmlSchemaElement(schemaInfo.getSchema(), true);
                el.setName(part.getElementQName().getLocalPart());
                el.setNillable(true);
                schemaInfo.setElement(null);
                Iterator itr = beanInfo.getTypeNames().iterator();
                if (!itr.hasNext()) {
                    if (LOG != null && LOG.isLoggable(Level.FINER)) {
                        LOG.exiting("org.apache.cxf.jaxb.JAXBSchemaInitializer", "end");
                    }
                    return;
                }
                QName typeName = (QName)itr.next();
                if (isLoggableFinest) {
                    LOG.finest("end: setSchemaTypeName to: " + typeName);
                }
                el.setSchemaTypeName(typeName);
            }
        } else if (part.getXmlSchema() == null) {
            Method[] methods;
            try {
                cls.getConstructor(String.class);
            }
            catch (Exception e) {
                try {
                    cls.getConstructor(new Class[0]);
                }
                catch (Exception e2) {
                    if (LOG != null && LOG.isLoggable(Level.FINER)) {
                        LOG.exiting("org.apache.cxf.jaxb.JAXBSchemaInitializer", "end");
                    }
                    return;
                }
            }
            SchemaInfo schemaInfo = this.serviceInfo.getSchema(part.getElementQName().getNamespaceURI());
            if (schemaInfo == null || this.isExistSchemaElement(schemaInfo.getSchema(), part.getElementQName())) {
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    LOG.exiting("org.apache.cxf.jaxb.JAXBSchemaInitializer", "end");
                }
                return;
            }
            XmlSchemaElement el = new XmlSchemaElement(schemaInfo.getSchema(), true);
            el.setName(part.getElementQName().getLocalPart());
            schemaInfo.setElement(null);
            part.setXmlSchema((XmlSchemaAnnotated)el);
            XmlSchemaComplexType ct = new XmlSchemaComplexType(schemaInfo.getSchema(), false);
            el.setSchemaType((XmlSchemaType)ct);
            XmlSchemaSequence seq = new XmlSchemaSequence();
            ct.setParticle((XmlSchemaParticle)seq);
            for (Method m : methods = cls.getMethods()) {
                if (!m.getName().startsWith("get") && !m.getName().startsWith("is")) continue;
                int beginIdx = m.getName().startsWith("get") ? 3 : 2;
                try {
                    m.getDeclaringClass().getMethod("set" + m.getName().substring(beginIdx), m.getReturnType());
                    JAXBBeanInfo beanInfo = this.getBeanInfo(m.getReturnType());
                    if (beanInfo != null) {
                        el = new XmlSchemaElement(schemaInfo.getSchema(), false);
                        el.setName(m.getName().substring(beginIdx));
                        Iterator itr = beanInfo.getTypeNames().iterator();
                        if (!itr.hasNext()) {
                            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                                LOG.exiting("org.apache.cxf.jaxb.JAXBSchemaInitializer", "end");
                            }
                            return;
                        }
                        QName typeName = (QName)itr.next();
                        el.setSchemaTypeName(typeName);
                    }
                    seq.getItems().add(el);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxb.JAXBSchemaInitializer", "end");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void buildExceptionType(MessagePartInfo part, Class<?> cls) {
        JAXBBeanInfo beanInfo;
        Type type;
        String faultTypeName;
        XmlSchema schema;
        XmlSchemaType existingType;
        NamespaceMap nsMap;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBSchemaInitializer", "buildExceptionType", new Object[]{part, cls});
        }
        SchemaInfo schemaInfo = null;
        for (SchemaInfo s : this.serviceInfo.getSchemas()) {
            if (!s.getNamespaceURI().equals(part.getElementQName().getNamespaceURI())) continue;
            schemaInfo = s;
            break;
        }
        XmlAccessorOrder xmlAccessorOrder = cls.getAnnotation(XmlAccessorOrder.class);
        XmlType xmlTypeAnno = cls.getAnnotation(XmlType.class);
        Object[] propertyOrder = null;
        boolean respectXmlTypeNS = false;
        XmlSchema faultBeanSchema = null;
        if (xmlTypeAnno != null && !StringUtils.isEmpty((String)xmlTypeAnno.namespace()) && !xmlTypeAnno.namespace().equals(part.getElementQName().getNamespaceURI())) {
            respectXmlTypeNS = true;
            nsMap = new NamespaceMap();
            nsMap.add("tns", xmlTypeAnno.namespace());
            nsMap.add("xsd", "http://www.w3.org/2001/XMLSchema");
            SchemaInfo faultBeanSchemaInfo = this.createSchemaIfNeeded(xmlTypeAnno.namespace(), nsMap);
            faultBeanSchema = faultBeanSchemaInfo.getSchema();
        }
        if (xmlTypeAnno != null && xmlTypeAnno.propOrder().length > 0) {
            propertyOrder = xmlTypeAnno.propOrder();
        }
        if (schemaInfo == null) {
            nsMap = new NamespaceMap();
            nsMap.add("tns", part.getElementQName().getNamespaceURI());
            nsMap.add("xsd", "http://www.w3.org/2001/XMLSchema");
            schemaInfo = this.createSchemaIfNeeded(part.getElementQName().getNamespaceURI(), nsMap);
        }
        if ((existingType = (schema = schemaInfo.getSchema()).getTypeByName(faultTypeName = xmlTypeAnno != null && !StringUtils.isEmpty((String)xmlTypeAnno.name()) ? xmlTypeAnno.name() : part.getElementQName().getLocalPart())) != null) {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.exiting("org.apache.cxf.jaxb.JAXBSchemaInitializer", "buildExceptionType");
            }
            return;
        }
        XmlSchemaElement el = new XmlSchemaElement(schema, true);
        el.setName(part.getElementQName().getLocalPart());
        part.setXmlSchema((XmlSchemaAnnotated)el);
        schemaInfo.setElement(null);
        if (respectXmlTypeNS) {
            schema = faultBeanSchema;
        }
        XmlSchemaComplexType ct = new XmlSchemaComplexType(schema, true);
        ct.setName(faultTypeName);
        el.setSchemaTypeName(ct.getQName());
        XmlSchemaSequence seq = new XmlSchemaSequence();
        ct.setParticle((XmlSchemaParticle)seq);
        String namespace = part.getElementQName().getNamespaceURI();
        XmlAccessType accessType = Utils.getXmlAccessType(cls);
        for (Field f : Utils.getFields(cls, accessType)) {
            type = Utils.getFieldType(f);
            if (type == null && f.getGenericType() instanceof ParameterizedType) {
                type = f.getGenericType();
            }
            if (this.generateGenericType(type)) {
                this.buildGenericElements(schema, seq, f);
                continue;
            }
            beanInfo = this.getBeanInfo(type);
            if (beanInfo == null) continue;
            XmlElement xmlElementAnno = f.getAnnotation(XmlElement.class);
            this.addElement(schema, seq, beanInfo, new QName(namespace, f.getName()), JAXBSchemaInitializer.isArray(type), xmlElementAnno);
        }
        for (Method m : Utils.getGetters(cls, accessType)) {
            type = Utils.getMethodReturnType(m);
            if (type == null && m.getGenericReturnType() instanceof ParameterizedType) {
                type = m.getGenericReturnType();
            }
            if (this.generateGenericType(type)) {
                this.buildGenericElements(schema, seq, m, type);
                continue;
            }
            beanInfo = this.getBeanInfo(type);
            if (beanInfo == null) continue;
            int idx = m.getName().startsWith("get") ? 3 : 2;
            String name = m.getName().substring(idx);
            name = Character.toLowerCase(name.charAt(0)) + name.substring(1);
            XmlElement xmlElementAnno = m.getAnnotation(XmlElement.class);
            this.addElement(schema, seq, beanInfo, new QName(namespace, name), JAXBSchemaInitializer.isArray(type), xmlElementAnno);
        }
        if (Exception.class.isAssignableFrom(cls)) {
            this.addExceptionMessage(cls, schema, seq);
        }
        if (propertyOrder != null) {
            if (propertyOrder.length == seq.getItems().size()) {
                this.sortItems(seq, (String[])propertyOrder);
            } else if (propertyOrder.length > 1 || propertyOrder.length == 1 && !propertyOrder[0].isEmpty()) {
                LOG.log(Level.WARNING, "propOrder in @XmlType doesn't define all schema elements :" + Arrays.toString(propertyOrder));
            }
        }
        if (xmlAccessorOrder != null && xmlAccessorOrder.value().equals((Object)XmlAccessOrder.ALPHABETICAL) && propertyOrder == null) {
            this.sort(seq);
        }
        this.schemas.addCrossImports();
        part.setProperty(JAXBDataBinding.class.getName() + ".CUSTOM_EXCEPTION", (Object)Boolean.TRUE);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxb.JAXBSchemaInitializer", "buildExceptionType");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void addExceptionMessage(Class<?> cls, XmlSchema schema, XmlSchemaSequence seq) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBSchemaInitializer", "addExceptionMessage", new Object[]{cls, schema, seq});
        }
        try {
            Method m = cls.getMethod("getMessage", new Class[0]);
            if (!m.isAnnotationPresent(XmlTransient.class) && m.getDeclaringClass().equals(Throwable.class)) {
                JAXBBeanInfo beanInfo = this.getBeanInfo(String.class);
                XmlSchemaElement exEle = new XmlSchemaElement(schema, false);
                exEle.setName("message");
                exEle.setSchemaTypeName(this.getTypeName(beanInfo));
                exEle.setMinOccurs(0L);
                seq.getItems().add(exEle);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxb.JAXBSchemaInitializer", "addExceptionMessage");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private boolean generateGenericType(Type type) {
        ParameterizedType paramType;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBSchemaInitializer", "generateGenericType", new Object[]{type});
        }
        if (type instanceof ParameterizedType && (paramType = (ParameterizedType)type).getActualTypeArguments().length > 1) {
            boolean bl = true;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                bl = bl;
                LOG.exiting("org.apache.cxf.jaxb.JAXBSchemaInitializer", "generateGenericType", bl);
            }
            return bl;
        }
        boolean bl = false;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.jaxb.JAXBSchemaInitializer", "generateGenericType", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void buildGenericElements(XmlSchema schema, XmlSchemaSequence seq, Field f) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBSchemaInitializer", "buildGenericElements", new Object[]{schema, seq, f});
        }
        XmlSchemaComplexType generics = new XmlSchemaComplexType(schema, true);
        Type type = f.getGenericType();
        String rawType = ((ParameterizedType)type).getRawType().toString();
        String typeName = StringUtils.uncapitalize((String)rawType.substring(rawType.lastIndexOf(46) + 1));
        generics.setName(typeName);
        Class<?> genericsClass = f.getType();
        this.buildGenericSeq(schema, generics, genericsClass);
        String name = Character.toLowerCase(f.getName().charAt(0)) + f.getName().substring(1);
        XmlSchemaElement newel = new XmlSchemaElement(schema, false);
        newel.setName(name);
        newel.setSchemaTypeName(generics.getQName());
        newel.setMinOccurs(0L);
        if (!seq.getItems().contains(newel)) {
            seq.getItems().add(newel);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxb.JAXBSchemaInitializer", "buildGenericElements");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void buildGenericElements(XmlSchema schema, XmlSchemaSequence seq, Method m, Type type) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBSchemaInitializer", "buildGenericElements", new Object[]{schema, seq, m, type});
        }
        String rawType = ((ParameterizedType)type).getRawType().toString();
        String typeName = StringUtils.uncapitalize((String)rawType.substring(rawType.lastIndexOf(46) + 1));
        XmlSchemaComplexType generics = (XmlSchemaComplexType)schema.getTypeByName(typeName);
        if (generics == null) {
            generics = new XmlSchemaComplexType(schema, true);
            generics.setName(typeName);
        }
        Class<?> genericsClass = m.getReturnType();
        this.buildGenericSeq(schema, generics, genericsClass);
        int idx = m.getName().startsWith("get") ? 3 : 2;
        String name = m.getName().substring(idx);
        name = Character.toLowerCase(name.charAt(0)) + name.substring(1);
        XmlSchemaElement newel = new XmlSchemaElement(schema, false);
        newel.setName(name);
        newel.setSchemaTypeName(generics.getQName());
        newel.setMinOccurs(0L);
        if (!seq.getItems().contains(newel)) {
            seq.getItems().add(newel);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxb.JAXBSchemaInitializer", "buildGenericElements");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void buildGenericSeq(XmlSchema schema, XmlSchemaComplexType generics, Class<?> genericsClass) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBSchemaInitializer", "buildGenericSeq", new Object[]{schema, generics, genericsClass});
        }
        XmlSchemaSequence genericsSeq = new XmlSchemaSequence();
        generics.setParticle((XmlSchemaParticle)genericsSeq);
        XmlAccessType accessType = Utils.getXmlAccessType(genericsClass);
        for (Field f : Utils.getFields(genericsClass, accessType)) {
            if (!(f.getGenericType() instanceof TypeVariable)) continue;
            String genericName = Character.toLowerCase(f.getName().charAt(0)) + f.getName().substring(1);
            XmlSchemaElement genericEle = new XmlSchemaElement(schema, false);
            genericEle.setName(genericName);
            genericEle.setMinOccurs(0L);
            JAXBBeanInfo anyBean = JAXBSchemaInitializer.getBeanInfo(this.context, f.getType());
            Iterator itr = anyBean.getTypeNames().iterator();
            if (!itr.hasNext()) {
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    LOG.exiting("org.apache.cxf.jaxb.JAXBSchemaInitializer", "buildGenericSeq");
                }
                return;
            }
            QName typeName = (QName)itr.next();
            genericEle.setSchemaTypeName(typeName);
            genericsSeq.getItems().add(genericEle);
        }
        for (Method genericMethod : Utils.getGetters(genericsClass, accessType)) {
            if (!(genericMethod.getGenericReturnType() instanceof TypeVariable)) continue;
            int idx = genericMethod.getName().startsWith("get") ? 3 : 2;
            String genericName = genericMethod.getName().substring(idx);
            genericName = Character.toLowerCase(genericName.charAt(0)) + genericName.substring(1);
            XmlSchemaElement genericEle = new XmlSchemaElement(schema, false);
            genericEle.setName(genericName);
            genericEle.setMinOccurs(0L);
            JAXBBeanInfo anyBean = JAXBSchemaInitializer.getBeanInfo(this.context, genericMethod.getReturnType());
            Iterator itr = anyBean.getTypeNames().iterator();
            if (!itr.hasNext()) {
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    LOG.exiting("org.apache.cxf.jaxb.JAXBSchemaInitializer", "buildGenericSeq");
                }
                return;
            }
            QName typeName = (QName)itr.next();
            genericEle.setSchemaTypeName(typeName);
            genericsSeq.getItems().add(genericEle);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxb.JAXBSchemaInitializer", "buildGenericSeq");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    static boolean isArray(Type cls) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBSchemaInitializer", "isArray", new Object[]{cls});
        }
        if (cls instanceof Class) {
            boolean bl = ((Class)cls).isArray();
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                bl = bl;
                LOG.exiting("org.apache.cxf.jaxb.JAXBSchemaInitializer", "isArray", bl);
            }
            return bl;
        }
        if (cls instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)cls;
            boolean bl = pt.getActualTypeArguments().length == 1 && pt.getRawType() instanceof Class && Collection.class.isAssignableFrom((Class)pt.getRawType());
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                bl = bl;
                LOG.exiting("org.apache.cxf.jaxb.JAXBSchemaInitializer", "isArray", bl);
            }
            return bl;
        }
        if (cls instanceof GenericArrayType) {
            boolean bl = true;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                bl = bl;
                LOG.exiting("org.apache.cxf.jaxb.JAXBSchemaInitializer", "isArray", bl);
            }
            return bl;
        }
        boolean bl = false;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.jaxb.JAXBSchemaInitializer", "isArray", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void addElement(XmlSchema schema, XmlSchemaSequence seq, JAXBBeanInfo beanInfo, QName name, boolean isArray, XmlElement xmlElementAnno) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBSchemaInitializer", "addElement", new Object[]{schema, seq, beanInfo, name, isArray, xmlElementAnno});
        }
        XmlSchemaElement el = new XmlSchemaElement(schema, false);
        if (isArray) {
            el.setMinOccurs(0L);
            el.setMaxOccurs(Long.MAX_VALUE);
        } else if (xmlElementAnno == null) {
            el.setMinOccurs(0L);
            el.setNillable(false);
        } else {
            el.setNillable(xmlElementAnno.nillable());
            int minOccurs = xmlElementAnno.required() ? 1 : 0;
            el.setMinOccurs((long)minOccurs);
        }
        if (beanInfo.isElement()) {
            QName ename = new QName(beanInfo.getElementNamespaceURI(null), beanInfo.getElementLocalName(null));
            XmlSchemaElement el2 = this.schemas.getElementByQName(ename);
            el.setNillable(false);
            el.getRef().setTargetQName(el2.getQName());
        } else {
            if (xmlElementAnno != null && !StringUtils.isEmpty((String)xmlElementAnno.name())) {
                el.setName(xmlElementAnno.name());
            } else {
                el.setName(name.getLocalPart());
            }
            Iterator itr = beanInfo.getTypeNames().iterator();
            if (!itr.hasNext()) {
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    LOG.exiting("org.apache.cxf.jaxb.JAXBSchemaInitializer", "addElement");
                }
                return;
            }
            QName typeName = (QName)itr.next();
            el.setSchemaTypeName(typeName);
        }
        seq.getItems().add(el);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxb.JAXBSchemaInitializer", "addElement");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private SchemaInfo createSchemaIfNeeded(String namespace, NamespaceMap nsMap) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBSchemaInitializer", "createSchemaIfNeeded", new Object[]{namespace, nsMap});
        }
        SchemaInfo schemaInfo = this.serviceInfo.getSchema(namespace);
        if (schemaInfo == null) {
            XmlSchema xmlSchema = this.schemas.newXmlSchemaInCollection(namespace);
            if (this.qualifiedSchemas) {
                xmlSchema.setElementFormDefault(XmlSchemaForm.QUALIFIED);
            }
            xmlSchema.setNamespaceContext((NamespacePrefixList)nsMap);
            schemaInfo = new SchemaInfo(namespace);
            schemaInfo.setSchema(xmlSchema);
            this.serviceInfo.addSchema(schemaInfo);
        }
        SchemaInfo schemaInfo2 = schemaInfo;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            schemaInfo2 = schemaInfo2;
            LOG.exiting("org.apache.cxf.jaxb.JAXBSchemaInitializer", "createSchemaIfNeeded", schemaInfo2);
        }
        return schemaInfo2;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private boolean isExistSchemaElement(XmlSchema schema, QName qn) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBSchemaInitializer", "isExistSchemaElement", new Object[]{schema, qn});
        }
        boolean bl = schema.getElementByName(qn) != null;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.jaxb.JAXBSchemaInitializer", "isExistSchemaElement", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void sortItems(XmlSchemaSequence seq, String[] propertyOrder) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBSchemaInitializer", "sortItems", new Object[]{seq, propertyOrder});
        }
        final List<String> propList = Arrays.asList(propertyOrder);
        Collections.sort(seq.getItems(), new Comparator<XmlSchemaSequenceMember>(){
            static final long serialVersionUID = -7436513594049200739L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public int compare(XmlSchemaSequenceMember o1, XmlSchemaSequenceMember o2) {
                XmlSchemaElement element1 = (XmlSchemaElement)o1;
                XmlSchemaElement element2 = (XmlSchemaElement)o2;
                int index1 = propList.indexOf(element1.getName());
                int index2 = propList.indexOf(element2.getName());
                return index1 - index2;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"org.apache.cxf.jaxb.JAXBSchemaInitializer$1", 1.class, null, null);
            }
        });
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxb.JAXBSchemaInitializer", "sortItems");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void sort(XmlSchemaSequence seq) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBSchemaInitializer", "sort", new Object[]{seq});
        }
        Collections.sort(seq.getItems(), new Comparator<XmlSchemaSequenceMember>(){
            static final long serialVersionUID = -2718531920092064681L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public int compare(XmlSchemaSequenceMember o1, XmlSchemaSequenceMember o2) {
                XmlSchemaElement element1 = (XmlSchemaElement)o1;
                XmlSchemaElement element2 = (XmlSchemaElement)o2;
                return element1.getName().compareTo(element2.getName());
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"org.apache.cxf.jaxb.JAXBSchemaInitializer$2", 2.class, null, null);
            }
        });
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxb.JAXBSchemaInitializer", "sort");
        }
    }
}

