/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.oauth20.error.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.oauth.core.api.OAuthResult;
import com.ibm.oauth.core.api.attributes.AttributeList;
import com.ibm.oauth.core.api.error.OAuthConfigurationException;
import com.ibm.oauth.core.api.error.OAuthException;
import com.ibm.oauth.core.api.error.oauth20.OAuth20AccessDeniedException;
import com.ibm.oauth.core.api.error.oauth20.OAuth20DuplicateParameterException;
import com.ibm.oauth.core.api.error.oauth20.OAuth20Exception;
import com.ibm.oauth.core.api.error.oauth20.OAuth20InvalidClientException;
import com.ibm.oauth.core.api.error.oauth20.OAuth20InvalidGrantTypeException;
import com.ibm.oauth.core.api.error.oauth20.OAuth20InvalidRedirectUriException;
import com.ibm.oauth.core.api.error.oauth20.OAuth20InvalidResponseTypeException;
import com.ibm.oauth.core.api.error.oauth20.OAuth20InvalidScopeException;
import com.ibm.oauth.core.util.JSONUtil;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.oauth20.error.OAuthExceptionHandler;
import com.ibm.ws.security.oauth20.error.impl.ErrorPageRenderer;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Locale;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/ejs/ras/TraceComponent;")
@InjectedFFDC
public class OAuth20AuthorizeRequestExceptionHandler
implements OAuthExceptionHandler {
    private static TraceComponent tc = Tr.register(OAuth20AuthorizeRequestExceptionHandler.class, (String)"OAuth20Provider", (String)"com.ibm.ws.security.oauth20.resources.ProviderMsgs");
    public static final String HEADER_ACCEPT_LANGUAGE = "Accept-Language";
    public static final String RESPONSE_TYPE_TOKEN = "token";
    public static final String RESPONSE_TYPE_ID_TOKEN = "id_token";
    public static final String RESPONSE_TYPE_TOKEN_ID_TOKEN = "token id_token";
    public static final String RESPONSE_TYPE_ID_TOKEN_TOKEN = "id_token token";
    public static final String STATE = "state";
    private final String _responseType;
    private final String _redirectUri;
    private final String _templateUrl;
    static final long serialVersionUID = -6657965777273944931L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    public OAuth20AuthorizeRequestExceptionHandler(String responseType, String redirectUri, String templateUrl) {
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"<init>", (Object)new Object[]{responseType, redirectUri, templateUrl});
        }
        this._responseType = responseType;
        this._redirectUri = redirectUri;
        this._templateUrl = templateUrl;
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"<init>", (Object)this);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    public void handleResultException(HttpServletRequest req, HttpServletResponse rsp, OAuthResult result) {
        block51: {
            String encoding;
            if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"handleResultException", (Object)new Object[]{req, rsp, result});
            }
            boolean handled = false;
            String string = encoding = req.getCharacterEncoding() != null ? req.getCharacterEncoding() : "utf-8";
            if (result.getStatus() != 0) {
                OAuthException e = result.getCause();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"com.ibm.ws.security.oauth20.web.OAuth20EndpointServlet result is bad", (Object)new Object[]{e, this._responseType, this._redirectUri, this._templateUrl});
                }
                if (e != null) {
                    block49: {
                        OAuthException e2;
                        String error;
                        boolean processException = true;
                        if (e instanceof OAuth20Exception && "invalid_request".equals(error = e.getError()) && "End-User authentication was unsuccessful. The id_token_hint parameter value is not valid.".equals(e.getMessage())) {
                            processException = false;
                        }
                        if (e instanceof OAuth20InvalidResponseTypeException || e instanceof OAuth20InvalidClientException || e instanceof OAuth20InvalidGrantTypeException || e instanceof OAuth20InvalidScopeException) {
                            processException = false;
                        }
                        if (processException) {
                            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.oauth20.error.impl.OAuth20AuthorizeRequestExceptionHandler", (String)"96", (Object)this);
                        }
                        if (e instanceof OAuth20Exception) {
                            AttributeList al;
                            StringBuilder location;
                            int index;
                            e2 = (OAuth20Exception)e;
                            String error2 = ((OAuth20Exception)e2).getError();
                            if ("unauthorized_client".equals(error2) || e2 instanceof OAuth20InvalidRedirectUriException || e2 instanceof OAuth20DuplicateParameterException && "redirect_uri".equals(((OAuth20DuplicateParameterException)e2).getParamName()) || this._redirectUri == null) {
                                try {
                                    if (this._templateUrl != null && !"".equals(this._templateUrl.trim())) {
                                        this.renderErrorPage(req, rsp, e2);
                                    } else {
                                        Locale locale = req.getLocale();
                                        rsp.setLocale(locale);
                                        PrintWriter pw = rsp.getWriter();
                                        pw.print(((OAuth20Exception)e2).formatSelf(locale, encoding));
                                    }
                                    handled = true;
                                }
                                catch (IOException locale) {
                                    FFDCFilter.processException((Throwable)locale, (String)"com.ibm.ws.security.oauth20.error.impl.OAuth20AuthorizeRequestExceptionHandler", (String)"160", (Object)this, (Object[])new Object[]{req, rsp, result});
                                    if (tc.isDebugEnabled()) {
                                        void ioe;
                                        Tr.debug((TraceComponent)tc, (String)"Internal error writing JSON response", (Object)new Object[]{ioe});
                                    }
                                    break block49;
                                }
                            }
                            if ("invalid_grant".equals(error2) || "unsupported_grant_type".equals(error2)) {
                                rsp.setStatus(401);
                                rsp.setHeader("Cache-Control", "no-store");
                                rsp.setHeader("Pragma", "no-cache");
                                rsp.setHeader("Content-Type", "application/json;charset=UTF-8");
                                String errorDescription = ((OAuth20Exception)e2).formatSelf(req.getLocale(), encoding);
                                HashMap<String, Object> attributes = new HashMap<String, Object>();
                                attributes.put("error", error2);
                                attributes.put("error_description", errorDescription);
                                try {
                                    PrintWriter pw = rsp.getWriter();
                                    pw.print(JSONUtil.getJSON(attributes));
                                    handled = true;
                                }
                                catch (IOException pw) {
                                    FFDCFilter.processException((Throwable)pw, (String)"com.ibm.ws.security.oauth20.error.impl.OAuth20AuthorizeRequestExceptionHandler", (String)"208", (Object)this, (Object[])new Object[]{req, rsp, result});
                                    if (tc.isDebugEnabled()) {
                                        void ioe;
                                        Tr.debug((TraceComponent)tc, (String)"Internal error writing JSON response", (Object)new Object[]{ioe});
                                    }
                                    break block49;
                                }
                            }
                            String separator = "?";
                            if (RESPONSE_TYPE_TOKEN.equals(this._responseType) || RESPONSE_TYPE_ID_TOKEN.equals(this._responseType) || RESPONSE_TYPE_ID_TOKEN_TOKEN.equals(this._responseType) || RESPONSE_TYPE_TOKEN_ID_TOKEN.equals(this._responseType)) {
                                separator = "#";
                            }
                            if ((index = this._redirectUri.indexOf(separator)) != (location = new StringBuilder(this._redirectUri)).length() - 1) {
                                if (index > -1) {
                                    location.append("&");
                                } else {
                                    location.append(separator);
                                }
                            }
                            location.append("error");
                            location.append("=");
                            try {
                                error2 = URLEncoder.encode(error2, "utf-8");
                            }
                            catch (UnsupportedEncodingException unsupportedEncodingException) {
                                FFDCFilter.processException((Throwable)unsupportedEncodingException, (String)"com.ibm.ws.security.oauth20.error.impl.OAuth20AuthorizeRequestExceptionHandler", (String)"246", (Object)this, (Object[])new Object[]{req, rsp, result});
                            }
                            location.append(error2);
                            String errorDesc = ((OAuth20Exception)e2).formatSelf(req.getLocale(), encoding);
                            if (errorDesc != null) {
                                block50: {
                                    location.append("&");
                                    location.append("error_description");
                                    location.append("=");
                                    try {
                                        errorDesc = URLEncoder.encode(errorDesc, "utf-8");
                                    }
                                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                                        void e1;
                                        FFDCFilter.processException((Throwable)unsupportedEncodingException, (String)"com.ibm.ws.security.oauth20.error.impl.OAuth20AuthorizeRequestExceptionHandler", (String)"257", (Object)this, (Object[])new Object[]{req, rsp, result});
                                        if (!tc.isDebugEnabled()) break block50;
                                        Tr.debug((TraceComponent)tc, (String)"Internal error encoding error description", (Object)new Object[]{e1});
                                    }
                                }
                                location.append(errorDesc);
                            }
                            if ((al = result.getAttributeList()) != null) {
                                String authType;
                                String state = al.getAttributeValueByName(STATE);
                                if (state != null) {
                                    location.append("&");
                                    location.append(STATE);
                                    location.append("=");
                                    try {
                                        state = URLEncoder.encode(state, "utf-8");
                                    }
                                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                                        FFDCFilter.processException((Throwable)unsupportedEncodingException, (String)"com.ibm.ws.security.oauth20.error.impl.OAuth20AuthorizeRequestExceptionHandler", (String)"276", (Object)this, (Object[])new Object[]{req, rsp, result});
                                    }
                                    location.append(state);
                                }
                                if ((authType = al.getAttributeValueByName("WWW-Authenticate")) != null && authType.length() > 0) {
                                    rsp.setHeader("WWW-Authenticate", authType);
                                }
                            }
                            int iStatusCode = 302;
                            if (e2 instanceof OAuth20AccessDeniedException) {
                                iStatusCode = ((OAuth20AccessDeniedException)e2).getHttpStatusCode();
                            }
                            if (iStatusCode >= 400 && iStatusCode < 600) {
                                try {
                                    rsp.sendError(iStatusCode, "error=" + error2 + "&" + "error_description" + "=" + ((OAuth20Exception)e2).formatSelf(req.getLocale(), encoding));
                                }
                                catch (IOException authType) {
                                    FFDCFilter.processException((Throwable)authType, (String)"com.ibm.ws.security.oauth20.error.impl.OAuth20AuthorizeRequestExceptionHandler", (String)"295", (Object)this, (Object[])new Object[]{req, rsp, result});
                                    if (tc.isDebugEnabled()) {
                                        void ioe;
                                        Tr.debug((TraceComponent)tc, (String)"Internal error", (Object)new Object[]{ioe});
                                    }
                                }
                            } else {
                                rsp.setStatus(iStatusCode);
                                rsp.setHeader("Location", location.toString());
                            }
                            handled = true;
                        } else if (e instanceof OAuthConfigurationException) {
                            e2 = (OAuthConfigurationException)e;
                            String error3 = ((OAuthConfigurationException)e2).getError();
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("processing exception with OAuthResult: " + error3));
                            }
                            rsp.setStatus(500);
                            rsp.setHeader("Cache-Control", "no-store");
                            rsp.setHeader("Pragma", "no-cache");
                            rsp.setHeader("Content-Type", "application/json;charset=UTF-8");
                            String errorDescription = ((OAuthConfigurationException)e2).formatSelf(req.getLocale(), encoding);
                            HashMap<String, Object> attributes = new HashMap<String, Object>();
                            attributes.put("error", error3);
                            attributes.put("error_description", errorDescription);
                            try {
                                PrintWriter pw = rsp.getWriter();
                                pw.print(JSONUtil.getJSON(attributes));
                                handled = true;
                            }
                            catch (IOException pw) {
                                void ioe;
                                FFDCFilter.processException((Throwable)pw, (String)"com.ibm.ws.security.oauth20.error.impl.OAuth20AuthorizeRequestExceptionHandler", (String)"357", (Object)this, (Object[])new Object[]{req, rsp, result});
                                if (!tc.isDebugEnabled()) break block49;
                                Tr.debug((TraceComponent)tc, (String)"Internal error writing JSON response", (Object)new Object[]{ioe});
                            }
                        }
                    }
                    if (!handled) {
                        try {
                            if (this._templateUrl != null && !"".equals(this._templateUrl.trim())) {
                                this.renderErrorPage(req, rsp, e);
                            } else {
                                PrintWriter pw = rsp.getWriter();
                                pw.print(e.getMessage());
                            }
                            handled = true;
                        }
                        catch (IOException pw) {
                            void ioe;
                            FFDCFilter.processException((Throwable)pw, (String)"com.ibm.ws.security.oauth20.error.impl.OAuth20AuthorizeRequestExceptionHandler", (String)"376", (Object)this, (Object[])new Object[]{req, rsp, result});
                            if (!tc.isDebugEnabled()) break block51;
                            Tr.debug((TraceComponent)tc, (String)"Internal error", (Object)new Object[]{ioe});
                        }
                    }
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"handleResultException");
        }
    }

    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    private void renderErrorPage(HttpServletRequest request, HttpServletResponse response, OAuthException exception) throws IOException {
        String methodName = "renderErrorPage";
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName);
        }
        String acceptLanguage = request.getHeader(HEADER_ACCEPT_LANGUAGE);
        ErrorPageRenderer renderer = new ErrorPageRenderer();
        renderer.renderErrorPage(exception, this._templateUrl, acceptLanguage, request, response);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)methodName);
        }
    }
}

