/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.cors.config;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={CorsConfig.class}, configurationPid={"com.ibm.ws.webcontainer.cors"}, configurationPolicy=ConfigurationPolicy.REQUIRE, immediate=true, property={"service.vendor=IBM"})
public class CorsConfig {
    private static final TraceComponent tc = Tr.register(CorsConfig.class, (String)"CorsService", (String)"com.ibm.ws.webcontainer.cors.internal.resources.CorsServiceMessages");
    public static final String CONFIG_DOMAIN = "domain";
    public static final String CONFIG_ALLOWED_ORIGINS = "allowedOrigins";
    public static final String CONFIG_ALLOWED_METHODS = "allowedMethods";
    public static final String CONFIG_ALLOWED_HEADERS = "allowedHeaders";
    public static final String CONFIG_MAX_AGE = "maxAge";
    public static final String CONFIG_ALLOW_CREDENTIALS = "allowCredentials";
    public static final String CONFIG_EXPOSE_HEADERS = "exposeHeaders";
    private String domain;
    private List<String> allowedOrigins;
    private List<String> allowedMethods;
    private List<String> allowedHeaders;
    private Long maxAge;
    private boolean allowCredentials;
    private String exposeHeaders;
    static final long serialVersionUID = 8727920375450579782L;

    public CorsConfig() {
    }

    public CorsConfig(Map<String, Object> properties) {
        this.processCors(properties);
    }

    @Activate
    protected void activate(ComponentContext context, Map<String, Object> properties) {
        this.processCors(properties);
    }

    @Modified
    protected void modified(Map<String, Object> properties) throws IOException {
        this.processCors(properties);
    }

    private void processCors(Map<String, Object> properties) {
        String configOrigins;
        this.domain = (String)properties.get(CONFIG_DOMAIN);
        if (this.domain.charAt(0) != '/') {
            this.domain = "/" + this.domain;
        }
        this.allowedOrigins = (configOrigins = (String)properties.get(CONFIG_ALLOWED_ORIGINS)).contains("*") ? Arrays.asList("*") : Arrays.asList(configOrigins.trim().split("\\s*,\\s*"));
        String allowedMethodsAsString = (String)properties.get(CONFIG_ALLOWED_METHODS);
        this.allowedMethods = allowedMethodsAsString == null || allowedMethodsAsString.isEmpty() ? Collections.emptyList() : Arrays.asList(allowedMethodsAsString.trim().split("\\s*,\\s*"));
        String allowedHeadersAsString = (String)properties.get(CONFIG_ALLOWED_HEADERS);
        this.allowedHeaders = allowedHeadersAsString == null || allowedHeadersAsString.isEmpty() ? Collections.emptyList() : Arrays.asList(allowedHeadersAsString.trim().split("\\s*,\\s*"));
        this.exposeHeaders = (String)properties.get(CONFIG_EXPOSE_HEADERS);
        this.maxAge = (Long)properties.get(CONFIG_MAX_AGE);
        this.allowCredentials = Boolean.TRUE.equals(properties.get(CONFIG_ALLOW_CREDENTIALS));
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)this.toString(), (Object[])new Object[0]);
        }
    }

    public String toString() {
        return "CorsConfig : domain: " + this.domain + " | allowedOrigins: " + Arrays.toString(this.allowedOrigins.toArray()) + " | allowedMethods: " + Arrays.toString(this.allowedMethods.toArray()) + " | allowedHeaders: " + Arrays.toString(this.allowedHeaders.toArray()) + " | allowCredentials: " + this.allowCredentials + " | maxAge: " + this.maxAge + " | exposeHeaders: " + this.exposeHeaders;
    }

    @Deactivate
    protected void deactivate(ComponentContext context, int reason) {
    }

    public String getDomain() {
        return this.domain;
    }

    public List<String> getAllowedOrigins() {
        return this.allowedOrigins;
    }

    public List<String> getAllowedMethods() {
        return this.allowedMethods;
    }

    public List<String> getAllowedHeaders() {
        return this.allowedHeaders;
    }

    public boolean getAllowCredentials() {
        return this.allowCredentials;
    }

    public Long getMaxAge() {
        return this.maxAge;
    }

    public String getExposedHeaders() {
        return this.exposeHeaders;
    }
}

