/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema.impl;

import graphql.AssertException;
import graphql.Internal;
import graphql.com.google.common.collect.ImmutableMap;
import graphql.schema.GraphQLAppliedDirectiveArgument;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLNamedType;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLSchemaElement;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeReference;
import graphql.schema.GraphQLTypeUtil;
import graphql.schema.GraphQLTypeVisitorStub;
import graphql.schema.GraphQLUnionType;
import graphql.util.TraversalControl;
import graphql.util.TraverserContext;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Supplier;

@Internal
public class GraphQLTypeCollectingVisitor
extends GraphQLTypeVisitorStub {
    private final Map<String, GraphQLNamedType> result = new LinkedHashMap<String, GraphQLNamedType>();
    private final Map<String, GraphQLNamedType> indirectStrongReferences = new LinkedHashMap<String, GraphQLNamedType>();

    @Override
    public TraversalControl visitGraphQLEnumType(GraphQLEnumType node, TraverserContext<GraphQLSchemaElement> context) {
        this.assertTypeUniqueness(node, this.result);
        this.save(node.getName(), node);
        return TraversalControl.CONTINUE;
    }

    @Override
    public TraversalControl visitGraphQLScalarType(GraphQLScalarType node, TraverserContext<GraphQLSchemaElement> context) {
        this.assertTypeUniqueness(node, this.result);
        this.save(node.getName(), node);
        return TraversalControl.CONTINUE;
    }

    @Override
    public TraversalControl visitGraphQLObjectType(GraphQLObjectType node, TraverserContext<GraphQLSchemaElement> context) {
        if (this.isNotTypeReference(node.getName())) {
            this.assertTypeUniqueness(node, this.result);
        } else {
            this.save(node.getName(), node);
        }
        return TraversalControl.CONTINUE;
    }

    @Override
    public TraversalControl visitGraphQLInputObjectType(GraphQLInputObjectType node, TraverserContext<GraphQLSchemaElement> context) {
        if (this.isNotTypeReference(node.getName())) {
            this.assertTypeUniqueness(node, this.result);
        } else {
            this.save(node.getName(), node);
        }
        return TraversalControl.CONTINUE;
    }

    @Override
    public TraversalControl visitGraphQLInterfaceType(GraphQLInterfaceType node, TraverserContext<GraphQLSchemaElement> context) {
        if (this.isNotTypeReference(node.getName())) {
            this.assertTypeUniqueness(node, this.result);
        } else {
            this.save(node.getName(), node);
        }
        return TraversalControl.CONTINUE;
    }

    @Override
    public TraversalControl visitGraphQLUnionType(GraphQLUnionType node, TraverserContext<GraphQLSchemaElement> context) {
        this.assertTypeUniqueness(node, this.result);
        this.save(node.getName(), node);
        return TraversalControl.CONTINUE;
    }

    @Override
    public TraversalControl visitGraphQLFieldDefinition(GraphQLFieldDefinition node, TraverserContext<GraphQLSchemaElement> context) {
        this.saveIndirectStrongReference(node::getType);
        return TraversalControl.CONTINUE;
    }

    @Override
    public TraversalControl visitGraphQLInputObjectField(GraphQLInputObjectField node, TraverserContext<GraphQLSchemaElement> context) {
        this.saveIndirectStrongReference(node::getType);
        return TraversalControl.CONTINUE;
    }

    @Override
    public TraversalControl visitGraphQLArgument(GraphQLArgument node, TraverserContext<GraphQLSchemaElement> context) {
        this.saveIndirectStrongReference(node::getType);
        return TraversalControl.CONTINUE;
    }

    @Override
    public TraversalControl visitGraphQLAppliedDirectiveArgument(GraphQLAppliedDirectiveArgument node, TraverserContext<GraphQLSchemaElement> context) {
        this.saveIndirectStrongReference(node::getType);
        return TraversalControl.CONTINUE;
    }

    private <T> void saveIndirectStrongReference(Supplier<GraphQLType> typeSupplier) {
        GraphQLNamedType type = (GraphQLNamedType)GraphQLTypeUtil.unwrapAllAs(typeSupplier.get());
        if (!(type instanceof GraphQLTypeReference)) {
            this.indirectStrongReferences.put(type.getName(), type);
        }
    }

    private boolean isNotTypeReference(String name) {
        return this.result.containsKey(name) && !(this.result.get(name) instanceof GraphQLTypeReference);
    }

    private void save(String name, GraphQLNamedType type) {
        this.result.put(name, type);
    }

    private void assertTypeUniqueness(GraphQLNamedType type, Map<String, GraphQLNamedType> result) {
        GraphQLType existingType = result.get(type.getName());
        if (existingType != null && !(existingType instanceof GraphQLTypeReference) && !(type instanceof GraphQLTypeReference)) {
            this.assertUniqueTypeObjects(type, existingType);
        }
    }

    private void assertUniqueTypeObjects(GraphQLNamedType type, GraphQLType existingType) {
        if (existingType != type) {
            throw new AssertException(String.format("All types within a GraphQL schema must have unique names. No two provided types may have the same name.\nNo provided type may have a name which conflicts with any built in types (including Scalar and Introspection types).\nYou have redefined the type '%s' from being a '%s' to a '%s'", type.getName(), existingType.getClass().getSimpleName(), type.getClass().getSimpleName()));
        }
    }

    public ImmutableMap<String, GraphQLNamedType> getResult() {
        TreeMap<String, GraphQLNamedType> types = new TreeMap<String, GraphQLNamedType>(this.fixDanglingReplacedTypes(this.result));
        return ImmutableMap.copyOf(types);
    }

    private Map<String, GraphQLNamedType> fixDanglingReplacedTypes(Map<String, GraphQLNamedType> visitedTypes) {
        for (GraphQLNamedType indirectStrongReference : this.indirectStrongReferences.values()) {
            String typeName = indirectStrongReference.getName();
            visitedTypes.putIfAbsent(typeName, indirectStrongReference);
        }
        return visitedTypes;
    }
}

